/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.logbox;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import androidx.annotation.Keep;
import com.lynx.devtool.LynxDevtoolEnv;
import com.lynx.devtool.logbox.LynxLogBoxOwner;
import com.lynx.devtoolwrapper.LogBoxLogLevel;
import com.lynx.devtoolwrapper.LynxBaseLogBoxProxy;
import com.lynx.devtoolwrapper.LynxDevtool;
import com.lynx.tasm.LynxError;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.behavior.LynxContext;
import com.lynx.tasm.utils.UIThreadUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class LynxLogBoxProxy
implements LynxBaseLogBoxProxy {
    private static final String TAG = "LynxLogBoxProxy";
    private WeakReference<LynxDevtool> mDevtool;
    private WeakReference<Context> mActivity;
    private Map<LogBoxLogLevel, List<String>> mLogs;

    public LynxLogBoxProxy(LynxDevtool devtool) {
        this.mDevtool = new WeakReference<LynxDevtool>(devtool);
        this.mLogs = new HashMap<LogBoxLogLevel, List<String>>();
        this.mLogs.put(LogBoxLogLevel.Error, new ArrayList());
        this.mLogs.put(LogBoxLogLevel.Warn, new ArrayList());
        this.mLogs.put(LogBoxLogLevel.Info, new ArrayList());
        LynxContext context = devtool.getLynxContext();
        this.attachContext((Context)context);
    }

    public void attachContext(Context context) {
        Context activity = this.findActivityByContext(context);
        if (this.mActivity == null || this.mActivity.get() == null) {
            this.mActivity = new WeakReference<Context>(activity);
            this.showCacheLogMessage();
        } else {
            LLog.e((String)TAG, (String)"LynxLogBoxProxy context has attached.");
        }
    }

    public void showLogMessage(LynxError error) {
        if (error == null) {
            return;
        }
        final String message = error.getMsg();
        final LogBoxLogLevel level = error.getLevel().equals("warn") ? LogBoxLogLevel.Warn : LogBoxLogLevel.Error;
        this.sendErrorEventToPerf(message, level);
        if (LynxDevtoolEnv.inst().isIgnoreErrorTypeEnabled(error.getErrorCode())) {
            return;
        }
        if (UIThreadUtils.isOnUiThread()) {
            this.onNewLog(message, level);
        } else {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxProxy.this.onNewLog(message, level);
                }
            });
        }
    }

    private void onNewLog(String message, LogBoxLogLevel level) {
        LLog.i((String)TAG, (String)("onNewLog with level " + level));
        List<String> logList = this.mLogs.get(level);
        if (logList == null) {
            return;
        }
        logList.add(message);
        if (this.mActivity == null || this.mActivity.get() == null) {
            return;
        }
        LynxLogBoxOwner.getInstance().dispatch(message, level, (Context)this.mActivity.get(), this);
    }

    private void showCacheLogMessage() {
        this.showCacheLogMessageByLogLevel(LogBoxLogLevel.Warn);
        this.showCacheLogMessageByLogLevel(LogBoxLogLevel.Error);
    }

    private void showCacheLogMessageByLogLevel(final LogBoxLogLevel level) {
        UIThreadUtils.runOnUiThreadImmediately((Runnable)new Runnable(){

            @Override
            public void run() {
                List logList = (List)LynxLogBoxProxy.this.mLogs.get(level);
                if (logList == null || logList.isEmpty()) {
                    return;
                }
                for (String message : logList) {
                    LynxLogBoxOwner.getInstance().dispatch(message, level, (Context)LynxLogBoxProxy.this.mActivity.get(), LynxLogBoxProxy.this);
                }
            }
        });
    }

    public List<String> getLogMessages(LogBoxLogLevel level) {
        ArrayList logs = this.mLogs.get(level);
        return logs == null ? new ArrayList() : logs;
    }

    public String getLastLog(LogBoxLogLevel level) {
        List<String> logs = this.mLogs.get(level);
        if (logs == null) {
            return "";
        }
        return logs.isEmpty() ? "" : logs.get(logs.size() - 1);
    }

    public void clearLogsWithLevel(LogBoxLogLevel level) {
        List<String> logs = this.mLogs.get(level);
        if (logs != null) {
            logs.clear();
        }
    }

    public void clearAllLogs() {
        for (List<String> logs : this.mLogs.values()) {
            logs.clear();
        }
    }

    public String getTemplateUrl() {
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        return devtool == null ? "" : devtool.getTemplateUrl();
    }

    public Map<String, Object> getAllJsSource() {
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        return devtool == null ? null : devtool.getAllJsSource();
    }

    public int getLogCount(LogBoxLogLevel level) {
        List<String> logs = this.mLogs.get(level);
        return logs == null ? 0 : logs.size();
    }

    public void reloadView() {
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        if (devtool != null) {
            devtool.reloadView();
        }
    }

    public void onLoadTemplate() {
        LynxLogBoxOwner.getInstance().onLoadTemplate((Context)this.mActivity.get(), this);
    }

    public void showConsole() {
        if (UIThreadUtils.isOnUiThread()) {
            this.showConsoleSync();
        } else {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxProxy.this.showConsoleSync();
                }
            });
        }
    }

    protected int getInstanceIdOfCurrentView() {
        LynxContext lynxContext;
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        if (devtool != null && (lynxContext = devtool.getLynxContext()) != null) {
            return lynxContext.getInstanceId();
        }
        return -1;
    }

    private void showConsoleSync() {
        LynxLogBoxOwner.getInstance().showConsoleLog((Context)this.mActivity.get(), this);
    }

    private Context findActivityByContext(Context context) {
        if (context == null) {
            return null;
        }
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private void sendErrorEventToPerf(String message, LogBoxLogLevel level) {
        if (level == LogBoxLogLevel.Info) {
            return;
        }
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        if (devtool == null) {
            return;
        }
        try {
            JSONObject eventData = new JSONObject();
            eventData.put("error", (Object)message);
            devtool.onPerfMetricsEvent("lynx_error_event", eventData);
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.toString());
        }
    }
}

