/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.memory;

import android.content.Context;
import com.lynx.debugrouter.DebugRouter;
import com.lynx.devtoolwrapper.MemoryListener;
import com.lynx.tasm.base.LLog;
import org.json.JSONException;
import org.json.JSONObject;

public class MemoryController
implements MemoryListener.MemoryReporter {
    private static final String TAG = "MemoryController";
    private static final String TYPE = "CDP";
    private Context mContext;

    public static MemoryController getInstance() {
        return MemoryControllerLoader.INSTANCE;
    }

    public void init(Context context) {
        this.mContext = context;
    }

    public void startMemoryTracing() {
        MemoryListener.getInstance().addMemoryReporter((MemoryListener.MemoryReporter)this);
    }

    public void stopMemoryTracing() {
        MemoryListener.getInstance().removeMemoryReporter((MemoryListener.MemoryReporter)this);
    }

    public void uploadImageInfo(JSONObject data) {
        try {
            JSONObject msg = new JSONObject();
            JSONObject params = new JSONObject();
            msg.put("method", (Object)"Memory.uploadImageInfo");
            params.put("data", (Object)data);
            msg.put("params", (Object)params);
            DebugRouter.getInstance().sendDataAsync(TYPE, -1, msg.toString());
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)("Memory uploadImageInfo construct JSONObject failed:" + e.toString()));
        }
    }

    private static class MemoryControllerLoader {
        private static final MemoryController INSTANCE = new MemoryController();

        private MemoryControllerLoader() {
        }
    }
}

