/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.module;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lynx.jsbridge.Arguments;
import com.lynx.react.bridge.ReadableArray;
import com.lynx.react.bridge.ReadableMap;
import com.lynx.react.bridge.WritableMap;
import com.lynx.tasm.base.LLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class LynxWebSocket {
    private final Delegate mDelegate;
    static final String TAG = "LynxWebSocket";
    private final Map<Integer, WebSocket> mWebSocketConnections = new ConcurrentHashMap<Integer, WebSocket>();
    private final Map<Integer, ContentHandler> mContentHandlers = new ConcurrentHashMap<Integer, ContentHandler>();

    public void setContentHandler(int id2, ContentHandler contentHandler) {
        if (contentHandler != null) {
            this.mContentHandlers.put(id2, contentHandler);
        } else {
            this.mContentHandlers.remove(id2);
        }
    }

    public LynxWebSocket(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public void destroy() {
        for (Map.Entry<Integer, WebSocket> entry : this.mWebSocketConnections.entrySet()) {
            entry.getValue().close(1000, "Destroy");
        }
    }

    public void connect(String url, @Nullable ReadableArray protocols, @Nullable ReadableMap ignoredOptions, double socketID) {
        final int id2 = (int)socketID;
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES);
        OkHttpClient client = okHttpBuilder.build();
        Request.Builder builder = new Request.Builder().tag((Object)id2).url(url);
        boolean hasOriginHeader = false;
        if (protocols != null && protocols.size() > 0) {
            StringBuilder protocolsValue = new StringBuilder();
            for (int i = 0; i < protocols.size(); ++i) {
                String v = protocols.getString(i).trim();
                if (v.isEmpty() || v.contains(",")) continue;
                protocolsValue.append(v);
                protocolsValue.append(",");
            }
            if (protocolsValue.length() > 0) {
                protocolsValue.replace(protocolsValue.length() - 1, protocolsValue.length(), "");
                builder.addHeader("Sec-WebSocket-Protocol", protocolsValue.toString());
            }
        }
        client.newWebSocket(builder.build(), new WebSocketListener(){

            public void onOpen(@NonNull WebSocket webSocket, @NonNull Response response) {
                LynxWebSocket.this.mWebSocketConnections.put(id2, webSocket);
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putString("protocol", response.header("Sec-WebSocket-Protocol", ""));
                LynxWebSocket.this.sendEvent("websocketOpen", params);
            }

            public void onClosing(@NonNull WebSocket websocket, int code, @NonNull String reason) {
                websocket.close(code, reason);
            }

            public void onClosed(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putInt("code", code);
                params.putString("reason", reason);
                LynxWebSocket.this.sendEvent("websocketClosed", params);
            }

            public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable t, Response response) {
                LynxWebSocket.this.notifyWebSocketFailed(id2, t.getMessage());
            }

            public void onMessage(@NonNull WebSocket webSocket, @NonNull String text) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putString("type", "text");
                ContentHandler contentHandler = (ContentHandler)LynxWebSocket.this.mContentHandlers.get(id2);
                if (contentHandler != null) {
                    contentHandler.onMessage(text, params);
                } else {
                    params.putString("data", text);
                }
                LynxWebSocket.this.sendEvent("websocketMessage", params);
            }

            public void onMessage(@NonNull WebSocket webSocket, @NonNull ByteString bytes) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putString("type", "binary");
                ContentHandler contentHandler = (ContentHandler)LynxWebSocket.this.mContentHandlers.get(id2);
                if (contentHandler != null) {
                    contentHandler.onMessage(bytes, params);
                } else {
                    String text = bytes.base64();
                    params.putString("data", text);
                }
                LynxWebSocket.this.sendEvent("websocketMessage", params);
            }
        });
        client.dispatcher().executorService().shutdown();
    }

    public void close(double code, String reason, double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            return;
        }
        try {
            client.close((int)code, reason);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
        }
        catch (Exception e) {
            LLog.e((String)TAG, (String)("Could not close WebSocket connection for id " + id2 + e));
        }
    }

    public void send(String message, double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            this.notifyWebSocketFailed(id2, "client is null", true);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
            return;
        }
        try {
            client.send(message);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    public void ping(double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            this.notifyWebSocketFailed(id2, "client is null", true);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
            return;
        }
        try {
            client.send(ByteString.EMPTY);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    private void sendEvent(String name, WritableMap data) {
        this.mDelegate.sendEvent(name, data);
    }

    private void notifyWebSocketFailed(int id2, String message) {
        this.notifyWebSocketFailed(id2, message, false);
    }

    private void notifyWebSocketFailed(int id2, String message, boolean withClose) {
        WritableMap params = Arguments.createMap();
        params.putInt("id", id2);
        params.putString("message", message);
        this.sendEvent("websocketFailed", params);
        if (withClose) {
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", message);
            this.sendEvent("websocketClosed", params);
        }
    }

    public static interface ContentHandler {
        public void onMessage(String var1, WritableMap var2);

        public void onMessage(ByteString var1, WritableMap var2);
    }

    public static interface Delegate {
        public void sendEvent(String var1, WritableMap var2);
    }
}

