/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.module;

import androidx.annotation.Nullable;
import com.lynx.devtool.module.LynxWebSocket;
import com.lynx.jsbridge.LynxContextModule;
import com.lynx.jsbridge.LynxMethod;
import com.lynx.react.bridge.JavaOnlyArray;
import com.lynx.react.bridge.ReadableArray;
import com.lynx.react.bridge.ReadableMap;
import com.lynx.react.bridge.WritableMap;
import com.lynx.tasm.behavior.LynxContext;

public class LynxWebSocketModule
extends LynxContextModule
implements LynxWebSocket.Delegate {
    public static final String NAME = "LynxWebSocketModule";
    private final LynxWebSocket mWebSocket = new LynxWebSocket(this);

    public LynxWebSocketModule(LynxContext context) {
        super(context);
    }

    public void destroy() {
        super.destroy();
        this.mWebSocket.destroy();
    }

    @LynxMethod
    public void connect(String url, @Nullable ReadableArray protocols, @Nullable ReadableMap options, double socketID) {
        this.mWebSocket.connect(url, protocols, options, socketID);
    }

    @LynxMethod
    public void close(double code, String reason, double socketID) {
        this.mWebSocket.close(code, reason, socketID);
    }

    @LynxMethod
    public void send(String message, double socketID) {
        this.mWebSocket.send(message, socketID);
    }

    @LynxMethod
    public void ping(double socketID) {
        this.mWebSocket.ping(socketID);
    }

    @Override
    public void sendEvent(String name, WritableMap data) {
        JavaOnlyArray array = new JavaOnlyArray();
        array.pushMap(data);
        this.mLynxContext.sendGlobalEvent(name, array);
    }
}

