/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.tracing;

import android.os.Looper;
import android.util.Printer;
import androidx.annotation.NonNull;
import com.lynx.devtool.framecapture.FrameTraceUtil;
import com.lynx.devtool.tracing.FrameTraceService;
import com.lynx.tasm.base.CalledByNative;
import com.lynx.tasm.base.TraceEvent;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class FPSTrace {
    private long mStartTimestamp;
    private ExecutorService mExecutorService;
    private static final int CALLBACK_INPUT = 0;
    private Runnable mCallback;
    private boolean isVsyncFrame = false;
    private LooperPrinter mPrinter;
    private long mNativeFPSTrace = this.nativeCreateFPSTrace();

    private FPSTrace() {
        this.mCallback = new Runnable(){

            @Override
            public void run() {
                FPSTrace.this.isVsyncFrame = true;
            }
        };
    }

    public static FPSTrace getInstance() {
        return FPSTraceLoader.INSTANCE;
    }

    private void addFPSCallback() {
        if (TraceEvent.categoryEnabled((long)3L)) {
            FrameTraceUtil.addFrameCallback(this.mCallback);
        }
    }

    @CalledByNative
    public void startFPSTrace() {
        if (TraceEvent.categoryEnabled((long)3L)) {
            FrameTraceService.getInstance().initializeService();
            this.mExecutorService = Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(@NonNull Runnable r) {
                    return new Thread(r, "FPSTrace");
                }
            });
            try {
                Looper looper = Looper.getMainLooper();
                Field logging = Looper.class.getDeclaredField("mLogging");
                logging.setAccessible(true);
                Printer origin = (Printer)logging.get(looper);
                this.mPrinter = new LooperPrinter(origin);
                looper.setMessageLogging((Printer)this.mPrinter);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.addFPSCallback();
        }
    }

    @CalledByNative
    public void stopFPSTrace() {
        if (this.mPrinter != null) {
            Looper.getMainLooper().setMessageLogging(this.mPrinter.getOrigin());
            this.mPrinter = null;
        }
        if (this.mExecutorService != null) {
            this.mExecutorService.shutdown();
            this.mExecutorService = null;
        }
    }

    private void record(final long startTimestamp, final long endTimestamp) {
        if (endTimestamp - startTimestamp >= FrameTraceUtil.getFrameIntervalNanos() && this.mExecutorService != null) {
            this.mExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    FrameTraceService.getInstance().FPSTrace(startTimestamp, endTimestamp);
                }
            });
        }
    }

    private void dispatchBegin() {
        this.isVsyncFrame = false;
        this.mStartTimestamp = FrameTraceUtil.getSystemBootTimeNs();
    }

    private void dispatchEnd() {
        if (this.isVsyncFrame) {
            this.isVsyncFrame = false;
            this.addFPSCallback();
            long endTimestamp = FrameTraceUtil.getSystemBootTimeNs();
            this.record(this.mStartTimestamp, endTimestamp);
        }
    }

    public long getNativeFPSTrace() {
        return this.mNativeFPSTrace;
    }

    private native long nativeCreateFPSTrace();

    private class LooperPrinter
    implements Printer {
        private Printer mOrigin;

        public LooperPrinter(Printer origin) {
            this.mOrigin = origin;
        }

        public Printer getOrigin() {
            return this.mOrigin;
        }

        public void println(String x) {
            if (this.mOrigin != null) {
                this.mOrigin.println(x);
            }
            if (x == null) {
                return;
            }
            if (x.charAt(0) == '>') {
                FPSTrace.this.dispatchBegin();
            } else if (x.charAt(0) == '<') {
                FPSTrace.this.dispatchEnd();
            }
        }
    }

    private static class FPSTraceLoader {
        private static final FPSTrace INSTANCE = new FPSTrace();

        private FPSTraceLoader() {
        }
    }
}

