/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import androidx.annotation.Keep;
import com.lynx.config.LynxLiteConfigs;
import com.lynx.devtool.LynxGlobalDebugBridge;
import com.lynx.devtool.memory.MemoryController;
import com.lynx.tasm.INativeLibraryLoader;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.base.LynxTraceEnv;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
public class LynxDevtoolEnv {
    private final String TAG = "LynxDevtoolEnv";
    private final String ERROR_CODE_KEY_PREFIX = "error_code";
    private final String CDP_DOMAIN_KEY_PREFIX = "enable_cdp_domain";
    private static volatile LynxDevtoolEnv sInstance;
    private Context mContext;
    private SharedPreferences mSharedPreferences;
    private Map<String, Integer> mErrorCodeMap = new HashMap<String, Integer>();
    private Map<String, Set<String>> mGroupSets;
    private Map<String, Object> mSwitchNotPersist;
    private Map<String, ArrayList<Object>> mSwitchAttrMap;
    private INativeLibraryLoader mDevtoolLibraryLoader = null;
    private ReadWriteLock mReadWriteLock = new ReentrantReadWriteLock(true);
    private Map<String, Boolean> mSwitchMasks = new HashMap<String, Boolean>();
    public static final int V8_OFF = 0;
    public static final int V8_ON = 1;
    public static final int V8_ALIGN_WITH_PROD = 2;
    public static final String ENABLE_PERF_METRICS = "enable_perf_metrics";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LynxDevtoolEnv inst() {
        if (sInstance != null) return sInstance;
        Class<LynxDevtoolEnv> clazz = LynxDevtoolEnv.class;
        synchronized (LynxDevtoolEnv.class) {
            if (sInstance != null) return sInstance;
            sInstance = new LynxDevtoolEnv();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private LynxDevtoolEnv() {
        this.mGroupSets = new HashMap<String, Set<String>>();
        this.mSwitchNotPersist = new HashMap<String, Object>();
    }

    public String getVersion() {
        return "0.0.1";
    }

    public void init(Context context) {
        try {
            if (!LynxEnv.inst().isNativeLibraryLoaded()) {
                if (this.tryLoadDebugLynxLibrary(LynxEnv.inst().getLibraryLoader())) {
                    LynxEnv.inst().setNativeLibraryLoaded(true);
                } else {
                    LynxEnv.inst().initNativeLibraries(LynxEnv.inst().getLibraryLoader());
                }
            }
            if (this.mContext == null || this.mSharedPreferences == null) {
                this.mContext = context;
                if (context != null) {
                    this.mSharedPreferences = context.getSharedPreferences("lynx_env_config", 0);
                }
            }
            this.initSwitchAttribute();
            this.initSyncToNative();
            if (!LynxEnv.inst().isDevLibraryLoaded()) {
                this.loadNativeDevtoolLibrary();
            }
            MemoryController.getInstance().init(this.mContext);
            this.setDefaultAppInfo(context);
            this.initEnvGroups();
        }
        catch (Throwable t) {
            LLog.e((String)"LynxDevtoolEnv", (String)t.toString());
            throw t;
        }
    }

    private void initSwitchAttribute() {
        this.mSwitchAttrMap = new HashMap<String, ArrayList<Object>>(){
            {
                this.put("enable_devtool", new ArrayList<Boolean>(Arrays.asList(true, true, false)));
                this.put("enable_logbox", new ArrayList<Boolean>(Arrays.asList(true, true, true)));
                this.put("enable_highlight_touch", new ArrayList<Boolean>(Arrays.asList(false, false, false)));
                this.put("enable_launch_record", new ArrayList<Boolean>(Arrays.asList(true, false, false)));
                this.put("enable_quickjs_debug", new ArrayList<Boolean>(Arrays.asList(true, true, true)));
                this.put("enable_dom_tree", new ArrayList<Boolean>(Arrays.asList(true, true, true)));
                this.put("enable_long_press_menu", new ArrayList<Boolean>(Arrays.asList(true, false, true)));
                this.put("enable_devtool_for_debuggable_view", new ArrayList<Boolean>(Arrays.asList(false, true, false)));
                this.put("devtool_connected", new ArrayList<Boolean>(Arrays.asList(false, true, false)));
                this.put("enable_preview_screen_shot", new ArrayList<Boolean>(Arrays.asList(false, false, true)));
                this.put("enable_quickjs_cache", new ArrayList<Boolean>(Arrays.asList(true, true, true)));
                this.put("enable_pixel_copy", new ArrayList<Boolean>(Arrays.asList(true, false, true)));
                this.put("enable_debug_mode", new ArrayList<Boolean>(Arrays.asList(true, false, false)));
                this.put("enable_v8", new ArrayList<Serializable>(Arrays.asList(true, true, 2)));
                this.put(LynxDevtoolEnv.ENABLE_PERF_METRICS, new ArrayList<Boolean>(Arrays.asList(false, false, false)));
            }
        };
    }

    private void initSyncToNative() {
        this.syncToNative("enable_devtool", this.getDevtoolEnv("enable_devtool", false));
        this.syncToNative("enable_quickjs_cache", this.getDevtoolEnv("enable_quickjs_cache", true));
        this.syncToNative("enable_v8", this.getV8Enabled());
        this.syncToNative("enable_quickjs_debug", this.isQuickjsDebugEnabled());
        this.syncToNative("enable_dom_tree", this.isDomTreeEnabled());
        this.syncToNative("enable_logbox", this.getDevtoolEnv("enable_logbox", true));
        this.syncToNative("devtool_connected", LynxGlobalDebugBridge.getInstance().isEnabled());
    }

    private void setDefaultAppInfo(Context context) {
        HashMap<String, String> appInfo = new HashMap<String, String>();
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            String appName = ai.loadLabel(context.getPackageManager()).toString();
            if (appName != null) {
                appInfo.put("App", appName);
            }
        }
        catch (Throwable t) {
            LLog.w((String)"LynxDevtoolEnv", (String)t.toString());
        }
        LynxGlobalDebugBridge.getInstance().setAppInfo(context, appInfo);
    }

    private void initEnvGroups() {
        this.mErrorCodeMap.put("error_code_css", 130100);
        if (this.mSharedPreferences == null) {
            return;
        }
        try {
            Set ignoredErrors = this.mSharedPreferences.getStringSet("ignore_error_types", null);
            if (ignoredErrors != null) {
                this.mGroupSets.put("ignore_error_types", ignoredErrors);
            }
        }
        catch (Throwable t) {
            LLog.e((String)"LynxDevtoolEnv", (String)("failed to initEnvGroups: " + t.toString()));
        }
    }

    public void setDevToolLibraryLoader(INativeLibraryLoader loader) {
        this.mDevtoolLibraryLoader = loader;
    }

    public void loadNativeDevtoolLibrary() {
        if (this.mDevtoolLibraryLoader != null) {
            this.mDevtoolLibraryLoader.loadLibrary("lynxdebugrouter");
            this.mDevtoolLibraryLoader.loadLibrary("v8_libfull.cr");
            this.mDevtoolLibraryLoader.loadLibrary("basedevtool");
            this.mDevtoolLibraryLoader.loadLibrary("lynxdevtool");
            LLog.i((String)"LynxDevtoolEnv", (String)"liblynxdevtool and libv8_libfull loaded via custom devtool library loader");
        } else if (LynxEnv.inst().getLibraryLoader() != null) {
            LynxEnv.inst().getLibraryLoader().loadLibrary("lynxdebugrouter");
            LynxEnv.inst().getLibraryLoader().loadLibrary("v8_libfull.cr");
            LynxEnv.inst().getLibraryLoader().loadLibrary("basedevtool");
            LynxEnv.inst().getLibraryLoader().loadLibrary("lynxdevtool");
            LLog.i((String)"LynxDevtoolEnv", (String)"liblynxdevtool loaded via library loader");
        } else {
            System.loadLibrary("v8_libfull.cr");
            System.loadLibrary("basedevtool");
            System.loadLibrary("lynxdevtool");
            LLog.i((String)"LynxDevtoolEnv", (String)"liblynxdevtool loaded via system loader");
        }
        LynxEnv.inst().setDevLibraryLoaded(true);
    }

    private void syncToNative(String key, Object defaultValue) {
        if (key == null || defaultValue == null) {
            throw new RuntimeException("syncToNative failed! key or defaultValue is null");
        }
        if (this.getDefaultValue(key) == null || !this.getDefaultValue(key).getClass().equals(defaultValue.getClass())) {
            throw new RuntimeException("syncToNative failed! key: " + key + "value: " + defaultValue.toString());
        }
        if (defaultValue instanceof Boolean) {
            LynxEnv.inst().nativeSetLocalEnv(key, (Boolean)defaultValue != false ? "1" : "0");
        } else {
            LynxEnv.inst().nativeSetLocalEnv(key, String.valueOf((Integer)defaultValue));
        }
    }

    private void syncToNative(String key, boolean defaultValue, String groupKey) {
        LynxEnv.inst().nativeSetGroupedEnv(key, defaultValue, groupKey);
    }

    private void syncToNative(String groupKey, Set<String> newGroupValues) {
        if (newGroupValues == null) {
            return;
        }
        LynxEnv.inst().nativeSetGroupedEnvWithGroupSet(groupKey, newGroupValues);
    }

    private void syncMaskToNative(String key) {
        LynxEnv.inst().nativeSetEnvMask(key, this.getDevtoolEnvMask(key).booleanValue());
    }

    public void setDevtoolEnv(String key, Object value) {
        try {
            boolean persist = this.needPersist(key);
            boolean syncToNative = this.needSyncToNative(key);
            KeyType type = this.getKeyType(key);
            switch (type) {
                case NORMAL_KEY: {
                    this.setDevtoolEnvInternal(key, value, persist, syncToNative);
                    break;
                }
                case CDP_DOMAIN_KEY: {
                    this.setDevtoolGroupedEnvInternal(key, "activated_cdp_domains", (Boolean)value, persist, syncToNative);
                    break;
                }
                case ERROR_KEY: {
                    Integer errorCode = this.mErrorCodeMap.get(key);
                    if (errorCode == null) break;
                    this.setDevtoolGroupedEnvInternal(errorCode.toString(), "ignore_error_types", (Boolean)value, persist, syncToNative);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LLog.e((String)"LynxDevtoolEnv", (String)(e.toString() + ", key: " + key + ", value: " + value.toString()));
        }
    }

    public void setDevtoolEnv(String groupKey, Set<String> newGroupValues) {
        if (this.mGroupSets == null || newGroupValues == null || newGroupValues.isEmpty()) {
            return;
        }
        this.mGroupSets.put(groupKey, newGroupValues);
        String key = newGroupValues.iterator().next();
        if (this.mSharedPreferences != null && this.needPersist(key)) {
            this.mSharedPreferences.edit().putStringSet(groupKey, newGroupValues).apply();
        }
        if (this.needSyncToNative(key)) {
            this.syncToNative(groupKey, newGroupValues);
        }
    }

    public Boolean getDevtoolEnv(String key, Boolean defaultValue) {
        return (Boolean)this.getDevtoolObjectEnv(key, defaultValue);
    }

    public Integer getDevtoolEnv(String key, Integer defaultValue) {
        return (Integer)this.getDevtoolObjectEnv(key, defaultValue);
    }

    Object getDevtoolObjectEnv(String key, Object defaultValue) {
        try {
            KeyType type = this.getKeyType(key);
            switch (type) {
                case NORMAL_KEY: {
                    return this.getDevtoolEnvInternal(key, defaultValue);
                }
                case CDP_DOMAIN_KEY: {
                    return this.getDevtoolGroupedEnvInternal(key, "activated_cdp_domains", (Boolean)defaultValue);
                }
                case ERROR_KEY: {
                    Integer errorCode = this.mErrorCodeMap.get(key);
                    if (errorCode == null) {
                        return false;
                    }
                    return this.getDevtoolGroupedEnvInternal(errorCode.toString(), "ignore_error_types", (Boolean)defaultValue);
                }
            }
            return defaultValue;
        }
        catch (RuntimeException e) {
            LLog.e((String)"LynxDevtoolEnv", (String)(e.toString() + ", key: " + key + ", value: " + defaultValue.toString()));
            return defaultValue;
        }
    }

    public Set<String> getDevtoolEnv(String groupKey) {
        if (this.mGroupSets == null) {
            return new HashSet<String>();
        }
        Set<String> set = this.mGroupSets.get(groupKey);
        if (set == null) {
            return new HashSet<String>();
        }
        return set;
    }

    public Object getDefaultValue(String key) {
        if (this.mSwitchAttrMap == null) {
            return null;
        }
        if (this.mSwitchAttrMap.containsKey(key) && this.mSwitchAttrMap.get(key) != null) {
            return this.mSwitchAttrMap.get(key).get(2);
        }
        return null;
    }

    private void setDevtoolEnvInternal(String key, Object value, Boolean persist, Boolean syncToNative) {
        if (this.getDefaultValue(key) == null || !this.getDefaultValue(key).getClass().equals(value.getClass())) {
            throw new RuntimeException("setDevtoolEnvInternal failed! key: " + key + ", value: " + value.toString());
        }
        if (persist.booleanValue() && this.mSharedPreferences != null) {
            if (value instanceof Boolean) {
                this.mSharedPreferences.edit().putBoolean(key, ((Boolean)value).booleanValue()).apply();
            } else {
                this.mSharedPreferences.edit().putInt(key, ((Integer)value).intValue()).apply();
            }
        } else if (!persist.booleanValue()) {
            this.mSwitchNotPersist.put(key, value);
        }
        if (syncToNative.booleanValue()) {
            this.syncToNative(key, value);
        }
    }

    private Object getDevtoolEnvInternal(String key, Object defaultValue) {
        if (this.getDefaultValue(key) == null || !this.getDefaultValue(key).getClass().equals(defaultValue.getClass())) {
            throw new RuntimeException("getDevtoolEnvInternal failed! key: " + key + ", value: " + defaultValue.toString());
        }
        Boolean mask = this.getDevtoolEnvMask(key);
        if (this.mSharedPreferences != null) {
            if (defaultValue instanceof Boolean) {
                if (this.mSharedPreferences.contains(key) || !this.mSwitchNotPersist.containsKey(key)) {
                    return this.mSharedPreferences.getBoolean(key, ((Boolean)defaultValue).booleanValue()) && mask != false;
                }
                return mask != false && (Boolean)this.mSwitchNotPersist.get(key) != false;
            }
            if (this.mSharedPreferences.contains(key) || !this.mSwitchNotPersist.containsKey(key)) {
                return mask != false ? this.mSharedPreferences.getInt(key, ((Integer)defaultValue).intValue()) : 0;
            }
            return mask != false ? this.mSwitchNotPersist.get(key) : Integer.valueOf(0);
        }
        LLog.e((String)"LynxDevtoolEnv", (String)("getDevtoolEnv must be called after init! key: " + key));
        if (defaultValue instanceof Boolean) {
            return mask != false && (Boolean)defaultValue != false;
        }
        return mask != false ? defaultValue : Integer.valueOf(0);
    }

    private void setDevtoolGroupedEnvInternal(String switchKey, String groupKey, Boolean value, Boolean persist, Boolean syncToNative) {
        if (this.mGroupSets == null) {
            return;
        }
        Set<String> groupSet = this.mGroupSets.get(groupKey);
        if (groupSet == null) {
            groupSet = new HashSet<String>();
            this.mGroupSets.put(groupKey, groupSet);
        }
        if (value.booleanValue()) {
            groupSet.add(switchKey);
        } else {
            groupSet.remove(switchKey);
        }
        if (this.mSharedPreferences != null && persist.booleanValue()) {
            this.mSharedPreferences.edit().putStringSet(groupKey, groupSet).apply();
        }
        if (syncToNative.booleanValue()) {
            this.syncToNative(switchKey, value, groupKey);
        }
    }

    private Boolean getDevtoolGroupedEnvInternal(String switchKey, String groupKey, Boolean defaultValue) {
        if (this.mGroupSets == null) {
            return defaultValue;
        }
        Set<String> set = this.mGroupSets.get(groupKey);
        return set != null ? set.contains(switchKey) : defaultValue.booleanValue();
    }

    public void setDevtoolEnvMask(String key, boolean value) {
        if (this.mSwitchMasks != null && this.mReadWriteLock != null) {
            this.mReadWriteLock.writeLock().lock();
            this.mSwitchMasks.put(key, value);
            this.mReadWriteLock.writeLock().unlock();
            this.syncMaskToNative(key);
        }
    }

    public Boolean getDevtoolEnvMask(String key) {
        Boolean mask = null;
        if (this.mSwitchMasks != null && this.mReadWriteLock != null) {
            this.mReadWriteLock.readLock().lock();
            mask = this.mSwitchMasks.get(key);
            this.mReadWriteLock.readLock().unlock();
        }
        if (mask == null) {
            return true;
        }
        return mask;
    }

    private boolean tryLoadDebugLynxLibrary(INativeLibraryLoader nativeLibraryLoader) {
        if (LynxEnv.inst().isDebugModeEnabled()) {
            try {
                if (nativeLibraryLoader != null) {
                    if (LynxLiteConfigs.requireQuickSharedLibrary()) {
                        nativeLibraryLoader.loadLibrary("quick");
                    }
                    nativeLibraryLoader.loadLibrary("lynx_debug");
                    if (!LynxTraceEnv.inst().isNativeLibraryLoaded()) {
                        nativeLibraryLoader.loadLibrary("lynxtrace");
                        LynxTraceEnv.inst().markNativeLibraryLoaded(true);
                    }
                } else {
                    if (LynxLiteConfigs.requireQuickSharedLibrary()) {
                        System.loadLibrary("quick");
                    }
                    System.loadLibrary("lynx_debug");
                }
                return true;
            }
            catch (UnsatisfiedLinkError error) {
                LLog.e((String)"LynxDevtoolEnv", (String)("Debug Lynx Library load from system with error message " + error.getMessage()));
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public boolean showDevtoolBadge() {
        return false;
    }

    @Deprecated
    public void setShowDevtoolBadge(boolean show) {
    }

    public boolean isQuickjsCacheEnabled() {
        return this.getDevtoolEnv("enable_quickjs_cache", true);
    }

    public void enableQuickjsCache(boolean enabled) {
        this.setDevtoolEnv("enable_quickjs_cache", enabled);
    }

    public int getV8Enabled() {
        return this.getDevtoolEnv("enable_v8", 2);
    }

    public void enableV8(int enabled) {
        if (enabled > 2) {
            enabled = 2;
            LLog.w((String)"LynxDevtoolEnv", (String)"The value must be 0 or 1 or 2. Change the value to 2!");
        } else if (enabled < 0) {
            enabled = 0;
            LLog.w((String)"LynxDevtoolEnv", (String)"The value must be 0 or 1 or 2. Change the value to 0!");
        }
        this.setDevtoolEnv("enable_v8", enabled);
    }

    public boolean isDomTreeEnabled() {
        return this.getDevtoolEnv("enable_dom_tree", true);
    }

    public void enableDomTree(boolean enabled) {
        this.setDevtoolEnv("enable_dom_tree", enabled);
    }

    public boolean isLongPressMenuEnabled() {
        return this.getDevtoolEnv("enable_long_press_menu", true);
    }

    public void enableLongPressMenu(boolean enabled) {
        this.setDevtoolEnv("enable_long_press_menu", enabled);
    }

    public boolean isIgnoreErrorTypeEnabled(Integer errCode) {
        if (this.mErrorCodeMap == null || !this.mErrorCodeMap.containsValue(errCode)) {
            return false;
        }
        return this.getDevtoolGroupedEnvInternal(errCode.toString(), "ignore_error_types", false);
    }

    private KeyType getKeyType(String key) {
        if (key.startsWith("error_code")) {
            return KeyType.ERROR_KEY;
        }
        if (key.startsWith("enable_cdp_domain")) {
            return KeyType.CDP_DOMAIN_KEY;
        }
        return KeyType.NORMAL_KEY;
    }

    private boolean needPersist(String key) {
        KeyType type = this.getKeyType(key);
        switch (type) {
            case ERROR_KEY: {
                return true;
            }
            case NORMAL_KEY: {
                if (this.mSwitchAttrMap == null || !this.mSwitchAttrMap.containsKey(key) || this.mSwitchAttrMap.get(key) == null) break;
                return (Boolean)this.mSwitchAttrMap.get(key).get(0);
            }
        }
        return false;
    }

    private boolean needSyncToNative(String key) {
        KeyType type = this.getKeyType(key);
        switch (type) {
            case CDP_DOMAIN_KEY: {
                return true;
            }
            case NORMAL_KEY: {
                if (this.mSwitchAttrMap == null || !this.mSwitchAttrMap.containsKey(key) || this.mSwitchAttrMap.get(key) == null) break;
                return (Boolean)this.mSwitchAttrMap.get(key).get(1);
            }
        }
        return false;
    }

    public void enableQuickjsDebug(boolean enabled) {
        this.setDevtoolEnv("enable_quickjs_debug", enabled);
    }

    public boolean isQuickjsDebugEnabled() {
        return this.getDevtoolEnv("enable_quickjs_debug", true);
    }

    public boolean isPreviewScreenShotEnabled() {
        return this.getDevtoolEnv("enable_preview_screen_shot", true);
    }

    public void enablePerfMetrics(boolean enable) {
        this.setDevtoolEnv(ENABLE_PERF_METRICS, enable);
    }

    public boolean isPerfMetricsEnabled() {
        return this.getDevtoolEnv(ENABLE_PERF_METRICS, false);
    }

    public boolean isAttached() {
        return true;
    }

    static enum KeyType {
        NORMAL_KEY,
        ERROR_KEY,
        CDP_DOMAIN_KEY;

    }
}

