/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lynx.debugrouter.ConnectionState;
import com.lynx.debugrouter.ConnectionType;
import com.lynx.debugrouter.DebugRouter;
import com.lynx.debugrouter.DebugRouterGlobalHandler;
import com.lynx.debugrouter.StateListener;
import com.lynx.devtool.LynxDevtoolEnv;
import com.lynx.devtool.LynxInspectorOwner;
import com.lynx.devtool.RecorderController;
import com.lynx.devtoolwrapper.LynxDevtoolCardListener;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.eventreport.ILynxEventReportObserver;
import com.lynx.tasm.eventreport.LynxEventReporter;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class LynxGlobalDebugBridge
implements DebugRouterGlobalHandler,
StateListener,
ILynxEventReportObserver {
    private static final String TAG = "LynxGlobalDebugBridge";
    private static final String GET_STOP_AT_ENTRY = "GetStopAtEntry";
    private static final String SET_STOP_AT_ENTRY = "SetStopAtEntry";
    private static final String GET_FETCH_DEBUG_INFO = "GetFetchDebugInfo";
    private static final String SET_FETCH_DEBUG_INFO = "SetFetchDebugInfo";
    private static final String CUSTOM_FOR_SET_GLOBAL_SWITCH = "SetGlobalSwitch";
    private static final String CUSTOM_FOR_GET_GLOBAL_SWITCH = "GetGlobalSwitch";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VALUE = "value";
    private static final String KEY_MTS = "MTS";
    private static final String KEY_BTS = "BTS";
    private static final String KEY_DEFAULT = "DEFAULT";
    private boolean mHasContext = false;
    private Context mContext;
    private WeakReference<ViewGroup> mRootView = null;
    private DevToolAgentDispatcher mAgentDispatcher;
    private Set<LynxDevtoolCardListener> mCardListeners = new HashSet<LynxDevtoolCardListener>();

    public static LynxGlobalDebugBridge getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private LynxGlobalDebugBridge() {
        this.mAgentDispatcher = new DevToolAgentDispatcher();
        DebugRouter.getInstance().addGlobalHandler((DebugRouterGlobalHandler)this);
        DebugRouter.getInstance().addStateListener((StateListener)this);
        LynxEventReporter.addObserver((ILynxEventReportObserver)this);
    }

    public void setContext(Context ctx) {
        if (this.mHasContext) {
            return;
        }
        this.mContext = ctx;
        this.mHasContext = true;
    }

    public boolean shouldPrepareRemoteDebug(String url) {
        return DebugRouter.getInstance().isValidSchema(url);
    }

    public boolean prepareRemoteDebug(String scheme) {
        return DebugRouter.getInstance().handleSchema(scheme);
    }

    public void setAppInfo(Context context, Map<String, String> appInfo) {
        if (appInfo == null) {
            return;
        }
        appInfo.put("sdkVersion", LynxEnv.inst().getLynxVersion());
        DebugRouter.getInstance().setAppInfo(context, appInfo);
    }

    public boolean isEnabled() {
        return DebugRouter.getInstance().getConnectionState() == ConnectionState.CONNECTED;
    }

    public void registerCardListener(LynxDevtoolCardListener listener) {
        if (listener != null) {
            this.mCardListeners.add(listener);
        }
    }

    public void openCard(String url) {
        for (LynxDevtoolCardListener listener : this.mCardListeners) {
            LLog.i((String)TAG, (String)("openCard: " + url + ", handled by " + listener.getClass().getName()));
            listener.open(url);
        }
    }

    public void onMessage(String type, int sessionId, String message) {
        if (type == null || message == null) {
            return;
        }
        if (type.equals(CUSTOM_FOR_SET_GLOBAL_SWITCH)) {
            Object result = this.mAgentDispatcher.setGlobalSwitch(message);
            DebugRouter.getInstance().sendDataAsync(CUSTOM_FOR_SET_GLOBAL_SWITCH, -1, String.valueOf(result));
        } else if (type.equals(CUSTOM_FOR_GET_GLOBAL_SWITCH)) {
            Object result = this.mAgentDispatcher.getGlobalSwitch(message);
            DebugRouter.getInstance().sendDataAsync(CUSTOM_FOR_GET_GLOBAL_SWITCH, -1, String.valueOf(result));
        } else {
            this.handleDevToolConfigMessage(message, type);
        }
    }

    private void handleDevToolConfigMessage(String message, String type) {
        if (!(type.equals(GET_STOP_AT_ENTRY) || type.equals(SET_STOP_AT_ENTRY) || type.equals(GET_FETCH_DEBUG_INFO) || type.equals(SET_FETCH_DEBUG_INFO))) {
            return;
        }
        try {
            JSONObject messageObj = new JSONObject(message);
            String key = messageObj.getString(KEY_TYPE);
            if (type.equals(GET_STOP_AT_ENTRY)) {
                boolean result = false;
                if (key.equals(KEY_MTS)) {
                    result = this.mAgentDispatcher.getStopAtEntry(true);
                } else if (key.equals(KEY_BTS) || key.equals(KEY_DEFAULT)) {
                    result = this.mAgentDispatcher.getStopAtEntry(false);
                }
                messageObj.put(KEY_VALUE, result);
            } else if (type.equals(SET_STOP_AT_ENTRY)) {
                boolean value = messageObj.getBoolean(KEY_VALUE);
                if (key.equals(KEY_MTS)) {
                    this.mAgentDispatcher.setStopAtEntry(value, true);
                } else if (key.equals(KEY_BTS) || key.equals(KEY_DEFAULT)) {
                    this.mAgentDispatcher.setStopAtEntry(value, false);
                }
            } else if (type.equals(GET_FETCH_DEBUG_INFO)) {
                boolean result = false;
                if (key.equals(KEY_MTS)) {
                    result = this.mAgentDispatcher.getFetchDebugInfo(true);
                }
                messageObj.put(KEY_VALUE, result);
            } else if (type.equals(SET_FETCH_DEBUG_INFO)) {
                boolean value = messageObj.getBoolean(KEY_VALUE);
                if (key.equals(KEY_MTS)) {
                    this.mAgentDispatcher.setFetchDebugInfo(value, true);
                }
            }
            DebugRouter.getInstance().sendDataAsync(type, -1, messageObj.toString());
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)String.format("handleStopAtEntry error! message: %s, type: %s, description: %s", message, type, e.getMessage()));
        }
    }

    public void startRecord() {
        RecorderController.nativeStartRecord();
    }

    public void onClose(int code, String reason) {
        this.enableTraceMode(false);
    }

    private void enableTraceMode(boolean enable) {
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_dom_tree", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_quickjs_debug", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_v8", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_preview_screen_shot", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_highlight_touch", !enable);
    }

    public void onError(String error) {
        this.enableTraceMode(false);
    }

    public void onOpen(ConnectionType type) {
        LynxDevtoolEnv.inst().setDevtoolEnv("devtool_connected", true);
    }

    public void onMessage(String text) {
    }

    public void onReportEvent(@NonNull String eventName, int instanceId, @NonNull Map<String, ?> props, @Nullable Map<String, ?> extraData) {
        this.onPerfMetricsEvent(eventName, new JSONObject(props), instanceId);
    }

    public void onPerfMetricsEvent(String eventName, @NonNull JSONObject data, int instanceId) {
        if (LynxDevtoolEnv.inst().isPerfMetricsEnabled() && this.mAgentDispatcher != null) {
            try {
                data.put("instanceId", instanceId);
                this.mAgentDispatcher.onPerfMetricsEvent(eventName, data);
            }
            catch (JSONException e) {
                LLog.e((String)TAG, (String)e.toString());
            }
        }
    }

    private static class DevToolAgentDispatcher
    extends LynxInspectorOwner {
        private DevToolAgentDispatcher() {
        }
    }

    private static class SingletonHolder {
        private static final LynxGlobalDebugBridge INSTANCE = new LynxGlobalDebugBridge();

        private SingletonHolder() {
        }
    }
}

