/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.lynx.basedevtool.utils.DevToolDownloader;
import com.lynx.basedevtool.utils.DownloadCallback;
import com.lynx.debugrouter.DebugRouter;
import com.lynx.devtool.DevToolPlatformAndroidDelegate;
import com.lynx.devtool.LynxDevMenu;
import com.lynx.devtool.LynxDevToolNGDelegate;
import com.lynx.devtool.LynxDevtoolEnv;
import com.lynx.devtool.helper.TestbenchDumpFileHelper;
import com.lynx.devtool.module.DevtoolWebSocketModule;
import com.lynx.devtool.tracing.FrameViewTrace;
import com.lynx.devtool.utils.ErrorUtils;
import com.lynx.devtoolwrapper.CDPResultCallback;
import com.lynx.devtoolwrapper.CustomizedMessage;
import com.lynx.devtoolwrapper.IDevToolDelegate;
import com.lynx.devtoolwrapper.LynxBaseInspectorOwnerNG;
import com.lynx.devtoolwrapper.MessageHandler;
import com.lynx.jsbridge.LynxModuleFactory;
import com.lynx.react.bridge.Callback;
import com.lynx.react.bridge.ReadableMap;
import com.lynx.recorder.LynxDebugInfoRecorder;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.LynxError;
import com.lynx.tasm.LynxGroup;
import com.lynx.tasm.LynxView;
import com.lynx.tasm.TemplateData;
import com.lynx.tasm.base.CalledByNative;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.base.PageReloadHelper;
import com.lynx.tasm.base.TraceEvent;
import com.lynx.tasm.behavior.LynxUIOwner;
import com.lynx.tasm.behavior.ui.LynxBaseUI;
import com.lynx.tasm.provider.LynxResourceCallback;
import com.lynx.tasm.provider.LynxResourceResponse;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class LynxInspectorOwner
implements LynxBaseInspectorOwnerNG {
    private static final String TAG = "LynxInspectorOwner";
    private static final String DEBUG_ACTIVE_MES = "Debugger.setDebugActive";
    private static final String GLOBAL_KEY = "global_key";
    private static final String GLOBAL_VALUE = "global_value";
    private WeakReference<LynxView> mLynxView;
    private boolean mIsDebugging;
    private boolean mNavigatePending;
    private LynxDevToolNGDelegate mLynxDevToolNG;
    private LynxDevMenu mDevMenu;
    private PageReloadHelper mReloadHelper;
    private DevToolPlatformAndroidDelegate mPlatform;
    private long mRecordID;
    private IDevToolDelegate mDevToolDelegate = null;
    private GlobalPropsObserver globalPropsObserver = null;
    private TemplateData cachedGlobalProps = null;

    public LynxInspectorOwner() {
        this.init();
    }

    public LynxInspectorOwner(LynxView lynxView) {
        this.init();
        this.mLynxView = new WeakReference<LynxView>(lynxView);
        this.mRecordID = 0L;
        this.mIsDebugging = false;
        this.mNavigatePending = false;
        this.mDevMenu = new LynxDevMenu(this, lynxView);
        this.mPlatform = new DevToolPlatformAndroidDelegate(lynxView);
        this.mReloadHelper = null;
        if (TraceEvent.enableTrace()) {
            FrameViewTrace.getInstance().attachView((View)lynxView);
        }
    }

    public void attach(LynxView lynxView) {
        this.mLynxView = new WeakReference<LynxView>(lynxView);
        if (this.mDevMenu != null) {
            this.mDevMenu.attach(lynxView);
        }
        if (this.mPlatform != null) {
            this.mPlatform.attach(lynxView);
        }
        if (TraceEvent.enableTrace()) {
            FrameViewTrace.getInstance().attachView((View)lynxView);
        }
    }

    public void init() {
        if (!LynxEnv.inst().isDevLibraryLoaded()) {
            LynxDevtoolEnv.inst().loadNativeDevtoolLibrary();
        }
        this.mLynxDevToolNG = new LynxDevToolNGDelegate();
    }

    public void attachLynxUIOwnerToAgent(LynxUIOwner uiOwner) {
        if (this.mPlatform != null) {
            this.mPlatform.attachLynxUIOwner(uiOwner);
        }
    }

    public void setReloadHelper(PageReloadHelper reloadHelper) {
        this.mReloadHelper = reloadHelper;
        if (this.mPlatform != null) {
            this.mPlatform.setReloadHelper(reloadHelper);
        }
    }

    public void setDebugInfoInterceptor(LynxDebugInfoRecorder debugInfoRecorder) {
        if (this.mPlatform != null) {
            this.mPlatform.setDebugInfoInterceptor(debugInfoRecorder);
        }
    }

    public void invokeCDPFromSDK(String cdpMsg, CDPResultCallback callback) {
        this.mLynxDevToolNG.invokeCDPFromSDK(cdpMsg, callback);
    }

    public void onRegisterModule(LynxModuleFactory moduleFactory) {
        moduleFactory.registerModule("DevtoolWebSocketModule", DevtoolWebSocketModule.class, null);
    }

    public boolean isDebugging() {
        return this.mIsDebugging;
    }

    public void attachToDebugBridge(String url) {
        LLog.i((String)TAG, (String)("attachToDebugBridge:" + url));
        if (this.mLynxDevToolNG != null) {
            if (!this.mLynxDevToolNG.isAttachToDebugRouter()) {
                int sessionId = this.mLynxDevToolNG.attachToDebug(url == null ? "" : url);
                LynxView lynxView = this.getLynxView();
                if (sessionId > 0 && lynxView != null) {
                    DebugRouter.getInstance().setSessionIdOfView((View)lynxView, sessionId);
                }
            }
            if (this.mRecordID != 0L) {
                this.initRecord();
            }
        }
    }

    private void initRecord() {
        LynxView lynxView = this.getLynxView();
        if (lynxView == null || lynxView.getLynxContext() == null) {
            return;
        }
        File dir = lynxView.getLynxContext().getExternalFilesDir(null);
        if (null == dir) {
            dir = lynxView.getLynxContext().getFilesDir();
        }
        if (dir == null) {
            return;
        }
        Resources resources = lynxView.getContext().getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        float screenWidth = dm.widthPixels;
        float screenHeight = dm.heightPixels;
        this.nativeInitRecorderConfig(dir.getPath(), this.mLynxDevToolNG.getSessionId(), screenWidth, screenHeight, this.mRecordID);
    }

    public void sendConsoleMessage(String text, int level, long timestamp) {
        if (this.mPlatform != null) {
            this.mPlatform.sendConsoleEvent(text, level, timestamp);
        }
    }

    public void savePostURL(@NonNull String postUrl) {
    }

    @CalledByNative
    public void reload(boolean ignoreCache) {
        this.reload(ignoreCache, null, false, 0);
    }

    public void reload(boolean ignoreCache, String templateBin, boolean fromTemplateFragments, int templateSize) {
        if (this.mReloadHelper != null) {
            LynxView lynxView = this.getLynxView();
            if (lynxView != null) {
                Toast.makeText((Context)lynxView.getContext(), (CharSequence)"Start to download & reload...", (int)0).show();
            }
            this.mReloadHelper.reload(ignoreCache, templateBin, fromTemplateFragments, templateSize);
        }
    }

    public void onReceiveTemplateFragment(String data, boolean eof) {
        if (this.mReloadHelper != null) {
            this.mReloadHelper.onReceiveTemplateFragment(data, eof);
        }
    }

    public void navigate(String url) {
        if (this.mReloadHelper != null) {
            this.mNavigatePending = true;
            this.mReloadHelper.navigate(url);
        }
    }

    @Deprecated
    public String getGroupID() {
        return LynxGroup.SINGNLE_GROUP;
    }

    public void destroy() {
        try {
            this.stopCasting();
            if (this.mLynxDevToolNG != null) {
                this.mLynxDevToolNG.detachToDebug();
                this.mLynxDevToolNG.destroy();
                this.mLynxDevToolNG = null;
            }
            if (this.mPlatform != null) {
                this.mPlatform.destroy();
                this.mPlatform = null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void onTemplateAssemblerCreated(long ptr) {
        if (this.mLynxDevToolNG != null) {
            this.mLynxDevToolNG.onTASMCreated(ptr);
            if (this.mPlatform != null) {
                this.mLynxDevToolNG.setDevToolPlatformAbility(this.mPlatform.getNativePtr());
                this.mPlatform.setDevToolDelegate(this.mDevToolDelegate);
            }
        }
        this.mRecordID = ptr;
    }

    public long onBackgroundRuntimeCreated(String groupName) {
        if (this.mLynxDevToolNG != null) {
            return this.mLynxDevToolNG.onBackgroundRuntimeCreated(groupName);
        }
        return 0L;
    }

    public static boolean isApkDebuggable(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public void stopCasting() {
        try {
            this.mPlatform.stopCasting();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void continueCasting() {
        try {
            if (this.mLynxDevToolNG != null && this.mLynxDevToolNG.isAttachToDebugRouter()) {
                this.mPlatform.continueCasting();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void pauseCasting() {
        try {
            if (this.mLynxDevToolNG != null && this.mLynxDevToolNG.isAttachToDebugRouter()) {
                this.mPlatform.pauseCasting();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public LynxView getLynxView() {
        return (LynxView)this.mLynxView.get();
    }

    @Deprecated
    public void sendResponse(String response) {
        Log.v((String)TAG, (String)response);
        if (this.mLynxDevToolNG != null) {
            this.mLynxDevToolNG.sendMessageToDebugPlatform("CDP", response);
        }
    }

    public int getSessionID() {
        return this.mLynxDevToolNG != null ? this.mLynxDevToolNG.getSessionId() : 0;
    }

    public void onRootViewInputEvent(InputEvent event) {
        if (!LynxEnv.inst().isDevtoolEnabled()) {
            return;
        }
        if (event instanceof MotionEvent && this.mDevMenu != null) {
            MotionEvent motionEvent = (MotionEvent)event;
            if (LynxDevtoolEnv.inst().isLongPressMenuEnabled()) {
                this.mDevMenu.onRootViewTouchEvent(motionEvent);
            }
            String[] values = new String[]{String.valueOf(motionEvent.getAction()), String.valueOf(motionEvent.getX()), String.valueOf(motionEvent.getY()), String.valueOf(motionEvent.getMetaState())};
            this.nativeRecordEventAndroid(0, values, this.mRecordID);
        } else if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            String[] values = new String[]{String.valueOf(keyEvent.getAction()), String.valueOf(keyEvent.getKeyCode()), String.valueOf(keyEvent.getMetaState())};
            this.nativeRecordEventAndroid(1, values, this.mRecordID);
        }
    }

    @Deprecated
    public boolean isHttpServerWorking() {
        return false;
    }

    @Deprecated
    public String getHttpServerIp() {
        return "Not Supported";
    }

    @Deprecated
    public String getHttpServerPort() {
        return "";
    }

    public View getTemplateView() {
        return (View)this.mLynxView.get();
    }

    @CalledByNative
    public String getTemplateUrl() {
        if (this.mPlatform != null) {
            return this.mPlatform.getTemplateUrl();
        }
        return "";
    }

    public long getTemplateDataPtr() {
        if (this.mReloadHelper != null) {
            return this.mReloadHelper.getTemplateDataPtr();
        }
        return 0L;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getTemplateJsInfo(int offset, int size) {
        if (this.mReloadHelper != null) {
            return this.mReloadHelper.getTemplateJsInfo(offset, size);
        }
        return "";
    }

    public void sendMessage(CustomizedMessage message) {
        if (this.mLynxDevToolNG != null && message != null) {
            this.mLynxDevToolNG.sendMessageToDebugPlatform(message.getType(), message.getData());
        }
    }

    public void subscribeMessage(String type, MessageHandler handler) {
        if (this.mLynxDevToolNG != null) {
            this.mLynxDevToolNG.subscribeMessage(type, handler);
        }
    }

    public void unsubscribeMessage(String type) {
        if (this.mLynxDevToolNG != null) {
            this.mLynxDevToolNG.unSubscribeMessage(type);
        }
    }

    public void updateScreenMetrics(int width, int height, float density) {
        if (this.mLynxDevToolNG != null) {
            this.mLynxDevToolNG.updateScreenMetrics(width, height, density);
        }
    }

    public void setStopAtEntry(boolean stop, boolean isMTS) {
        this.nativeSetStopAtEntry(stop, isMTS);
    }

    public boolean getStopAtEntry(boolean isMTS) {
        return this.nativeGetStopAtEntry(isMTS);
    }

    public void setFetchDebugInfo(boolean fetch, boolean isMTS) {
        this.nativeSetFetchDebugInfo(fetch, isMTS);
    }

    public boolean getFetchDebugInfo(boolean isMTS) {
        return this.nativeGetFetchDebugInfo(isMTS);
    }

    public Object setGlobalSwitch(String message) {
        try {
            JSONObject messageObj = new JSONObject(message);
            LynxDevtoolEnv.inst().setDevtoolEnv(messageObj.getString(GLOBAL_KEY), messageObj.get(GLOBAL_VALUE));
            return messageObj.get(GLOBAL_VALUE);
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    public Object getGlobalSwitch(String message) {
        try {
            JSONObject messageObj = new JSONObject(message);
            String key = messageObj.getString(GLOBAL_KEY);
            return LynxDevtoolEnv.inst().getDevtoolObjectEnv(key, LynxDevtoolEnv.inst().getDefaultValue(key));
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    public void addUITreeToTestbench() {
        LynxView lynxView = this.getLynxView();
        if (lynxView != null && lynxView.getLynxUIRoot() != null) {
            this.sendFileByAgent("UITree", TestbenchDumpFileHelper.getUITree((LynxBaseUI)lynxView.getLynxUIRoot()));
        }
    }

    public void addViewTreeToTestbench() {
        LynxView lynxView = this.getLynxView();
        if (lynxView != null && lynxView.getRootView() != null) {
            this.sendFileByAgent("ViewTree", TestbenchDumpFileHelper.getViewTree(lynxView.getRootView()));
        }
    }

    public void sendFileByAgent(String type, String file) {
        this.nativeSendFileByAgent(type, file);
    }

    public void endTestbench(String filePath) {
        LLog.d((String)TAG, (String)"end testbench replay test");
        this.addUITreeToTestbench();
        this.addViewTreeToTestbench();
        this.nativeEndTestbench(filePath);
    }

    public void onPageUpdate() {
        if (this.mPlatform != null) {
            this.mPlatform.sendLayerTreeDidChangeEvent();
        }
    }

    public void downloadResource(final String url, final LynxResourceCallback<byte[]> callback) {
        new DevToolDownloader(url, new DownloadCallback(){

            public void onResponse(int status, int contentLength) {
            }

            public void onData(byte[] bytes, int length) {
                callback.onResponse(LynxResourceResponse.success((Object)bytes));
            }

            public void onFailure(String reason) {
                callback.onResponse(LynxResourceResponse.failed((int)-1, (Throwable)new Exception("download fail with url: " + url + ", the reason is: " + reason)));
            }
        });
    }

    public void setLynxInspectorConsoleDelegate(Object delegate) {
        if (this.mPlatform != null) {
            this.mPlatform.setLynxInspectorConsoleDelegate(delegate);
        }
    }

    public void getConsoleObject(String objectId, boolean needStringify, Callback callback) {
        if (this.mPlatform != null) {
            this.mPlatform.getConsoleObject(objectId, needStringify, callback);
        }
    }

    public void onPerfMetricsEvent(String eventName, @NonNull JSONObject data) {
        if (!LynxDevtoolEnv.inst().isPerfMetricsEnabled()) {
            return;
        }
        try {
            JSONObject eventInfo = new JSONObject();
            eventInfo.put("method", (Object)eventName);
            eventInfo.put("params", (Object)data);
            this.sendMessage(new CustomizedMessage("CDP", eventInfo.toString()));
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.toString());
        }
    }

    public String getDebugInfoUrl(String fileName) {
        if (this.mPlatform != null) {
            return this.mPlatform.getLepusDebugInfoUrl(fileName);
        }
        return "";
    }

    public void onReceiveMessageEvent(ReadableMap event) {
        if (this.mLynxDevToolNG == null || !this.mLynxDevToolNG.isAttachToDebugRouter()) {
            return;
        }
        if (event == null) {
            return;
        }
        String eventName = event.getString("type");
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        try {
            JSONObject object = new JSONObject();
            object.putOpt("event", (Object)eventName);
            object.putOpt("vmType", (Object)event.getString("origin", ""));
            object.putOpt("data", (Object)event.getString("data", ""));
            this.handleCDPEvent("Lynx.onVMEvent", object);
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.toString());
        }
    }

    public void setDevToolDelegate(IDevToolDelegate devToolDelegate) {
        this.mDevToolDelegate = devToolDelegate;
        if (this.mPlatform != null) {
            this.mPlatform.setDevToolDelegate(devToolDelegate);
        }
    }

    public void dispatchMessageEvent(ReadableMap event) {
        if (this.mDevToolDelegate != null) {
            this.mDevToolDelegate.onDispatchMessageEvent(event);
        }
    }

    private void handleCDPEvent(String event, JSONObject params) throws JSONException {
        if (this.mLynxDevToolNG == null || !this.mLynxDevToolNG.isAttachToDebugRouter()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)event)) {
            return;
        }
        JSONObject msg = new JSONObject();
        msg.put("method", (Object)event);
        if (params != null && params.length() > 0) {
            msg.put("params", (Object)params);
        }
        this.mLynxDevToolNG.sendMessageToDebugPlatform("CDP", msg.toString());
    }

    void getViewLocationOnScreen(int[] outLocation) {
        if (outLocation == null || outLocation.length < 2 || this.mLynxView == null) {
            return;
        }
        LynxView view = (LynxView)this.mLynxView.get();
        if (view != null && view.getLynxContext() != null) {
            view.getLocationOnScreen(outLocation);
            float scale = view.getLynxContext().getResources().getDisplayMetrics().density;
            outLocation[0] = (int)((float)outLocation[0] / scale);
            outLocation[1] = (int)((float)outLocation[1] / scale);
        }
    }

    public void registerGlobalPropsUpdatedObserver(GlobalPropsObserver observer) {
        this.globalPropsObserver = observer;
        if (this.cachedGlobalProps != null) {
            this.triggerGlobalPropsObserver();
        }
    }

    public void onGlobalPropsUpdated(TemplateData props) {
        this.cachedGlobalProps = props;
        this.triggerGlobalPropsObserver();
    }

    private void triggerGlobalPropsObserver() {
        if (this.globalPropsObserver != null) {
            Map globalProps = null;
            if (this.cachedGlobalProps != null) {
                globalProps = this.cachedGlobalProps.toMap();
            }
            this.globalPropsObserver.onGlobalPropsUpdated(globalProps);
        }
    }

    public void showErrorMessageOnConsole(LynxError error) {
        if (error == null || !error.isValid() || error.isJSError() || error.isLepusError()) {
            return;
        }
        String errMsg = ErrorUtils.getKeyMessage(error);
        String consoleLog = "Native error:\n" + errMsg;
        int level = ErrorUtils.errorLevelStrToInt(error.getLevel());
        this.sendConsoleMessage(consoleLog, level, System.currentTimeMillis());
    }

    public void showMessageOnConsole(String message, int level) {
        if (message == null) {
            return;
        }
        this.sendConsoleMessage(message, level, System.currentTimeMillis());
    }

    private native void nativeSetStopAtEntry(boolean var1, boolean var2);

    private native boolean nativeGetStopAtEntry(boolean var1);

    private native void nativeSetFetchDebugInfo(boolean var1, boolean var2);

    private native boolean nativeGetFetchDebugInfo(boolean var1);

    private native void nativeInitRecorderConfig(String var1, int var2, float var3, float var4, long var5);

    private native void nativeSendFileByAgent(String var1, String var2);

    private native void nativeEndTestbench(String var1);

    private native void nativeRecordEventAndroid(int var1, String[] var2, long var3);

    public static interface GlobalPropsObserver {
        public void onGlobalPropsUpdated(Map var1);
    }
}

