/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.framecapture;

import android.graphics.Bitmap;
import android.os.Build;
import android.view.View;
import com.lynx.devtool.framecapture.FrameTraceUtil;
import com.lynx.devtool.helper.ScreenCapturer;
import com.lynx.devtoolwrapper.ScreenshotBitmapHandler;
import com.lynx.tasm.utils.UIThreadUtils;
import java.lang.ref.WeakReference;

public abstract class FrameCapturer {
    protected int mScreenshotQuality = 70;
    protected long mMaxScreenshotAreaSize = 256000L;
    protected int mScreenshotInterval = 32000;
    protected WeakReference<View> mView = new WeakReference<Object>(null);
    protected long mLastScreenshotTime = 0L;
    protected volatile String mScreenshotBitmapDataCache;
    protected FrameChangeListener mFrameChangeListener;
    private final Runnable mCallback = new Runnable(){

        @Override
        public void run() {
            if (FrameCapturer.this.mFrameChangeListener == null) {
                FrameCapturer.this.screenshot();
            } else {
                FrameCapturer.this.mFrameChangeListener.onFrameChanged();
            }
            if (FrameCapturer.this.isEnabled()) {
                FrameCapturer.this.addFrameViewCallback();
            }
        }
    };
    private static final int CALLBACK_LAST = Build.VERSION.SDK_INT < 23 ? 2 : (Build.VERSION.SDK_INT < 29 ? 3 : 4);

    protected abstract boolean isEnabled();

    protected abstract void onNewScreenshotBitmapData(String var1);

    public void attachView(View view) {
        this.mView = new WeakReference<View>(view);
    }

    public void startFrameViewTrace() {
        this.clearScreenshotBitmapDataCache();
        if (this.isEnabled()) {
            this.addFrameViewCallback();
        }
    }

    public void stopFrameViewTrace() {
    }

    public void clearScreenshotBitmapDataCache() {
        this.mScreenshotBitmapDataCache = null;
    }

    protected void addFrameViewCallback() {
        if (this.isEnabled()) {
            FrameTraceUtil.addFrameCallback(this.mCallback);
        }
    }

    protected void screenshot() {
        long currentTime = FrameTraceUtil.getSystemBootTimeNs() / 1000L;
        if (currentTime - this.mLastScreenshotTime < (long)this.mScreenshotInterval) {
            return;
        }
        this.mLastScreenshotTime = currentTime;
        UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                View view = (View)FrameCapturer.this.mView.get();
                if (view == null) {
                    return;
                }
                FrameCapturer.this.onScreenshotActionStart();
                try {
                    FrameCapturer.this.screenshot(view, new ScreenshotBitmapHandler(){

                        public void sendBitmap(Bitmap bitmap) {
                            ScreenCapturer.getInstance().onScreenshotBitmapReady(bitmap);
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void onScreenshotActionEnd() {
    }

    protected void onScreenshotActionStart() {
    }

    protected abstract void screenshot(View var1, ScreenshotBitmapHandler var2);

    public static interface FrameChangeListener {
        public void onFrameChanged();
    }
}

