/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.helper;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.DisplayMetrics;
import android.view.Choreographer;
import android.view.View;
import androidx.annotation.NonNull;
import com.lynx.devtool.framecapture.FrameCapturer;
import com.lynx.devtoolwrapper.IDevToolDelegate;
import com.lynx.devtoolwrapper.ScreenshotBitmapHandler;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.utils.BitmapUtils;
import com.lynx.tasm.utils.DisplayMetricsHolder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScreenCapturer
extends FrameCapturer {
    private static final String TAG = "ScreenCapturer";
    private static final ScreenCapturer mInstance = new ScreenCapturer();
    private static final int CARD_PREVIEW_QUALITY = 100;
    private static final int CARD_PREVIEW_MAX_WIDTH = 400;
    private static final int CARD_PREVIEW_MAX_HEIGHT = 800;
    private IDevToolDelegate mDevToolDelegate = null;
    public static final int SCREEN_SHOT_PREVIEW_DELAY_TIME = 1500;
    private final ScreenRequest mScreenRequest;
    private final ScreenMetadata mScreenMetadata;
    private boolean mIsEnabled = false;
    private ScreenshotListener mScreenshotListener = null;
    private final AtomicBoolean mAckReceived;
    protected AtomicBoolean mIsDirty;
    private Choreographer.FrameCallback mResetDirtyCallBack;
    private volatile long mScreenshotOnMainThreadTime = 0L;
    private long mScreenshotStartTime = 0L;
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            return new Thread(runnable, ScreenCapturer.TAG);
        }
    });

    public static ScreenCapturer getInstance() {
        return mInstance;
    }

    private ScreenCapturer() {
        this.mScreenRequest = new ScreenRequest();
        this.mScreenMetadata = new ScreenMetadata();
        this.mAckReceived = new AtomicBoolean(false);
        this.mIsDirty = new AtomicBoolean(false);
        this.mFrameChangeListener = new FrameCapturer.FrameChangeListener(){

            @Override
            public void onFrameChanged() {
                ScreenCapturer.this.triggerNextCapture();
            }
        };
        this.mResetDirtyCallBack = new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                ScreenCapturer.this.mIsDirty.set(true);
                Choreographer.getInstance().postFrameCallback(ScreenCapturer.this.mResetDirtyCallBack);
            }
        };
    }

    public void setDevToolDelegate(IDevToolDelegate devToolDelegate) {
        this.mDevToolDelegate = devToolDelegate;
    }

    public void startCapture(int maxWidth, int maxHeight, int quality, String screenShotMode, ScreenshotListener listener) {
        this.mScreenRequest.mMaxWidth = maxWidth;
        this.mScreenRequest.mMaxHeight = maxHeight;
        this.mScreenRequest.mQuality = quality;
        this.mScreenRequest.mScreenshotMode = screenShotMode;
        this.mScreenshotListener = listener;
        this.mIsEnabled = true;
        this.addResetDirtyStatusCallBack();
        this.startFrameViewTrace();
        this.triggerNextCapture();
    }

    private void addResetDirtyStatusCallBack() {
        Choreographer.getInstance().postFrameCallback(this.mResetDirtyCallBack);
    }

    public void stopCapture(View targetView) {
        if (targetView != this.mView.get()) {
            return;
        }
        this.stopFrameViewTrace();
        this.mIsEnabled = false;
        this.mView.clear();
    }

    public void triggerNextCapture() {
        if (!this.mIsEnabled) {
            return;
        }
        if (this.mScreenshotBitmapDataCache == null || this.mAckReceived.get() && this.mIsDirty.get()) {
            this.screenshot();
        }
    }

    public void onAckReceived() {
        this.mAckReceived.set(true);
        this.triggerNextCapture();
    }

    public ScreenMetadata getScreenMetadata() {
        return this.mScreenMetadata;
    }

    @Override
    protected boolean isEnabled() {
        return this.mIsEnabled;
    }

    protected String getScreenshotDataFromBitmap(Bitmap bitmap, boolean isPreview) {
        int quality = isPreview ? 100 : this.mScreenRequest.mQuality;
        int maxWidth = isPreview ? 400 : this.mScreenRequest.mMaxWidth;
        int maxHeight = isPreview ? 800 : this.mScreenRequest.mMaxHeight;
        return BitmapUtils.bitmapToBase64WithQuality((Bitmap)this.scaleImage(bitmap, maxWidth, maxHeight), (int)quality);
    }

    public void onScreenshotBitmapReady(final Bitmap bitmap) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (bitmap != null) {
                    String screenshotData = ScreenCapturer.this.getScreenshotDataFromBitmap(bitmap, false);
                    if (screenshotData == null || screenshotData.equals(ScreenCapturer.this.mScreenshotBitmapDataCache)) {
                        return;
                    }
                    ScreenCapturer.this.mScreenshotBitmapDataCache = screenshotData;
                    ScreenCapturer.this.onNewScreenshotBitmapData(ScreenCapturer.this.mScreenshotBitmapDataCache);
                }
            }
        });
    }

    @Override
    protected void onNewScreenshotBitmapData(String data) {
        this.mAckReceived.set(false);
        if (this.mScreenshotListener != null) {
            if (this.mScreenshotOnMainThreadTime == 0L) {
                LLog.e((String)TAG, (String)"onNewScreenshotBitmapData: screenshotMainTime == 0");
            }
            this.mScreenshotListener.onNewScreenshotBitmapData(data, this.mScreenshotOnMainThreadTime);
        }
    }

    @Override
    protected void onScreenshotActionStart() {
        this.mIsDirty.set(false);
        this.mScreenshotStartTime = System.nanoTime();
        this.mScreenshotOnMainThreadTime = 0L;
    }

    @Override
    protected void onScreenshotActionEnd() {
        if (this.mScreenshotStartTime == 0L) {
            LLog.e((String)TAG, (String)"onScreenshotActionEnd: lastTime == 0");
            return;
        }
        this.mScreenshotOnMainThreadTime = System.nanoTime() - this.mScreenshotStartTime;
    }

    @Override
    protected void screenshot(View view, ScreenshotBitmapHandler handler) {
        if (this.mDevToolDelegate != null) {
            this.mDevToolDelegate.takeScreenshot(handler, this.mScreenRequest.mScreenshotMode);
        }
        this.onScreenshotActionEnd();
    }

    public void submit(Runnable task) {
        this.executorService.submit(task);
    }

    private float getScale(int originalWidth, int originalHeight, int maxWidth, int maxHeight) {
        float scale = 0.0f;
        float scalingWidth = 1.0f;
        float scalingHeight = 1.0f;
        try {
            if (maxWidth != 0 && maxHeight != 0 && (originalWidth > maxWidth || originalHeight > maxHeight)) {
                scalingWidth = (float)maxWidth / (float)originalWidth;
                scalingHeight = (float)maxHeight / (float)originalHeight;
            }
            scale = Math.min(scalingWidth, scalingHeight);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return scale;
    }

    private Bitmap scaleImage(Bitmap bitmap, int maxWidth, int maxHeight) {
        if (bitmap == null) {
            LLog.e((String)TAG, (String)"scaleImage: bitmap is null");
            return null;
        }
        int originalWidth = bitmap.getWidth();
        int originalHeight = bitmap.getHeight();
        float scale = this.getScale(originalWidth, originalHeight, maxWidth, maxHeight);
        DisplayMetrics dm = DisplayMetricsHolder.getScreenDisplayMetrics();
        this.mScreenMetadata.mDeviceWidth = (float)originalWidth / dm.density;
        this.mScreenMetadata.mDeviceHeight = (float)originalHeight / dm.density;
        this.mScreenMetadata.mPageScaleFactor = 1.0f;
        try {
            Matrix matrix = new Matrix();
            matrix.postScale(scale, scale);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)originalWidth, (int)originalHeight, (Matrix)matrix, (boolean)false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static interface ScreenshotListener {
        public void onNewScreenshotBitmapData(String var1, long var2);
    }

    public static class ScreenMetadata {
        public float mOffsetTop;
        public float mPageScaleFactor;
        public float mDeviceWidth;
        public float mDeviceHeight;
        public float mScrollOffsetX;
        public float mScrollOffsetY;
        public float mTimestamp;
    }

    private static class ScreenRequest {
        private int mMaxWidth;
        private int mMaxHeight;
        private int mQuality;
        private String mScreenshotMode;

        private ScreenRequest() {
        }
    }
}

