/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.helper;

import android.graphics.Bitmap;
import android.view.View;
import com.lynx.devtool.DevToolPlatformAndroidDelegate;
import com.lynx.devtool.helper.ScreenCapturer;
import com.lynx.devtoolwrapper.IDevToolDelegate;
import com.lynx.tasm.LynxView;
import java.lang.ref.WeakReference;

public class ScreenCastHelper {
    private WeakReference<DevToolPlatformAndroidDelegate> mPlatformDelegate;
    private WeakReference<LynxView> mLynxView;
    private volatile boolean mPaused;
    private volatile boolean mScreencastEnabled;

    public ScreenCastHelper(DevToolPlatformAndroidDelegate platformDelegate, LynxView lynxView) {
        this.mPlatformDelegate = new WeakReference<DevToolPlatformAndroidDelegate>(platformDelegate);
        this.mLynxView = new WeakReference<LynxView>(lynxView);
        this.mPaused = false;
        this.mScreencastEnabled = false;
    }

    public void attach(LynxView lynxView) {
        this.mLynxView = new WeakReference<LynxView>(lynxView);
        ScreenCapturer.getInstance().attachView((View)lynxView);
    }

    public void startCasting(int quality, int maxWidth, int maxHeight, String screenShotMode, IDevToolDelegate devToolDelegate) {
        this.mScreencastEnabled = true;
        DevToolPlatformAndroidDelegate platformDelegate = (DevToolPlatformAndroidDelegate)this.mPlatformDelegate.get();
        if (platformDelegate != null) {
            platformDelegate.dispatchScreencastVisibilityChanged(true);
        }
        ScreenCapturer.getInstance().attachView((View)this.mLynxView.get());
        ScreenCapturer.getInstance().setDevToolDelegate(devToolDelegate);
        ScreenCapturer.getInstance().startCapture(maxWidth, maxHeight, quality, screenShotMode, new ScreenCapturer.ScreenshotListener(){

            @Override
            public void onNewScreenshotBitmapData(String screenData, long timeCost) {
                ScreenCapturer.ScreenMetadata metadata = ScreenCapturer.getInstance().getScreenMetadata();
                float time = (float)((double)timeCost / 1000000.0);
                DevToolPlatformAndroidDelegate platformDelegate = (DevToolPlatformAndroidDelegate)ScreenCastHelper.this.mPlatformDelegate.get();
                if (platformDelegate != null) {
                    platformDelegate.sendScreenCast(screenData, metadata, metadata.mPageScaleFactor, time);
                }
            }
        });
    }

    public void stopCasting() {
        this.mScreencastEnabled = false;
        LynxView lynxView = (LynxView)this.mLynxView.get();
        if (lynxView != null) {
            ScreenCapturer.getInstance().stopCapture((View)lynxView);
            DevToolPlatformAndroidDelegate platformDelegate = (DevToolPlatformAndroidDelegate)this.mPlatformDelegate.get();
            if (platformDelegate != null) {
                platformDelegate.dispatchScreencastVisibilityChanged(false);
            }
        }
    }

    public void continueCasting() {
        if (this.mScreencastEnabled && this.mPaused) {
            ScreenCapturer.getInstance().clearScreenshotBitmapDataCache();
            this.mPaused = false;
            DevToolPlatformAndroidDelegate platformDelegate = (DevToolPlatformAndroidDelegate)this.mPlatformDelegate.get();
            if (platformDelegate != null) {
                platformDelegate.dispatchScreencastVisibilityChanged(true);
            }
            ScreenCapturer.getInstance().triggerNextCapture();
        }
    }

    public void pauseCasting() {
        if (this.mScreencastEnabled && !this.mPaused) {
            this.mPaused = true;
            DevToolPlatformAndroidDelegate platformDelegate = (DevToolPlatformAndroidDelegate)this.mPlatformDelegate.get();
            if (platformDelegate != null) {
                platformDelegate.dispatchScreencastVisibilityChanged(false);
            }
        }
    }

    public void onAckReceived() {
        ScreenCapturer.getInstance().onAckReceived();
    }

    public void sendCardPreview(final IDevToolDelegate devToolDelegate) {
        LynxView lynxView = (LynxView)this.mLynxView.get();
        if (lynxView != null && devToolDelegate != null) {
            lynxView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    final Bitmap bitmap = devToolDelegate.getBitmapOfView();
                    ScreenCapturer.getInstance().submit(new Runnable(){

                        @Override
                        public void run() {
                            String cardPreviewData = ScreenCapturer.getInstance().getScreenshotDataFromBitmap(bitmap, true);
                            DevToolPlatformAndroidDelegate platformDelegate = (DevToolPlatformAndroidDelegate)ScreenCastHelper.this.mPlatformDelegate.get();
                            if (platformDelegate != null) {
                                platformDelegate.sendCardPreviewData(cardPreviewData);
                            }
                        }
                    });
                }
            }, 1500L);
        }
    }
}

