/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.logbox;

import android.content.Context;
import com.lynx.basedevtool.logbox.ILogBoxResourceProvider;
import com.lynx.basedevtool.logbox.LogBoxLogLevel;
import com.lynx.basedevtool.logbox.LogBoxProxy;
import com.lynx.devtoolwrapper.ILynxLogBox;
import com.lynx.devtoolwrapper.LynxDevtool;
import com.lynx.tasm.LynxError;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.behavior.LynxContext;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxLogBoxWrapper
implements ILynxLogBox,
ILogBoxResourceProvider {
    private static final String TAG = "LynxLogBoxWrapper";
    private LogBoxProxy mLogBoxProxy;
    private WeakReference<LynxDevtool> mDevtool;

    public LynxLogBoxWrapper(LynxDevtool devtool) {
        this.mDevtool = new WeakReference<LynxDevtool>(devtool);
        LynxContext context = null;
        if (devtool != null) {
            context = devtool.getLynxContext();
        }
        this.mLogBoxProxy = new LogBoxProxy((Context)context, "lynx", (ILogBoxResourceProvider)this);
        this.mLogBoxProxy.registerErrorParser("logbox/lynx-error-parser.js");
    }

    public void showLogMessage(LynxError error) {
        String message = error.getMsg();
        LogBoxLogLevel level = error.getLevel().equals("warn") ? LogBoxLogLevel.Warn : LogBoxLogLevel.Error;
        this.sendErrorEventToPerf(message, level);
        this.mLogBoxProxy.showLogMessage(message, level);
    }

    public void onLoadTemplate() {
        this.mLogBoxProxy.reset();
    }

    public void attachContext(Context context) {
        this.mLogBoxProxy.attachContext(context);
    }

    public String getEntryUrlForLogSrc() {
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        return devtool == null ? "" : devtool.getTemplateUrl();
    }

    public Map<String, Object> getLogSources() {
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        return devtool == null ? null : devtool.getAllJsSource();
    }

    public String getLogSourceWithFileName(String fileName) {
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        if (devtool == null) {
            return "";
        }
        if (fileName.endsWith("main-thread.js")) {
            return devtool.getDebugInfoUrl(fileName);
        }
        Map<String, Object> logSources = this.getLogSources();
        String value = "";
        int matchLength = 0;
        for (Map.Entry<String, Object> entry : logSources.entrySet()) {
            String key = entry.getKey();
            if (!fileName.endsWith(key) || key.length() <= matchLength) continue;
            matchLength = key.length();
            value = (String)entry.getValue();
        }
        return value;
    }

    protected void sendErrorEventToPerf(String message, LogBoxLogLevel level) {
        if (level == LogBoxLogLevel.Info) {
            return;
        }
        LynxDevtool devtool = (LynxDevtool)this.mDevtool.get();
        if (devtool == null) {
            return;
        }
        try {
            JSONObject eventData = new JSONObject();
            eventData.put("error", (Object)message);
            devtool.onPerfMetricsEvent("lynx_error_event", eventData);
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.toString());
        }
    }
}

