/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.lynx.BuildConfig;
import com.lynx.devtool.recorder.LynxRecorderActionCallback;
import com.lynx.devtool.recorder.LynxRecorderEnv;
import com.lynx.devtool.recorder.LynxRecorderEventSend;
import com.lynx.devtool.recorder.LynxRecorderFetcher;
import com.lynx.devtool.recorder.LynxRecorderOpenUrlModule;
import com.lynx.devtool.recorder.LynxRecorderReplayDataModule;
import com.lynx.devtool.recorder.LynxRecorderReplayDataProvider;
import com.lynx.devtool.recorder.LynxRecorderReplayStateView;
import com.lynx.devtool.recorder.LynxRecorderSourceProvider;
import com.lynx.devtool.recorder.LynxRecorderTemplateProvider;
import com.lynx.devtool.recorder.QueryMapUtils;
import com.lynx.devtool.recorder.Utils;
import com.lynx.devtoolwrapper.LynxBaseInspectorOwner;
import com.lynx.recorder.LynxDebugInfoRecorder;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.LynxGroup;
import com.lynx.tasm.LynxLoadMeta;
import com.lynx.tasm.LynxLoadMode;
import com.lynx.tasm.LynxUpdateMeta;
import com.lynx.tasm.LynxView;
import com.lynx.tasm.LynxViewBuilder;
import com.lynx.tasm.LynxViewClient;
import com.lynx.tasm.TemplateBundle;
import com.lynx.tasm.TemplateBundleOption;
import com.lynx.tasm.TemplateData;
import com.lynx.tasm.ThreadStrategyForRendering;
import com.lynx.tasm.behavior.Behavior;
import com.lynx.tasm.behavior.BuiltInBehavior;
import com.lynx.tasm.behavior.LynxContext;
import com.lynx.tasm.behavior.shadow.ShadowNode;
import com.lynx.tasm.behavior.shadow.text.RawTextShadowNode;
import com.lynx.tasm.behavior.ui.LynxUI;
import com.lynx.tasm.behavior.ui.view.UIView;
import com.lynx.tasm.component.DynamicComponentFetcher;
import com.lynx.tasm.provider.AbsTemplateProvider;
import com.lynx.tasm.provider.LynxResourceProvider;
import com.lynx.tasm.utils.LynxViewBuilderProperty;
import com.lynx.tasm.utils.UIThreadUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.Inflater;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxRecorderActionManager {
    private static final String TAG = "LynxRecorderActionManager";
    private static final int UPDATE_PRE_DATA = 0;
    private static final int UPDATE_VIEW_PORT = 1;
    private static final int SET_THREAD_STRATEGY = 2;
    private static final int SET_GLOBAL_PROPS = 3;
    private static final int LOAD_TEMPLATE = 4;
    private static final int LOAD_TEMPLATE_BUNDLE = 9;
    private static final int SEND_GLOBAL_EVENT = 5;
    private static final int SEND_EVENT_ANDROID = 6;
    private static final int RELOAD_TEMPLATE = 7;
    private static final int UPDATE_FONT_SCALE = 11;
    private static final int END_TESTBENCH = 10;
    private static final int UPDATE_META_DATA = 13;
    private static final int ON_TESTBENCH_COMPLETE = 14;
    private static final int SWITCH_ENGINE_FROM_UI_THREAD = 15;
    private static final int IS_VIRTUAL_NODE = 2;
    private static final int IS_FLATTEN_NODE = 8;
    private static final HashMap<String, Integer> mCanMockFuncMap = new HashMap();
    private static final HashSet<String> mReloadFuncSet;
    private long mStartTime = 0L;
    private ArrayList<ReloadAction> mReloadList;
    private final ViewGroup mViewGroup;
    private final Intent mIntent;
    private final ArrayList<LynxRecorderActionCallback> mCallbacks;
    private final Handler mHandler;
    private final Context mContext;
    private String mUrl;
    private byte[] templateSource;
    private byte[] mPreloadedTemplateSource;
    private JSONObject mThreadStrategyData;
    private int mThreadMode;
    private JSONObject mGlobalPropsCache;
    private JSONArray mComponentList;
    private JSONObject mConfig;
    private String mLoadTemplateURL;
    private TemplateData mLoadTemplateData;
    private TemplateData mGlobalPropCacheCloned;
    private TemplateData mGlobalProps;
    private LynxRecorderFetcher mDynamicFetcher;
    private TestBenchLynxViewClient mViewClient;
    private boolean mReplayGesture;
    private boolean mPreDecode;
    private boolean mDisableOptPushStyleToBundle;
    private boolean mEnableNativeScheduleCreateViewAsync;
    private int mDelayEndInterval;
    private LynxRecorderReplayStateView mStateView;
    private int mScreenWidth;
    private float mDensity;
    private int mScreenHeight;
    private LynxView mLynxView;
    private boolean mSSRLoaded;
    private boolean mDisableUpdateViewport;
    private boolean mCreateWhenReload;
    private int mBackgroundColor;
    private boolean mLandScape;
    private boolean mEnableAirStrictMode;
    private boolean mEnableSizeOptimization;
    private boolean mForbidTimeFreeze;
    private List<String> mPreloadScripts;
    private LynxGroup mLynxGroup;
    private float mRawFontScale;
    private String mSourceURL;
    private JSONObject mTemplateBundleParams;
    private TemplateBundle mTemplateBundle;
    private TemplateBundleOption mTemplateBundleOptions;
    private LynxRecorderReplayDataProviderInternal mDataProvider;
    private LynxDebugInfoRecorderDelegate mLynxDebugInfoRecorderDelegate;
    public static final int sEndForFirstScreen = 0;
    public static final int sEndForAll = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] data) {
        byte[] output;
        Inflater decompresser = new Inflater();
        decompresser.reset();
        decompresser.setInput(data);
        ByteArrayOutputStream o = new ByteArrayOutputStream(data.length);
        try {
            byte[] buf = new byte[1024];
            while (!decompresser.finished()) {
                int i = decompresser.inflate(buf);
                o.write(buf, 0, i);
            }
            output = o.toByteArray();
        }
        catch (Exception e) {
            output = data;
            e.printStackTrace();
        }
        finally {
            try {
                o.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        decompresser.end();
        return output;
    }

    private boolean checkFile(JSONArray actionList) {
        for (int index = 0; index < actionList.length(); ++index) {
            try {
                JSONObject action = actionList.getJSONObject(index);
                String functionName = action.getString("Function Name");
                if (!functionName.equals("loadTemplate") && !functionName.equals("loadTemplateBundle")) continue;
                this.mTemplateBundleParams = action.getJSONObject("Params");
                return true;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public LynxRecorderActionManager(@NonNull Intent intent, @NonNull Context context, @NonNull ViewGroup viewGroup, @Nullable LynxGroup lynxGroup) {
        this.mContext = context;
        this.mLynxView = null;
        this.mIntent = intent;
        this.mUrl = null;
        this.mViewGroup = viewGroup;
        this.mCallbacks = new ArrayList();
        this.mThreadStrategyData = null;
        this.mGlobalPropsCache = null;
        this.mConfig = null;
        this.mReloadList = new ArrayList();
        this.mLoadTemplateData = null;
        this.mLoadTemplateURL = null;
        this.mViewClient = null;
        this.mTemplateBundle = null;
        this.mTemplateBundleOptions = new TemplateBundleOption.Builder().setContextPoolSize(5).setEnableContextAutoRefill(true).build();
        this.mDataProvider = new LynxRecorderReplayDataProviderInternal();
        this.mTemplateBundleParams = null;
        this.mReplayGesture = false;
        this.mPreDecode = false;
        this.mThreadMode = -1;
        this.mStateView = new LynxRecorderReplayStateView(context);
        this.mDelayEndInterval = 3500;
        this.mRawFontScale = -1.0f;
        this.mDynamicFetcher = new LynxRecorderFetcher();
        this.mLynxDebugInfoRecorderDelegate = new LynxDebugInfoRecorderDelegate();
        this.mLynxGroup = lynxGroup;
        Resources resources = this.mContext.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        this.mScreenWidth = dm.widthPixels;
        this.mScreenHeight = dm.heightPixels;
        this.mDensity = dm.density;
        this.mEnableSizeOptimization = false;
        this.mForbidTimeFreeze = false;
        this.mPreloadScripts = new ArrayList<String>();
        this.mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 2: {
                        LynxRecorderActionManager.this.initialLynxView((JSONObject)msg.obj);
                        break;
                    }
                    case 1: {
                        LynxRecorderActionManager.this.initialLynxView((JSONObject)msg.obj);
                        break;
                    }
                    case 3: {
                        LynxRecorderActionManager.this.setGlobalProps((JSONObject)msg.obj);
                        break;
                    }
                    case 4: {
                        LynxRecorderActionManager.this.loadTemplate((JSONObject)msg.obj);
                        break;
                    }
                    case 9: {
                        LynxRecorderActionManager.this.loadTemplateBundle((JSONObject)msg.obj);
                        break;
                    }
                    case 10: {
                        LynxRecorderActionManager.this.endTestbench();
                        break;
                    }
                    case 0: {
                        LynxRecorderActionManager.this.updateDataPreData((JSONObject)msg.obj);
                        break;
                    }
                    case 5: {
                        LynxRecorderActionManager.this.sendGlobalEvent((JSONObject)msg.obj);
                        break;
                    }
                    case 6: {
                        LynxRecorderActionManager.this.sendEventAndroid((JSONObject)msg.obj);
                        break;
                    }
                    case 7: {
                        LynxRecorderActionManager.this.reloadTemplate((JSONObject)msg.obj);
                        break;
                    }
                    case 11: {
                        LynxRecorderActionManager.this.updateFontScale((JSONObject)msg.obj);
                        break;
                    }
                    case 13: {
                        LynxRecorderActionManager.this.updateMetaData((JSONObject)msg.obj);
                        break;
                    }
                    case 14: {
                        LynxRecorderActionManager.this.onTestBenchComplete();
                        break;
                    }
                    case 15: {
                        LynxRecorderActionManager.this.switchEngineFromUIThread((JSONObject)msg.obj);
                        break;
                    }
                }
            }
        };
    }

    public void registerCallback(LynxRecorderActionCallback callback) {
        this.mCallbacks.add(callback);
    }

    public void onLynxViewWillBuild(LynxRecorderActionManager manager, LynxViewBuilder builder) {
        for (LynxRecorderActionCallback callback : this.mCallbacks) {
            callback.onLynxViewWillBuild(manager, builder);
        }
    }

    public void onReplayFinish(int endType) {
        for (LynxRecorderActionCallback callback : this.mCallbacks) {
            callback.onReplayFinish(endType);
        }
    }

    public void onTestBenchComplete() {
        for (LynxRecorderActionCallback callback : this.mCallbacks) {
            callback.onTestBenchComplete();
        }
    }

    private void onLynxViewDidBuild(@NonNull LynxView kitView, @NonNull Intent intent, @NonNull Context context, @NonNull ViewGroup view) {
        for (LynxRecorderActionCallback callback : this.mCallbacks) {
            callback.onLynxViewDidBuild(kitView, intent, context, view);
        }
    }

    public void setLynxGroup(LynxGroup lynxGroup) {
        this.mLynxGroup = lynxGroup;
    }

    public LynxGroup getLynxGroup() {
        return this.mLynxGroup;
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public JSONArray getComponentList() {
        return this.mComponentList;
    }

    public String[] getTestBenchPreloadScripts() {
        return this.mPreloadScripts.toArray(new String[0]);
    }

    public void startWithUrl(@NonNull String url) {
        if (!url.startsWith(LynxRecorderEnv.getInstance().lynxRecorderUrlPrefix)) {
            this.mStateView.setReplayState(6);
            this.mViewGroup.addView((View)this.mStateView);
            return;
        }
        QueryMapUtils queryMap = new QueryMapUtils();
        queryMap.parse(url);
        this.mUrl = queryMap.getString("url");
        this.mSourceURL = queryMap.getString("source");
        if (null == this.mUrl) {
            Log.e((String)TAG, (String)"Testbench url is Null!");
            return;
        }
        this.mReplayGesture = queryMap.getBoolean("gesture", false);
        this.mPreDecode = queryMap.getBoolean("enablePreDecode", false);
        this.mThreadMode = queryMap.getInt("thread_mode", -1);
        this.mDelayEndInterval = queryMap.getInt("delayEndInterval", 3500);
        this.mEnableAirStrictMode = queryMap.getBoolean("enableAirStrict", false);
        this.mLandScape = queryMap.getBoolean("landscape", false);
        this.mDisableUpdateViewport = queryMap.getBoolean("disableUpdateViewport", false);
        this.mCreateWhenReload = queryMap.getBoolean("createWhenReload", false);
        this.mDisableOptPushStyleToBundle = queryMap.getInt("disable_opt_push_style_to_bundle", 0) == 1;
        this.mEnableNativeScheduleCreateViewAsync = queryMap.getInt("enable_native_schedule_create_view_async", 0) == 1;
        int[] colorValues = new int[]{255, 255, 255, 255};
        String rgba = queryMap.getString("backgroundColor");
        if (rgba != null) {
            try {
                String[] values = rgba.split("_");
                for (int i = 0; i < values.length && i < 4; ++i) {
                    colorValues[i] = Integer.parseInt(values[i]);
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("set background color failed:" + e.toString()));
            }
        }
        this.mBackgroundColor = Color.argb((int)colorValues[3], (int)colorValues[0], (int)colorValues[1], (int)colorValues[2]);
        this.mViewGroup.setBackgroundColor(this.mBackgroundColor);
        this.mEnableSizeOptimization = queryMap.getBoolean("enableSizeOptimization", false);
        this.mForbidTimeFreeze = queryMap.getBoolean("forbidTimeFreeze", false);
        this.create();
    }

    private void create() {
        this.destroy();
        if (this.mLynxView != null) {
            this.mViewGroup.removeView((View)this.mLynxView);
            this.mLynxView = null;
        }
        this.mStateView.setReplayState(0);
        this.mViewGroup.addView((View)this.mStateView);
        if (null != this.mSourceURL) {
            LynxEnv.inst().getTemplateProvider().loadTemplate(this.mSourceURL, new AbsTemplateProvider.Callback(){

                public void onSuccess(byte[] template) {
                    LynxRecorderActionManager.access$2102(LynxRecorderActionManager.this, template);
                    LynxRecorderActionManager.this.downloadRecordedFile();
                }

                public void onFailed(String msg) {
                    Log.e((String)LynxRecorderActionManager.TAG, (String)"Load source template js fail!");
                }
            });
        } else {
            this.downloadRecordedFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replayTimeEnvJScript() {
        InputStream in = null;
        try {
            in = this.mContext.getAssets().open("lynx_recorder.js");
            int length = in.available();
            byte[] buffer = new byte[length];
            in.read(buffer);
            String script = new String(buffer);
            script = script.replace("###LYNX_RECORDER_REPLAY_TIME###", String.valueOf(this.mStartTime));
            File file = new File(this.mContext.getFilesDir(), "lynx_recorder.js");
            if (file.exists() && !file.delete()) {
                Log.e((String)"TestBench", (String)"Call replayTimeEnvJScript failed: file can't be deleted.");
                return "";
            }
            if (file.createNewFile()) {
                String filePath = "";
                FileOutputStream outStream = null;
                try {
                    outStream = new FileOutputStream(file);
                    outStream.write(script.getBytes());
                    filePath = "file://" + file.getPath();
                    return filePath;
                }
                catch (IOException e) {
                    filePath = "";
                    e.printStackTrace();
                }
                finally {
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return filePath;
                }
            }
            Log.e((String)"TestBench", (String)"Call replayTimeEnvJScript failed: file can't created.");
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void downloadRecordedFile() {
        if (this.mUrl.startsWith("asset:///")) {
            try {
                InputStream inputStream = this.mContext.getAssets().open(this.mUrl.replace("asset:///", ""));
                final byte[] bytes = Utils.inputStreamToByteArray(inputStream);
                UIThreadUtils.runOnUiThreadImmediately((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        new InnerCallback().onSuccess(bytes);
                    }
                });
            }
            catch (IOException e) {
                UIThreadUtils.runOnUiThreadImmediately((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        new InnerCallback().onFailed(e.getMessage());
                    }
                });
            }
        } else {
            new LynxRecorderTemplateProvider().loadTemplate(this.mUrl, new InnerCallback());
        }
    }

    public void onResume() {
        this.mLynxView.onEnterForeground();
    }

    public void onPause() {
        this.mLynxView.onEnterBackground();
    }

    public void updateScreenSize(int width, int height) {
        this.mLynxView.updateScreenMetrics(width, height);
    }

    public void updateFontScale(JSONObject params) {
        String type = params.optString("type", "unknown");
        float scale = (float)params.optDouble("scale", -1.0);
        if (type.equals("updateFontScale") && this.mLynxView != null) {
            this.mLynxView.updateFontScale(scale);
        } else {
            this.mRawFontScale = scale;
        }
    }

    public void onExceptionOccurred(String errorMessage) {
        this.mLynxView.getLynxContext().handleException(new Exception(errorMessage));
    }

    private void handleActionList(JSONArray actionList) {
        long recordTime = 0L;
        if (this.mPreDecode) {
            this.preDecodeTemplate(this.mTemplateBundleParams);
        }
        for (int i = 0; i < actionList.length(); ++i) {
            try {
                JSONObject action = actionList.getJSONObject(i);
                String functionName = action.getString("Function Name");
                if (functionName.equals("loadTemplate") && this.mPreDecode) {
                    functionName = "loadTemplateBundle";
                }
                recordTime = action.getLong("Record Time") * 1000L;
                if (action.has("RecordMillisecond")) {
                    recordTime = action.getLong("RecordMillisecond");
                }
                JSONObject params = action.getJSONObject("Params");
                if (!mCanMockFuncMap.containsKey(functionName) || functionName.equals("sendEventAndroid") && !this.mReplayGesture) continue;
                if (this.mStartTime == 0L) {
                    this.mStartTime = recordTime;
                }
                long delay = recordTime - this.mStartTime;
                if (mReloadFuncSet.contains(functionName)) {
                    this.mReloadList.add(new ReloadAction(params, mCanMockFuncMap.get(functionName), delay));
                } else {
                    this.dispatchAction(functionName, params, delay);
                }
                if (i != actionList.length() - 1) continue;
                Message completeMsg = Message.obtain();
                completeMsg.what = 14;
                this.mHandler.sendMessageDelayed(completeMsg, delay);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void dispatchAction(String functionName, JSONObject params, long delay) {
        Integer functionID = mCanMockFuncMap.get(functionName);
        if (functionID == null) {
            return;
        }
        Message msg = Message.obtain();
        msg.obj = params;
        msg.what = functionID;
        this.mHandler.sendMessageDelayed(msg, delay);
    }

    private void mockComponent(JSONArray componentList) {
        this.mComponentList = componentList;
    }

    private void addExtraComponent(LynxViewBuilder builder) {
        if (this.mComponentList == null) {
            return;
        }
        ArrayList behaviors = new ArrayList();
        behaviors.addAll(new BuiltInBehavior().create());
        if (LynxEnv.inst().getBehaviorBundle() != null) {
            behaviors.addAll(LynxEnv.inst().getBehaviorBundle().create());
        }
        HashMap<String, Behavior> mBehaviorMap = new HashMap<String, Behavior>();
        for (Behavior behavior : behaviors) {
            mBehaviorMap.put(behavior.getName(), behavior);
        }
        for (int i = 0; i < this.mComponentList.length(); ++i) {
            try {
                JSONObject componentInfo = this.mComponentList.getJSONObject(i);
                String name = componentInfo.getString("Name");
                int type = componentInfo.getInt("Type");
                if (mBehaviorMap.containsKey(name)) continue;
                if ((type & 2) != 0) {
                    builder.addBehavior(new Behavior(name){

                        public ShadowNode createShadowNode() {
                            return new RawTextShadowNode();
                        }
                    });
                    continue;
                }
                builder.addBehavior(new Behavior(name, (type & 8) != 0){

                    public LynxUI createUIWithParams(LynxContext context, Object params) {
                        return new UIView(context, params);
                    }
                });
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void preprocessGlobalPropsDictData(JSONObject obj) throws JSONException {
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = obj.get(key);
            if (value instanceof JSONObject) {
                this.preprocessGlobalPropsDictData((JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                this.preprocessGlobalPropsArrayData((JSONArray)value);
                continue;
            }
            if (key.equals("screenHeight")) {
                int dpHeight = (int)Math.ceil((float)this.mScreenHeight / this.mDensity);
                obj.put(key, dpHeight);
                continue;
            }
            if (!key.equals("screenWidth")) continue;
            int dpWidth = (int)Math.ceil((float)this.mScreenWidth / this.mDensity);
            obj.put(key, dpWidth);
        }
    }

    private void preprocessGlobalPropsArrayData(JSONArray arr) throws JSONException {
        for (int i = 0; i < arr.length(); ++i) {
            Object value = arr.get(i);
            if (value instanceof JSONObject) {
                this.preprocessGlobalPropsDictData((JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            this.preprocessGlobalPropsArrayData((JSONArray)value);
        }
    }

    private void setGlobalProps(JSONObject params) {
        try {
            if (this.mLynxView != null) {
                this.mGlobalPropsCache = null;
                JSONObject obj = params.getJSONObject("global_props");
                if (this.mEnableSizeOptimization) {
                    this.preprocessGlobalPropsDictData(obj);
                }
                this.mGlobalProps = TemplateData.fromString((String)obj.toString());
                LynxUpdateMeta.Builder metaBuilder = new LynxUpdateMeta.Builder();
                metaBuilder.setUpdatedGlobalProps(this.mGlobalProps);
                this.mLynxView.updateMetaData(metaBuilder.build());
            } else {
                this.mGlobalPropsCache = params.getJSONObject("global_props");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void updateDataPreData(JSONObject params) {
        try {
            JSONObject option;
            boolean resetPageData;
            String value = params.getJSONObject("value").toString();
            String preprocessorName = params.getString("preprocessorName");
            if (params.has("updatePageOption") && (resetPageData = (option = params.getJSONObject("updatePageOption")).getBoolean("reset_page_data"))) {
                TemplateData data = TemplateData.fromString((String)value);
                this.mLynxView.resetData(data);
            }
            this.mLynxView.updateData(value, preprocessorName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void reloadTemplate(JSONObject params) {
        try {
            String value = params.getJSONObject("value").toString();
            String preprocessorName = params.getString("preprocessorName");
            TemplateData templateData = TemplateData.fromString((String)value);
            templateData.markState(preprocessorName);
            templateData.markReadOnly();
            this.mLynxView.reloadTemplate(templateData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private ThreadStrategyForRendering getThreadStrategy(int schemaThreadStrategy, int testBenchThreadStrategy) {
        int threadStrategy = testBenchThreadStrategy;
        if (schemaThreadStrategy >= ThreadStrategyForRendering.ALL_ON_UI.id() && schemaThreadStrategy <= ThreadStrategyForRendering.MULTI_THREADS.id()) {
            threadStrategy = schemaThreadStrategy;
        }
        switch (threadStrategy) {
            case 1: {
                return ThreadStrategyForRendering.MOST_ON_TASM;
            }
            case 2: {
                return ThreadStrategyForRendering.PART_ON_LAYOUT;
            }
            case 3: {
                return ThreadStrategyForRendering.MULTI_THREADS;
            }
        }
        return ThreadStrategyForRendering.ALL_ON_UI;
    }

    private int getMeasureMode(int param) {
        switch (param) {
            case 1: {
                return 0x40000000;
            }
            case 2: {
                return Integer.MIN_VALUE;
            }
        }
        return 0;
    }

    private int getLynxViewLayoutParams(int mode, int value) {
        switch (mode) {
            case 0x40000000: {
                return value;
            }
        }
        return -2;
    }

    private void updateViewLayoutParams(int widthLayout, int heightLayout) {
        ViewGroup.LayoutParams layoutParams = this.mLynxView.getLayoutParams();
        layoutParams.width = widthLayout;
        layoutParams.height = heightLayout;
        this.mLynxView.setLayoutParams(layoutParams);
    }

    private boolean enableJSRuntime() {
        boolean enableJSRuntime = true;
        if (this.mThreadStrategyData.has("enableJSRuntime")) {
            try {
                enableJSRuntime = this.mThreadStrategyData.getBoolean("enableJSRuntime") && !this.mEnableAirStrictMode;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return enableJSRuntime;
    }

    private boolean enableAir() {
        return !this.enableJSRuntime();
    }

    private int[] getMeasureSpec(JSONObject params) {
        try {
            int widthMode = params.getInt("layoutWidthMode");
            int heightMode = params.getInt("layoutHeightMode");
            int preferredLayoutHeight = params.getInt("preferredLayoutHeight");
            int preferredLayoutWidth = params.getInt("preferredLayoutWidth");
            if (this.hasScreenSizeInfo()) {
                int recordScreenWidth = this.mConfig.getInt("screenWidth");
                int recordScreenHeight = this.mConfig.getInt("screenHeight");
                if (recordScreenWidth != 0 && recordScreenHeight != 0) {
                    preferredLayoutHeight = (int)Math.ceil((double)preferredLayoutHeight / (double)recordScreenHeight * (double)this.mScreenHeight);
                    preferredLayoutWidth = (int)Math.ceil((double)preferredLayoutWidth / (double)recordScreenWidth * (double)this.mScreenWidth);
                }
            }
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)preferredLayoutHeight, (int)this.getMeasureMode(heightMode));
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)preferredLayoutWidth, (int)this.getMeasureMode(widthMode));
            int viewWidthLayoutParams = this.getLynxViewLayoutParams(this.getMeasureMode(widthMode), preferredLayoutWidth);
            int viewHeightLayoutParams = this.getLynxViewLayoutParams(this.getMeasureMode(heightMode), preferredLayoutHeight);
            if (this.mLandScape) {
                return new int[]{heightMeasureSpec, widthMeasureSpec, viewHeightLayoutParams, viewWidthLayoutParams};
            }
            return new int[]{widthMeasureSpec, heightMeasureSpec, viewWidthLayoutParams, viewHeightLayoutParams};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean hasScreenSizeInfo() {
        return this.mConfig != null && this.mConfig.has("screenWidth") && this.mConfig.has("screenHeight");
    }

    private void initialLynxView(JSONObject params) {
        if (BuildConfig.enable_frozen_mode.booleanValue()) {
            LynxEnv.inst().setCreateViewAsync(false);
        }
        if (params.has("threadStrategy")) {
            this.mThreadStrategyData = params;
            return;
        }
        if (this.mThreadStrategyData == null && this.mLynxView == null) {
            return;
        }
        try {
            int[] measureSpec = this.getMeasureSpec(params);
            if (this.mLynxView == null) {
                LynxViewBuilder builder = new LynxViewBuilder();
                builder.setEnableJSRuntime(this.enableJSRuntime());
                builder.setEnableAirStrictMode(this.enableAir());
                builder.setPresetMeasuredSpec(measureSpec[0], measureSpec[1]);
                this.addExtraComponent(builder);
                builder.registerModule("LynxRecorderReplayDataModule", LynxRecorderReplayDataModule.class, (Object)this.mDataProvider);
                builder.registerModule("LynxRecorderOpenUrlModule", LynxRecorderOpenUrlModule.class);
                if (BuildConfig.enable_frozen_mode.booleanValue()) {
                    builder.setThreadStrategyForRendering(ThreadStrategyForRendering.ALL_ON_UI);
                } else {
                    builder.setThreadStrategyForRendering(this.getThreadStrategy(this.mThreadMode, this.mThreadStrategyData.getInt("threadStrategy")));
                }
                LynxRecorderSourceProvider provider = new LynxRecorderSourceProvider();
                if (this.mConfig != null && this.mConfig.has("urlRedirect")) {
                    provider.setUrlRedirect(this.mConfig.getJSONObject("urlRedirect"));
                }
                builder.setResourceProvider("EXTERNAL_JS_SOURCE", (LynxResourceProvider)provider);
                builder.setDynamicComponentFetcher((DynamicComponentFetcher)this.mDynamicFetcher);
                if (this.mRawFontScale != -1.0f) {
                    builder.setFontScale(this.mRawFontScale);
                }
                if (!this.mForbidTimeFreeze) {
                    this.mPreloadScripts.add(this.replayTimeEnvJScript());
                }
                this.onLynxViewWillBuild(this, builder);
                this.mLynxView = builder.build(this.mContext);
                this.mLynxView.getLynxContext().setLynxView(this.mLynxView);
                this.mViewClient = new TestBenchLynxViewClient();
                this.mLynxView.addLynxViewClient((LynxViewClient)this.mViewClient);
                this.mThreadStrategyData = null;
                this.onLynxViewDidBuild(this.mLynxView, this.mIntent, this.mContext, this.mViewGroup);
            } else {
                if (!this.mDisableUpdateViewport) {
                    this.mLynxView.updateViewport(measureSpec[0], measureSpec[1]);
                }
                if (this.needSetContainerSize()) {
                    int[] containerSize = this.getContainerSize(new int[]{View.MeasureSpec.getSize((int)measureSpec[0]), View.MeasureSpec.getSize((int)measureSpec[1])});
                    this.setViewLayoutParams((View)this.mViewGroup, containerSize[0], containerSize[1]);
                }
            }
            if (this.hasScreenSizeInfo() && this.mEnableSizeOptimization) {
                this.updateViewLayoutParams(measureSpec[2], measureSpec[3]);
            }
            this.mLynxView.getBaseInspectorOwner().setDebugInfoInterceptor((LynxDebugInfoRecorder)this.mLynxDebugInfoRecorderDelegate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int[] getContainerSize(int[] defaultSize) {
        JSONObject containerSize = this.mConfig.optJSONObject("setContainerSize");
        if (containerSize == null) {
            Log.i((String)TAG, (String)"Miss setContainerSize property in config field");
            return defaultSize;
        }
        return new int[]{containerSize.optInt("width", defaultSize[0]), containerSize.optInt("height", defaultSize[1])};
    }

    private boolean needSetContainerSize() {
        return this.mConfig != null && this.mConfig.has("setContainerSize");
    }

    private void setViewLayoutParams(View view, int width, int height) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams.width != width || layoutParams.height != height) {
            layoutParams.width = width;
            layoutParams.height = height;
            view.setLayoutParams(layoutParams);
        }
    }

    private TemplateData buildTemplateData(JSONObject templateData) {
        TemplateData templateInitData = TemplateData.fromString((String)templateData.toString());
        try {
            String processorName = templateData.getString("preprocessorName");
            boolean readOnly = templateData.getBoolean("readOnly");
            if (!processorName.isEmpty()) {
                templateInitData.markState(processorName);
            }
            if (readOnly) {
                templateInitData.markReadOnly();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return templateInitData;
    }

    private void loadTemplate(JSONObject params) {
        try {
            String url = LynxRecorderEnv.getInstance().lynxRecorderUrlPrefix;
            if (this.mGlobalPropsCache != null) {
                this.mGlobalPropCacheCloned = TemplateData.fromString((String)this.mGlobalPropsCache.toString());
                LynxUpdateMeta.Builder metaBuilder = new LynxUpdateMeta.Builder();
                metaBuilder.setUpdatedGlobalProps(this.mGlobalPropCacheCloned);
                this.mLynxView.updateMetaData(metaBuilder.build());
            }
            this.templateSource = this.mPreloadedTemplateSource != null ? this.mPreloadedTemplateSource : Base64.decode((String)params.getString("source"), (int)0);
            JSONObject templateData = params.getJSONObject("templateData");
            TemplateData templateInitData = this.buildTemplateData(templateData);
            this.mLoadTemplateURL = url;
            if (this.mStateView != null && this.mViewGroup != null) {
                this.mViewGroup.removeView((View)this.mStateView);
            }
            boolean isCSR = true;
            if (params.has("isCSR")) {
                isCSR = params.getBoolean("isCSR");
            }
            if (isCSR) {
                this.mLoadTemplateData = templateInitData.deepClone();
                templateInitData.recycle();
                if (!this.mSSRLoaded) {
                    LynxLoadMeta.Builder builder = new LynxLoadMeta.Builder();
                    builder.setBinaryData(this.templateSource);
                    builder.setUrl(url);
                    builder.setInitialData(this.mLoadTemplateData);
                    JSONObject nativeConfig = new JSONObject();
                    if (this.mDisableOptPushStyleToBundle) {
                        nativeConfig.put("enableOptPushStyleToBundle", false);
                    }
                    if (this.mEnableNativeScheduleCreateViewAsync) {
                        nativeConfig.put("enableNativeScheduleCreateViewAsync", true);
                    }
                    HashMap<String, String> lynxConfig = new HashMap<String, String>();
                    lynxConfig.put(LynxViewBuilderProperty.PLATFORM_CONFIG.getKey(), nativeConfig.toString());
                    builder.setLynxViewConfig(lynxConfig);
                    this.mLynxView.loadTemplate(builder.build());
                } else {
                    LynxLoadMeta.Builder builder = new LynxLoadMeta.Builder();
                    builder.setLoadMode(LynxLoadMode.HYDRATE_SSR);
                    builder.setUrl(url);
                    builder.setBinaryData(this.templateSource);
                    builder.setInitialData(this.mLoadTemplateData);
                    this.mLynxView.loadTemplate(builder.build());
                }
            } else {
                Map dataMap = templateInitData.toMap();
                LynxLoadMeta.Builder builder = new LynxLoadMeta.Builder();
                builder.setLoadMode(LynxLoadMode.RENDER_SSR);
                builder.setUrl(url);
                builder.setBinaryData(this.templateSource);
                builder.setInitialData(TemplateData.fromMap((Map)dataMap));
                this.mLynxView.loadTemplate(builder.build());
                this.mSSRLoaded = true;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void preDecodeTemplate(JSONObject params) {
        try {
            this.templateSource = this.mPreloadedTemplateSource != null ? this.mPreloadedTemplateSource : Base64.decode((String)params.getString("source"), (int)0);
            this.mTemplateBundle = TemplateBundle.fromTemplate((byte[])this.templateSource, (TemplateBundleOption)this.mTemplateBundleOptions);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void switchEngineFromUIThread(JSONObject params) {
        try {
            if (this.mLynxView == null) {
                return;
            }
            boolean attach = params.getBoolean("attach");
            if (attach) {
                this.mLynxView.attachEngineToUIThread();
            } else {
                this.mLynxView.detachEngineFromUIThread();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void updateMetaData(JSONObject params) {
        try {
            if (this.mLynxView == null) {
                return;
            }
            JSONObject templateDataJson = params.getJSONObject("templateData");
            JSONObject globalPropsJson = params.getJSONObject("global_props");
            String preprocessorName = templateDataJson.getString("preprocessorName");
            boolean readOnly = templateDataJson.getBoolean("readOnly");
            TemplateData templateData = TemplateData.fromString((String)templateDataJson.getJSONObject("value").toString());
            if (!preprocessorName.equals("")) {
                templateData.markState(preprocessorName);
            }
            if (readOnly) {
                templateData.markReadOnly();
            }
            TemplateData globalProps = TemplateData.fromString((String)globalPropsJson.toString());
            LynxUpdateMeta.Builder metaBuilder = new LynxUpdateMeta.Builder();
            metaBuilder.setUpdatedGlobalProps(globalProps).setUpdatedData(templateData);
            this.mLynxView.updateMetaData(metaBuilder.build());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void loadTemplateBundle(JSONObject params) {
        try {
            String url = LynxRecorderEnv.getInstance().lynxRecorderUrlPrefix;
            if (this.mGlobalPropsCache != null) {
                this.mGlobalPropCacheCloned = TemplateData.fromString((String)this.mGlobalPropsCache.toString());
                LynxUpdateMeta.Builder metaBuilder = new LynxUpdateMeta.Builder();
                metaBuilder.setUpdatedGlobalProps(this.mGlobalPropCacheCloned);
                this.mLynxView.updateMetaData(metaBuilder.build());
            }
            JSONObject templateData = params.getJSONObject("templateData");
            TemplateData templateInitData = this.buildTemplateData(templateData);
            this.mLoadTemplateURL = url;
            if (this.mStateView != null && this.mViewGroup != null) {
                this.mViewGroup.removeView((View)this.mStateView);
            }
            this.mLoadTemplateData = templateInitData.deepClone();
            templateInitData.recycle();
            if (this.mTemplateBundle == null) {
                this.templateSource = this.mPreloadedTemplateSource != null ? this.mPreloadedTemplateSource : Base64.decode((String)params.getString("source"), (int)0);
                LynxLoadMeta.Builder builder = new LynxLoadMeta.Builder();
                builder.setTemplateBundle(TemplateBundle.fromTemplate((byte[])this.templateSource, (TemplateBundleOption)this.mTemplateBundleOptions));
                builder.setUrl(url);
                builder.setInitialData(this.mLoadTemplateData);
                JSONObject nativeConfig = new JSONObject();
                if (this.mDisableOptPushStyleToBundle) {
                    nativeConfig.put("enableOptPushStyleToBundle", false);
                }
                if (this.mEnableNativeScheduleCreateViewAsync) {
                    nativeConfig.put("enableNativeScheduleCreateViewAsync", true);
                }
                HashMap<String, String> lynxConfig = new HashMap<String, String>();
                lynxConfig.put(LynxViewBuilderProperty.PLATFORM_CONFIG.getKey(), nativeConfig.toString());
                builder.setLynxViewConfig(lynxConfig);
                this.mLynxView.loadTemplate(builder.build());
            } else {
                this.mLynxView.renderTemplateBundle(this.mTemplateBundle, this.mLoadTemplateData, url);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendEventAndroid(JSONObject params) {
        if (this.mConfig != null && this.mConfig.has("screenWidth") && this.mConfig.has("screenHeight")) {
            try {
                int recordScreenWidth = this.mConfig.getInt("screenWidth");
                int recordScreenHeight = this.mConfig.getInt("screenHeight");
                if (recordScreenWidth != 0 && recordScreenHeight != 0) {
                    float xScaling = (float)this.mScreenWidth / (float)recordScreenWidth;
                    float yScaling = (float)this.mScreenHeight / (float)recordScreenHeight;
                    LynxRecorderEventSend.sendEventAndroid(params, this.mLynxView, xScaling, yScaling);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            LynxRecorderEventSend.sendEventAndroid(params, this.mLynxView, 1.0f, 1.0f);
        }
    }

    private void sendGlobalEvent(JSONObject params) {
        LynxRecorderEventSend.sendGlobalEvent(params, this.mLynxView);
    }

    private void endTestbench() {
        final String path = this.getDumpFilePath();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LynxRecorderActionManager.this.onReplayFinish(1);
                LynxBaseInspectorOwner owner = LynxRecorderActionManager.this.mLynxView.getBaseInspectorOwner();
                if (owner != null) {
                    owner.endTestbench(path);
                }
            }
        };
        new Handler(Looper.getMainLooper()).postDelayed(runnable, 1000L);
    }

    private String getDumpFilePath() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        File dir = this.mContext.getExternalFilesDir(null);
        File file = new File(dir, "lynx-testbench-" + formatter.format(new Date()));
        return file.getPath();
    }

    public void load() {
        if (this.mCreateWhenReload) {
            this.create();
        } else if (this.mLoadTemplateURL != null && this.mLoadTemplateData != null) {
            TemplateData old_data = this.mLoadTemplateData;
            this.mLoadTemplateData = this.mLoadTemplateData.deepClone();
            old_data.recycle();
            if (null != this.mSourceURL) {
                LynxEnv.inst().getTemplateProvider().loadTemplate(this.mSourceURL, new AbsTemplateProvider.Callback(){

                    public void onSuccess(byte[] template) {
                        LynxRecorderActionManager.this.mLynxView.renderTemplateWithBaseUrl(template, LynxRecorderActionManager.this.mLoadTemplateData, LynxRecorderActionManager.this.mLoadTemplateURL);
                    }

                    public void onFailed(String msg) {
                        Log.e((String)LynxRecorderActionManager.TAG, (String)"Load source template js fail!");
                    }
                });
            } else {
                this.mLynxView.renderTemplateWithBaseUrl(this.templateSource, this.mLoadTemplateData, this.mLoadTemplateURL);
            }
        }
    }

    public void reloadAction() {
        long mLastDelayTime = 1000L;
        for (int index = 0; index < this.mReloadList.size(); ++index) {
            this.mReloadList.get(index).run();
            if (index != this.mReloadList.size() - 1) continue;
            mLastDelayTime = this.mReloadList.get(index).getDelayTime() + (long)this.mDelayEndInterval;
        }
        Message endMsg = Message.obtain();
        endMsg.what = 10;
        if (mLastDelayTime >= 60000L) {
            mLastDelayTime = 5000L;
        }
        this.mHandler.sendMessageDelayed(endMsg, mLastDelayTime);
    }

    public void destroy() {
        if (this.mLoadTemplateData != null) {
            this.mLoadTemplateData.recycle();
        }
        if (this.mGlobalPropCacheCloned != null) {
            this.mGlobalPropCacheCloned.recycle();
        }
        if (this.mGlobalProps != null) {
            this.mGlobalProps.recycle();
        }
        if (this.mLynxView != null) {
            this.mLynxView.destroy();
        }
        this.mHandler.removeCallbacksAndMessages(null);
    }

    static /* synthetic */ byte[] access$2102(LynxRecorderActionManager x0, byte[] x1) {
        x0.mPreloadedTemplateSource = x1;
        return x1;
    }

    static {
        mCanMockFuncMap.put("setGlobalProps", 3);
        mCanMockFuncMap.put("updateViewPort", 1);
        mCanMockFuncMap.put("loadTemplate", 4);
        mCanMockFuncMap.put("loadTemplateBundle", 9);
        mCanMockFuncMap.put("setThreadStrategy", 2);
        mCanMockFuncMap.put("updateDataByPreParsedData", 0);
        mCanMockFuncMap.put("sendGlobalEvent", 5);
        mCanMockFuncMap.put("sendEventAndroid", 6);
        mCanMockFuncMap.put("reloadTemplate", 7);
        mCanMockFuncMap.put("updateFontScale", 11);
        mCanMockFuncMap.put("updateMetaData", 13);
        mCanMockFuncMap.put("switchEngineFromUIThread", 15);
        mReloadFuncSet = new HashSet();
        mReloadFuncSet.add("sendGlobalEvent");
        mReloadFuncSet.add("updateDataByPreParsedData");
        mReloadFuncSet.add("sendEventAndroid");
    }

    private class InnerCallback
    implements AbsTemplateProvider.Callback {
        private InnerCallback() {
        }

        public void onSuccess(byte[] body) {
            block15: {
                this.mainThreadChecker("onSuccess");
                try {
                    Gson gson = new Gson();
                    String str = new String(body, StandardCharsets.UTF_8);
                    Map map = null;
                    LynxRecorderActionManager.this.mStateView.setReplayState(1);
                    try {
                        if (str.startsWith("{")) {
                            map = (Map)gson.fromJson(str, Map.class);
                        } else {
                            byte[] base64decodedBytes = Base64.decode((String)str, (int)0);
                            String str2 = new String(LynxRecorderActionManager.decompress(base64decodedBytes), StandardCharsets.UTF_8);
                            map = (Map)gson.fromJson(str2, Map.class);
                        }
                    }
                    catch (Exception e) {
                        LynxRecorderActionManager.this.mStateView.setReplayState(3);
                        return;
                    }
                    JSONObject json = new JSONObject(map);
                    if (json.has("Config") && !json.get("Config").toString().equals("null")) {
                        LynxRecorderActionManager.this.mConfig = json.getJSONObject("Config");
                        if (LynxRecorderActionManager.this.mConfig.has("jsbIgnoredInfo")) {
                            ((LynxRecorderActionManager)LynxRecorderActionManager.this).mDataProvider.jsbIgnoredInfo = LynxRecorderActionManager.this.mConfig.getJSONArray("jsbIgnoredInfo");
                        }
                        if (LynxRecorderActionManager.this.mConfig.has("jsbSettings")) {
                            ((LynxRecorderActionManager)LynxRecorderActionManager.this).mDataProvider.jsbSettings = LynxRecorderActionManager.this.mConfig.getJSONObject("jsbSettings");
                        }
                    }
                    if (json.has("Debug Info")) {
                        JSONArray debugInfo = json.getJSONArray("Debug Info");
                        Log.i((String)LynxRecorderActionManager.TAG, (String)("debugInfo: " + debugInfo.toString()));
                        for (int i = 0; i < debugInfo.length(); ++i) {
                            JSONObject info = debugInfo.getJSONObject(i);
                            String url = info.getString("url");
                            String content = info.getString("content");
                            LynxRecorderActionManager.this.mLynxDebugInfoRecorderDelegate.setDebugInfo(url, content);
                        }
                    }
                    if (json.has("Invoked Method Data")) {
                        ((LynxRecorderActionManager)LynxRecorderActionManager.this).mDataProvider.functionCall = json.getJSONArray("Invoked Method Data");
                    }
                    if (json.has("Callback")) {
                        ((LynxRecorderActionManager)LynxRecorderActionManager.this).mDataProvider.callbackData = json.getJSONObject("Callback");
                    }
                    if (json.has("Component List")) {
                        LynxRecorderActionManager.this.mockComponent(json.getJSONArray("Component List"));
                    }
                    if (!json.has("Action List")) break block15;
                    if (LynxRecorderActionManager.this.checkFile(json.getJSONArray("Action List"))) {
                        LynxRecorderActionManager.this.mDynamicFetcher.parse(json.getJSONArray("Action List"));
                        LynxRecorderActionManager.this.mStateView.setReplayState(2);
                        LynxRecorderActionManager.this.handleActionList(json.getJSONArray("Action List"));
                        break block15;
                    }
                    LynxRecorderActionManager.this.mStateView.setReplayState(4);
                    return;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        public void onFailed(String msg) {
            this.mainThreadChecker("onFailed");
            Log.e((String)LynxRecorderActionManager.TAG, (String)"Read recorded file failed!");
            LynxRecorderActionManager.this.mStateView.setReplayState(5);
        }

        private void mainThreadChecker(String methodName) {
            if (!Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
                throw new IllegalThreadStateException("Callback " + methodName + "must be fired on main thread.");
            }
        }
    }

    private class ReloadAction {
        private JSONObject mParams;
        private int mFunctionID;
        private long mDelayTime;

        public ReloadAction(JSONObject params, int functionID, long delayTime) {
            this.mParams = params;
            this.mFunctionID = functionID;
            this.mDelayTime = delayTime;
        }

        public long getDelayTime() {
            return this.mDelayTime;
        }

        public void run() {
            Message msg = new Message();
            msg.obj = this.mParams;
            msg.what = this.mFunctionID;
            LynxRecorderActionManager.this.mHandler.sendMessageDelayed(msg, this.mDelayTime);
        }
    }

    private class LynxDebugInfoRecorderDelegate
    implements LynxDebugInfoRecorder {
        private final Map<String, String> debugInfoDict = new HashMap<String, String>();

        public void setDebugInfo(String url, String debugInfo) {
            this.debugInfoDict.put(url, debugInfo);
        }

        public String getDebugInfo(String url) {
            return this.debugInfoDict.get(url);
        }
    }

    private class TestBenchLynxViewClient
    extends LynxViewClient {
        private TestBenchLynxViewClient() {
        }

        public void onFirstScreen() {
            super.onFirstScreen();
            LynxRecorderActionManager.this.reloadAction();
            LynxRecorderActionManager.this.onReplayFinish(0);
        }
    }

    private class LynxRecorderReplayDataProviderInternal
    implements LynxRecorderReplayDataProvider {
        public JSONArray functionCall;
        public JSONObject callbackData;
        public JSONArray jsbIgnoredInfo;
        public JSONObject jsbSettings;

        private LynxRecorderReplayDataProviderInternal() {
        }

        @Override
        public JSONArray getFunctionCall() {
            return this.functionCall;
        }

        @Override
        public JSONObject getCallbackData() {
            return this.callbackData;
        }

        @Override
        public JSONArray getJsbIgnoredInfo() {
            return this.jsbIgnoredInfo;
        }

        @Override
        public JSONObject getJsbSettings() {
            return this.jsbSettings;
        }
    }
}

