/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import com.example.lynxdevtool.R;
import com.lynx.devtool.recorder.LynxRecorderActionCallback;
import com.lynx.devtool.recorder.LynxRecorderActionManager;
import com.lynx.devtool.recorder.LynxRecorderEnv;
import com.lynx.devtool.recorder.LynxRecorderPageManager;
import com.lynx.devtool.recorder.LynxRecorderReplayStateView;
import com.lynx.devtool.recorder.QueryMapUtils;
import com.lynx.devtoolwrapper.LynxDevtoolGlobalHelper;
import com.lynx.tasm.LynxGroup;
import com.lynx.tasm.LynxView;
import com.lynx.tasm.utils.DisplayMetricsHolder;
import java.util.ArrayList;

public class LynxRecorderActivity
extends AppCompatActivity
implements LifecycleOwner {
    private static final String TAG = "LynxRecorderActivity";
    public static final String LYNX_VIEW_WIDTH = "LynxViewWidth";
    public static final String LYNX_VIEW_HEIGHT = "LynxViewHeight";
    public static final String LYNX_VIEW_DENSITY = "LynxViewDensity";
    private String url;
    private LifecycleRegistry mLifecycleRegistry = null;
    private LynxView mLynxView;
    private RelativeLayout mContainerView;
    private LynxRecorderActionManager mActionManager;
    private boolean mHasBeenRemoveFromPageStack = false;

    public LynxGroup getLynxGroup() {
        return this.mActionManager.getLynxGroup();
    }

    public void setLynxGroup(LynxGroup lynxGroup) {
        this.mActionManager.setLynxGroup(lynxGroup);
    }

    public void setState(boolean hasBeenRemoveFromPageStack) {
        this.mHasBeenRemoveFromPageStack = hasBeenRemoveFromPageStack;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        QueryMapUtils queryMap = new QueryMapUtils();
        this.url = intent.getStringExtra(LynxRecorderEnv.getInstance().mUriKey);
        queryMap.parse(this.url);
        if (queryMap.getBoolean("fullScreen", false)) {
            this.setContentView(R.layout.recorder_full_screen_activity);
            this.getWindow().addFlags(1024);
        } else {
            this.setContentView(R.layout.recorder_activity);
            ActionBar actionBar = this.getSupportActionBar();
            Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
            if (actionBar == null) {
                this.setSupportActionBar(toolbar);
                actionBar = this.getSupportActionBar();
                if (actionBar != null) {
                    actionBar.setDisplayShowTitleEnabled(false);
                }
            } else {
                ViewGroup parent = (ViewGroup)toolbar.getParent();
                if (parent != null) {
                    parent.removeView((View)toolbar);
                }
                actionBar.setDisplayShowTitleEnabled(false);
                actionBar.setCustomView(R.layout.recorder_toolbar_content);
                actionBar.setDisplayOptions(16);
            }
        }
        if (queryMap.getBoolean("landscape", false)) {
            this.setRequestedOrientation(0);
        }
        this.mContainerView = (RelativeLayout)this.findViewById(R.id.container);
        this.getWindow().setSoftInputMode(48);
        Object group = null;
        this.mActionManager = new LynxRecorderActionManager(intent, (Context)this, (ViewGroup)this.mContainerView, null);
        LynxRecorderPageManager.getInstance().initLynxGroup(intent.getStringExtra("groupName"), this);
        LynxRecorderPageManager.getInstance().registerActivity(intent.getStringExtra("pageName"), this);
        if (this.mLifecycleRegistry == null) {
            this.mLifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
        }
        this.mLifecycleRegistry.markState(Lifecycle.State.CREATED);
        this.mActionManager.registerCallback(new LynxRecorderActionCallback(){

            @Override
            public void onLynxViewDidBuild(@NonNull LynxView kitView, @NonNull Intent intent, @NonNull Context context, @NonNull ViewGroup viewGroup) {
                LynxRecorderActivity.this.mLynxView = kitView;
                LynxRecorderActivity.this.attachToView(viewGroup, intent.getIntExtra(LynxRecorderActivity.LYNX_VIEW_WIDTH, -1), intent.getIntExtra(LynxRecorderActivity.LYNX_VIEW_HEIGHT, -1));
            }
        });
        ArrayList<LynxRecorderActionCallback> externalCallbacks = LynxRecorderPageManager.getInstance().getCallbacks();
        for (LynxRecorderActionCallback callback : externalCallbacks) {
            this.mActionManager.registerCallback(callback);
        }
        this.mActionManager.startWithUrl(this.url);
    }

    private void attachToView(ViewGroup view, int width, int height) {
        if (this.mLynxView != null) {
            view.addView((View)this.mLynxView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
        }
    }

    public Lifecycle getLifecycle() {
        if (this.mLifecycleRegistry == null) {
            this.mLifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
        }
        return this.mLifecycleRegistry;
    }

    protected void onResume() {
        super.onResume();
        if (this.mLynxView != null) {
            this.mLynxView.onEnterForeground();
        }
        LynxDevtoolGlobalHelper helper = LynxDevtoolGlobalHelper.getInstance();
        helper.setContext(this.getApplicationContext());
        this.mLifecycleRegistry.markState(Lifecycle.State.RESUMED);
    }

    protected void onStart() {
        super.onStart();
        this.mLifecycleRegistry.markState(Lifecycle.State.STARTED);
    }

    protected void onPause() {
        super.onPause();
        if (this.mLynxView != null) {
            this.mLynxView.onEnterBackground();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.testbench_menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_refresh) {
            this.mActionManager.load();
            if (this.mLynxView != null) {
                this.mLynxView.onEnterForeground();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        LynxRecorderReplayStateView state;
        super.onConfigurationChanged(newConfig);
        DisplayMetrics dm = DisplayMetricsHolder.getRealScreenDisplayMetrics((Context)this);
        if (this.mLynxView != null) {
            this.mLynxView.updateScreenMetrics(dm.widthPixels, dm.heightPixels);
        }
        if ((state = (LynxRecorderReplayStateView)this.findViewById(R.id.recorder_state_view)) != null) {
            state.updateScreenMetrics();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        LynxRecorderPageManager.getInstance().onActivityDestroy(this.getIntent().getStringExtra("pageName"), this.mHasBeenRemoveFromPageStack);
        if (this.mActionManager != null) {
            this.mActionManager.destroy();
        }
    }
}

