/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.lynx.react.bridge.JavaOnlyArray;
import com.lynx.react.bridge.JavaOnlyMap;
import com.lynx.tasm.LynxView;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxRecorderEventSend {
    private static MotionEvent getMotionEvent(JSONObject params, float xScaling, float yScaling) {
        try {
            int action = Integer.parseInt(params.getString("action"));
            float x = Float.parseFloat(params.getString("x")) * xScaling;
            float y = Float.parseFloat(params.getString("y")) * yScaling;
            int metaState = Integer.parseInt(params.getString("metaState"));
            return MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)action, (float)x, (float)y, (int)metaState);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static KeyEvent getKeyEvent(JSONObject params) {
        try {
            int action = Integer.parseInt(params.getString("action"));
            int keycode = Integer.parseInt(params.getString("keycode"));
            return new KeyEvent(action, keycode);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JavaOnlyMap jsonObjectToJavaOnlyMap(JSONObject obj) {
        Iterator iterator = obj.keys();
        JavaOnlyMap result = new JavaOnlyMap();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (obj.opt(key) instanceof JSONArray) {
                result.put((Object)key, (Object)LynxRecorderEventSend.jsonArrayToJavaOnlyArray((JSONArray)obj.opt(key)));
                continue;
            }
            if (obj.opt(key) instanceof JSONObject) {
                result.put((Object)key, (Object)LynxRecorderEventSend.jsonObjectToJavaOnlyMap((JSONObject)obj.opt(key)));
                continue;
            }
            result.put((Object)key, obj.opt(key));
        }
        return result;
    }

    private static JavaOnlyArray jsonArrayToJavaOnlyArray(JSONArray array) {
        JavaOnlyArray result = new JavaOnlyArray();
        for (int index = 0; index < array.length(); ++index) {
            if (array.opt(index) instanceof JSONArray) {
                result.add((Object)LynxRecorderEventSend.jsonArrayToJavaOnlyArray((JSONArray)array.opt(index)));
                continue;
            }
            if (array.opt(index) instanceof JSONObject) {
                result.add((Object)LynxRecorderEventSend.jsonObjectToJavaOnlyMap((JSONObject)array.opt(index)));
                continue;
            }
            result.add(array.opt(index));
        }
        return result;
    }

    public static void sendEventAndroid(JSONObject params, LynxView view, float xScaling, float yScaling) {
        String type = null;
        try {
            type = params.getString("type");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (type != null && type.equals("key")) {
            view.dispatchKeyEvent(LynxRecorderEventSend.getKeyEvent(params));
        } else {
            view.dispatchTouchEvent(LynxRecorderEventSend.getMotionEvent(params, xScaling, yScaling));
        }
    }

    public static void sendGlobalEvent(JSONObject params, LynxView view) {
        try {
            JSONArray arguments = params.getJSONArray("arguments");
            if (arguments.length() != 2) {
                return;
            }
            String name = arguments.getString(0);
            if (name.equals("exposure") || name.equals("disexposure")) {
                return;
            }
            JSONArray args = arguments.getJSONArray(1);
            if (view != null) {
                view.sendGlobalEvent(name, LynxRecorderEventSend.jsonArrayToJavaOnlyArray(args));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

