/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.util.Base64;
import com.lynx.devtool.recorder.ThreadUtils;
import com.lynx.devtool.recorder.Utils;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.component.DynamicComponentFetcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxRecorderFetcher
implements DynamicComponentFetcher {
    private static int count = 0;
    private static String ASSETS_SCHEMA = "assets://";
    private static final int HTTP_TIME_OUT = 5000;
    private boolean disableSyncRequest = false;
    private HashMap<String, JSONObject> mDynamicMap;

    public void disableSyncRequest(boolean disable) {
        this.disableSyncRequest = disable;
    }

    private boolean shouldSendAsyncRequest() {
        if (this.disableSyncRequest) {
            return true;
        }
        return count++ % 2 == 0;
    }

    public void loadDynamicComponent(final String url, final DynamicComponentFetcher.LoadedHandler handler) {
        try {
            if (this.mDynamicMap.containsKey(url)) {
                JSONObject data = this.mDynamicMap.get(url);
                byte[] res = Base64.decode((String)data.getString("source"), (int)0);
                if (data.getBoolean("sync_tag")) {
                    handler.onComponentLoaded(res, null);
                } else {
                    ThreadUtils.getThreadPool().execute(() -> handler.onComponentLoaded(res, null));
                }
            } else if (this.shouldSendAsyncRequest()) {
                ThreadUtils.getThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            handler.onComponentLoaded(LynxRecorderFetcher.loadDynamicComponentTemplate(url), null);
                        }
                        catch (Throwable e) {
                            handler.onComponentLoaded(null, e);
                        }
                    }
                });
            } else {
                Object res = null;
                Future future = ThreadUtils.getThreadPool().submit(new Callable(){

                    public byte[] call() {
                        try {
                            return LynxRecorderFetcher.loadDynamicComponentTemplate(url);
                        }
                        catch (Throwable e) {
                            return null;
                        }
                    }
                });
                try {
                    handler.onComponentLoaded((byte[])future.get(5000L, TimeUnit.MILLISECONDS), null);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    e.printStackTrace();
                    handler.onComponentLoaded(null, (Throwable)e);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            handler.onComponentLoaded(null, (Throwable)e);
        }
    }

    public LynxRecorderFetcher() {
        this.disableSyncRequest(true);
        this.mDynamicMap = new HashMap();
    }

    public void parse(JSONArray actionList) {
        for (int i = 0; i < actionList.length(); ++i) {
            try {
                JSONObject action = actionList.getJSONObject(i);
                JSONObject params = action.getJSONObject("Params");
                if (!action.getString("Function Name").equals("LoadComponentWithCallback")) continue;
                this.mDynamicMap.put(params.getString("url"), params);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] loadDynamicComponentTemplate(String urlStr) throws Exception {
        if (urlStr.startsWith(ASSETS_SCHEMA)) {
            return LynxRecorderFetcher.loadDynamicComponentFromAssets(urlStr.substring(ASSETS_SCHEMA.length()));
        }
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setReadTimeout(5000);
        if (conn.getResponseCode() == 200) {
            return Utils.inputStreamToByteArray(conn.getInputStream());
        }
        return null;
    }

    private static byte[] loadDynamicComponentFromAssets(String path) throws IOException {
        try (InputStream in = LynxEnv.inst().getAppContext().getAssets().open(path);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int n;
                byte[] buffer = new byte[4096];
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }
}

