/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.lifecycle.LifecycleOwner;
import com.example.lynxdevtool.R;
import com.google.gson.Gson;
import com.lynx.devtool.recorder.LynxRecorderEnv;
import com.lynx.devtool.recorder.LynxRecorderView;
import com.lynx.devtool.recorder.QueryMapUtils;
import com.lynx.devtoolwrapper.LynxDevtoolGlobalHelper;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.provider.AbsTemplateProvider;
import com.lynx.tasm.utils.DisplayMetricsHolder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxRecorderMultiPagesActivity
extends AppCompatActivity
implements LifecycleOwner {
    private String url;
    private RelativeLayout mContainerView;
    private JSONArray mPages;
    private ArrayList<LynxRecorderView> mPageInstances;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        QueryMapUtils queryMap = new QueryMapUtils();
        this.url = intent.getStringExtra(LynxRecorderEnv.getInstance().mUriKey);
        this.mPageInstances = new ArrayList();
        queryMap.parse(this.url);
        if (queryMap.getBoolean("fullScreen", false)) {
            this.setContentView(R.layout.recorder_full_screen_activity);
            this.getWindow().addFlags(1024);
        } else {
            this.setContentView(R.layout.recorder_multi_pages_activity);
            Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
            if (toolbar != null) {
                this.setSupportActionBar(toolbar);
                ActionBar actionBar = this.getSupportActionBar();
                if (actionBar != null) {
                    actionBar.setDisplayShowTitleEnabled(false);
                }
            }
        }
        if (queryMap.getBoolean("landscape", false)) {
            this.setRequestedOrientation(0);
        }
        this.mContainerView = (RelativeLayout)this.findViewById(R.id.container);
        this.getWindow().setSoftInputMode(48);
        this.loadFile();
    }

    private void loadFile() {
        QueryMapUtils queryMap = new QueryMapUtils();
        queryMap.parse(this.url);
        String url = queryMap.getString("url");
        LynxEnv.inst().getTemplateProvider().loadTemplate(url, new AbsTemplateProvider.Callback(){

            public void onSuccess(byte[] template) {
                if (!Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
                    throw new IllegalThreadStateException("Callback must be fired on main thread.");
                }
                Gson gson = new Gson();
                String str = new String(template, Charset.forName("UTF-8"));
                List list = (List)gson.fromJson(str, List.class);
                LynxRecorderMultiPagesActivity.this.mPages = new JSONArray((Collection)list);
                LynxRecorderMultiPagesActivity.this.buildPages();
            }

            public void onFailed(String msg) {
            }
        });
    }

    private void buildPages() {
        for (int i = 0; i < this.mPages.length(); ++i) {
            try {
                JSONObject page = this.mPages.getJSONObject(i);
                String url = page.getString("url");
                int x = page.getJSONObject("frame").getInt("x");
                int y = page.getJSONObject("frame").getInt("y");
                LynxRecorderView tbView = new LynxRecorderView((Context)this);
                this.mContainerView.addView((View)tbView);
                this.mPageInstances.add(tbView);
                tbView.loadPageWithPoint(url, new int[]{x, y}, this.getIntent());
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    protected void onResume() {
        super.onResume();
        LynxDevtoolGlobalHelper helper = LynxDevtoolGlobalHelper.getInstance();
        helper.setContext(this.getApplicationContext());
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.testbench_menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_refresh) {
            for (LynxRecorderView view : this.mPageInstances) {
                view.reload();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        DisplayMetrics dm = DisplayMetricsHolder.getRealScreenDisplayMetrics((Context)this);
        for (LynxRecorderView view : this.mPageInstances) {
            view.updateScreenMetrics(dm.widthPixels, dm.heightPixels);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        for (LynxRecorderView view : this.mPageInstances) {
            view.destroy();
        }
    }
}

