/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.content.Context;
import android.graphics.Point;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.example.lynxdevtool.R;
import java.util.ArrayList;

public class LynxRecorderReplayStateView
extends LinearLayout {
    public static final int DOWNLOAD_JSON_FILE = 0;
    public static final int PARSING_JSON_FILE = 1;
    public static final int HANDLE_ACTION_LIST = 2;
    public static final int INVALID_JSON_FILE = 3;
    public static final int RECORD_ERROR_MISS_TEMPLATEJS = 4;
    public static final int ERROR_DOWNLOAD_FAILED = 5;
    public static final int ERROR_MISS_LYNXRECORDER_HEADER = 6;
    private static final ArrayList<String> mState = new ArrayList();
    private TextView mText;
    private ProgressBar mProgress;

    public LynxRecorderReplayStateView(Context context) {
        super(context);
        this.setId(R.id.recorder_state_view);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.recorder_replay_state, (ViewGroup)this);
        this.updateScreenMetrics();
        this.setGravity(17);
        this.mText = (TextView)this.findViewById(R.id.textView2);
        this.mProgress = (ProgressBar)this.findViewById(R.id.progressBar2);
    }

    public void updateScreenMetrics() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Point size = new Point();
        wm.getDefaultDisplay().getSize(size);
        ViewGroup.LayoutParams layout_params = this.getLayoutParams();
        if (layout_params == null) {
            layout_params = new LinearLayout.LayoutParams(size.x, size.y);
        } else {
            layout_params.width = size.x;
            layout_params.height = size.y;
        }
        this.setLayoutParams(layout_params);
    }

    private int getProgress(int stateCode) {
        return (stateCode + 1) * 100 / (mState.size() + 1);
    }

    public void setReplayState(int stateCode) {
        if (this.mText != null && this.mProgress != null) {
            if (stateCode >= 0 && stateCode < mState.size()) {
                this.mText.setText((CharSequence)mState.get(stateCode));
                this.mProgress.setProgress(this.getProgress(stateCode));
            } else {
                this.mText.setText((CharSequence)"Unknown State");
                this.mProgress.setProgress(0);
            }
        }
    }

    static {
        mState.add(0, "Download json file");
        mState.add(1, "Parsing json file");
        mState.add(2, "Handle action list");
        mState.add(3, "Invalid Json File");
        mState.add(4, "Record Error: Miss template.js");
        mState.add(5, "LynxRecorder artifact download failed");
        mState.add(6, "Miss LynxRecorder header : file://lynxrecorder?url={{{url}}}");
    }
}

