/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.lynx.devtool.recorder.LynxRecorderActionCallback;
import com.lynx.devtool.recorder.LynxRecorderActionManager;
import com.lynx.devtool.recorder.LynxRecorderPageManager;
import com.lynx.tasm.LynxView;
import java.util.ArrayList;
import java.util.Arrays;

public class LynxRecorderView
extends RelativeLayout {
    public static final String LYNX_VIEW_WIDTH = "LynxViewWidth";
    public static final String LYNX_VIEW_HEIGHT = "LynxViewHeight";
    private int[] mPoint;
    private LynxRecorderActionManager mActionManager;
    private LynxView mLynxView;

    public LynxRecorderView(Context context) {
        super(context);
    }

    public void reload() {
        this.mActionManager.load();
        if (this.mLynxView != null) {
            this.mLynxView.onEnterForeground();
        }
    }

    public void destroy() {
        if (this.mActionManager != null) {
            this.mActionManager.destroy();
        }
    }

    public void updateScreenMetrics(int widthPixels, int heightPixels) {
        if (this.mLynxView != null) {
            this.mLynxView.updateScreenMetrics(widthPixels, heightPixels);
        }
    }

    public void loadPageWithPoint(String url, int[] point, Intent intent) {
        this.mPoint = Arrays.copyOf(point, point.length);
        this.mActionManager = new LynxRecorderActionManager(intent, this.getContext(), (ViewGroup)this, null);
        this.mActionManager.registerCallback(new LynxRecorderActionCallback(){

            @Override
            public void onLynxViewDidBuild(@NonNull LynxView kitView, @NonNull Intent intent, @NonNull Context context, @NonNull ViewGroup viewGroup) {
                LynxRecorderView.this.mLynxView = kitView;
                LynxRecorderView.this.attachToView(viewGroup, intent.getIntExtra(LynxRecorderView.LYNX_VIEW_WIDTH, -1), intent.getIntExtra(LynxRecorderView.LYNX_VIEW_HEIGHT, -1));
            }
        });
        ArrayList<LynxRecorderActionCallback> externalCallbacks = LynxRecorderPageManager.getInstance().getCallbacks();
        for (LynxRecorderActionCallback callback : externalCallbacks) {
            this.mActionManager.registerCallback(callback);
        }
        this.mActionManager.startWithUrl(url);
    }

    private void attachToView(ViewGroup view, int width, int height) {
        if (this.mLynxView != null) {
            view.addView((View)this.mLynxView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
            layoutParams.width = -2;
            layoutParams.height = -2;
            layoutParams.leftMargin = this.mPoint[0];
            layoutParams.topMargin = this.mPoint[1];
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }
}

