/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.utils;

import android.text.TextUtils;
import androidx.annotation.Keep;
import com.lynx.tasm.LynxError;
import java.util.Map;

@Keep
public class ErrorUtils {
    private static final int CONSOLE_LOG_VERBOSE = -1;
    private static final int CONSOLE_LOG_INFO = 0;
    protected static final int CONSOLE_LOG_WARNING = 1;
    protected static final int CONSOLE_LOG_ERROR = 2;

    public static String getKeyMessage(LynxError error) {
        if (error == null || !error.isValid()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("code: ").append(error.getSubCode()).append("\n");
        sb.append("message: ").append(error.getSummaryMessage()).append("\n");
        String rootCause = error.getRootCause();
        if (!TextUtils.isEmpty((CharSequence)rootCause)) {
            sb.append("root_cause: ").append(error.getRootCause()).append("\n");
        }
        Map contextInfo = error.getContextInfo();
        for (Map.Entry i : contextInfo.entrySet()) {
            sb.append((String)i.getKey()).append(": ").append((String)i.getValue()).append("\n");
        }
        String fixSuggestion = error.getFixSuggestion();
        if (!TextUtils.isEmpty((CharSequence)fixSuggestion)) {
            sb.append("fix_suggestion: ").append(error.getFixSuggestion());
        }
        return sb.toString();
    }

    public static int errorLevelStrToInt(String levelStr) {
        int level = 2;
        if (TextUtils.isEmpty((CharSequence)levelStr)) {
            return level;
        }
        if (levelStr != null && levelStr.equalsIgnoreCase("warn")) {
            level = 1;
        }
        return level;
    }
}

