/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import com.lynx.devtool.DevToolPlatformAndroidDelegate;
import com.lynx.devtool.LynxInspectorConsoleDelegate;
import com.lynx.react.bridge.Callback;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConsoleDelegateManager {
    private LynxInspectorConsoleDelegate mConsoleDelegate = null;
    private HashMap<Integer, Callback> mConsoleObjectCallback = null;
    private static AtomicInteger nextCallbackId = new AtomicInteger(0);

    public void setLynxInspectorConsoleDelegate(Object delegate, DevToolPlatformAndroidDelegate platform, long facadePtr) {
        if (delegate instanceof LynxInspectorConsoleDelegate) {
            this.mConsoleDelegate = (LynxInspectorConsoleDelegate)delegate;
            if (platform != null && facadePtr != 0L) {
                platform.nativeFlushConsoleMessages(facadePtr);
            }
        }
    }

    public void getConsoleObject(String objectId, boolean needStringify, Callback callback, DevToolPlatformAndroidDelegate platform, long facadePtr) {
        if (platform != null && facadePtr != 0L) {
            if (this.mConsoleObjectCallback == null) {
                this.mConsoleObjectCallback = new HashMap();
            }
            int callbackId = nextCallbackId.decrementAndGet();
            this.mConsoleObjectCallback.put(callbackId, callback);
            platform.nativeGetConsoleObject(facadePtr, objectId, needStringify, callbackId);
        }
    }

    public void onConsoleMessage(String msg) {
        if (this.mConsoleDelegate != null) {
            this.mConsoleDelegate.onConsoleMessage(msg);
        }
    }

    public void onConsoleObject(String detail, int callbackId) {
        if (this.mConsoleObjectCallback != null && this.mConsoleObjectCallback.containsKey(callbackId)) {
            Callback callback = this.mConsoleObjectCallback.get(callbackId);
            if (callback != null) {
                callback.invoke(new Object[]{detail});
            }
            this.mConsoleObjectCallback.remove(callbackId);
        }
    }
}

