/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.Keep;
import com.lynx.devtool.ConsoleDelegateManager;
import com.lynx.devtool.LynxDevtoolEnv;
import com.lynx.devtool.helper.EmulateTouchHelper;
import com.lynx.devtool.helper.LepusDebugInfoHelper;
import com.lynx.devtool.helper.ScreenCapturer;
import com.lynx.devtool.helper.ScreenCastHelper;
import com.lynx.devtool.helper.UITreeHelper;
import com.lynx.devtoolwrapper.IDevToolDelegate;
import com.lynx.react.bridge.Callback;
import com.lynx.react.bridge.JavaOnlyMap;
import com.lynx.react.bridge.ReadableMap;
import com.lynx.recorder.LynxDebugInfoRecorder;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.LynxView;
import com.lynx.tasm.base.CalledByNative;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.base.PageReloadHelper;
import com.lynx.tasm.behavior.LynxUIOwner;
import java.lang.ref.WeakReference;

public class DevToolPlatformAndroidDelegate {
    private static final String TAG = "DevToolPlatformAndroidDelegate";
    static final String NO_DEBUG_INFO_FOUND_BY_URL = "NO_DEBUG_INFO_FOUND_BY_URL";
    private long mFacadePtr;
    private UITreeHelper mUITreeHelper = new UITreeHelper();
    private EmulateTouchHelper mTouchHelper;
    private PageReloadHelper mReloadHelper;
    private IDevToolDelegate mDevToolDelegate = null;
    private WeakReference<LynxView> mLynxView;
    private ConsoleDelegateManager mConsoleDelegateManager = new ConsoleDelegateManager();
    private ScreenCastHelper mCastHelper;
    private LepusDebugInfoHelper mLepusDebugInfoHelper;
    private boolean mNavigatePending;
    private LynxDebugInfoRecorder mDebugInfoRecorder;

    @Keep
    public DevToolPlatformAndroidDelegate(LynxView lynxView) {
        this.mLynxView = new WeakReference<LynxView>(lynxView);
        this.mLepusDebugInfoHelper = new LepusDebugInfoHelper();
        this.mCastHelper = new ScreenCastHelper(this, lynxView);
        this.mFacadePtr = this.nativeCreateDevToolPlatformFacade();
        this.mTouchHelper = new EmulateTouchHelper(this.mLynxView);
        this.mReloadHelper = null;
        this.mNavigatePending = false;
        this.mDebugInfoRecorder = null;
    }

    public void attachLynxUIOwner(LynxUIOwner uiOwner) {
        if (this.mUITreeHelper != null) {
            this.mUITreeHelper.attachLynxUIOwner(uiOwner);
        }
    }

    public void setReloadHelper(PageReloadHelper reloadHelper) {
        this.mReloadHelper = reloadHelper;
    }

    public void setDebugInfoInterceptor(LynxDebugInfoRecorder debugInfoRecorder) {
        this.mDebugInfoRecorder = debugInfoRecorder;
    }

    @CalledByNative
    public String getDebugInfoByUrl(String url) {
        String debugInfo;
        if (this.mDebugInfoRecorder != null && (debugInfo = this.mDebugInfoRecorder.getDebugInfo(url)) != null) {
            return debugInfo;
        }
        return NO_DEBUG_INFO_FOUND_BY_URL;
    }

    public long getNativePtr() {
        return this.mFacadePtr;
    }

    public void setDevToolDelegate(IDevToolDelegate devToolDelegate) {
        this.mDevToolDelegate = devToolDelegate;
    }

    public void setLynxInspectorConsoleDelegate(Object delegate) {
        if (this.mConsoleDelegateManager != null && this.mFacadePtr != 0L) {
            this.mConsoleDelegateManager.setLynxInspectorConsoleDelegate(delegate, this, this.mFacadePtr);
        }
    }

    public void getConsoleObject(String objectId, boolean needStringify, Callback callback) {
        if (this.mConsoleDelegateManager != null && this.mFacadePtr != 0L) {
            this.mConsoleDelegateManager.getConsoleObject(objectId, needStringify, callback, this, this.mFacadePtr);
        }
    }

    @CalledByNative
    public void scrollIntoViewFromUI(int nodeId) {
        if (this.mDevToolDelegate != null) {
            this.mDevToolDelegate.scrollIntoViewFromUI(nodeId);
        }
    }

    @CalledByNative
    public int findNodeIdForLocationFromUI(float x, float y, String mode) {
        if (this.mDevToolDelegate != null) {
            return this.mDevToolDelegate.getNodeForLocation(x, y, mode);
        }
        return 0;
    }

    @CalledByNative
    public void onConsoleMessage(String msg) {
        if (this.mConsoleDelegateManager != null) {
            this.mConsoleDelegateManager.onConsoleMessage(msg);
        }
    }

    @CalledByNative
    public void onConsoleObject(String detail, int callbackId) {
        if (this.mConsoleDelegateManager != null) {
            this.mConsoleDelegateManager.onConsoleObject(detail, callbackId);
        }
    }

    @CalledByNative
    public void startCasting(int quality, int max_width, int max_height, String screenshot_mode) {
        if (this.mCastHelper != null) {
            this.mCastHelper.startCasting(quality, max_width, max_height, screenshot_mode, this.mDevToolDelegate);
        }
    }

    @CalledByNative
    public long getTemplateDataPtr() {
        if (this.mReloadHelper != null) {
            return this.mReloadHelper.getTemplateDataPtr();
        }
        return 0L;
    }

    @CalledByNative
    public String getTemplateJsInfo(int offset, int size) {
        if (this.mReloadHelper != null) {
            return this.mReloadHelper.getTemplateJsInfo(offset, size);
        }
        return "";
    }

    public void dispatchScreencastVisibilityChanged(boolean status) {
        if (this.mFacadePtr != 0L) {
            this.nativeDispatchScreencastVisibilityChanged(this.mFacadePtr, status);
        }
    }

    @CalledByNative
    public void onAckReceived() {
        if (this.mCastHelper != null) {
            this.mCastHelper.onAckReceived();
        }
    }

    @CalledByNative
    public void sendCardPreview() {
        if (this.mCastHelper != null) {
            this.mCastHelper.sendCardPreview(this.mDevToolDelegate);
        }
    }

    @CalledByNative
    public String getLynxUITree() {
        if (this.mUITreeHelper != null) {
            return this.mUITreeHelper.getLynxUITree();
        }
        return "";
    }

    @CalledByNative
    public String getUINodeInfo(int id2) {
        if (this.mUITreeHelper != null) {
            return this.mUITreeHelper.getUINodeInfo(id2);
        }
        return "";
    }

    @CalledByNative
    public int setUIStyle(int id2, String name, String content) {
        if (this.mUITreeHelper != null) {
            return this.mUITreeHelper.setUIStyle(id2, name, content);
        }
        return -1;
    }

    public void sendCardPreviewData(String data) {
        if (this.mFacadePtr != 0L) {
            this.nativeSendLynxScreenshotCapturedEvent(this.mFacadePtr, data);
        }
    }

    public void sendScreenCast(String bitmap, ScreenCapturer.ScreenMetadata metadata, float pageScaleFactor, float timeCost) {
        if (bitmap == null || metadata == null) {
            return;
        }
        if (this.mFacadePtr != 0L) {
            this.nativeSendPageScreencastFrameEvent(this.mFacadePtr, bitmap, metadata.mOffsetTop, pageScaleFactor, metadata.mDeviceWidth, metadata.mDeviceHeight, metadata.mScrollOffsetX, metadata.mScrollOffsetY, metadata.mTimestamp);
        }
    }

    public void sendConsoleEvent(String text, int level, long timestamp) {
        if (this.mFacadePtr != 0L) {
            this.nativeSendConsoleEvent(this.mFacadePtr, text, level, timestamp);
        }
    }

    public void sendLayerTreeDidChangeEvent() {
        if (this.mFacadePtr != 0L) {
            this.nativeSendLayerTreeDidChangeEvent(this.mFacadePtr);
        }
    }

    @CalledByNative
    public void stopCasting() {
        if (this.mCastHelper != null) {
            this.mCastHelper.stopCasting();
        }
    }

    public void continueCasting() {
        if (this.mCastHelper != null) {
            this.mCastHelper.continueCasting();
        }
    }

    public void pauseCasting() {
        if (this.mCastHelper != null) {
            this.mCastHelper.pauseCasting();
        }
    }

    @CalledByNative
    void pageReload(boolean ignoreCache, String templateBin, boolean fromTemplateFragments, int templateSize) {
        if (this.mReloadHelper != null) {
            LynxView lynxView = (LynxView)this.mLynxView.get();
            if (lynxView != null) {
                Toast.makeText((Context)lynxView.getContext(), (CharSequence)"Start to download & reload...", (int)0).show();
            }
            this.mReloadHelper.reload(ignoreCache, templateBin, fromTemplateFragments, templateSize);
        }
    }

    @CalledByNative
    void navigate(String url) {
        if (this.mReloadHelper != null) {
            this.mNavigatePending = true;
            this.mReloadHelper.navigate(url);
        }
    }

    public void onLoadFinished() {
        if (this.mNavigatePending) {
            this.mNavigatePending = false;
            this.dispatchFrameNavigated();
        }
    }

    public void dispatchFrameNavigated() {
        if (this.mFacadePtr != 0L) {
            this.nativeSendPageFrameNavigatedEvent(this.mFacadePtr, this.getTemplateUrl());
        }
    }

    public String getTemplateUrl() {
        if (this.mReloadHelper != null) {
            return this.mReloadHelper.getURL();
        }
        LLog.w((String)TAG, (String)"mReloadHelper == null");
        return "";
    }

    public void attach(LynxView lynxView) {
        this.mLynxView = new WeakReference<LynxView>(lynxView);
        if (this.mCastHelper != null) {
            this.mCastHelper.attach(lynxView);
        }
        if (this.mTouchHelper != null) {
            this.mTouchHelper.attach(lynxView);
        }
    }

    public String getLepusDebugInfoUrl(String fileName) {
        if (this.mFacadePtr != 0L) {
            return this.nativeGetLepusDebugInfoUrl(this.mFacadePtr, fileName);
        }
        return "";
    }

    @CalledByNative
    public String getLepusDebugInfo(String url) {
        if (this.mLepusDebugInfoHelper != null) {
            return this.mLepusDebugInfoHelper.getDebugInfo(url);
        }
        return "";
    }

    public void destroy() {
        if (this.mFacadePtr != 0L) {
            this.nativeDestroyDevToolPlatformFacade(this.mFacadePtr);
        }
        this.mFacadePtr = 0L;
    }

    @CalledByNative
    public void emulateTouch(String type, int x, int y, float deltaX, float deltaY, String button) {
        if (this.mTouchHelper == null) {
            return;
        }
        LynxView lynxView = (LynxView)this.mLynxView.get();
        if (lynxView != null) {
            float scale = lynxView.getLynxContext().getResources().getDisplayMetrics().density;
            this.mTouchHelper.emulateTouch(type, (int)((float)x * scale + 0.5f), (int)((float)y * scale + 0.5f), deltaX * scale + 0.5f, deltaY * scale + 0.5f, button, this.mDevToolDelegate);
        }
    }

    @CalledByNative
    public float[] getTransformValue(int sign, float[] padBorderMarginLayout) {
        if (this.mDevToolDelegate != null) {
            return this.mDevToolDelegate.getTransformValue(sign, padBorderMarginLayout);
        }
        return new float[0];
    }

    @CalledByNative
    public float[] getRectToWindow() {
        if (this.mUITreeHelper != null) {
            return this.mUITreeHelper.getRectToWindow();
        }
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    @CalledByNative
    public static String getLynxVersion() {
        return LynxEnv.inst().getLynxVersion();
    }

    @CalledByNative
    public static void setDevToolSwitch(String key, boolean value) {
        LynxDevtoolEnv.inst().setDevtoolEnvMask(key, value);
    }

    @CalledByNative
    public void onReceiveTemplateFragment(String data, boolean eof) {
        if (this.mReloadHelper != null) {
            this.mReloadHelper.onReceiveTemplateFragment(data, eof);
        }
    }

    @CalledByNative
    public int[] getViewLocationOnScreen() {
        int[] res = new int[]{-1, -1};
        if (this.mUITreeHelper != null) {
            this.mUITreeHelper.getViewLocationOnScreen(res);
            return res;
        }
        return res;
    }

    @CalledByNative
    void sendEventToVM(String vmType, String eventName, String data) {
        if (this.mDevToolDelegate != null && !TextUtils.isEmpty((CharSequence)vmType) && !TextUtils.isEmpty((CharSequence)eventName)) {
            JavaOnlyMap map = new JavaOnlyMap();
            map.putString("type", eventName);
            map.putString("data", data != null ? data : "");
            map.putString("origin", "Devtool");
            map.putString("target", vmType);
            this.mDevToolDelegate.onDispatchMessageEvent((ReadableMap)map);
        }
    }

    private native long nativeCreateDevToolPlatformFacade();

    private native void nativeDestroyDevToolPlatformFacade(long var1);

    private native void nativeSendPageScreencastFrameEvent(long var1, String var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private native void nativeSendPageFrameNavigatedEvent(long var1, String var3);

    private native void nativeDispatchScreencastVisibilityChanged(long var1, boolean var3);

    private native void nativeSendLynxScreenshotCapturedEvent(long var1, String var3);

    public native void nativeFlushConsoleMessages(long var1);

    public native void nativeGetConsoleObject(long var1, String var3, boolean var4, int var5);

    private native void nativeSendConsoleEvent(long var1, String var3, int var4, long var5);

    private native void nativeSendLayerTreeDidChangeEvent(long var1);

    private native String nativeGetLepusDebugInfoUrl(long var1, String var3);
}

