/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.helper;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.MotionEvent;
import com.lynx.devtoolwrapper.IDevToolDelegate;
import com.lynx.tasm.LynxView;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.event.LynxTouchEvent;
import java.lang.ref.WeakReference;

public class EmulateTouchHelper {
    private static final String TAG = "EmulateTouchHelper";
    private WeakReference<LynxView> mLynxView;
    private MotionEvent mEvent;
    private boolean mMouseWheelFlag;
    private float mLastX;
    private float mLastY;
    private Handler mMouseWheelHandler;
    private int mDeltaScale;

    public EmulateTouchHelper(WeakReference<LynxView> lynxView) {
        this.mLynxView = lynxView;
        this.mEvent = null;
        this.mMouseWheelFlag = false;
        this.mMouseWheelHandler = new Handler(Looper.getMainLooper());
        this.mDeltaScale = 10;
    }

    public void attach(LynxView lynxView) {
        this.mLynxView = new WeakReference<LynxView>(lynxView);
    }

    public void emulateTouch(String type, int x, int y, float deltaX, float deltaY, String button, IDevToolDelegate devToolDelegate) {
        if (type == null) {
            LLog.e((String)TAG, (String)"emulateTouch: type is null");
            return;
        }
        LynxView view = (LynxView)this.mLynxView.get();
        if (view == null) {
            LLog.e((String)TAG, (String)"emulateTouch: view is null");
            return;
        }
        if (devToolDelegate == null) {
            LLog.e((String)TAG, (String)"emulateTouch: devToolDelegate is null");
            return;
        }
        if (devToolDelegate.getActualScreenshotMode().equals("fullscreen")) {
            int[] outLocation = new int[2];
            view.getLocationOnScreen(outLocation);
            x -= outLocation[0];
            y -= outLocation[1];
        }
        if (type.equals("mousePressed")) {
            this.mEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)0, (float)x, (float)y, (int)0);
            view.dispatchTouchEvent(this.mEvent);
        } else if (type.equals("mouseMoved")) {
            this.mEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)2, (float)x, (float)y, (int)0);
            view.dispatchTouchEvent(this.mEvent);
        } else if (type.equals("mouseReleased")) {
            this.mEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)1, (float)x, (float)y, (int)0);
            view.dispatchTouchEvent(this.mEvent);
            this.mEvent.recycle();
        } else if (type.equals("mouseWheel")) {
            this.mMouseWheelHandler.removeCallbacksAndMessages(null);
            if (!this.mMouseWheelFlag) {
                this.mMouseWheelFlag = true;
                this.mLastX = x;
                this.mLastY = y;
                this.mEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)0, (float)x, (float)y, (int)0);
                view.dispatchTouchEvent(this.mEvent);
            }
            this.mLastX += deltaX / (float)this.mDeltaScale;
            this.mLastY += deltaY / (float)this.mDeltaScale;
            this.mEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)2, (float)this.mLastX, (float)this.mLastY, (int)0);
            view.dispatchTouchEvent(this.mEvent);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EmulateTouchHelper.this.stopMouseWheel();
                }
            };
            this.mMouseWheelHandler.postDelayed(runnable, 100L);
        } else if ((type.equals("touchstart") || type.equals("touchmove") || type.equals("touchend") || type.equals("touchcancel") || type.equals("tap") || type.equals("longpress") || type.equals("click")) && view.getLynxContext() != null && view.getLynxContext().getEventEmitter() != null) {
            view.getLynxContext().getEventEmitter().sendTouchEvent(new LynxTouchEvent(Integer.parseInt(button), type, (float)x, (float)y));
        }
    }

    private void stopMouseWheel() {
        LynxView lynxView = (LynxView)this.mLynxView.get();
        if (lynxView == null) {
            LLog.e((String)TAG, (String)"stopMouseWheel: lynxView is null");
            return;
        }
        if (this.mMouseWheelFlag && this.mEvent.getAction() == 2) {
            this.mMouseWheelFlag = false;
            this.mEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)1, (float)this.mLastX, (float)this.mLastY, (int)0);
            lynxView.dispatchTouchEvent(this.mEvent);
            this.mEvent.recycle();
        }
    }
}

