/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.helper;

import com.lynx.basedevtool.utils.DevToolDownloader;
import com.lynx.basedevtool.utils.DownloadCallback;
import com.lynx.tasm.base.LLog;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;

public class LepusDebugInfoHelper {
    private static final String TAG = "LepusDebugInfoHelper";
    private AtomicBoolean mIsLoading = new AtomicBoolean(false);
    private String mDebugInfo;

    public String getDebugInfo(String url) {
        LLog.i((String)TAG, (String)("lepus debug: debug info url: " + url));
        this.mIsLoading.set(true);
        this.downloadDebugInfo(url);
        try {
            while (this.mIsLoading.get()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            LLog.e((String)TAG, (String)e.toString());
        }
        return this.mDebugInfo;
    }

    private void downloadDebugInfo(String url) {
        new DevToolDownloader(url, new DownloadCallback(){

            public void onResponse(int status, int contentLength) {
            }

            public void onData(byte[] bytes, int length) {
                LepusDebugInfoHelper.this.mDebugInfo = new String(bytes, Charset.defaultCharset());
                LepusDebugInfoHelper.this.mIsLoading.set(false);
            }

            public void onFailure(String reason) {
                LepusDebugInfoHelper.this.mDebugInfo = "";
                LepusDebugInfoHelper.this.mIsLoading.set(false);
                LLog.e((String)LepusDebugInfoHelper.TAG, (String)("lepus debug: download debug info failed, the reason is: " + reason));
            }
        });
    }
}

