/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import com.google.gson.Gson;
import com.lynx.devtool.recorder.LynxRecorderActionCallback;
import com.lynx.devtool.recorder.LynxRecorderActivity;
import com.lynx.devtool.recorder.LynxRecorderEnv;
import com.lynx.devtool.recorder.LynxRecorderMultiPagesActivity;
import com.lynx.devtool.recorder.QueryMapUtils;
import com.lynx.react.bridge.ReadableMap;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.provider.AbsTemplateProvider;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxRecorderPageManager {
    private static final String TAG = "LynxRecorderPageManager";
    private static LynxRecorderPageManager instance;
    private AtomicInteger count = new AtomicInteger(0);
    private JSONObject mPages;
    private JSONObject mRouters;
    private JSONObject mGroups;
    private JSONObject mActivities;
    private ArrayList<String> mPageStack;
    private int mActivityLaunchFlags;
    private ArrayList<LynxRecorderActionCallback> mCallbacks = new ArrayList();
    private boolean mIsMultiEnv;

    private int incrementAndGet() {
        return this.count.incrementAndGet();
    }

    public ArrayList<LynxRecorderActionCallback> getCallbacks() {
        return this.mCallbacks;
    }

    public void registerCallback(LynxRecorderActionCallback callback) {
        this.mCallbacks.add(callback);
    }

    private String getRawPageName(String pageName) {
        return pageName.split("#")[0];
    }

    private String buildPageName(String rawPageName) {
        return rawPageName + "#" + String.valueOf(this.incrementAndGet());
    }

    private LynxRecorderPageManager() {
    }

    private void clear() {
        this.mIsMultiEnv = false;
        this.mPages = new JSONObject();
        this.mRouters = new JSONObject();
        this.mActivities = new JSONObject();
        this.mGroups = new JSONObject();
        this.mPageStack = new ArrayList();
    }

    public static synchronized LynxRecorderPageManager getInstance() {
        if (instance == null) {
            instance = new LynxRecorderPageManager();
            instance.clear();
        }
        return instance;
    }

    private Intent getTestBenchIntent(Context ctx, String url) {
        Intent intent = new Intent(ctx, LynxRecorderActivity.class);
        intent.addFlags(this.mActivityLaunchFlags);
        intent.putExtra(LynxRecorderEnv.getInstance().mUriKey, url);
        return intent;
    }

    void replaySignalPage(String url, Context ctx) {
        this.clear();
        this.mIsMultiEnv = false;
        Intent intent = this.getTestBenchIntent(ctx, url);
        ctx.startActivity(intent);
    }

    void replayMultiPagesInOneActivity(String url, Context ctx) {
        this.clear();
        this.mIsMultiEnv = true;
        Intent intent = new Intent(ctx, LynxRecorderMultiPagesActivity.class);
        intent.addFlags(this.mActivityLaunchFlags);
        intent.putExtra(LynxRecorderEnv.getInstance().mUriKey, url);
        ctx.startActivity(intent);
    }

    void replayMultiPages(String url, Context ctx) {
        this.clear();
        this.mIsMultiEnv = true;
        this.loadDescribeFile(url, ctx);
    }

    public void initLynxGroup(String groupName, LynxRecorderActivity currActivity) {
        if (!this.mIsMultiEnv) {
            return;
        }
        LynxRecorderActivity activity = (LynxRecorderActivity)((Object)this.mGroups.opt(groupName));
        if (activity == null) {
            try {
                this.mGroups.put(groupName, (Object)currActivity);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            currActivity.setLynxGroup(activity.getLynxGroup());
        }
    }

    public void registerActivity(String pageName, LynxRecorderActivity currActivity) {
        if (!this.mIsMultiEnv) {
            return;
        }
        try {
            this.mActivities.put(pageName, (Object)currActivity);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onActivityDestroy(String pageName, boolean hasBeenRemoveFromPageStack) {
        if (!this.mIsMultiEnv) {
            return;
        }
        if (!hasBeenRemoveFromPageStack) {
            this.mPageStack.remove(this.mPageStack.size() - 1);
        }
        this.mActivities.remove(pageName);
    }

    public void replayPageFromOpenSchema(ReadableMap params) {
        if (!this.mIsMultiEnv) {
            return;
        }
        String currPageName = this.mPageStack.get(this.mPageStack.size() - 1);
        String currRawPageName = this.getRawPageName(currPageName);
        String label = params.getString("label");
        JSONObject nextPageInfo = this.mRouters.optJSONObject(currRawPageName).optJSONObject(label);
        boolean popLast = nextPageInfo.optBoolean("popLast");
        String nextPage = nextPageInfo.optString("next");
        if (popLast) {
            this.mPageStack.remove(this.mPageStack.size() - 1);
        }
        this.mPageStack.add(this.buildPageName(nextPage));
        this.replayCurrPage((Context)((LynxRecorderActivity)((Object)this.mActivities.opt(currPageName))), popLast);
    }

    void replayCurrPage(Context ctx, boolean popLast) {
        String pageName = this.mPageStack.get(this.mPageStack.size() - 1);
        String rawPageName = this.getRawPageName(pageName);
        JSONObject pageInfo = this.mPages.optJSONObject(rawPageName);
        if (pageInfo == null) {
            return;
        }
        Intent intent = this.getTestBenchIntent(ctx, pageInfo.optString("url"));
        intent.putExtra("groupName", pageInfo.optString("group"));
        intent.putExtra("pageName", pageName);
        ctx.startActivity(intent);
        if (popLast) {
            ((LynxRecorderActivity)ctx).setState(true);
            ((LynxRecorderActivity)ctx).finish();
        }
    }

    void loadDescribeFile(String rawUrl, final Context ctx) {
        QueryMapUtils queryMap = new QueryMapUtils();
        queryMap.parse(rawUrl);
        String url = queryMap.getString("url");
        LynxEnv.inst().getTemplateProvider().loadTemplate(url, new AbsTemplateProvider.Callback(){

            public void onSuccess(byte[] template) {
                if (!Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
                    throw new IllegalThreadStateException("Callback must be fired on main thread.");
                }
                Gson gson = new Gson();
                String str = new String(template, Charset.forName("UTF-8"));
                Map map = (Map)gson.fromJson(str, Map.class);
                JSONObject describeFile = new JSONObject(map);
                LynxRecorderPageManager.this.mPages = describeFile.optJSONObject("pages");
                LynxRecorderPageManager.this.mRouters = describeFile.optJSONObject("routers");
                LynxRecorderPageManager.this.mPageStack.add(LynxRecorderPageManager.this.buildPageName(describeFile.optString("root")));
                LynxRecorderPageManager.this.replayCurrPage(ctx, false);
            }

            public void onFailed(String msg) {
            }
        });
    }

    private boolean isDescribeFile(String url) {
        QueryMapUtils queryMap = new QueryMapUtils();
        queryMap.parse(url);
        return queryMap.getString("describe_file") != null && queryMap.getBoolean("describe_file", false);
    }

    private boolean isMultiPagesFile(String url) {
        QueryMapUtils queryMap = new QueryMapUtils();
        queryMap.parse(url);
        return queryMap.getString("multi-page") != null && queryMap.getBoolean("multi-page", false);
    }

    public void startReplay(String url, Context ctx, int activityLaunchFlags) {
        this.mActivityLaunchFlags = activityLaunchFlags;
        if (this.isDescribeFile(url)) {
            this.replayMultiPages(url, ctx);
        } else if (this.isMultiPagesFile(url)) {
            this.replayMultiPagesInOneActivity(url, ctx);
        } else {
            this.replaySignalPage(url, ctx);
        }
    }
}

