/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.content.Context;
import com.lynx.devtool.recorder.LynxRecorderReplayDataProvider;
import com.lynx.jsbridge.LynxMethod;
import com.lynx.jsbridge.LynxModule;
import com.lynx.react.bridge.Callback;
import com.lynx.tasm.base.LLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxRecorderReplayDataModule
extends LynxModule {
    private static final String TAG = "LynxRecorderReplayDataModule";
    private JSONArray mFunctionCall;
    private JSONObject mCallbackData;
    private JSONArray mJsbIgnoredInfo;
    private JSONObject mJsbSettings;

    public LynxRecorderReplayDataModule(Context context) {
        super(context);
    }

    public LynxRecorderReplayDataModule(Context context, Object param) {
        super(context);
        LynxRecorderReplayDataProvider provider = (LynxRecorderReplayDataProvider)param;
        this.mFunctionCall = provider.getFunctionCall();
        this.mCallbackData = provider.getCallbackData();
        this.mJsbIgnoredInfo = provider.getJsbIgnoredInfo();
        this.mJsbSettings = provider.getJsbSettings();
    }

    @LynxMethod
    public void getData(Callback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put("RecordData", (Object)this.getRecordData());
            data.put("JsbIgnoredInfo", (Object)this.getJsbIgnoredInfo());
            data.put("JsbSettings", (Object)this.getJsbSettings());
        }
        catch (JSONException e) {
            LLog.e((String)"TestBench", (String)"Record file format error!");
            callback.invoke(new Object[]{"{}"});
        }
        callback.invoke(new Object[]{data.toString()});
    }

    private String getRecordData() {
        JSONObject json = new JSONObject();
        try {
            for (int index = 0; index < this.mFunctionCall.length(); ++index) {
                JSONArray callbackIDs;
                JSONObject funcInvoke = this.mFunctionCall.getJSONObject(index);
                String moduleName = funcInvoke.getString("Module Name");
                if (!json.has(moduleName)) {
                    json.put(moduleName, (Object)new JSONArray());
                }
                JSONObject methodLookUp = new JSONObject();
                String methodName = funcInvoke.getString("Method Name");
                long requestTime = Long.parseLong(funcInvoke.getString("Record Time")) * 1000L;
                if (funcInvoke.has("RecordMillisecond")) {
                    requestTime = funcInvoke.getLong("RecordMillisecond");
                }
                JSONObject params = funcInvoke.getJSONObject("Params");
                try {
                    callbackIDs = params.getJSONArray("callback");
                }
                catch (JSONException e) {
                    callbackIDs = null;
                }
                StringBuffer functionInvokeLabel = new StringBuffer();
                JSONArray callbackReturnValues = new JSONArray();
                if (callbackIDs != null) {
                    for (int i = 0; i < callbackIDs.length(); ++i) {
                        JSONObject callbackInfo;
                        try {
                            callbackInfo = this.mCallbackData.getJSONObject(callbackIDs.getString(i));
                        }
                        catch (JSONException e) {
                            callbackInfo = null;
                        }
                        if (callbackInfo != null) {
                            long responseTime = Long.parseLong(callbackInfo.getString("Record Time")) * 1000L;
                            if (funcInvoke.has("RecordMillisecond")) {
                                responseTime = callbackInfo.getLong("RecordMillisecond");
                            }
                            JSONObject callbackKernel = new JSONObject();
                            callbackKernel.put("Value", (Object)callbackInfo.getJSONObject("Params"));
                            callbackKernel.put("Delay", responseTime - requestTime);
                            callbackReturnValues.put(i, (Object)callbackKernel);
                        }
                        functionInvokeLabel.append(callbackIDs.getString(i)).append("_");
                    }
                }
                if (funcInvoke.has("SyncAttributes")) {
                    methodLookUp.put("SyncAttributes", (Object)funcInvoke.getJSONObject("SyncAttributes"));
                }
                methodLookUp.put("Method Name", (Object)methodName);
                methodLookUp.put("Params", (Object)params);
                methodLookUp.put("Callback", (Object)callbackReturnValues);
                methodLookUp.put("Label", (Object)functionInvokeLabel.toString());
                json.getJSONArray(moduleName).put((Object)methodLookUp);
            }
        }
        catch (JSONException e) {
            LLog.e((String)"TestBench", (String)"Record file format error!");
            return "{}";
        }
        return json.toString();
    }

    private String getJsbIgnoredInfo() {
        if (this.mJsbIgnoredInfo != null) {
            return this.mJsbIgnoredInfo.toString();
        }
        LLog.e((String)"TestBench", (String)"getJsbIgnoredInfo  error: download File failed");
        return "[]";
    }

    private String getJsbSettings() {
        if (this.mJsbSettings != null) {
            return this.mJsbSettings.toString();
        }
        LLog.e((String)"TestBench", (String)"getJsbSettings  error: download File failed");
        return "{}";
    }
}

