/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import androidx.annotation.NonNull;
import com.lynx.devtool.recorder.Utils;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.provider.LynxResourceCallback;
import com.lynx.tasm.provider.LynxResourceProvider;
import com.lynx.tasm.provider.LynxResourceRequest;
import com.lynx.tasm.provider.LynxResourceResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class LynxRecorderSourceProvider
extends LynxResourceProvider<Object, byte[]> {
    private static final String TAG = "LynxRecorderSourceProvider";
    private static final String ASSETS_SCHEME = "assets://";
    private static final int HTTP_TIME_OUT = 5000;
    private JSONObject mUrlRedirect = null;

    public void setUrlRedirect(JSONObject urlRedirect) {
        this.mUrlRedirect = urlRedirect;
    }

    public void request(@NonNull LynxResourceRequest<Object> request, @NonNull LynxResourceCallback<byte[]> callback) {
        LLog.i((String)TAG, (String)("LynxRecorderSourceProvider request " + request.getUrl()));
        byte[] data = null;
        Throwable error = null;
        try {
            String requestUrl = request.getUrl();
            if (requestUrl.length() > ASSETS_SCHEME.length() && requestUrl.startsWith(ASSETS_SCHEME)) {
                data = this.requestFromAssets(requestUrl.substring(ASSETS_SCHEME.length()));
            } else {
                if (this.mUrlRedirect != null && this.mUrlRedirect.has(requestUrl)) {
                    requestUrl = this.mUrlRedirect.getString(requestUrl);
                }
                data = this.requestFromURL(requestUrl);
            }
        }
        catch (Throwable e) {
            error = e;
        }
        if (error != null) {
            LLog.i((String)TAG, (String)("LynxRecorderSourceProvider request failed, error:" + error));
            callback.onResponse(LynxResourceResponse.failed((int)-1, (Throwable)error));
        } else {
            LLog.i((String)TAG, (String)"LynxRecorderSourceProvider request successfully");
            callback.onResponse(LynxResourceResponse.success(data));
        }
    }

    private byte[] requestFromURL(@NonNull String requestUrl) throws IOException {
        URL url = new URL(requestUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setReadTimeout(5000);
        if (conn.getResponseCode() == 200) {
            return Utils.inputStreamToByteArray(conn.getInputStream());
        }
        throw new IOException(conn.getResponseMessage());
    }

    private byte[] requestFromAssets(@NonNull String path) throws IOException {
        try (InputStream in = LynxEnv.inst().getAppContext().getAssets().open(path);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int n;
                byte[] buffer = new byte[4096];
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }
}

