/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.recorder;

import android.net.Uri;
import android.util.Log;
import java.util.HashMap;

public class QueryMapUtils {
    private final String TAG = this.getClass().toString();
    private HashMap<String, String> mQuery = new HashMap();

    public void parse(String url) {
        String queryString = this.getQueryStringFromUrl(url);
        this.saveQueryToMap(queryString);
    }

    private void saveQueryToMap(String query) {
        String[] params;
        if (query == null || query.isEmpty()) {
            Log.i((String)this.TAG, (String)"The URL does not contain any query information.");
            return;
        }
        for (String param : params = query.split("&")) {
            String[] splitResult = param.split("=");
            if (splitResult.length < 2) continue;
            String name = splitResult[0];
            String value = splitResult[1];
            if (value.startsWith("http")) {
                value = Uri.decode((String)value);
            }
            this.mQuery.put(name, value);
        }
    }

    private String getQueryStringFromUrl(String url) {
        if (url.contains("?")) {
            String queryString = url.split("\\?")[1];
            return queryString;
        }
        return null;
    }

    public HashMap<String, String> toMap() {
        HashMap<String, String> copyQueryMap = new HashMap<String, String>();
        copyQueryMap.putAll(this.mQuery);
        return copyQueryMap;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String val = this.mQuery.get(key);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(val);
        }
        catch (Throwable e) {
            Log.e((String)this.TAG, (String)"The query value cannot be converted to a boolean type.");
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        String val = this.mQuery.get(key);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Throwable e) {
            Log.e((String)this.TAG, (String)"The query value cannot be converted to a Int type.");
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        if (this.mQuery.containsKey(key)) {
            String val = this.mQuery.get(key);
            if (val == null) {
                return defaultValue;
            }
            try {
                return Float.parseFloat(val);
            }
            catch (Throwable e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getString(String key) {
        String val = this.mQuery.get(key);
        return val;
    }

    public boolean contains(String key) {
        return this.mQuery.containsKey(key);
    }
}

