/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.tracing;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.View;
import com.lynx.devtool.framecapture.FrameCapturer;
import com.lynx.devtool.tracing.FrameTraceService;
import com.lynx.devtoolwrapper.ScreenshotBitmapHandler;
import com.lynx.tasm.base.CalledByNative;
import com.lynx.tasm.base.TraceEvent;
import com.lynx.tasm.utils.BitmapUtils;

public class FrameViewTrace
extends FrameCapturer {
    private long mNativeFrameViewTrace = this.nativeCreateFrameViewTrace();

    public static FrameViewTrace getInstance() {
        return FrameViewTraceLoader.INSTANCE;
    }

    @Override
    protected boolean isEnabled() {
        return TraceEvent.categoryEnabled((long)2L);
    }

    private String takeScreenshot(View view) {
        String data = null;
        try {
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
            view.setDrawingCacheEnabled(false);
            if (bitmap != null) {
                int originWidth = bitmap.getWidth();
                int originHeight = bitmap.getHeight();
                float area = originHeight * originWidth;
                if (area > (float)this.mMaxScreenshotAreaSize) {
                    float scale = (float)Math.sqrt((float)this.mMaxScreenshotAreaSize / area);
                    Matrix matrix = new Matrix();
                    matrix.setScale(scale, scale);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)originWidth, (int)originHeight, (Matrix)matrix, (boolean)false);
                }
                data = BitmapUtils.bitmapToBase64WithQuality((Bitmap)bitmap, (int)this.mScreenshotQuality);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    protected void onNewScreenshotBitmapData(String data) {
        if (this.isEnabled()) {
            FrameTraceService.getInstance().screenshot(data);
        }
    }

    @Override
    @CalledByNative
    public void startFrameViewTrace() {
        super.startFrameViewTrace();
    }

    @Override
    @CalledByNative
    public void stopFrameViewTrace() {
        super.stopFrameViewTrace();
    }

    public long getNativeFrameViewTrace() {
        return this.mNativeFrameViewTrace;
    }

    private native long nativeCreateFrameViewTrace();

    @Override
    protected void screenshot(View view, ScreenshotBitmapHandler handler) {
        String data = this.takeScreenshot(view);
        this.onScreenshotActionEnd();
        if (data == null || data.equals(this.mScreenshotBitmapDataCache)) {
            return;
        }
        this.mScreenshotBitmapDataCache = data;
        this.onNewScreenshotBitmapData(data);
    }

    private static class FrameViewTraceLoader {
        private static final FrameViewTrace INSTANCE = new FrameViewTrace();

        private FrameViewTraceLoader() {
        }
    }
}

