/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.tasm.base;

import android.util.Log;
import com.lynx.tasm.base.TraceEvent;

public class LynxTraceEnv {
    private static LynxTraceEnv sInstance;
    private volatile boolean mIsNativeLibraryLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LynxTraceEnv inst() {
        if (sInstance != null) return sInstance;
        Class<LynxTraceEnv> clazz = LynxTraceEnv.class;
        synchronized (LynxTraceEnv.class) {
            if (sInstance != null) return sInstance;
            sInstance = new LynxTraceEnv();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private LynxTraceEnv() {
    }

    public boolean isNativeLibraryLoaded() {
        return this.mIsNativeLibraryLoaded;
    }

    public void markNativeLibraryLoaded(boolean status) {
        this.mIsNativeLibraryLoaded = status;
        TraceEvent.markTraceEnvInited(status);
    }

    public boolean init() {
        if (this.mIsNativeLibraryLoaded) {
            return this.mIsNativeLibraryLoaded;
        }
        this.mIsNativeLibraryLoaded = this.loadNativeTraceLibrary();
        TraceEvent.markTraceEnvInited(this.mIsNativeLibraryLoaded);
        return this.mIsNativeLibraryLoaded;
    }

    public boolean loadNativeTraceLibrary() {
        if (this.mIsNativeLibraryLoaded) {
            return this.mIsNativeLibraryLoaded;
        }
        try {
            System.loadLibrary("lynxtrace");
            return true;
        }
        catch (Exception e) {
            Log.e((String)"trace env init", (String)"failed to load liblynxtrace.so");
            return false;
        }
    }
}

