/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.tasm.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Process;
import android.os.Trace;
import android.util.Log;
import android.widget.Toast;
import com.lynx.tasm.base.LynxTraceEnv;
import com.lynx.tasm.base.TraceEvent;
import com.lynx.trace.CalledByNative;
import java.io.File;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class TraceController {
    private static final String ACTION_START = "LYNX_TRACE_START";
    private static final String ACTION_STOP = "LYNX_TRACE_STOP";
    private static final String CATEGORIES_EXTRA = "categories";
    private static final String FILE_EXTRA = "file";
    private static final String BUFFER_SIZE_EXTRA = "buffer";
    private static final String NATIVE_ONLY_EXTRA = "nativeOnly";
    private static final String TAG = "Lynx startup trace";
    private static final int DEFAULT_BUFFER_SIZE = 40960;
    private static final long ATRACE_TAG_ALL = 0x7FFFFFFL;
    private Context mContext;
    private List<CompleteCallback> mCompleteCallbacks = new ArrayList<CompleteCallback>();
    private TraceBroadcastReceiver mBroadcastReceiver;
    private boolean mTracingStarted = false;
    private long mNativeTraceController = 0L;
    private int tracingSession = -1;
    private static boolean sNativeTracingOnly = false;
    private static boolean isTraceEnvInit = false;
    private String traceFilePath;

    private TraceController() {
        try {
            if (this.mNativeTraceController == 0L && TraceController.isTraceEnvInited()) {
                this.mNativeTraceController = this.nativeCreateTraceController();
            }
        }
        catch (UnsatisfiedLinkError e) {
            Log.w((String)TAG, (String)"failed to create NativeTraceController", (Throwable)e);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"failed to create NativeTraceController", (Throwable)e);
        }
        if (this.mNativeTraceController == 0L) {
            Log.w((String)TAG, (String)"failed to create NativeTraceController");
            return;
        }
    }

    public static boolean isNativeTracingOnly() {
        return sNativeTracingOnly;
    }

    public static TraceController getInstance() {
        return TraceControllerLoader.INSTANCE;
    }

    public long getNativeTraceController() {
        return this.mNativeTraceController;
    }

    public String startTrace() {
        File file = this.getFile();
        String fileName = file.getPath();
        this.startTracing(40960, null, null, fileName, false);
        String logMessage = "Trace started at: " + fileName;
        Toast.makeText((Context)this.mContext, (CharSequence)logMessage, (int)0).show();
        Log.i((String)TAG, (String)logMessage);
        return file.getAbsolutePath();
    }

    public void stopTrace() {
        this.stopTracing();
        Toast.makeText((Context)this.mContext, (CharSequence)"Trace stopped", (int)0).show();
        Log.i((String)TAG, (String)"Trace stopped");
    }

    public void startStartupTracingIfNeeded() {
        if (this.mNativeTraceController != 0L) {
            this.nativeStartStartupTracingIfNeeded(this.mNativeTraceController);
        }
    }

    public void startTracing(CompleteCallback callback, String config) {
        this.mCompleteCallbacks.add(callback);
        String traceFile = this.generateTracingFileName();
        this.startTracing(40960, null, null, traceFile, false);
    }

    public void startTracing(CompleteCallback callback, Map<String, String> config) {
        this.mCompleteCallbacks.add(callback);
        String traceFile = this.generateTracingFileName();
        Boolean enableSystrace = false;
        int bufferSize = 40960;
        if (config.containsKey("trace_file")) {
            traceFile = config.get("trace_file");
        }
        if (config.containsKey("buffer_size")) {
            bufferSize = Integer.parseInt(config.get("buffer_size"));
        }
        if (config.containsKey("enable_systrace")) {
            enableSystrace = Boolean.parseBoolean(config.get("enable_systrace"));
        }
        this.startTracing(bufferSize, null, null, traceFile, enableSystrace);
    }

    public void stopTracing() {
        if (this.mNativeTraceController == 0L || !this.mTracingStarted) {
            return;
        }
        this.mTracingStarted = false;
        this.nativeStopTracing(this.mNativeTraceController, this.tracingSession);
        if (!this.traceFilePath.isEmpty()) {
            this.onTracingComplete(this.traceFilePath);
            this.traceFilePath = "";
        }
    }

    public boolean isTracingStarted() {
        return this.mTracingStarted;
    }

    @Deprecated
    public void recordClockSyncMarker(String syncId) {
    }

    public void onTracingComplete(String traceFile) {
        for (CompleteCallback callback : this.mCompleteCallbacks) {
            callback.onComplete(traceFile);
        }
        this.mCompleteCallbacks.clear();
    }

    private String generateTracingFileName() {
        File file = this.getFile();
        return file.getPath();
    }

    @CalledByNative
    private String generateTracingFileDir() {
        return this.mContext.getExternalFilesDir(null).getPath();
    }

    private File getFile() {
        int pid = Process.myPid();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        File dir = this.mContext.getExternalFilesDir(null);
        return new File(dir, "lynx-profile-trace-" + pid + "-" + formatter.format(new Date()));
    }

    @CalledByNative
    private void refreshATraceTags() {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                Field field = Trace.class.getDeclaredField("sEnabledTags");
                field.setAccessible(true);
                field.setLong(null, 0x7FFFFFFL);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isTraceEnvInited() {
        if (isTraceEnvInit) {
            return isTraceEnvInit;
        }
        isTraceEnvInit = LynxTraceEnv.inst().init();
        return isTraceEnvInit;
    }

    protected void startTracing(int bufferSize, String[] includeCategories, String[] excludeCategories, String traceFile, boolean enableSystrace) {
        if (this.mTracingStarted) {
            Toast.makeText((Context)this.mContext, (CharSequence)"Trace already started, please stop it first", (int)0).show();
            return;
        }
        if (this.mNativeTraceController == 0L) {
            Log.w((String)TAG, (String)"tracing not enabled");
            return;
        }
        this.mTracingStarted = true;
        this.traceFilePath = traceFile.isEmpty() ? this.getFile().getPath() : traceFile;
        this.tracingSession = this.nativeStartTracing(this.mNativeTraceController, bufferSize, includeCategories, excludeCategories, this.traceFilePath, enableSystrace);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("Version", "0.0.1");
        TraceEvent.instant(1L, "Version", args);
    }

    public void init(Context context) {
        this.mContext = context;
        this.mBroadcastReceiver = new TraceBroadcastReceiver();
        TraceIntentFilter filter = new TraceIntentFilter(this.mContext);
        if (Build.VERSION.SDK_INT >= 34 && context.getApplicationInfo().targetSdkVersion >= 34) {
            this.mContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, (IntentFilter)filter, 4);
        } else {
            this.mContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, (IntentFilter)filter);
        }
    }

    public void onTerminate() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        this.mContext = null;
    }

    private native long nativeCreateTraceController();

    private native int nativeStartTracing(long var1, int var3, String[] var4, String[] var5, String var6, boolean var7);

    private native void nativeStopTracing(long var1, int var3);

    private native void nativeStartStartupTracingIfNeeded(long var1);

    class TraceBroadcastReceiver
    extends BroadcastReceiver {
        TraceBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().endsWith(TraceController.ACTION_START)) {
                String categories = intent.getStringExtra(TraceController.CATEGORIES_EXTRA);
                String filename = intent.getStringExtra(TraceController.FILE_EXTRA);
                int bufferSize = intent.getIntExtra(TraceController.BUFFER_SIZE_EXTRA, 40960);
                boolean isNativeOnly = intent.getBooleanExtra(TraceController.NATIVE_ONLY_EXTRA, false);
                sNativeTracingOnly = isNativeOnly;
                if (filename == null) {
                    filename = TraceController.this.generateTracingFileName();
                }
                TraceController.this.startTracing(bufferSize, categories != null ? categories.split(",") : null, null, filename, false);
                String logMessage = "Trace started at: " + filename;
                Toast.makeText((Context)context, (CharSequence)logMessage, (int)0).show();
                Log.i((String)TraceController.TAG, (String)logMessage);
            } else if (intent.getAction().endsWith(TraceController.ACTION_STOP)) {
                sNativeTracingOnly = false;
                TraceController.this.stopTracing();
                Toast.makeText((Context)context, (CharSequence)"Trace stopped", (int)0).show();
                Log.i((String)TraceController.TAG, (String)"Trace stopped");
            }
        }
    }

    private static class TraceIntentFilter
    extends IntentFilter {
        public TraceIntentFilter(Context context) {
            this.addAction(context.getPackageName() + "." + TraceController.ACTION_START);
            this.addAction(context.getPackageName() + "." + TraceController.ACTION_STOP);
        }
    }

    public static interface CompleteCallback {
        public void onComplete(String var1);
    }

    private static class TraceControllerLoader {
        private static final TraceController INSTANCE = new TraceController();

        private TraceControllerLoader() {
        }
    }
}

