/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.tasm.base;

import android.os.Trace;
import com.lynx.tasm.base.TraceController;
import java.util.Map;
import java.util.Random;

public class TraceEvent {
    public static final long CATEGORY_DEFAULT = 0L;
    public static final long CATEGORY_VITALS = 1L;
    public static final long CATEGORY_SCREENSHOTS = 2L;
    public static final long CATEGORY_FPS = 3L;
    public static final String DEFAULT_INSTANT_COLOR = "#FF0000";
    public static final String[] defualt_categories = new String[]{"lynx", "vitals", "screenshot", "fps"};
    private static boolean sTraceEnvInited = false;
    private static boolean sDebugModeEnabled = false;
    private static boolean sPerfettoTraceEnabled = false;
    private static boolean sSystemTraceEnabled = false;

    private static String getRandomColor() {
        try {
            StringBuilder result = new StringBuilder();
            result.append('#');
            for (int i = 0; i < 6; ++i) {
                result.append(Integer.toHexString(new Random().nextInt(16)));
            }
            return result.toString().toUpperCase();
        }
        catch (Exception e) {
            return DEFAULT_INSTANT_COLOR;
        }
    }

    public static void markTraceEnvInited(boolean isInit) {
        sTraceEnvInited = isInit;
    }

    public static void markTraceDebugMode(boolean isDebugModeEnabled) {
        sDebugModeEnabled = isDebugModeEnabled;
    }

    public static void beginSection(String sectionName) {
        TraceEvent.beginSection(0L, sectionName);
    }

    public static void endSection(String sectionName) {
        TraceEvent.endSection(0L, sectionName);
    }

    @Deprecated
    public static void beginSection(long category, String sectionName) {
        TraceEvent.beginSection(defualt_categories[(int)category], sectionName);
    }

    public static void beginSection(String category, String sectionName) {
        if (TraceController.isNativeTracingOnly()) {
            return;
        }
        if (TraceEvent.enableTrace()) {
            if (TraceEvent.enablePerfettoTrace() && TraceEvent.isTracingStarted()) {
                TraceEvent.nativeBeginSection(category, sectionName);
            } else {
                Trace.beginSection((String)sectionName);
            }
        }
    }

    @Deprecated
    public static void endSection(long category, String sectionName) {
        TraceEvent.endSection(defualt_categories[(int)category], sectionName);
    }

    public static void endSection(String category, String sectionName) {
        if (TraceController.isNativeTracingOnly()) {
            return;
        }
        if (TraceEvent.enableTrace()) {
            if (TraceEvent.enablePerfettoTrace() && TraceEvent.isTracingStarted()) {
                TraceEvent.nativeEndSection(category, sectionName);
            } else {
                Trace.endSection();
            }
        }
    }

    public static void beginSection(String sectionName, Map<String, String> props) {
        TraceEvent.beginSection(0L, sectionName, props);
    }

    @Deprecated
    public static void beginSection(long category, String sectionName, Map<String, String> props) {
        TraceEvent.beginSection(defualt_categories[(int)category], sectionName, props);
    }

    public static void beginSection(String category, String sectionName, Map<String, String> props) {
        if (TraceController.isNativeTracingOnly()) {
            return;
        }
        if (TraceEvent.enableTrace()) {
            if (TraceEvent.enablePerfettoTrace() && TraceEvent.isTracingStarted()) {
                TraceEvent.nativeBeginSectionWithProps(category, sectionName, props);
            } else {
                Trace.beginSection((String)sectionName);
            }
        }
    }

    @Deprecated
    public static void endSection(long category, String sectionName, Map<String, String> props) {
        TraceEvent.endSection(defualt_categories[(int)category], sectionName, props);
    }

    public static void endSection(String category, String sectionName, Map<String, String> props) {
        if (TraceController.isNativeTracingOnly()) {
            return;
        }
        if (TraceEvent.enableTrace()) {
            if (TraceEvent.enablePerfettoTrace() && TraceEvent.isTracingStarted()) {
                TraceEvent.nativeEndSectionWithProps(category, sectionName, props);
            } else {
                Trace.endSection();
            }
        }
    }

    @Deprecated
    public static void instant(long category, String eventName) {
        TraceEvent.instant(defualt_categories[(int)category], eventName, System.nanoTime() / 1000L);
    }

    public static void instant(String category, String eventName) {
        TraceEvent.instant(category, eventName, System.nanoTime() / 1000L);
    }

    @Deprecated
    public static void instant(long category, String eventName, long timestamp) {
        TraceEvent.instant(defualt_categories[(int)category], eventName, timestamp, TraceEvent.getRandomColor());
    }

    public static void instant(String category, String eventName, long timestamp) {
        TraceEvent.instant(category, eventName, timestamp, TraceEvent.getRandomColor());
    }

    @Deprecated
    public static void instant(long category, String eventName, String color) {
        TraceEvent.instant(defualt_categories[(int)category], eventName, System.nanoTime() / 1000L, color);
    }

    public static void instant(String category, String eventName, String color) {
        TraceEvent.instant(category, eventName, System.nanoTime() / 1000L, color);
    }

    @Deprecated
    public static void instant(long category, String eventName, Map<String, String> props) {
        TraceEvent.instant(defualt_categories[(int)category], eventName, props);
    }

    public static void instant(String category, String eventName, Map<String, String> props) {
        if (TraceEvent.enableTrace()) {
            if (TraceEvent.enablePerfettoTrace() && TraceEvent.isTracingStarted()) {
                TraceEvent.nativeInstantWithProps(category, eventName, System.nanoTime() / 1000L, props);
            } else {
                Trace.beginSection((String)eventName);
                Trace.endSection();
            }
        }
    }

    @Deprecated
    public static void counter(long category, String name, long counterValue) {
        TraceEvent.counter(defualt_categories[(int)category], name, counterValue);
    }

    public static void counter(String category, String name, long counterValue) {
        if (TraceController.isNativeTracingOnly()) {
            return;
        }
        if (TraceEvent.enableTrace() && TraceEvent.isTracingStarted()) {
            TraceEvent.nativeCounter(category, name, counterValue);
        }
    }

    @Deprecated
    public static boolean registerTraceBackend(long ptr) {
        return false;
    }

    @Deprecated
    public static boolean categoryEnabled(long category) {
        return TraceEvent.categoryEnabled(defualt_categories[(int)category]);
    }

    public static boolean categoryEnabled(String category) {
        return TraceEvent.enableTrace() && TraceEvent.nativeCategoryEnabled(category);
    }

    public static boolean enableTrace() {
        return sDebugModeEnabled;
    }

    public static boolean enableSystemTrace() {
        if (!sSystemTraceEnabled && sTraceEnvInited) {
            sSystemTraceEnabled = TraceEvent.nativeSystemTraceEnabled();
        }
        return sSystemTraceEnabled;
    }

    public static boolean enablePerfettoTrace() {
        if (!sPerfettoTraceEnabled && sTraceEnvInited) {
            sPerfettoTraceEnabled = TraceEvent.nativePerfettoTraceEnabled();
        }
        return sPerfettoTraceEnabled;
    }

    public static boolean isTracingStarted() {
        return TraceController.isTracingStarted();
    }

    private static void instant(String category, String eventName, long timestamp, String color) {
        if (TraceEvent.enableTrace()) {
            if (TraceEvent.enablePerfettoTrace() && TraceEvent.isTracingStarted()) {
                TraceEvent.nativeInstant(category, eventName, timestamp, color);
            } else {
                Trace.beginSection((String)eventName);
                Trace.endSection();
            }
        }
    }

    private static void instant(String category, String eventName, long timestamp, Map<String, String> props) {
        if (TraceEvent.enableTrace()) {
            if (TraceEvent.enablePerfettoTrace() && TraceEvent.isTracingStarted()) {
                timestamp = timestamp > 0L ? timestamp : System.nanoTime() / 1000L;
                TraceEvent.nativeInstantWithProps(category, eventName, timestamp, props);
            } else {
                Trace.beginSection((String)eventName);
                Trace.endSection();
            }
        }
    }

    private static native void nativeBeginSection(String var0, String var1);

    private static native void nativeBeginSectionWithProps(String var0, String var1, Map<String, String> var2);

    private static native void nativeEndSection(String var0, String var1);

    private static native void nativeEndSectionWithProps(String var0, String var1, Map<String, String> var2);

    private static native void nativeInstant(String var0, String var1, long var2, String var4);

    private static native void nativeInstantWithProps(String var0, String var1, long var2, Map<String, String> var4);

    private static native void nativeCounter(String var0, String var1, long var2);

    private static native boolean nativeCategoryEnabled(String var0);

    private static native boolean nativeSystemTraceEnabled();

    private static native boolean nativePerfettoTraceEnabled();
}

