/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.xelement.input;

import android.text.Spannable;
import android.view.KeyEvent;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\"B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u001a\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0016J\u001a\u0010!\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/lynx/xelement/input/LynxInputConnectionWrapper;", "Landroid/view/inputmethod/InputConnectionWrapper;", "target", "Landroid/view/inputmethod/InputConnection;", "mutable", "", "(Landroid/view/inputmethod/InputConnection;Z)V", "mBackspaceListener", "Lcom/lynx/xelement/input/LynxInputConnectionWrapper$BackspaceListener;", "mEditTextRelated", "Landroid/widget/EditText;", "bindEditText", "", "editText", "commitText", "text", "", "newCursorPosition", "", "deleteSurroundingText", "beforeLength", "afterLength", "hasComposingText", "Landroid/text/Spannable;", "removeBackspaceListener", "sendKeyEvent", "event", "Landroid/view/KeyEvent;", "setBackspaceListener", "backspaceListener", "setComposingRegion", "start", "end", "setComposingText", "BackspaceListener", "Input_release"})
public final class LynxInputConnectionWrapper
extends InputConnectionWrapper {
    @Nullable
    private BackspaceListener mBackspaceListener;
    @Nullable
    private EditText mEditTextRelated;

    public LynxInputConnectionWrapper(@Nullable InputConnection target, boolean mutable) {
        super(target, mutable);
    }

    public final void bindEditText(@NotNull EditText editText2) {
        Intrinsics.checkNotNullParameter((Object)editText2, (String)"editText");
        this.mEditTextRelated = editText2;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (beforeLength == 1 && afterLength == 0 && this.mBackspaceListener != null) {
            BackspaceListener backspaceListener = this.mBackspaceListener;
            Intrinsics.checkNotNull((Object)backspaceListener);
            if (backspaceListener.onBackspace()) {
                return true;
            }
        }
        return super.deleteSurroundingText(beforeLength, afterLength);
    }

    public boolean commitText(@Nullable CharSequence text, int newCursorPosition) {
        return super.commitText(text, newCursorPosition);
    }

    public boolean setComposingText(@Nullable CharSequence text, int newCursorPosition) {
        return super.setComposingText(text, newCursorPosition);
    }

    public boolean setComposingRegion(int start, int end) {
        return super.setComposingRegion(start, end);
    }

    public final void setBackspaceListener(@Nullable BackspaceListener backspaceListener) {
        this.mBackspaceListener = backspaceListener;
    }

    public final void removeBackspaceListener() {
        this.mBackspaceListener = null;
    }

    public boolean sendKeyEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getKeyCode() == 67 && event.getAction() == 0 && this.mBackspaceListener != null) {
            BackspaceListener backspaceListener = this.mBackspaceListener;
            Intrinsics.checkNotNull((Object)backspaceListener);
            if (backspaceListener.onBackspace()) {
                return true;
            }
        }
        return super.sendKeyEvent(event);
    }

    public final boolean hasComposingText(@NotNull Spannable text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int a = BaseInputConnection.getComposingSpanStart((Spannable)text);
        int b = BaseInputConnection.getComposingSpanEnd((Spannable)text);
        return a != -1 && b != -1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/lynx/xelement/input/LynxInputConnectionWrapper$BackspaceListener;", "", "onBackspace", "", "Input_release"})
    public static interface BackspaceListener {
        public boolean onBackspace();
    }
}

