/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.xelement.input;

import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.widget.EditText;
import com.lynx.tasm.behavior.shadow.text.StaticLayoutCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lcom/lynx/xelement/input/LynxInputUtils;", "", "()V", "getLayoutInEditText", "Landroid/text/Layout;", "charSequence", "", "editText", "Landroid/widget/EditText;", "measuredWidth", "", "measuredHeight", "Input_release"})
public final class LynxInputUtils {
    @NotNull
    public final Layout getLayoutInEditText(@NotNull CharSequence charSequence, @NotNull EditText editText2, int measuredWidth, int measuredHeight) {
        Layout.Alignment textAlign;
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        Intrinsics.checkNotNullParameter((Object)editText2, (String)"editText");
        switch (editText2.getGravity()) {
            case 3: {
                Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 17: {
                Layout.Alignment alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 5: {
                Layout.Alignment alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            default: {
                Layout.Alignment alignment = textAlign = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            TextDirectionHeuristic textDirectionHeuristic;
            switch (editText2.getTextDirection()) {
                case 3: {
                    textDirectionHeuristic = TextDirectionHeuristics.LTR;
                    break;
                }
                case 4: {
                    textDirectionHeuristic = TextDirectionHeuristics.RTL;
                    break;
                }
                case 5: {
                    textDirectionHeuristic = TextDirectionHeuristics.LOCALE;
                    break;
                }
                default: {
                    textDirectionHeuristic = TextDirectionHeuristics.LTR;
                }
            }
            TextDirectionHeuristic textDirectionHeuristics = textDirectionHeuristic;
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)charSequence, (int)0, (int)charSequence.length(), (TextPaint)editText2.getPaint(), (int)measuredWidth).setAlignment(textAlign).setTextDirection(textDirectionHeuristics).setLineSpacing(editText2.getLineSpacingExtra(), editText2.getLineSpacingMultiplier()).setIncludePad(editText2.getIncludeFontPadding());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"obtain(\n                \u2026tText.includeFontPadding)");
            StaticLayout.Builder builder2 = builder;
            if (Build.VERSION.SDK_INT >= 28) {
                builder2.setUseLineSpacingFromFallbacks(true);
            }
            StaticLayout staticLayout = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)staticLayout, (String)"builder.build()");
            return (Layout)staticLayout;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            TextDirectionHeuristic textDirectionHeuristic;
            switch (editText2.getTextDirection()) {
                case 3: {
                    TextDirectionHeuristic textDirectionHeuristic2 = TextDirectionHeuristics.LTR;
                    textDirectionHeuristic = textDirectionHeuristic2;
                    Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic2, (String)"LTR");
                    break;
                }
                case 4: {
                    TextDirectionHeuristic textDirectionHeuristic3 = TextDirectionHeuristics.RTL;
                    textDirectionHeuristic = textDirectionHeuristic3;
                    Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic3, (String)"RTL");
                    break;
                }
                case 5: {
                    TextDirectionHeuristic textDirectionHeuristic4 = TextDirectionHeuristics.LOCALE;
                    textDirectionHeuristic = textDirectionHeuristic4;
                    Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic4, (String)"LOCALE");
                    break;
                }
                default: {
                    TextDirectionHeuristic textDirectionHeuristic5 = TextDirectionHeuristics.LTR;
                    textDirectionHeuristic = textDirectionHeuristic5;
                    Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic5, (String)"LTR");
                }
            }
            TextDirectionHeuristic textDirectionHeuristics = textDirectionHeuristic;
            StaticLayout staticLayout = StaticLayoutCompat.get((CharSequence)charSequence, (int)0, (int)charSequence.length(), (TextPaint)editText2.getPaint(), (int)measuredWidth, (Layout.Alignment)textAlign, (float)editText2.getLineSpacingMultiplier(), (float)editText2.getLineSpacingExtra(), (boolean)editText2.getIncludeFontPadding(), (TextUtils.TruncateAt)TextUtils.TruncateAt.END, (int)-1, (TextDirectionHeuristic)textDirectionHeuristics);
            Intrinsics.checkNotNullExpressionValue((Object)staticLayout, (String)"get(\n                cha\u2026nHeuristics\n            )");
            return (Layout)staticLayout;
        }
        return (Layout)new StaticLayout(charSequence, 0, charSequence.length(), editText2.getPaint(), measuredWidth, textAlign, editText2.getLineSpacingMultiplier(), editText2.getLineSpacingExtra(), editText2.getIncludeFontPadding(), TextUtils.TruncateAt.END, measuredWidth);
    }
}

