/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.xelement.input;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.text.style.AbsoluteSizeSpan;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.lynx.react.bridge.Callback;
import com.lynx.react.bridge.Dynamic;
import com.lynx.react.bridge.JavaOnlyMap;
import com.lynx.react.bridge.ReadableMap;
import com.lynx.react.bridge.ReadableType;
import com.lynx.tasm.EventEmitter;
import com.lynx.tasm.behavior.LynxContext;
import com.lynx.tasm.behavior.LynxProp;
import com.lynx.tasm.behavior.LynxUIMethod;
import com.lynx.tasm.behavior.StylesDiffMap;
import com.lynx.tasm.behavior.TouchEventDispatcher;
import com.lynx.tasm.behavior.shadow.ShadowNode;
import com.lynx.tasm.behavior.shadow.text.FontFamilySpan;
import com.lynx.tasm.behavior.shadow.text.TypefaceCache;
import com.lynx.tasm.behavior.ui.LynxBaseUI;
import com.lynx.tasm.behavior.ui.LynxUI;
import com.lynx.tasm.event.LynxCustomEvent;
import com.lynx.tasm.event.LynxDetailEvent;
import com.lynx.tasm.fontface.FontFaceManager;
import com.lynx.tasm.utils.ColorUtils;
import com.lynx.tasm.utils.ContextUtils;
import com.lynx.tasm.utils.PixelUtils;
import com.lynx.tasm.utils.UnitUtils;
import com.lynx.xelement.input.LynxEditText;
import com.lynx.xelement.input.LynxEditTextView;
import com.lynx.xelement.input.LynxInputConnectionWrapper;
import com.lynx.xelement.input.LynxInputUtils;
import com.lynx.xelement.input.LynxUIBaseInput;
import com.lynx.xelement.input.LynxUIBaseInputShadowNode;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b+\b\u0016\u0018\u0000 r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001rB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u001c\u0010-\u001a\u00020'2\b\u0010\u0006\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0007J\u0012\u00101\u001a\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u000102H\u0014J\u0010\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0012H\u0016J\u001c\u00105\u001a\u00020'2\b\u0010\u0006\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0007J\u001c\u00106\u001a\u00020'2\b\u0010\u0006\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0007J\b\u00107\u001a\u00020'H\u0003J\b\u00108\u001a\u00020\u001fH\u0016J\b\u00109\u001a\u00020\u001fH\u0016J\b\u0010:\u001a\u00020'H\u0004J\u0018\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001fH\u0016J\b\u0010>\u001a\u00020'H\u0016J\b\u0010?\u001a\u00020'H\u0016J\u0012\u0010@\u001a\u00020'2\b\u0010A\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010B\u001a\u00020'2\b\u0010C\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020\u001fH\u0007J\b\u0010F\u001a\u00020'H\u0014J\u0010\u0010G\u001a\u00020'2\u0006\u0010C\u001a\u00020HH\u0007J\u0012\u0010I\u001a\u00020'2\b\u0010J\u001a\u0004\u0018\u00010\u0010H\u0017J\u0010\u0010K\u001a\u00020'2\u0006\u0010L\u001a\u00020\u0012H\u0017J\u0017\u0010M\u001a\u00020'2\b\u0010N\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010OJ\u0012\u0010P\u001a\u00020'2\b\u0010A\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010Q\u001a\u00020'2\b\u0010A\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010R\u001a\u00020'2\u0006\u0010S\u001a\u00020\u001fH\u0007J\u0010\u0010T\u001a\u00020'2\u0006\u0010U\u001a\u00020\u001fH\u0007J\u0010\u0010V\u001a\u00020'2\u0006\u0010A\u001a\u00020\u0016H\u0007J\u0010\u0010W\u001a\u00020'2\u0006\u0010X\u001a\u00020\u0016H\u0007J\u0010\u0010Y\u001a\u00020'2\u0006\u0010Z\u001a\u00020HH\u0017J\u0010\u0010[\u001a\u00020'2\u0006\u0010\\\u001a\u00020\u0012H\u0017J\u0012\u0010]\u001a\u00020'2\b\u0010^\u001a\u0004\u0018\u00010HH\u0007J\u0012\u0010_\u001a\u00020'2\b\u0010A\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010`\u001a\u00020'2\u0006\u0010C\u001a\u00020HH\u0007J\b\u0010a\u001a\u00020'H\u0014J\u0012\u0010b\u001a\u00020'2\b\u0010c\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010d\u001a\u00020'2\u0006\u0010L\u001a\u00020\u0012H\u0007J\u0010\u0010e\u001a\u00020'2\u0006\u0010f\u001a\u00020\u0016H\u0007J\u0012\u0010g\u001a\u00020'2\b\u0010h\u001a\u0004\u0018\u00010HH\u0007J\u001c\u0010i\u001a\u00020'2\b\u0010\u0006\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0007J\u0010\u0010j\u001a\u00020'2\u0006\u0010k\u001a\u00020\u001fH\u0007J\u0010\u0010l\u001a\u00020'2\u0006\u0010A\u001a\u00020\u0010H\u0007J\u0010\u0010m\u001a\u00020'2\u0006\u00104\u001a\u00020\u0012H\u0007J\u001c\u0010n\u001a\u00020'2\b\u0010\u0006\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0007J\b\u0010o\u001a\u00020\u001fH\u0003J\u0010\u0010p\u001a\u00020'2\u0006\u0010q\u001a\u00020\u0012H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006s"}, d2={"Lcom/lynx/xelement/input/LynxUIBaseInput;", "Lcom/lynx/tasm/behavior/ui/LynxUI;", "Lcom/lynx/xelement/input/LynxEditTextView;", "context", "Lcom/lynx/tasm/behavior/LynxContext;", "(Lcom/lynx/tasm/behavior/LynxContext;)V", "params", "", "(Lcom/lynx/tasm/behavior/LynxContext;Ljava/lang/Object;)V", "inputValueRegexFilter", "Landroid/text/InputFilter;", "getInputValueRegexFilter", "()Landroid/text/InputFilter;", "setInputValueRegexFilter", "(Landroid/text/InputFilter;)V", "mFontFamilyName", "", "mFontStyle", "", "mFontWeight", "mInputFilterRegex", "mLineSpacing", "", "mPlaceholder", "mPlaceholderFontColor", "mPlaceholderFontFamilyName", "mPlaceholderFontSize", "mPlaceholderFontStyle", "mPlaceholderFontWeight", "mSoftInputModeStateStash", "mUseCustomKeyboard", "", "maxLengthInputFilter", "Landroid/text/InputFilter$LengthFilter;", "getMaxLengthInputFilter", "()Landroid/text/InputFilter$LengthFilter;", "setMaxLengthInputFilter", "(Landroid/text/InputFilter$LengthFilter;)V", "afterPropsUpdated", "", "props", "Lcom/lynx/tasm/behavior/StylesDiffMap;", "afterTextDidChanged", "s", "Landroid/text/Editable;", "blur", "Lcom/lynx/react/bridge/ReadableMap;", "callback", "Lcom/lynx/react/bridge/Callback;", "createView", "Landroid/content/Context;", "customTextAlignSetting", "align", "focus", "getValue", "hideSoftInput", "isFocusable", "isTextArea", "onConfirm", "onFocusChanged", "hasFocus", "isFocusTransition", "onLayoutUpdated", "onNodeReady", "setConfirmType", "value", "setCursorColor", "color", "setDisable", "disabled", "setFont", "setFontColor", "Lcom/lynx/react/bridge/Dynamic;", "setFontFamily", "fontFamily", "setFontStyle", "fontStyle", "setFontWeight", "fontWeightNumerical", "(Ljava/lang/Integer;)V", "setInputFilter", "setInputType", "setIsReadOnly", "isReadOnly", "setKeyBoardFullscreenMode", "isFullscreenMode", "setLetterSpacing", "setLineHeight", "lineHeight", "setLineSpacing", "lineSpacing", "setLynxDirection", "direction", "setMaxLength", "maxLength", "setPlaceholder", "setPlaceholderColor", "setPlaceholderFont", "setPlaceholderFontFamily", "fontFamilyName", "setPlaceholderFontStyle", "setPlaceholderTextSize", "size", "setPlaceholderTextWeight", "weight", "setSelectionRange", "setShowSoftInputOnFocus", "isShowSoftInputOnFocus", "setSoftInputMode", "setTextAlign", "setValue", "showSoftInput", "triggerUpdateLayout", "updatedHeight", "Companion", "Input_release"})
public class LynxUIBaseInput
extends LynxUI<LynxEditTextView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mFontWeight;
    private int mPlaceholderFontWeight;
    private float mLineSpacing;
    private int mFontStyle;
    private int mPlaceholderFontStyle;
    @Nullable
    private String mFontFamilyName;
    @Nullable
    private String mPlaceholderFontFamilyName;
    @Nullable
    private String mPlaceholder;
    private float mPlaceholderFontSize;
    private int mPlaceholderFontColor;
    @Nullable
    private String mInputFilterRegex;
    @NotNull
    private InputFilter.LengthFilter maxLengthInputFilter;
    @NotNull
    private InputFilter inputValueRegexFilter;
    private int mSoftInputModeStateStash;
    private boolean mUseCustomKeyboard;
    public static final int UNDEFINED_INT = Integer.MIN_VALUE;
    public static final float UNDEFINED_FLOAT = Float.MIN_VALUE;
    @NotNull
    public static final String TYPE_NUMBER = "number";
    @NotNull
    public static final String TYPE_TEXT = "text";
    @NotNull
    public static final String TYPE_DIGIT = "digit";
    @NotNull
    public static final String TYPE_PASSWORD = "password";
    @NotNull
    public static final String TYPE_TEL = "tel";
    @NotNull
    public static final String TYPE_EMAIL = "email";

    public LynxUIBaseInput(@NotNull LynxContext context, @Nullable Object params) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, params);
        this.mFontWeight = 400;
        this.mPlaceholderFontWeight = Integer.MIN_VALUE;
        this.mLineSpacing = -1.0f;
        this.mPlaceholderFontStyle = Integer.MIN_VALUE;
        this.mPlaceholderFontSize = Float.MIN_VALUE;
        this.mPlaceholderFontColor = ColorUtils.parse((String)"#3c433c4c");
        this.maxLengthInputFilter = new InputFilter.LengthFilter(Integer.MAX_VALUE);
        this.inputValueRegexFilter = new InputFilter(this){
            final /* synthetic */ LynxUIBaseInput this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public CharSequence filter(@NotNull CharSequence source, int start, int end, @NotNull Spanned dest, int dstart, int dend) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                String string = LynxUIBaseInput.access$getMInputFilterRegex$p(this.this$0);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    StringBuilder builder = new StringBuilder("");
                    for (int i = 0; i < source.length(); ++i) {
                        char c = source.charAt(i);
                        CharSequence charSequence = String.valueOf(c);
                        if (!new Regex(it).matches(charSequence)) continue;
                        builder.append(c);
                    }
                    String string2 = builder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
                    return string2;
                }
                inputValueRegexFilter.1 $this$filter_u24lambda_u2d1 = this;
                boolean bl = false;
                return source;
            }
        };
    }

    public LynxUIBaseInput(@NotNull LynxContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    @NotNull
    public final InputFilter.LengthFilter getMaxLengthInputFilter() {
        return this.maxLengthInputFilter;
    }

    public final void setMaxLengthInputFilter(@NotNull InputFilter.LengthFilter lengthFilter) {
        Intrinsics.checkNotNullParameter((Object)lengthFilter, (String)"<set-?>");
        this.maxLengthInputFilter = lengthFilter;
    }

    @NotNull
    public final InputFilter getInputValueRegexFilter() {
        return this.inputValueRegexFilter;
    }

    public final void setInputValueRegexFilter(@NotNull InputFilter inputFilter) {
        Intrinsics.checkNotNullParameter((Object)inputFilter, (String)"<set-?>");
        this.inputValueRegexFilter = inputFilter;
    }

    public void afterTextDidChanged(@Nullable Editable s) {
    }

    @NotNull
    protected LynxEditTextView createView(@Nullable Context context) {
        LynxEditTextView lynxEditTextView;
        LynxContext lynxContext = this.mContext;
        this.mFontSize = UnitUtils.toPxWithDisplayMetrics((String)"14px", (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (DisplayMetrics)(lynxContext != null ? lynxContext.getScreenMetrics() : null));
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        LynxEditTextView $this$createView_u24lambda_u2d2 = lynxEditTextView = new LynxEditTextView(context2);
        boolean bl = false;
        $this$createView_u24lambda_u2d2.setOnFocusChangeListener((arg_0, arg_1) -> LynxUIBaseInput.createView$lambda-2$lambda-1(this, $this$createView_u24lambda_u2d2, arg_0, arg_1));
        $this$createView_u24lambda_u2d2.setOnAttachedToWindowListener(new LynxEditText.OnAttachedListener(this){
            final /* synthetic */ LynxUIBaseInput this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAttachedToWindow(int inputMode) {
                block2: {
                    for (LynxBaseUI parent = this.this$0.getParentBaseUI(); parent != null; parent = parent.getParentBaseUI()) {
                        if (!Intrinsics.areEqual((Object)parent.getTagName(), (Object)"x-overlay-ng")) continue;
                        Window window = parent.getWindow();
                        if (window != null) {
                            window.setSoftInputMode(inputMode);
                        }
                        return;
                    }
                    Window window = this.this$0.getWindow();
                    if (window == null) break block2;
                    window.setSoftInputMode(inputMode);
                }
            }
        });
        $this$createView_u24lambda_u2d2.setBackground(null);
        $this$createView_u24lambda_u2d2.setImeOptions(1);
        $this$createView_u24lambda_u2d2.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ LynxUIBaseInput this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            }

            /*
             * WARNING - void declaration
             */
            public void afterTextChanged(@Nullable Editable s) {
                block3: {
                    this.this$0.afterTextDidChanged(s);
                    if (LynxUIBaseInput.access$getMView$p$s-1453334866(this.this$0) == null) break block3;
                    Editable editable = s;
                    if (editable != null) {
                        void $this$afterTextChanged_u24lambda_u2d1_u24lambda_u2d0;
                        LynxDetailEvent lynxDetailEvent;
                        Editable editable2 = editable;
                        LynxUIBaseInput lynxUIBaseInput = this.this$0;
                        Editable it = editable2;
                        boolean bl = false;
                        LynxDetailEvent lynxDetailEvent2 = lynxDetailEvent = new LynxDetailEvent(lynxUIBaseInput.getSign(), "input");
                        EventEmitter eventEmitter = lynxUIBaseInput.getLynxContext().getEventEmitter();
                        boolean bl2 = false;
                        $this$afterTextChanged_u24lambda_u2d1_u24lambda_u2d0.addDetail("value", (Object)it.toString());
                        int selectionStart = -1;
                        if (((LynxEditTextView)LynxUIBaseInput.access$getMView$p$s-1453334866(lynxUIBaseInput)).isFocused()) {
                            selectionStart = ((LynxEditTextView)LynxUIBaseInput.access$getMView$p$s-1453334866(lynxUIBaseInput)).getSelectionStart();
                        }
                        int selectionEnd = -1;
                        if (((LynxEditTextView)LynxUIBaseInput.access$getMView$p$s-1453334866(lynxUIBaseInput)).isFocused()) {
                            selectionEnd = ((LynxEditTextView)LynxUIBaseInput.access$getMView$p$s-1453334866(lynxUIBaseInput)).getSelectionEnd();
                        }
                        $this$afterTextChanged_u24lambda_u2d1_u24lambda_u2d0.addDetail("selectionStart", (Object)selectionStart);
                        $this$afterTextChanged_u24lambda_u2d1_u24lambda_u2d0.addDetail("selectionEnd", (Object)selectionEnd);
                        Object object = (LynxEditTextView)LynxUIBaseInput.access$getMView$p$s-1453334866(lynxUIBaseInput);
                        $this$afterTextChanged_u24lambda_u2d1_u24lambda_u2d0.addDetail("isComposing", object != null && (object = object.inputConnection()) != null ? Boolean.valueOf(((LynxInputConnectionWrapper)((Object)object)).hasComposingText((Spannable)it)) : null);
                        eventEmitter.sendCustomEvent((LynxCustomEvent)lynxDetailEvent);
                    }
                }
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
            }
        });
        $this$createView_u24lambda_u2d2.setOnSelectionChangeListener(new LynxEditTextView.OnSelectionChangeListener(this){
            final /* synthetic */ LynxUIBaseInput this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onSelectionChange(int selStart, int selEnd) {
                void $this$onSelectionChange_u24lambda_u2d0;
                LynxDetailEvent lynxDetailEvent;
                LynxDetailEvent lynxDetailEvent2 = lynxDetailEvent = new LynxDetailEvent(this.this$0.getSign(), "selection");
                EventEmitter eventEmitter = this.this$0.getLynxContext().getEventEmitter();
                boolean bl = false;
                $this$onSelectionChange_u24lambda_u2d0.addDetail("selectionStart", (Object)selStart);
                $this$onSelectionChange_u24lambda_u2d0.addDetail("selectionEnd", (Object)selEnd);
                eventEmitter.sendCustomEvent((LynxCustomEvent)lynxDetailEvent);
            }
        });
        LynxEditTextView editText2 = lynxEditTextView;
        editText2.setHint("");
        return editText2;
    }

    @LynxProp(name="placeholder")
    public final void setPlaceholder(@Nullable String value) {
        this.mPlaceholder = value;
    }

    @LynxProp(name="placeholder-font-size", defaultFloat=1.4E-45f)
    public final void setPlaceholderTextSize(float size) {
        this.mPlaceholderFontSize = size;
    }

    @LynxProp(name="font-weight", defaultInt=0)
    public final void setFontWeight(@Nullable Integer fontWeightNumerical) {
        block4: {
            int n;
            Integer n2 = fontWeightNumerical;
            if (n2 == null) break block4;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            switch (it) {
                case 1: {
                    n = 700;
                    break;
                }
                case 0: {
                    n = 400;
                    break;
                }
                default: {
                    n = (it - 1) * 100;
                }
            }
            this.mFontWeight = n;
        }
    }

    @LynxProp(name="placeholder-font-weight")
    public final void setPlaceholderTextWeight(@Nullable Dynamic weight) {
        if (weight == null) {
            this.mPlaceholderFontWeight = Integer.MIN_VALUE;
        } else {
            ReadableType readableType = weight.getType();
            switch (readableType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[readableType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    int fontWeight;
                    int n;
                    switch (weight.asInt()) {
                        case 1: {
                            n = 700;
                            break;
                        }
                        case 0: {
                            n = 400;
                            break;
                        }
                        default: {
                            n = (weight.asInt() - 1) * 100;
                        }
                    }
                    this.mPlaceholderFontWeight = fontWeight = n;
                    break;
                }
                case 4: {
                    this.mPlaceholderFontWeight = weight.asString().equals("bold") ? 700 : (weight.asString().equals("normal") ? 400 : Integer.MIN_VALUE);
                    break;
                }
                default: {
                    this.mPlaceholderFontWeight = Integer.MIN_VALUE;
                }
            }
        }
    }

    @LynxProp(name="font-style", defaultInt=0)
    public void setFontStyle(int fontStyle) {
        int n;
        switch (fontStyle) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.mFontStyle = n;
    }

    @LynxProp(name="placeholder-font-style")
    public final void setPlaceholderFontStyle(int fontStyle) {
        int n;
        switch (fontStyle) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = Integer.MIN_VALUE;
            }
        }
        this.mPlaceholderFontStyle = n;
    }

    @LynxProp(name="font-family")
    public void setFontFamily(@Nullable String fontFamily) {
        block0: {
            String string = fontFamily;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.mFontFamilyName = it;
        }
    }

    @LynxProp(name="placeholder-font-family")
    public final void setPlaceholderFontFamily(@Nullable String fontFamilyName) {
        this.mPlaceholderFontFamilyName = fontFamilyName;
    }

    @LynxProp(name="color", defaultInt=-16777216)
    public final void setFontColor(@NotNull Dynamic color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ReadableType readableType = color.getType();
        switch (readableType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[readableType.ordinal()]) {
            case 1: 
            case 2: {
                ((LynxEditTextView)this.mView).setTextColor(color.asInt());
                break;
            }
            case 4: {
                ((LynxEditTextView)this.mView).setTextColor(ColorUtils.parse((String)color.asString()));
            }
        }
    }

    @LynxProp(name="placeholder-color")
    public final void setPlaceholderColor(@NotNull Dynamic color) {
        int n;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ReadableType readableType = color.getType();
        switch (readableType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[readableType.ordinal()]) {
            case 1: 
            case 2: {
                n = color.asInt();
                break;
            }
            case 4: {
                n = ColorUtils.parse((String)color.asString());
                break;
            }
            default: {
                n = ColorUtils.parse((String)"#3c433c");
            }
        }
        this.mPlaceholderFontColor = n;
    }

    @LynxProp(name="caret-color")
    public final void setCursorColor(@Nullable String color) {
        block2: {
            String string = color;
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 29) {
                Drawable drawable = ((LynxEditTextView)this.mView).getTextCursorDrawable();
                if (drawable != null) {
                    Drawable drawable2 = drawable;
                    boolean bl2 = false;
                    drawable2.setTint(ColorUtils.parse((String)color));
                    ((LynxEditTextView)this.mView).setTextCursorDrawable(drawable2);
                }
            }
        }
    }

    @LynxProp(name="line-height", defaultFloat=0.0f)
    public final void setLineHeight(float lineHeight) {
    }

    @LynxProp(name="line-spacing")
    public void setLineSpacing(@NotNull Dynamic lineSpacing) {
        Intrinsics.checkNotNullParameter((Object)lineSpacing, (String)"lineSpacing");
        if (lineSpacing.getType() == ReadableType.String) {
            this.mLineSpacing = UnitUtils.toPxWithDisplayMetrics((String)lineSpacing.asString(), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0f, (DisplayMetrics)this.getLynxContext().getScreenMetrics());
        } else if (lineSpacing.getType() == ReadableType.Number || lineSpacing.getType() == ReadableType.Int) {
            this.mLineSpacing = PixelUtils.dipToPx((double)lineSpacing.asDouble());
        }
    }

    @LynxProp(name="letter-spacing", defaultFloat=0.0f)
    public final void setLetterSpacing(float value) {
        if (Build.VERSION.SDK_INT >= 21 && !(((LynxEditTextView)this.mView).getTextSize() == 0.0f)) {
            ((LynxEditTextView)this.mView).setLetterSpacing(value / ((LynxEditTextView)this.mView).getTextSize());
        }
    }

    @LynxProp(name="text-align", defaultInt=0)
    public final void setTextAlign(int align) {
        int customSetting = this.customTextAlignSetting(align);
        switch (align) {
            case 0: {
                ((LynxEditTextView)this.mView).setGravity(3 | customSetting);
                break;
            }
            case 2: {
                ((LynxEditTextView)this.mView).setGravity(5 | customSetting);
                break;
            }
            case 1: {
                ((LynxEditTextView)this.mView).setGravity(1 | customSetting);
            }
        }
    }

    @LynxProp(name="direction", defaultInt=3)
    public void setLynxDirection(int direction) {
        this.mLynxDirection = direction;
        if (Build.VERSION.SDK_INT >= 17) {
            switch (this.mLynxDirection) {
                case 0: {
                    ((LynxEditTextView)this.mView).setTextDirection(5);
                    break;
                }
                case 3: {
                    ((LynxEditTextView)this.mView).setTextDirection(3);
                    break;
                }
                case 2: {
                    ((LynxEditTextView)this.mView).setTextDirection(4);
                }
            }
        }
    }

    @LynxProp(name="confirm-type")
    public final void setConfirmType(@Nullable String value) {
        String string;
        if (this.isTextArea()) {
            ((LynxEditTextView)this.mView).setSingleLine(false);
            ((LynxEditTextView)this.mView).setInputType(1);
            ((LynxEditTextView)this.mView).setHorizontallyScrolling(false);
            ((LynxEditTextView)this.mView).setMaxLines(((LynxEditTextView)this.mView).getMaxLines());
        }
        if ((string = value) == null) {
            string = "done";
        }
        switch (string) {
            case "next": {
                ((LynxEditTextView)this.mView).setImeOptions(5);
                break;
            }
            case "search": {
                ((LynxEditTextView)this.mView).setImeOptions(3);
                break;
            }
            case "send": {
                ((LynxEditTextView)this.mView).setImeOptions(4);
                break;
            }
            case "done": {
                ((LynxEditTextView)this.mView).setImeOptions(6);
                break;
            }
            case "go": {
                ((LynxEditTextView)this.mView).setImeOptions(2);
            }
        }
    }

    @LynxProp(name="type")
    public final void setInputType(@Nullable String value) {
        int imeOptions = ((LynxEditTextView)this.mView).getImeOptions();
        String string = value;
        if (string == null) {
            string = TYPE_TEXT;
        }
        switch (string) {
            case "number": {
                ((LynxEditTextView)this.mView).setInputType(2);
                break;
            }
            case "text": {
                ((LynxEditTextView)this.mView).setInputType(1);
                break;
            }
            case "password": {
                ((LynxEditTextView)this.mView).setInputType(128);
                break;
            }
            case "digit": {
                ((LynxEditTextView)this.mView).setInputType(8194);
                break;
            }
            case "tel": {
                ((LynxEditTextView)this.mView).setInputType(3);
                break;
            }
            case "email": {
                ((LynxEditTextView)this.mView).setInputType(32);
            }
        }
        int selectionStart = ((LynxEditTextView)this.mView).getSelectionStart();
        if (!Intrinsics.areEqual((Object)value, (Object)TYPE_PASSWORD)) {
            ((LynxEditTextView)this.mView).setTransformationMethod((TransformationMethod)SingleLineTransformationMethod.getInstance());
        } else {
            ((LynxEditTextView)this.mView).setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
        ((LynxEditTextView)this.mView).setSelection(selectionStart);
        ((LynxEditTextView)this.mView).setInputType(((LynxEditTextView)this.mView).getInputType() | 0x80000);
        if (this.isTextArea()) {
            ((LynxEditTextView)this.mView).setSingleLine(false);
            ((LynxEditTextView)this.mView).setImeOptions(imeOptions);
        }
    }

    @LynxProp(name="maxlength")
    public final void setMaxLength(@Nullable Dynamic maxLength) {
        Dynamic dynamic = maxLength;
        Object object = dynamic != null ? dynamic.getType() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 4: {
                String string = maxLength.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"maxLength.asString()");
                this.maxLengthInputFilter = new InputFilter.LengthFilter(Integer.parseInt(string));
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.maxLengthInputFilter = new InputFilter.LengthFilter(maxLength.asInt());
            }
        }
    }

    @LynxProp(name="input-filter")
    public final void setInputFilter(@Nullable String value) {
        this.mInputFilterRegex = value;
    }

    @LynxProp(name="disabled", defaultBoolean=false)
    public final void setDisable(boolean disabled) {
        ((LynxEditTextView)this.mView).setEnabled(!disabled);
        ((LynxEditTextView)this.mView).setFocusable(!disabled);
        ((LynxEditTextView)this.mView).setFocusableInTouchMode(!disabled);
        this.userInteractionEnabled = !disabled;
    }

    @LynxProp(name="readonly", defaultBoolean=false)
    public final void setIsReadOnly(boolean isReadOnly) {
        ((LynxEditTextView)this.mView).setFocusable(!isReadOnly);
        ((LynxEditTextView)this.mView).setFocusableInTouchMode(!isReadOnly);
        this.userInteractionEnabled = !isReadOnly;
    }

    @LynxProp(name="show-soft-input-on-focus", defaultBoolean=true)
    public final void setShowSoftInputOnFocus(boolean isShowSoftInputOnFocus) {
        Activity context;
        if (Build.VERSION.SDK_INT >= 21 && (context = ContextUtils.getActivity((Context)((Context)this.getLynxContext()))) != null) {
            if (!isShowSoftInputOnFocus) {
                this.mUseCustomKeyboard = true;
                this.mSoftInputModeStateStash = context.getWindow().getAttributes().softInputMode & 0xF;
                int currentSoftInputModeExpectState = context.getWindow().getAttributes().softInputMode ^ 0xF;
                int newSoftInputMode = currentSoftInputModeExpectState | 3;
                context.getWindow().setSoftInputMode(newSoftInputMode);
                ((LynxEditTextView)this.mView).setShowSoftInputOnFocus(false);
            } else {
                this.mUseCustomKeyboard = false;
                int currentSoftInputModeExpectState = context.getWindow().getAttributes().softInputMode ^ 0xF;
                int newSoftInputMode = currentSoftInputModeExpectState | this.mSoftInputModeStateStash;
                context.getWindow().setSoftInputMode(newSoftInputMode);
                ((LynxEditTextView)this.mView).setShowSoftInputOnFocus(true);
            }
        }
    }

    @LynxProp(name="android-fullscreen-mode", defaultBoolean=true)
    public final void setKeyBoardFullscreenMode(boolean isFullscreenMode) {
        if (!isFullscreenMode) {
            ((LynxEditTextView)this.mView).setImeOptions(((LynxEditTextView)this.mView).getImeOptions() | 0x2000000 | 0x10000000);
        } else {
            ((LynxEditTextView)this.mView).setImeOptions(((LynxEditTextView)this.mView).getImeOptions() & 0xFDFFFFFF & 0xEFFFFFFF);
        }
    }

    @LynxProp(name="android-set-soft-input-mode")
    public final void setSoftInputMode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int inputMode = 0;
        if (Intrinsics.areEqual((Object)"unspecified", (Object)value)) {
            inputMode = 0;
        } else if (Intrinsics.areEqual((Object)"nothing", (Object)value)) {
            inputMode = 48;
        } else if (Intrinsics.areEqual((Object)"pan", (Object)value)) {
            inputMode = 32;
        } else if (Intrinsics.areEqual((Object)"resize", (Object)value)) {
            inputMode = 16;
        }
        ((LynxEditTextView)this.mView).updateInputMode(inputMode);
    }

    public void afterPropsUpdated(@Nullable StylesDiffMap props) {
        super.afterPropsUpdated(props);
        this.setFont();
        this.setPlaceholderFont();
        if (Build.VERSION.SDK_INT >= 28 && !((Object)Float.valueOf(this.mLineSpacing)).equals(Float.valueOf(-1.0f))) {
            int fontHeight = ((LynxEditTextView)this.mView).getPaint().getFontMetricsInt(null);
            int lineHeight = Math.max(fontHeight, fontHeight + (int)this.mLineSpacing);
            ((LynxEditTextView)this.mView).setLineHeight(lineHeight);
        }
    }

    public void onLayoutUpdated() {
        super.onLayoutUpdated();
        ((LynxEditTextView)this.mView).setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
    }

    protected void setFont() {
        Typeface typeface = null;
        if (this.mFontFamilyName != null) {
            typeface = TypefaceCache.getTypeface((LynxContext)this.getLynxContext(), (String)this.mFontFamilyName, (int)this.mFontStyle);
        }
        if (typeface == null) {
            FontFaceManager fontFaceManager = FontFaceManager.getInstance();
            LynxContext lynxContext = this.getLynxContext();
            String string = this.mFontFamilyName;
            if (string == null) {
                string = "";
            }
            typeface = fontFaceManager.getTypeface(lynxContext, string, this.mFontStyle, null);
        }
        if (typeface == null) {
            typeface = Typeface.create((Typeface)((LynxEditTextView)this.mView).getTypeface(), (int)this.mFontStyle);
        }
        if (Build.VERSION.SDK_INT >= 29 && typeface != null && typeface.getWeight() != this.mFontWeight) {
            typeface = Typeface.create((Typeface)typeface, (int)this.mFontWeight, (this.mFontStyle == 2 ? 1 : 0) != 0);
        }
        ((LynxEditTextView)this.mView).setTypeface(typeface);
        ((LynxEditTextView)this.mView).setTextSize(0, this.mFontSize);
    }

    protected void setPlaceholderFont() {
        if (this.mPlaceholder == null) {
            ((LynxEditTextView)this.mView).setHint("");
        } else {
            float placeholderFontSize;
            String placeholderFontFamilyName;
            int placeholderFontStyle;
            int placeholderFontWeight = this.mPlaceholderFontWeight;
            if (placeholderFontWeight == Integer.MIN_VALUE) {
                placeholderFontWeight = this.mFontWeight;
            }
            if ((placeholderFontStyle = this.mPlaceholderFontStyle) == Integer.MIN_VALUE) {
                placeholderFontStyle = this.mFontStyle;
            }
            if ((placeholderFontFamilyName = this.mPlaceholderFontFamilyName) == null) {
                placeholderFontFamilyName = this.mFontFamilyName;
            }
            if ((placeholderFontSize = this.mPlaceholderFontSize) == Float.MIN_VALUE) {
                placeholderFontSize = this.mFontSize;
            }
            Typeface typeface = null;
            if (placeholderFontFamilyName != null) {
                typeface = TypefaceCache.getTypeface((LynxContext)this.getLynxContext(), (String)placeholderFontFamilyName, (int)placeholderFontStyle);
            }
            if (typeface == null) {
                FontFaceManager fontFaceManager = FontFaceManager.getInstance();
                LynxContext lynxContext = this.getLynxContext();
                String string = placeholderFontFamilyName;
                if (string == null) {
                    string = "";
                }
                typeface = fontFaceManager.getTypeface(lynxContext, string, placeholderFontStyle, null);
            }
            if (typeface == null) {
                typeface = Typeface.create((Typeface)((LynxEditTextView)this.mView).getTypeface(), (int)placeholderFontStyle);
            }
            if (Build.VERSION.SDK_INT >= 29 && typeface != null && typeface.getWeight() != placeholderFontWeight) {
                typeface = Typeface.create((Typeface)typeface, (int)placeholderFontWeight, (placeholderFontStyle == 2 ? 1 : 0) != 0);
            }
            SpannableString placeholderSpan = new SpannableString((CharSequence)this.mPlaceholder);
            int length = placeholderSpan.length();
            placeholderSpan.setSpan((Object)new AbsoluteSizeSpan((int)placeholderFontSize, false), 0, length, 33);
            if (typeface != null) {
                placeholderSpan.setSpan((Object)new FontFamilySpan(typeface), 0, length, 33);
            }
            ((LynxEditTextView)this.mView).setHint((CharSequence)placeholderSpan);
            ((LynxEditTextView)this.mView).setHintTextColor(this.mPlaceholderFontColor);
        }
    }

    public void onNodeReady() {
        super.onNodeReady();
        LynxInputUtils lynxInputUtils = new LynxInputUtils();
        CharSequence charSequence = String.valueOf(((LynxEditTextView)this.mView).getText());
        View view = this.mView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"mView");
        Layout textLayout = lynxInputUtils.getLayoutInEditText(charSequence, (EditText)view, this.getWidth(), Integer.MAX_VALUE);
        this.triggerUpdateLayout(textLayout.getHeight());
    }

    public void triggerUpdateLayout(int updatedHeight) {
        block1: {
            LynxInputUtils lynxInputUtils = new LynxInputUtils();
            CharSequence charSequence = ((LynxEditTextView)this.mView).getHint();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"mView.hint");
            View view = this.mView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"mView");
            Layout placeholderTextLayout = lynxInputUtils.getLayoutInEditText(charSequence, (EditText)view, this.getWidth(), Integer.MAX_VALUE);
            ShadowNode shadowNode = this.getLynxContext().findShadowNodeBySign(this.getSign());
            if (shadowNode == null) break block1;
            ShadowNode it = shadowNode;
            boolean bl = false;
            if (it instanceof LynxUIBaseInputShadowNode) {
                ((LynxUIBaseInputShadowNode)it).updateHeightIfNeeded(RangesKt.coerceAtLeast((int)placeholderTextLayout.getHeight(), (int)updatedHeight));
            }
        }
    }

    public int customTextAlignSetting(int align) {
        return 0;
    }

    public boolean isFocusable() {
        return ((LynxEditTextView)this.mView).isFocusable();
    }

    public void onFocusChanged(boolean hasFocus, boolean isFocusTransition) {
        if (!isFocusTransition) {
            if (hasFocus) {
                ((LynxEditTextView)this.mView).requestFocus();
                if (!this.mUseCustomKeyboard) {
                    this.showSoftInput();
                }
            } else {
                ((LynxEditTextView)this.mView).clearFocus();
                this.hideSoftInput();
            }
        }
    }

    @LynxUIMethod
    public final void setValue(@Nullable ReadableMap params, @Nullable Callback callback) {
        block5: {
            int cursor;
            if (params == null) {
                Callback callback2 = callback;
                if (callback2 != null) {
                    Object[] objectArray = new Object[]{4, "Param is not a map."};
                    callback2.invoke(objectArray);
                }
                return;
            }
            String text = params.hasKey("value") ? params.getString("value") : "";
            int n = cursor = params.hasKey("cursor") ? params.getInt("cursor") : -1;
            if (((LynxEditTextView)this.mView).getText() == null) {
                ((LynxEditTextView)this.mView).setText(text);
            } else {
                Editable editable = ((LynxEditTextView)this.mView).getText();
                Intrinsics.checkNotNull((Object)editable);
                Editable editable2 = ((LynxEditTextView)this.mView).getText();
                Intrinsics.checkNotNull((Object)editable2);
                editable.replace(0, editable2.length(), (CharSequence)text);
            }
            if (cursor != -1) {
                ((LynxEditTextView)this.mView).setSelection(cursor);
            }
            Callback callback3 = callback;
            if (callback3 == null) break block5;
            Object[] objectArray = new Object[]{0};
            callback3.invoke(objectArray);
        }
    }

    @LynxUIMethod
    public final void getValue(@Nullable ReadableMap params, @Nullable Callback callback) {
        block4: {
            boolean composing = false;
            Editable editable = ((LynxEditTextView)this.mView).getText();
            if (editable != null) {
                Editable it = editable;
                boolean bl = false;
                LynxInputConnectionWrapper lynxInputConnectionWrapper = ((LynxEditTextView)this.mView).inputConnection();
                composing = lynxInputConnectionWrapper != null ? lynxInputConnectionWrapper.hasComposingText((Spannable)it) : false;
            }
            JavaOnlyMap result = new JavaOnlyMap();
            String text = null;
            text = "";
            Editable editable2 = ((LynxEditTextView)this.mView).getText();
            if (editable2 != null) {
                Editable it = editable2;
                boolean bl = false;
                text = String.valueOf(((LynxEditTextView)this.mView).getText());
            }
            int selectionStart = -1;
            if (((LynxEditTextView)this.mView).isFocused()) {
                selectionStart = ((LynxEditTextView)this.mView).getSelectionStart();
            }
            int selectionEnd = -1;
            if (((LynxEditTextView)this.mView).isFocused()) {
                selectionEnd = ((LynxEditTextView)this.mView).getSelectionEnd();
            }
            ((Map)result).put("value", text);
            Integer n = selectionStart;
            ((Map)result).put("selectionStart", n);
            n = selectionEnd;
            ((Map)result).put("selectionEnd", n);
            ((Map)result).put("isComposing", composing);
            Callback callback2 = callback;
            if (callback2 == null) break block4;
            Object[] objectArray = new Object[]{0, result};
            callback2.invoke(objectArray);
        }
    }

    @LynxUIMethod
    public final void setSelectionRange(@Nullable ReadableMap params, @Nullable Callback callback) {
        block8: {
            int textLength;
            int n;
            if (params == null) {
                Callback callback2 = callback;
                if (callback2 != null) {
                    Object[] objectArray = new Object[]{4, "Param is not a map."};
                    callback2.invoke(objectArray);
                }
                return;
            }
            int selectionStart = -1;
            int selectionEnd = -1;
            if (params.hasKey("selectionStart")) {
                selectionStart = params.getInt("selectionStart");
            }
            if (params.hasKey("selectionEnd")) {
                selectionEnd = params.getInt("selectionEnd");
            }
            if (((LynxEditTextView)this.mView).getText() != null) {
                Editable editable = ((LynxEditTextView)this.mView).getText();
                Intrinsics.checkNotNull((Object)editable);
                n = editable.length();
            } else {
                n = textLength = -1;
            }
            if (textLength == -1 || selectionStart > textLength || selectionEnd > textLength || selectionStart < 0 || selectionEnd < 0) {
                Callback callback3 = callback;
                if (callback3 != null) {
                    Object[] objectArray = new Object[]{4, "Range does not meet expectations."};
                    callback3.invoke(objectArray);
                }
                return;
            }
            ((LynxEditTextView)this.mView).setSelection(selectionStart, selectionEnd);
            Callback callback4 = callback;
            if (callback4 == null) break block8;
            Object[] objectArray = new Object[]{0, "Success."};
            callback4.invoke(objectArray);
        }
    }

    @LynxUIMethod
    public final void focus(@Nullable ReadableMap params, @Nullable Callback callback) {
        block2: {
            block0: {
                block3: {
                    block1: {
                        if (!((LynxEditTextView)this.mView).requestFocus()) break block0;
                        if (!this.mUseCustomKeyboard) break block1;
                        this.hideSoftInput();
                        break block2;
                    }
                    if (!this.showSoftInput()) break block3;
                    Callback callback2 = callback;
                    if (callback2 == null) break block2;
                    Object[] objectArray = new Object[]{0};
                    callback2.invoke(objectArray);
                    break block2;
                }
                Callback callback3 = callback;
                if (callback3 == null) break block2;
                Object[] objectArray = new Object[]{1, "fail to show keyboard"};
                callback3.invoke(objectArray);
                break block2;
            }
            Callback callback4 = callback;
            if (callback4 == null) break block2;
            Object[] objectArray = new Object[]{1, "fail to focus"};
            callback4.invoke(objectArray);
        }
    }

    @LynxUIMethod
    public final void blur(@Nullable ReadableMap params, @Nullable Callback callback) {
        block1: {
            ((LynxEditTextView)this.mView).clearFocus();
            if (!this.mUseCustomKeyboard) {
                this.hideSoftInput();
            }
            Callback callback2 = callback;
            if (callback2 == null) break block1;
            Object[] objectArray = new Object[]{0};
            callback2.invoke(objectArray);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private final boolean showSoftInput() {
        Object object = this.getLynxContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        return imm.showSoftInput(this.mView, 1, null);
    }

    @SuppressLint(value={"WrongConstant"})
    private final void hideSoftInput() {
        Object object = this.getLynxContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.hideSoftInputFromWindow(((LynxEditTextView)this.mView).getWindowToken(), 0);
    }

    /*
     * WARNING - void declaration
     */
    protected final void onConfirm() {
        void $this$onConfirm_u24lambda_u2d10;
        LynxDetailEvent lynxDetailEvent;
        LynxDetailEvent lynxDetailEvent2 = lynxDetailEvent = new LynxDetailEvent(this.getSign(), "confirm");
        EventEmitter eventEmitter = this.getLynxContext().getEventEmitter();
        boolean bl = false;
        Editable editable = ((LynxEditTextView)this.mView).getText();
        $this$onConfirm_u24lambda_u2d10.addDetail("value", (Object)(editable != null ? editable.toString() : null));
        eventEmitter.sendCustomEvent((LynxCustomEvent)lynxDetailEvent);
    }

    public boolean isTextArea() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final void createView$lambda-2$lambda-1(LynxUIBaseInput this$0, LynxEditTextView $this_apply, View view, boolean hasFocus) {
        block3: {
            void $this$createView_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0;
            LynxDetailEvent lynxDetailEvent;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)$this_apply), (String)"$this_apply");
            if (hasFocus && !this$0.mUseCustomKeyboard) {
                this$0.showSoftInput();
            }
            LynxDetailEvent lynxDetailEvent2 = lynxDetailEvent = new LynxDetailEvent(this$0.getSign(), hasFocus ? "focus" : "blur");
            EventEmitter eventEmitter = this$0.getLynxContext().getEventEmitter();
            boolean bl = false;
            Editable editable = $this_apply.getText();
            $this$createView_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.addDetail("value", (Object)(editable != null ? editable.toString() : null));
            eventEmitter.sendCustomEvent((LynxCustomEvent)lynxDetailEvent);
            if (!hasFocus) break block3;
            this$0.getLynxContext().EnsureEventDispatcher();
            for (LynxBaseUI parentUI = this$0.getParentBaseUI(); parentUI != null; parentUI = parentUI.getParentBaseUI()) {
                if (!Intrinsics.areEqual((Object)parentUI.getTagName(), (Object)"x-overlay-ng")) continue;
                TouchEventDispatcher touchEventDispatcher = parentUI.getTouchEventDispatcher();
                if (touchEventDispatcher == null) break;
                touchEventDispatcher.setFocusedUI((LynxBaseUI)this$0);
                break;
            }
            TouchEventDispatcher touchEventDispatcher = this$0.getLynxContext().getTouchEventDispatcher();
            if (touchEventDispatcher != null) {
                touchEventDispatcher.setFocusedUI((LynxBaseUI)this$0);
            }
        }
    }

    public static final /* synthetic */ View access$getMView$p$s-1453334866(LynxUIBaseInput $this) {
        return $this.mView;
    }

    public static final /* synthetic */ String access$getMInputFilterRegex$p(LynxUIBaseInput $this) {
        return $this.mInputFilterRegex;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/lynx/xelement/input/LynxUIBaseInput$Companion;", "", "()V", "TYPE_DIGIT", "", "TYPE_EMAIL", "TYPE_NUMBER", "TYPE_PASSWORD", "TYPE_TEL", "TYPE_TEXT", "UNDEFINED_FLOAT", "", "UNDEFINED_INT", "", "Input_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            nArray[ReadableType.Int.ordinal()] = 1;
            nArray[ReadableType.Long.ordinal()] = 2;
            nArray[ReadableType.Number.ordinal()] = 3;
            nArray[ReadableType.String.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

