/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.BigList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.FloatBigList;

public class FloatObjBigList
extends IList<Float> {
    FloatBigList list;

    static Float[] toWrapper(float[] elems) {
        Float[] e = new Float[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = Float.valueOf(elems[i]);
        }
        return e;
    }

    static float[] toPrimitive(Float[] elems) {
        float[] e = new float[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i].floatValue();
        }
        return e;
    }

    static float[] toPrimitive(BigList<? extends Float> list2) {
        float[] e = new float[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = ((Float)list2.get(i)).floatValue();
        }
        return e;
    }

    static float[] toPrimitive(Collection<? extends Float> list) {
        float[] e = new float[list.size()];
        Iterator<? extends Float> iter = list.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next().floatValue();
        }
        return e;
    }

    public static FloatObjBigList create() {
        return new FloatObjBigList();
    }

    public static FloatObjBigList create(Float ... elems) {
        FloatObjBigList list = new FloatObjBigList();
        list.init(elems);
        return list;
    }

    public static FloatObjBigList create(Collection<? extends Float> elems) {
        return new FloatObjBigList(elems);
    }

    public FloatObjBigList() {
        this.init();
    }

    public void init() {
        this.list = new FloatBigList();
    }

    public FloatObjBigList(int capacity) {
        this.list = new FloatBigList(capacity);
    }

    public void init(Float ... elems) {
        this.list = FloatBigList.create(FloatObjBigList.toPrimitive(elems));
    }

    public FloatObjBigList(Collection<? extends Float> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Float> elems) {
        this.list = FloatBigList.create(FloatObjBigList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Float> that) {
        this.list = (FloatBigList)((FloatObjBigList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Float> that) {
        FloatObjBigList list = (FloatObjBigList)that;
        this.list = list.list;
    }

    public FloatObjBigList copy() {
        return (FloatObjBigList)this.clone();
    }

    @Override
    public Float getDefaultElem() {
        return Float.valueOf(this.list.getDefaultElem());
    }

    @Override
    public IList<Float> doCreate(int capacity) {
        return new FloatObjBigList();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Float get(int index) {
        return Float.valueOf(this.list.get(index));
    }

    @Override
    protected Float doGet(int index) {
        return Float.valueOf(this.list.doGet(index));
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len) {
        for (int i = 0; i < len; ++i) {
            elems[i] = Float.valueOf(this.list.doGet(index + i));
        }
    }

    @Override
    protected boolean doAdd(int index, Float elem) {
        return this.list.doAdd(index, elem.floatValue());
    }

    @Override
    protected Float doSet(int index, Float elem) {
        return Float.valueOf(this.list.doSet(index, elem.floatValue()));
    }

    @Override
    protected Float doRemove(int index) {
        return Float.valueOf(this.list.doRemove(index));
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        this.list.doRemoveAll(index, len);
    }

    @Override
    protected Float doReSet(int index, Float elem) {
        return Float.valueOf(this.list.doReSet(index, elem.floatValue()));
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len) {
        this.list.move(srcIndex, dstIndex, len);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.list.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Float.class) {
            return -1;
        }
        return this.list.indexOf(((Float)elem).floatValue());
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Float.class) {
            return -1;
        }
        return this.list.lastIndexOf(((Float)elem).floatValue());
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Float.class) {
            return false;
        }
        int index = this.list.indexOf(((Float)elem).floatValue());
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Float.class) {
            return false;
        }
        return this.list.contains(((Float)elem).floatValue());
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray(int index, int len) {
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = Float.valueOf(this.list.get(i));
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array, int index, int len) {
        if (array.length < len) {
            array = this.doCreateArray(array.getClass().getComponentType(), len);
        }
        for (int i = 0; i < len; ++i) {
            array[i] = Float.valueOf(this.list.get(i));
        }
        if (array.length > len) {
            array[len] = null;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(Class<T> clazz, int index, int len) {
        T[] array = this.doCreateArray(clazz, len);
        for (int i = 0; i < len; ++i) {
            array[i] = Float.valueOf(this.list.get(i));
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Float> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Float> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addArray(Float ... elems) {
        float[] e = FloatObjBigList.toPrimitive(elems);
        return this.list.addArray(e);
    }

    public boolean addArray(int index, Float ... elems) {
        float[] e = FloatObjBigList.toPrimitive(elems);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Float> list2) {
        float[] e = FloatObjBigList.toPrimitive(list2);
        return this.list.addArray(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Float> list2) {
        float[] e = FloatObjBigList.toPrimitive(list2);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Float.class) {
            return false;
        }
        return this.list.removeFirstOccurrence(((Float)elem).floatValue());
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Float.class) {
            return false;
        }
        return this.list.removeLastOccurrence(((Float)elem).floatValue());
    }

    @Override
    public BigList<Float> getAll(int index, int len) {
        float[] elems = this.list.toArray(Float.TYPE, index, len);
        return BigList.create(FloatObjBigList.toWrapper(elems));
    }

    @Override
    public void setAll(int index, IList<? extends Float> list2) {
        float[] e = FloatObjBigList.toPrimitive(list2);
        this.list.setArray(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Float> coll) {
        float[] e = FloatObjBigList.toPrimitive(coll);
        this.list.setArray(index, e);
    }

    public void setArray(int index, Float ... elems) {
        float[] e = FloatObjBigList.toPrimitive(elems);
        this.list.setArray(index, e);
    }

    @Override
    public void sort(int index, int len, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len, ((Float)key).floatValue());
    }

    public FloatObjBigList unmodifiableList() {
        return new ImmutableFloatObjBigList(this);
    }

    protected static class ImmutableFloatObjBigList
    extends FloatObjBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableFloatObjBigList(FloatObjBigList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Float elem) {
            this.error();
            return false;
        }

        @Override
        protected Float doSet(int index, Float elem) {
            this.error();
            return null;
        }

        @Override
        protected Float doReSet(int index, Float elem) {
            this.error();
            return null;
        }

        @Override
        protected Float doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

