/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.primitive.FloatObjBigList;
import org.magicwerk.brownies.collections.primitive.FloatObjGapList;

public abstract class IFloatList
implements Cloneable,
Serializable {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static float[] toArray(Collection<Float> coll) {
        Object[] values = coll.toArray();
        float[] v = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = ((Float)values[i]).floatValue();
        }
        return v;
    }

    public IFloatList copy() {
        return (IFloatList)this.clone();
    }

    public abstract IFloatList unmodifiableList();

    public Object clone() {
        try {
            IFloatList list = (IFloatList)super.clone();
            list.doClone(this);
            return list;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IFloatList var1);

    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len, float elem) {
        this.checkLength(len);
        int size = this.size();
        if (len < size) {
            this.remove(len, size - len);
        } else {
            for (int i = size; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public abstract int size();

    public abstract int capacity();

    public float get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract float doGet(int var1);

    protected abstract float doSet(int var1, float var2);

    public float set(int index, float elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public float put(int index, float elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return 0.0f;
    }

    protected abstract float doReSet(int var1, float var2);

    protected abstract float getDefaultElem();

    protected void doModify() {
    }

    public boolean add(float elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, float elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, float var2);

    public float remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract float doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof FloatObjGapList) {
            obj = ((FloatObjGapList)obj).list;
        } else if (obj instanceof FloatObjBigList) {
            obj = ((FloatObjBigList)obj).list;
        }
        if (!(obj instanceof IFloatList)) {
            return false;
        }
        IFloatList list = (IFloatList)obj;
        int size = this.size();
        if (size != list.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (IFloatList.equalsElem(this.doGet(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float elem = this.doGet(i);
            hashCode = 31 * hashCode + IFloatList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(float elem1, float elem2) {
        return Float.floatToIntBits(elem1) == Float.floatToIntBits(elem2);
    }

    static int hashCodeElem(float elem) {
        return (int)elem;
    }

    public int getCount(float elem) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IFloatList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public float getSingle() {
        if (this.size() != 1) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public float getSingleOrEmpty() {
        int size = this.size();
        if (size == 0) {
            return 0.0f;
        }
        if (size == 1) {
            return this.doGet(0);
        }
        throw new NoSuchElementException();
    }

    public IFloatList getAll(float elem) {
        IFloatList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            if (!IFloatList.equalsElem(e, elem)) continue;
            list.add(e);
        }
        return list;
    }

    public IFloatList getIf(Predicate predicate) {
        IFloatList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            if (!predicate.test(Float.valueOf(e))) continue;
            list.add(e);
        }
        return list;
    }

    public boolean removeIf(Predicate<Float> predicate) {
        boolean removed = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            if (!predicate.test(Float.valueOf(e))) continue;
            this.doRemove(i);
            --size;
            --i;
            removed = true;
        }
        return removed;
    }

    public boolean retainIf(Predicate<Float> predicate) {
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            if (predicate.test(Float.valueOf(e))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public IFloatList extractIf(Predicate<Float> predicate) {
        IFloatList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            if (!predicate.test(Float.valueOf(e))) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public Set getDistinct() {
        HashSet<Float> set = new HashSet<Float>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            set.add(Float.valueOf(this.doGet(i)));
        }
        return set;
    }

    public <R> IList<R> mappedList(Function<Float, R> func) {
        int size = this.size();
        GapList<R> list = new GapList<R>(size);
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            ((IList)list).add(func.apply(Float.valueOf(e)));
        }
        return list;
    }

    public IFloatList transformedList(UnaryOperator<Float> op) {
        int size = this.size();
        IFloatList list = this.doCreate(size);
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            list.add(((Float)op.apply(Float.valueOf(e))).floatValue());
        }
        return list;
    }

    public void transform(UnaryOperator<Float> op) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            e = ((Float)op.apply(Float.valueOf(e))).floatValue();
            this.doSet(i, e);
        }
    }

    public IFloatList filteredList(Predicate<Float> predicate) {
        IFloatList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            if (!predicate.test(Float.valueOf(e))) continue;
            list.add(e);
        }
        return list;
    }

    public void filter(Predicate<Float> predicate) {
        IFloatList list = this.filteredList(predicate);
        this.doAssign(list);
    }

    public int indexOf(float elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IFloatList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(Predicate<Float> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(Float.valueOf(this.doGet(i)))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IFloatList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(float elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size = this.size();
        for (int i = fromIndex; i < size; ++i) {
            if (!IFloatList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float elem, int fromIndex) {
        int size = this.size();
        if (fromIndex >= size) {
            fromIndex = size - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!IFloatList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(float elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(float elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean containsIf(Predicate<Float> predicate) {
        return this.indexOfIf(predicate) != -1;
    }

    public boolean addIfAbsent(float elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<Float> coll) {
        for (float elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Float> coll) {
        for (float elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public IFloatList removeAll(float elem) {
        IFloatList list = this.doCreate(-1);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.doGet(i);
            if (!IFloatList.equalsElem(elem, e)) continue;
            list.add(e);
            this.doRemove(i);
            --size;
            --i;
        }
        return list;
    }

    public boolean removeAll(Collection<Float> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(Float.valueOf(this.doGet(i)))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(IFloatList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Float> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(Float.valueOf(this.doGet(i)))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IFloatList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size;
            --i;
            modified = true;
        }
        return modified;
    }

    public float[] toArray() {
        return this.toArray(0, this.size());
    }

    public float[] toArray(float[] array) {
        return this.toArray(array, 0, this.size());
    }

    public float[] toArray(Class clazz) {
        return this.toArray(clazz, 0, this.size());
    }

    public float[] toArray(int index, int len) {
        float[] array = new float[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public float[] toArray(float[] array, int index, int len) {
        if (array.length < len) {
            array = this.doCreateArray(array.getClass().getComponentType(), len);
        }
        this.doGetAll(array, index, len);
        if (array.length > len) {
            array[len] = 0.0f;
        }
        return array;
    }

    public float[] toArray(Class clazz, int index, int len) {
        float[] array = this.doCreateArray(clazz, len);
        this.doGetAll(array, index, len);
        return array;
    }

    protected float[] doCreateArray(Class clazz, int len) {
        return (float[])Array.newInstance(clazz, len);
    }

    protected void doGetAll(float[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, IFloatList list) {
        int listSize = list.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            float elem = list.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    public float peek() {
        if (this.size() == 0) {
            return 0.0f;
        }
        return this.getFirst();
    }

    public float element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public float poll() {
        if (this.size() == 0) {
            return 0.0f;
        }
        return this.doRemove(0);
    }

    public float remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(float elem) {
        return this.doAdd(-1, elem);
    }

    public float getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public float getLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size - 1);
    }

    public void addFirst(float elem) {
        this.doAdd(0, elem);
    }

    public void addLast(float elem) {
        this.doAdd(-1, elem);
    }

    public float removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public float removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size - 1);
    }

    public boolean offerFirst(float elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(float elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public float peekFirst() {
        if (this.size() == 0) {
            return 0.0f;
        }
        return this.doGet(0);
    }

    public float peekLast() {
        int size = this.size();
        if (size == 0) {
            return 0.0f;
        }
        return this.doGet(size - 1);
    }

    public float pollFirst() {
        if (this.size() == 0) {
            return 0.0f;
        }
        return this.doRemove(0);
    }

    public float pollLast() {
        int size = this.size();
        if (size == 0) {
            return 0.0f;
        }
        return this.doRemove(size - 1);
    }

    public float pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(float elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(float elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(float elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void transferCopy(IFloatList src, int srcIndex, int srcLen, IFloatList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferMove(IFloatList src, int srcIndex, int srcLen, IFloatList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferRemove(IFloatList src, int srcIndex, int srcLen, IFloatList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, IFloatList dst, int dstIndex, int dstLen) {
        if (srcLen == -1) {
            srcLen = this.size() - srcIndex;
        }
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        float defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                float elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                float elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static void transferSwap(IFloatList src, int srcIndex, IFloatList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len);
        }
    }

    void doTransferSwap(int srcIndex, IFloatList dst, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        dst.checkRange(dstIndex, len);
        for (int i = 0; i < len; ++i) {
            float swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract IFloatList doCreate(int var1);

    protected abstract void doAssign(IFloatList var1);

    public IFloatList getAll(int index, int len) {
        this.checkRange(index, len);
        IFloatList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        return list;
    }

    public IFloatList extract(int index, int len) {
        this.checkRange(index, len);
        IFloatList list = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list.add(this.doGet(index + i));
        }
        this.remove(index, len);
        return list;
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public boolean addAll(IFloatList list) {
        return this.doAddAll(-1, list);
    }

    public boolean addAll(int index, IFloatList list) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list);
    }

    public boolean addAll(Collection<Float> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyFloatListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyFloatListFromCollection(coll));
    }

    public boolean addAll(int index, Collection<Float> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyFloatListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyFloatListFromCollection(coll));
    }

    public boolean addArray(float ... elems) {
        return this.doAddAll(-1, new IReadOnlyFloatListFromArray(elems));
    }

    public boolean addArray(float[] elems, int offset, int length) {
        return this.doAddAll(-1, new IReadOnlyFloatListFromArray(elems, offset, length));
    }

    public boolean addArray(int index, float[] elems, int offset, int length) {
        return this.doAddAll(index, new IReadOnlyFloatListFromArray(elems, offset, length));
    }

    public boolean addArray(int index, float ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyFloatListFromArray(elems));
    }

    public boolean addMult(int len, float elem) {
        return this.doAddAll(-1, new IReadOnlyFloatListFromMult(len, elem));
    }

    public boolean addMult(int index, int len, float elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyFloatListFromMult(len, elem));
    }

    public void setAll(int index, IFloatList list) {
        int listSize = list.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list);
    }

    public void setAll(int index, Collection<Float> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyFloatListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyFloatListFromCollection(coll));
        }
    }

    public void setArray(int index, float ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyFloatListFromArray(elems));
    }

    public void setArray(int index, float[] elems, int offset, int length) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyFloatListFromArray(elems, offset, length));
    }

    public void setMult(int index, int len, float elem) {
        this.checkRange(index, len);
        this.doReplaceAll(index, len, new IReadOnlyFloatListFromMult(len, elem));
    }

    public void putAll(int index, IFloatList list) {
        this.checkIndexAdd(index);
        this.checkNonNull(list);
        int len = this.size() - index;
        if (list != null && list.size() < len) {
            len = list.size();
        }
        this.doReplaceAll(index, len, list);
    }

    public void putAll(int index, Collection<Float> coll) {
        if (coll instanceof IFloatList) {
            this.putAll(index, (IFloatList)((Object)coll));
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyFloatListFromList((List)coll));
        } else {
            this.putAll(index, new IReadOnlyFloatListFromCollection(coll));
        }
    }

    public void putArray(int index, float ... elems) {
        this.putAll(index, new IReadOnlyFloatListFromArray(elems));
    }

    public void putMult(int index, int len, float elem) {
        this.putAll(index, new IReadOnlyFloatListFromMult(len, elem));
    }

    public void initAll(IFloatList list) {
        this.checkNonNull(list);
        this.doReplaceAll(0, this.size(), list);
    }

    public void initAll(Collection<Float> coll) {
        if (coll instanceof IFloatList) {
            this.initAll((IFloatList)((Object)coll));
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyFloatListFromList((List)coll));
        } else {
            this.initAll(new IReadOnlyFloatListFromCollection(coll));
        }
    }

    public void initArray(float ... elems) {
        this.initAll(new IReadOnlyFloatListFromArray(elems));
    }

    public void initMult(int len, float elem) {
        this.checkLength(len);
        this.initAll(new IReadOnlyFloatListFromMult(len, elem));
    }

    public void replaceAll(int index, int len, Collection<Float> coll) {
        if (coll instanceof IFloatList) {
            this.replaceAll(index, len, (IFloatList)((Object)coll));
        } else if (coll instanceof List) {
            this.replaceAll(index, len, new IReadOnlyFloatListFromList((List)coll));
        } else {
            this.replaceAll(index, len, new IReadOnlyFloatListFromCollection(coll));
        }
    }

    public void replaceArray(int index, int len, float ... elems) {
        this.replaceAll(index, len, new IReadOnlyFloatListFromArray(elems));
    }

    public void replaceMult(int index, int len, int numElems, float elem) {
        this.replaceAll(index, len, new IReadOnlyFloatListFromMult(numElems, elem));
    }

    public void replaceAll(int index, int len, IFloatList list) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len == -1) {
            len = this.size() - index;
            if (list != null && list.size() < len) {
                len = list.size();
            }
        } else {
            this.checkRange(index, len);
        }
        this.doReplaceAll(index, len, list);
    }

    protected boolean doReplaceAll(int index, int len, IFloatList list) {
        assert (index >= 0 && index <= this.size());
        assert (len >= 0 && index + len <= this.size());
        int srcLen = 0;
        if (list != null) {
            srcLen = list.size();
        }
        this.doEnsureCapacity(this.size() - len + srcLen);
        this.doRemoveAll(index, len);
        for (int i = 0; i < srcLen; ++i) {
            if (this.doAdd(index + i, list.doGet(i))) continue;
            --index;
        }
        return len > 0 || srcLen > 0;
    }

    public void fill(float elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, 0.0f);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.setMult(srcIndex + len - fill, fill, 0.0f);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            float swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            float swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        this.doRotate(index, len, distance);
    }

    protected void doRotate(int index, int len, int distance) {
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len);
        int num = 0;
        int start = 0;
        while (num != len) {
            float elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(float key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, float var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len) {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be 0");
        }
    }

    protected static class IReadOnlyFloatListFromList
    extends IReadOnlyFloatList {
        List<Float> list2;

        IReadOnlyFloatListFromList(List<Float> list) {
            this.list2 = list;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected float doGet(int index) {
            return this.list2.get(index).floatValue();
        }
    }

    protected static class IReadOnlyFloatListFromCollection
    extends IReadOnlyFloatList {
        float[] array;

        IReadOnlyFloatListFromCollection(Collection<Float> coll) {
            this.array = IReadOnlyFloatListFromCollection.toArray(coll);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected float doGet(int index) {
            return this.array[index];
        }
    }

    protected static class IReadOnlyFloatListFromMult
    extends IReadOnlyFloatList {
        int len;
        float elem;

        IReadOnlyFloatListFromMult(int len, float elem) {
            this.checkLength(len);
            this.len = len;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected float doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyFloatListFromArray
    extends IReadOnlyFloatList {
        float[] array;
        int offset;
        int length;

        IReadOnlyFloatListFromArray(float[] array) {
            this.array = array;
            this.offset = 0;
            this.length = array.length;
        }

        IReadOnlyFloatListFromArray(float[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        protected float doGet(int index) {
            return this.array[this.offset + index];
        }
    }

    protected static abstract class IReadOnlyFloatList
    extends IFloatList {
        protected IReadOnlyFloatList() {
        }

        @Override
        public IFloatList unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(IFloatList that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected float doSet(int index, float elem) {
            this.error();
            return 0.0f;
        }

        @Override
        protected float doReSet(int index, float elem) {
            this.error();
            return 0.0f;
        }

        @Override
        protected float getDefaultElem() {
            this.error();
            return 0.0f;
        }

        @Override
        protected boolean doAdd(int index, float elem) {
            this.error();
            return false;
        }

        @Override
        protected float doRemove(int index) {
            this.error();
            return 0.0f;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IFloatList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IFloatList that) {
            this.error();
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }

        @Override
        public int binarySearch(int index, int len, float key) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }
}

