package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link ImageSearchResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableImageSearchResult.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableImageSearchResult implements ImageSearchResult {
  private final String description;
  private final boolean official;
  private final boolean automated;
  private final String name;
  private final int starCount;

  private ImmutableImageSearchResult(
      String description,
      boolean official,
      boolean automated,
      String name,
      int starCount) {
    this.description = description;
    this.official = official;
    this.automated = automated;
    this.name = name;
    this.starCount = starCount;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  /**
   * @return The value of the {@code official} attribute
   */
  @JsonProperty("is_official")
  @Override
  public boolean official() {
    return official;
  }

  /**
   * @return The value of the {@code automated} attribute
   */
  @JsonProperty("is_automated")
  @Override
  public boolean automated() {
    return automated;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code starCount} attribute
   */
  @JsonProperty("star_count")
  @Override
  public int starCount() {
    return starCount;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageSearchResult#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageSearchResult withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableImageSearchResult(newValue, this.official, this.automated, this.name, this.starCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageSearchResult#official() official} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for official
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageSearchResult withOfficial(boolean value) {
    if (this.official == value) return this;
    return new ImmutableImageSearchResult(this.description, value, this.automated, this.name, this.starCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageSearchResult#automated() automated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for automated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageSearchResult withAutomated(boolean value) {
    if (this.automated == value) return this;
    return new ImmutableImageSearchResult(this.description, this.official, value, this.name, this.starCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageSearchResult#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageSearchResult withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableImageSearchResult(this.description, this.official, this.automated, newValue, this.starCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageSearchResult#starCount() starCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for starCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageSearchResult withStarCount(int value) {
    if (this.starCount == value) return this;
    return new ImmutableImageSearchResult(this.description, this.official, this.automated, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableImageSearchResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableImageSearchResult
        && equalTo((ImmutableImageSearchResult) another);
  }

  private boolean equalTo(ImmutableImageSearchResult another) {
    return description.equals(another.description)
        && official == another.official
        && automated == another.automated
        && name.equals(another.name)
        && starCount == another.starCount;
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code official}, {@code automated}, {@code name}, {@code starCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + description.hashCode();
    h += (h << 5) + Boolean.hashCode(official);
    h += (h << 5) + Boolean.hashCode(automated);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + starCount;
    return h;
  }

  /**
   * Prints the immutable value {@code ImageSearchResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ImageSearchResult{"
        + "description=" + description
        + ", official=" + official
        + ", automated=" + automated
        + ", name=" + name
        + ", starCount=" + starCount
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ImageSearchResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImageSearchResult instance
   */
  public static ImmutableImageSearchResult copyOf(ImageSearchResult instance) {
    if (instance instanceof ImmutableImageSearchResult) {
      return (ImmutableImageSearchResult) instance;
    }
    return ImmutableImageSearchResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableImageSearchResult ImmutableImageSearchResult}.
   * <pre>
   * ImmutableImageSearchResult.builder()
   *    .description(String) // required {@link ImageSearchResult#description() description}
   *    .official(boolean) // required {@link ImageSearchResult#official() official}
   *    .automated(boolean) // required {@link ImageSearchResult#automated() automated}
   *    .name(String) // required {@link ImageSearchResult#name() name}
   *    .starCount(int) // required {@link ImageSearchResult#starCount() starCount}
   *    .build();
   * </pre>
   * @return A new ImmutableImageSearchResult builder
   */
  public static ImmutableImageSearchResult.Builder builder() {
    return new ImmutableImageSearchResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableImageSearchResult ImmutableImageSearchResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_DESCRIPTION = 0x1L;
    private static final long INIT_BIT_OFFICIAL = 0x2L;
    private static final long INIT_BIT_AUTOMATED = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_STAR_COUNT = 0x10L;
    private long initBits = 0x1fL;

    private String description;
    private boolean official;
    private boolean automated;
    private String name;
    private int starCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImageSearchResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImageSearchResult instance) {
      Objects.requireNonNull(instance, "instance");
      description(instance.description());
      official(instance.official());
      automated(instance.automated());
      name(instance.name());
      starCount(instance.starCount());
      return this;
    }

    /**
     * Initializes the value for the {@link ImageSearchResult#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageSearchResult#official() official} attribute.
     * @param official The value for official 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("is_official")
    public final Builder official(boolean official) {
      this.official = official;
      initBits &= ~INIT_BIT_OFFICIAL;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageSearchResult#automated() automated} attribute.
     * @param automated The value for automated 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("is_automated")
    public final Builder automated(boolean automated) {
      this.automated = automated;
      initBits &= ~INIT_BIT_AUTOMATED;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageSearchResult#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageSearchResult#starCount() starCount} attribute.
     * @param starCount The value for starCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("star_count")
    public final Builder starCount(int starCount) {
      this.starCount = starCount;
      initBits &= ~INIT_BIT_STAR_COUNT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableImageSearchResult ImmutableImageSearchResult}.
     * @return An immutable instance of ImageSearchResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableImageSearchResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableImageSearchResult(description, official, automated, name, starCount);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_OFFICIAL) != 0) attributes.add("official");
      if ((initBits & INIT_BIT_AUTOMATED) != 0) attributes.add("automated");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STAR_COUNT) != 0) attributes.add("starCount");
      return "Cannot build ImageSearchResult, some of required attributes are not set " + attributes;
    }
  }
}
