package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ReplicatedJob}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReplicatedJob.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableReplicatedJob implements ReplicatedJob {
  private final @Nullable Long maxConcurrent;
  private final @Nullable Long totalCompletions;

  private ImmutableReplicatedJob(
      @Nullable Long maxConcurrent,
      @Nullable Long totalCompletions) {
    this.maxConcurrent = maxConcurrent;
    this.totalCompletions = totalCompletions;
  }

  /**
   * @return The value of the {@code maxConcurrent} attribute
   */
  @JsonProperty("MaxConcurrent")
  @Override
  public @Nullable Long maxConcurrent() {
    return maxConcurrent;
  }

  /**
   * @return The value of the {@code totalCompletions} attribute
   */
  @JsonProperty("TotalCompletions")
  @Override
  public @Nullable Long totalCompletions() {
    return totalCompletions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplicatedJob#maxConcurrent() maxConcurrent} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxConcurrent (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReplicatedJob withMaxConcurrent(@Nullable Long value) {
    if (Objects.equals(this.maxConcurrent, value)) return this;
    return new ImmutableReplicatedJob(value, this.totalCompletions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplicatedJob#totalCompletions() totalCompletions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCompletions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReplicatedJob withTotalCompletions(@Nullable Long value) {
    if (Objects.equals(this.totalCompletions, value)) return this;
    return new ImmutableReplicatedJob(this.maxConcurrent, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReplicatedJob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReplicatedJob
        && equalTo((ImmutableReplicatedJob) another);
  }

  private boolean equalTo(ImmutableReplicatedJob another) {
    return Objects.equals(maxConcurrent, another.maxConcurrent)
        && Objects.equals(totalCompletions, another.totalCompletions);
  }

  /**
   * Computes a hash code from attributes: {@code maxConcurrent}, {@code totalCompletions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(maxConcurrent);
    h += (h << 5) + Objects.hashCode(totalCompletions);
    return h;
  }

  /**
   * Prints the immutable value {@code ReplicatedJob} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReplicatedJob{"
        + "maxConcurrent=" + maxConcurrent
        + ", totalCompletions=" + totalCompletions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ReplicatedJob} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReplicatedJob instance
   */
  public static ImmutableReplicatedJob copyOf(ReplicatedJob instance) {
    if (instance instanceof ImmutableReplicatedJob) {
      return (ImmutableReplicatedJob) instance;
    }
    return ImmutableReplicatedJob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReplicatedJob ImmutableReplicatedJob}.
   * <pre>
   * ImmutableReplicatedJob.builder()
   *    .maxConcurrent(Long | null) // nullable {@link ReplicatedJob#maxConcurrent() maxConcurrent}
   *    .totalCompletions(Long | null) // nullable {@link ReplicatedJob#totalCompletions() totalCompletions}
   *    .build();
   * </pre>
   * @return A new ImmutableReplicatedJob builder
   */
  public static ImmutableReplicatedJob.Builder builder() {
    return new ImmutableReplicatedJob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReplicatedJob ImmutableReplicatedJob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements ReplicatedJob.Builder {
    private Long maxConcurrent;
    private Long totalCompletions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReplicatedJob} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReplicatedJob instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Long maxConcurrentValue = instance.maxConcurrent();
      if (maxConcurrentValue != null) {
        maxConcurrent(maxConcurrentValue);
      }
      @Nullable Long totalCompletionsValue = instance.totalCompletions();
      if (totalCompletionsValue != null) {
        totalCompletions(totalCompletionsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ReplicatedJob#maxConcurrent() maxConcurrent} attribute.
     * @param maxConcurrent The value for maxConcurrent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MaxConcurrent")
    public final Builder maxConcurrent(@Nullable Long maxConcurrent) {
      this.maxConcurrent = maxConcurrent;
      return this;
    }

    /**
     * Initializes the value for the {@link ReplicatedJob#totalCompletions() totalCompletions} attribute.
     * @param totalCompletions The value for totalCompletions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("TotalCompletions")
    public final Builder totalCompletions(@Nullable Long totalCompletions) {
      this.totalCompletions = totalCompletions;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReplicatedJob ImmutableReplicatedJob}.
     * @return An immutable instance of ReplicatedJob
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReplicatedJob build() {
      return new ImmutableReplicatedJob(maxConcurrent, totalCompletions);
    }
  }
}
