package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ExecState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExecState.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableExecState implements ExecState {
  private final String id;
  private final Boolean running;
  private final @Nullable Long exitCode;
  private final ProcessConfig processConfig;
  private final Boolean openStdin;
  private final Boolean openStdout;
  private final Boolean openStderr;
  private final @Nullable ContainerInfo container;
  private final @Nullable String containerId;

  private ImmutableExecState(
      String id,
      Boolean running,
      @Nullable Long exitCode,
      ProcessConfig processConfig,
      Boolean openStdin,
      Boolean openStdout,
      Boolean openStderr,
      @Nullable ContainerInfo container,
      @Nullable String containerId) {
    this.id = id;
    this.running = running;
    this.exitCode = exitCode;
    this.processConfig = processConfig;
    this.openStdin = openStdin;
    this.openStdout = openStdout;
    this.openStderr = openStderr;
    this.container = container;
    this.containerId = containerId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code running} attribute
   */
  @JsonProperty("Running")
  @Override
  public Boolean running() {
    return running;
  }

  /**
   * @return The value of the {@code exitCode} attribute
   */
  @JsonProperty("ExitCode")
  @Override
  public @Nullable Long exitCode() {
    return exitCode;
  }

  /**
   * @return The value of the {@code processConfig} attribute
   */
  @JsonProperty("ProcessConfig")
  @Override
  public ProcessConfig processConfig() {
    return processConfig;
  }

  /**
   * @return The value of the {@code openStdin} attribute
   */
  @JsonProperty("OpenStdin")
  @Override
  public Boolean openStdin() {
    return openStdin;
  }

  /**
   * @return The value of the {@code openStdout} attribute
   */
  @JsonProperty("OpenStdout")
  @Override
  public Boolean openStdout() {
    return openStdout;
  }

  /**
   * @return The value of the {@code openStderr} attribute
   */
  @JsonProperty("OpenStderr")
  @Override
  public Boolean openStderr() {
    return openStderr;
  }

  /**
   * @return The value of the {@code container} attribute
   */
  @JsonProperty("Container")
  @Override
  public @Nullable ContainerInfo container() {
    return container;
  }

  /**
   * @return The value of the {@code containerId} attribute
   */
  @JsonProperty("ContainerID")
  @Override
  public @Nullable String containerId() {
    return containerId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableExecState(
        newValue,
        this.running,
        this.exitCode,
        this.processConfig,
        this.openStdin,
        this.openStdout,
        this.openStderr,
        this.container,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#running() running} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for running
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withRunning(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "running");
    if (this.running.equals(newValue)) return this;
    return new ImmutableExecState(
        this.id,
        newValue,
        this.exitCode,
        this.processConfig,
        this.openStdin,
        this.openStdout,
        this.openStderr,
        this.container,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#exitCode() exitCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exitCode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withExitCode(@Nullable Long value) {
    if (Objects.equals(this.exitCode, value)) return this;
    return new ImmutableExecState(
        this.id,
        this.running,
        value,
        this.processConfig,
        this.openStdin,
        this.openStdout,
        this.openStderr,
        this.container,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#processConfig() processConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withProcessConfig(ProcessConfig value) {
    if (this.processConfig == value) return this;
    ProcessConfig newValue = Objects.requireNonNull(value, "processConfig");
    return new ImmutableExecState(
        this.id,
        this.running,
        this.exitCode,
        newValue,
        this.openStdin,
        this.openStdout,
        this.openStderr,
        this.container,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#openStdin() openStdin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openStdin
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withOpenStdin(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "openStdin");
    if (this.openStdin.equals(newValue)) return this;
    return new ImmutableExecState(
        this.id,
        this.running,
        this.exitCode,
        this.processConfig,
        newValue,
        this.openStdout,
        this.openStderr,
        this.container,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#openStdout() openStdout} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openStdout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withOpenStdout(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "openStdout");
    if (this.openStdout.equals(newValue)) return this;
    return new ImmutableExecState(
        this.id,
        this.running,
        this.exitCode,
        this.processConfig,
        this.openStdin,
        newValue,
        this.openStderr,
        this.container,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#openStderr() openStderr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openStderr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withOpenStderr(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "openStderr");
    if (this.openStderr.equals(newValue)) return this;
    return new ImmutableExecState(
        this.id,
        this.running,
        this.exitCode,
        this.processConfig,
        this.openStdin,
        this.openStdout,
        newValue,
        this.container,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#container() container} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for container (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withContainer(@Nullable ContainerInfo value) {
    if (this.container == value) return this;
    return new ImmutableExecState(
        this.id,
        this.running,
        this.exitCode,
        this.processConfig,
        this.openStdin,
        this.openStdout,
        this.openStderr,
        value,
        this.containerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecState#containerId() containerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containerId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecState withContainerId(@Nullable String value) {
    if (Objects.equals(this.containerId, value)) return this;
    return new ImmutableExecState(
        this.id,
        this.running,
        this.exitCode,
        this.processConfig,
        this.openStdin,
        this.openStdout,
        this.openStderr,
        this.container,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExecState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExecState
        && equalTo(0, (ImmutableExecState) another);
  }

  private boolean equalTo(int synthetic, ImmutableExecState another) {
    return id.equals(another.id)
        && running.equals(another.running)
        && Objects.equals(exitCode, another.exitCode)
        && processConfig.equals(another.processConfig)
        && openStdin.equals(another.openStdin)
        && openStdout.equals(another.openStdout)
        && openStderr.equals(another.openStderr)
        && Objects.equals(container, another.container)
        && Objects.equals(containerId, another.containerId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code running}, {@code exitCode}, {@code processConfig}, {@code openStdin}, {@code openStdout}, {@code openStderr}, {@code container}, {@code containerId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + running.hashCode();
    h += (h << 5) + Objects.hashCode(exitCode);
    h += (h << 5) + processConfig.hashCode();
    h += (h << 5) + openStdin.hashCode();
    h += (h << 5) + openStdout.hashCode();
    h += (h << 5) + openStderr.hashCode();
    h += (h << 5) + Objects.hashCode(container);
    h += (h << 5) + Objects.hashCode(containerId);
    return h;
  }

  /**
   * Prints the immutable value {@code ExecState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExecState{"
        + "id=" + id
        + ", running=" + running
        + ", exitCode=" + exitCode
        + ", processConfig=" + processConfig
        + ", openStdin=" + openStdin
        + ", openStdout=" + openStdout
        + ", openStderr=" + openStderr
        + ", container=" + container
        + ", containerId=" + containerId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExecState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExecState instance
   */
  public static ImmutableExecState copyOf(ExecState instance) {
    if (instance instanceof ImmutableExecState) {
      return (ImmutableExecState) instance;
    }
    return ImmutableExecState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExecState ImmutableExecState}.
   * <pre>
   * ImmutableExecState.builder()
   *    .id(String) // required {@link ExecState#id() id}
   *    .running(Boolean) // required {@link ExecState#running() running}
   *    .exitCode(Long | null) // nullable {@link ExecState#exitCode() exitCode}
   *    .processConfig(org.mandas.docker.client.messages.ProcessConfig) // required {@link ExecState#processConfig() processConfig}
   *    .openStdin(Boolean) // required {@link ExecState#openStdin() openStdin}
   *    .openStdout(Boolean) // required {@link ExecState#openStdout() openStdout}
   *    .openStderr(Boolean) // required {@link ExecState#openStderr() openStderr}
   *    .container(org.mandas.docker.client.messages.ContainerInfo | null) // nullable {@link ExecState#container() container}
   *    .containerId(String | null) // nullable {@link ExecState#containerId() containerId}
   *    .build();
   * </pre>
   * @return A new ImmutableExecState builder
   */
  public static ImmutableExecState.Builder builder() {
    return new ImmutableExecState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExecState ImmutableExecState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_RUNNING = 0x2L;
    private static final long INIT_BIT_PROCESS_CONFIG = 0x4L;
    private static final long INIT_BIT_OPEN_STDIN = 0x8L;
    private static final long INIT_BIT_OPEN_STDOUT = 0x10L;
    private static final long INIT_BIT_OPEN_STDERR = 0x20L;
    private long initBits = 0x3fL;

    private String id;
    private Boolean running;
    private Long exitCode;
    private ProcessConfig processConfig;
    private Boolean openStdin;
    private Boolean openStdout;
    private Boolean openStderr;
    private ContainerInfo container;
    private String containerId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExecState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecState instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      running(instance.running());
      @Nullable Long exitCodeValue = instance.exitCode();
      if (exitCodeValue != null) {
        exitCode(exitCodeValue);
      }
      processConfig(instance.processConfig());
      openStdin(instance.openStdin());
      openStdout(instance.openStdout());
      openStderr(instance.openStderr());
      @Nullable ContainerInfo containerValue = instance.container();
      if (containerValue != null) {
        container(containerValue);
      }
      @Nullable String containerIdValue = instance.containerId();
      if (containerIdValue != null) {
        containerId(containerIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#running() running} attribute.
     * @param running The value for running 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Running")
    public final Builder running(Boolean running) {
      this.running = Objects.requireNonNull(running, "running");
      initBits &= ~INIT_BIT_RUNNING;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#exitCode() exitCode} attribute.
     * @param exitCode The value for exitCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExitCode")
    public final Builder exitCode(@Nullable Long exitCode) {
      this.exitCode = exitCode;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#processConfig() processConfig} attribute.
     * @param processConfig The value for processConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ProcessConfig")
    public final Builder processConfig(ProcessConfig processConfig) {
      this.processConfig = Objects.requireNonNull(processConfig, "processConfig");
      initBits &= ~INIT_BIT_PROCESS_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#openStdin() openStdin} attribute.
     * @param openStdin The value for openStdin 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OpenStdin")
    public final Builder openStdin(Boolean openStdin) {
      this.openStdin = Objects.requireNonNull(openStdin, "openStdin");
      initBits &= ~INIT_BIT_OPEN_STDIN;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#openStdout() openStdout} attribute.
     * @param openStdout The value for openStdout 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OpenStdout")
    public final Builder openStdout(Boolean openStdout) {
      this.openStdout = Objects.requireNonNull(openStdout, "openStdout");
      initBits &= ~INIT_BIT_OPEN_STDOUT;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#openStderr() openStderr} attribute.
     * @param openStderr The value for openStderr 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("OpenStderr")
    public final Builder openStderr(Boolean openStderr) {
      this.openStderr = Objects.requireNonNull(openStderr, "openStderr");
      initBits &= ~INIT_BIT_OPEN_STDERR;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#container() container} attribute.
     * @param container The value for container (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Container")
    public final Builder container(@Nullable ContainerInfo container) {
      this.container = container;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecState#containerId() containerId} attribute.
     * @param containerId The value for containerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainerID")
    public final Builder containerId(@Nullable String containerId) {
      this.containerId = containerId;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExecState ImmutableExecState}.
     * @return An immutable instance of ExecState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExecState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExecState(
          id,
          running,
          exitCode,
          processConfig,
          openStdin,
          openStdout,
          openStderr,
          container,
          containerId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_RUNNING) != 0) attributes.add("running");
      if ((initBits & INIT_BIT_PROCESS_CONFIG) != 0) attributes.add("processConfig");
      if ((initBits & INIT_BIT_OPEN_STDIN) != 0) attributes.add("openStdin");
      if ((initBits & INIT_BIT_OPEN_STDOUT) != 0) attributes.add("openStdout");
      if ((initBits & INIT_BIT_OPEN_STDERR) != 0) attributes.add("openStderr");
      return "Cannot build ExecState, some of required attributes are not set " + attributes;
    }
  }
}
