package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link Network}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNetwork.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableNetwork implements Network {
  private final String name;
  private final String id;
  private final String scope;
  private final String driver;
  private final Ipam ipam;
  private final @Nullable Map<String, Network.Container> containers;
  private final @Nullable Map<String, String> options;
  private final @Nullable Boolean internal;
  private final @Nullable Boolean enableIPv6;
  private final @Nullable Map<String, String> labels;
  private final @Nullable Boolean attachable;

  private ImmutableNetwork(
      String name,
      String id,
      String scope,
      String driver,
      Ipam ipam,
      @Nullable Map<String, Network.Container> containers,
      @Nullable Map<String, String> options,
      @Nullable Boolean internal,
      @Nullable Boolean enableIPv6,
      @Nullable Map<String, String> labels,
      @Nullable Boolean attachable) {
    this.name = name;
    this.id = id;
    this.scope = scope;
    this.driver = driver;
    this.ipam = ipam;
    this.containers = containers;
    this.options = options;
    this.internal = internal;
    this.enableIPv6 = enableIPv6;
    this.labels = labels;
    this.attachable = attachable;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("Id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code scope} attribute
   */
  @JsonProperty("Scope")
  @Override
  public String scope() {
    return scope;
  }

  /**
   * @return The value of the {@code driver} attribute
   */
  @JsonProperty("Driver")
  @Override
  public String driver() {
    return driver;
  }

  /**
   * @return The value of the {@code ipam} attribute
   */
  @JsonProperty("IPAM")
  @Override
  public Ipam ipam() {
    return ipam;
  }

  /**
   * @return The value of the {@code containers} attribute
   */
  @JsonProperty("Containers")
  @Override
  public @Nullable Map<String, Network.Container> containers() {
    return containers;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty("Options")
  @Override
  public @Nullable Map<String, String> options() {
    return options;
  }

  /**
   * @return The value of the {@code internal} attribute
   */
  @JsonProperty("Internal")
  @Override
  public @Nullable Boolean internal() {
    return internal;
  }

  /**
   * @return The value of the {@code enableIPv6} attribute
   */
  @JsonProperty("EnableIPv6")
  @Override
  public @Nullable Boolean enableIPv6() {
    return enableIPv6;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("Labels")
  @Override
  public @Nullable Map<String, String> labels() {
    return labels;
  }

  /**
   * @return The value of the {@code attachable} attribute
   */
  @JsonProperty("Attachable")
  @Override
  public @Nullable Boolean attachable() {
    return attachable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableNetwork(
        newValue,
        this.id,
        this.scope,
        this.driver,
        this.ipam,
        this.containers,
        this.options,
        this.internal,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableNetwork(
        this.name,
        newValue,
        this.scope,
        this.driver,
        this.ipam,
        this.containers,
        this.options,
        this.internal,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#scope() scope} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scope
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withScope(String value) {
    String newValue = Objects.requireNonNull(value, "scope");
    if (this.scope.equals(newValue)) return this;
    return new ImmutableNetwork(
        this.name,
        this.id,
        newValue,
        this.driver,
        this.ipam,
        this.containers,
        this.options,
        this.internal,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#driver() driver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for driver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withDriver(String value) {
    String newValue = Objects.requireNonNull(value, "driver");
    if (this.driver.equals(newValue)) return this;
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        newValue,
        this.ipam,
        this.containers,
        this.options,
        this.internal,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#ipam() ipam} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipam
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withIpam(Ipam value) {
    if (this.ipam == value) return this;
    Ipam newValue = Objects.requireNonNull(value, "ipam");
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        this.driver,
        newValue,
        this.containers,
        this.options,
        this.internal,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by replacing the {@link Network#containers() containers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the containers map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNetwork withContainers(@Nullable Map<String, ? extends Network.Container> entries) {
    if (this.containers == entries) return this;
    @Nullable Map<String, Network.Container> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        this.driver,
        this.ipam,
        newValue,
        this.options,
        this.internal,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by replacing the {@link Network#options() options} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the options map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNetwork withOptions(@Nullable Map<String, ? extends String> entries) {
    if (this.options == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        this.driver,
        this.ipam,
        this.containers,
        newValue,
        this.internal,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#internal() internal} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for internal (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withInternal(@Nullable Boolean value) {
    if (Objects.equals(this.internal, value)) return this;
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        this.driver,
        this.ipam,
        this.containers,
        this.options,
        value,
        this.enableIPv6,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#enableIPv6() enableIPv6} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableIPv6 (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withEnableIPv6(@Nullable Boolean value) {
    if (Objects.equals(this.enableIPv6, value)) return this;
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        this.driver,
        this.ipam,
        this.containers,
        this.options,
        this.internal,
        value,
        this.labels,
        this.attachable);
  }

  /**
   * Copy the current immutable object by replacing the {@link Network#labels() labels} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the labels map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNetwork withLabels(@Nullable Map<String, ? extends String> entries) {
    if (this.labels == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        this.driver,
        this.ipam,
        this.containers,
        this.options,
        this.internal,
        this.enableIPv6,
        newValue,
        this.attachable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#attachable() attachable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attachable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withAttachable(@Nullable Boolean value) {
    if (Objects.equals(this.attachable, value)) return this;
    return new ImmutableNetwork(
        this.name,
        this.id,
        this.scope,
        this.driver,
        this.ipam,
        this.containers,
        this.options,
        this.internal,
        this.enableIPv6,
        this.labels,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNetwork} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNetwork
        && equalTo(0, (ImmutableNetwork) another);
  }

  private boolean equalTo(int synthetic, ImmutableNetwork another) {
    return name.equals(another.name)
        && id.equals(another.id)
        && scope.equals(another.scope)
        && driver.equals(another.driver)
        && ipam.equals(another.ipam)
        && Objects.equals(containers, another.containers)
        && Objects.equals(options, another.options)
        && Objects.equals(internal, another.internal)
        && Objects.equals(enableIPv6, another.enableIPv6)
        && Objects.equals(labels, another.labels)
        && Objects.equals(attachable, another.attachable);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code id}, {@code scope}, {@code driver}, {@code ipam}, {@code containers}, {@code options}, {@code internal}, {@code enableIPv6}, {@code labels}, {@code attachable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + scope.hashCode();
    h += (h << 5) + driver.hashCode();
    h += (h << 5) + ipam.hashCode();
    h += (h << 5) + Objects.hashCode(containers);
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + Objects.hashCode(internal);
    h += (h << 5) + Objects.hashCode(enableIPv6);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(attachable);
    return h;
  }

  /**
   * Prints the immutable value {@code Network} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Network{"
        + "name=" + name
        + ", id=" + id
        + ", scope=" + scope
        + ", driver=" + driver
        + ", ipam=" + ipam
        + ", containers=" + containers
        + ", options=" + options
        + ", internal=" + internal
        + ", enableIPv6=" + enableIPv6
        + ", labels=" + labels
        + ", attachable=" + attachable
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Network} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Network instance
   */
  public static ImmutableNetwork copyOf(Network instance) {
    if (instance instanceof ImmutableNetwork) {
      return (ImmutableNetwork) instance;
    }
    return ImmutableNetwork.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNetwork ImmutableNetwork}.
   * <pre>
   * ImmutableNetwork.builder()
   *    .name(String) // required {@link Network#name() name}
   *    .id(String) // required {@link Network#id() id}
   *    .scope(String) // required {@link Network#scope() scope}
   *    .driver(String) // required {@link Network#driver() driver}
   *    .ipam(org.mandas.docker.client.messages.Ipam) // required {@link Network#ipam() ipam}
   *    .containers(Map&amp;lt;String, org.mandas.docker.client.messages.Network.Container&amp;gt; | null) // nullable {@link Network#containers() containers}
   *    .options(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link Network#options() options}
   *    .internal(Boolean | null) // nullable {@link Network#internal() internal}
   *    .enableIPv6(Boolean | null) // nullable {@link Network#enableIPv6() enableIPv6}
   *    .labels(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link Network#labels() labels}
   *    .attachable(Boolean | null) // nullable {@link Network#attachable() attachable}
   *    .build();
   * </pre>
   * @return A new ImmutableNetwork builder
   */
  public static ImmutableNetwork.Builder builder() {
    return new ImmutableNetwork.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNetwork ImmutableNetwork}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_SCOPE = 0x4L;
    private static final long INIT_BIT_DRIVER = 0x8L;
    private static final long INIT_BIT_IPAM = 0x10L;
    private long initBits = 0x1fL;

    private String name;
    private String id;
    private String scope;
    private String driver;
    private Ipam ipam;
    private Map<String, Network.Container> containers = null;
    private Map<String, String> options = null;
    private Boolean internal;
    private Boolean enableIPv6;
    private Map<String, String> labels = null;
    private Boolean attachable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Network} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Network instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      id(instance.id());
      scope(instance.scope());
      driver(instance.driver());
      ipam(instance.ipam());
      @Nullable Map<String, Network.Container> containersValue = instance.containers();
      if (containersValue != null) {
        putAllContainers(containersValue);
      }
      @Nullable Map<String, String> optionsValue = instance.options();
      if (optionsValue != null) {
        putAllOptions(optionsValue);
      }
      @Nullable Boolean internalValue = instance.internal();
      if (internalValue != null) {
        internal(internalValue);
      }
      @Nullable Boolean enableIPv6Value = instance.enableIPv6();
      if (enableIPv6Value != null) {
        enableIPv6(enableIPv6Value);
      }
      @Nullable Map<String, String> labelsValue = instance.labels();
      if (labelsValue != null) {
        putAllLabels(labelsValue);
      }
      @Nullable Boolean attachableValue = instance.attachable();
      if (attachableValue != null) {
        attachable(attachableValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Network#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#scope() scope} attribute.
     * @param scope The value for scope 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Scope")
    public final Builder scope(String scope) {
      this.scope = Objects.requireNonNull(scope, "scope");
      initBits &= ~INIT_BIT_SCOPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#driver() driver} attribute.
     * @param driver The value for driver 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Driver")
    public final Builder driver(String driver) {
      this.driver = Objects.requireNonNull(driver, "driver");
      initBits &= ~INIT_BIT_DRIVER;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#ipam() ipam} attribute.
     * @param ipam The value for ipam 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IPAM")
    public final Builder ipam(Ipam ipam) {
      this.ipam = Objects.requireNonNull(ipam, "ipam");
      initBits &= ~INIT_BIT_IPAM;
      return this;
    }

    /**
     * Put one entry to the {@link Network#containers() containers} map.
     * @param key The key in the containers map
     * @param value The associated value in the containers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addContainer(String key, Network.Container value) {
      if (this.containers == null) {
        this.containers = new LinkedHashMap<String, Network.Container>();
      }
      this.containers.put(
          Objects.requireNonNull(key, "containers key"),
          value == null ? Objects.requireNonNull(value, "containers value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link Network#containers() containers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addContainer(Map.Entry<String, ? extends Network.Container> entry) {
      if (this.containers == null) {
        this.containers = new LinkedHashMap<String, Network.Container>();
      }
      String k = entry.getKey();
      Network.Container v = entry.getValue();
      this.containers.put(
          Objects.requireNonNull(k, "containers key"),
          v == null ? Objects.requireNonNull(v, "containers value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Network#containers() containers} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the containers map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Containers")
    public final Builder containers(@Nullable Map<String, ? extends Network.Container> entries) {
      if (entries == null) {
        this.containers = null;
        return this;
      }
      this.containers = new LinkedHashMap<String, Network.Container>();
      return putAllContainers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Network#containers() containers} map. Nulls are not permitted
     * @param entries The entries that will be added to the containers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllContainers(Map<String, ? extends Network.Container> entries) {
      if (this.containers == null) {
        this.containers = new LinkedHashMap<String, Network.Container>();
      }
      for (Map.Entry<String, ? extends Network.Container> e : entries.entrySet()) {
        String k = e.getKey();
        Network.Container v = e.getValue();
        this.containers.put(
            Objects.requireNonNull(k, "containers key"),
            v == null ? Objects.requireNonNull(v, "containers value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Network#options() options} map.
     * @param key The key in the options map
     * @param value The associated value in the options map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOption(String key, String value) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      this.options.put(
          Objects.requireNonNull(key, "options key"),
          value == null ? Objects.requireNonNull(value, "options value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link Network#options() options} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOption(Map.Entry<String, ? extends String> entry) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.options.put(
          Objects.requireNonNull(k, "options key"),
          v == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Network#options() options} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Options")
    public final Builder options(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.options = null;
        return this;
      }
      this.options = new LinkedHashMap<String, String>();
      return putAllOptions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Network#options() options} map. Nulls are not permitted
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllOptions(Map<String, ? extends String> entries) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.options.put(
            Objects.requireNonNull(k, "options key"),
            v == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Network#internal() internal} attribute.
     * @param internal The value for internal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Internal")
    public final Builder internal(@Nullable Boolean internal) {
      this.internal = internal;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#enableIPv6() enableIPv6} attribute.
     * @param enableIPv6 The value for enableIPv6 (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("EnableIPv6")
    public final Builder enableIPv6(@Nullable Boolean enableIPv6) {
      this.enableIPv6 = enableIPv6;
      return this;
    }

    /**
     * Put one entry to the {@link Network#labels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(String key, String value) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      this.labels.put(
          Objects.requireNonNull(key, "labels key"),
          value == null ? Objects.requireNonNull(value, "labels value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link Network#labels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.labels.put(
          Objects.requireNonNull(k, "labels key"),
          v == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Network#labels() labels} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Labels")
    public final Builder labels(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.labels = null;
        return this;
      }
      this.labels = new LinkedHashMap<String, String>();
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Network#labels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabels(Map<String, ? extends String> entries) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.labels.put(
            Objects.requireNonNull(k, "labels key"),
            v == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Network#attachable() attachable} attribute.
     * @param attachable The value for attachable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Attachable")
    public final Builder attachable(@Nullable Boolean attachable) {
      this.attachable = attachable;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNetwork ImmutableNetwork}.
     * @return An immutable instance of Network
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNetwork build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNetwork(
          name,
          id,
          scope,
          driver,
          ipam,
          containers == null ? null : createUnmodifiableMap(false, false, containers),
          options == null ? null : createUnmodifiableMap(false, false, options),
          internal,
          enableIPv6,
          labels == null ? null : createUnmodifiableMap(false, false, labels),
          attachable);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_SCOPE) != 0) attributes.add("scope");
      if ((initBits & INIT_BIT_DRIVER) != 0) attributes.add("driver");
      if ((initBits & INIT_BIT_IPAM) != 0) attributes.add("ipam");
      return "Cannot build Network, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link Network.Container}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableNetwork.Container.builder()}.
   */
  static final class Container implements Network.Container {
    private final @Nullable String name;
    private final String endpointId;
    private final String macAddress;
    private final String ipv4Address;
    private final String ipv6Address;

    private Container(
        @Nullable String name,
        String endpointId,
        String macAddress,
        String ipv4Address,
        String ipv6Address) {
      this.name = name;
      this.endpointId = endpointId;
      this.macAddress = macAddress;
      this.ipv4Address = ipv4Address;
      this.ipv6Address = ipv6Address;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @JsonProperty("Name")
    @Override
    public @Nullable String name() {
      return name;
    }

    /**
     * @return The value of the {@code endpointId} attribute
     */
    @JsonProperty("EndpointID")
    @Override
    public String endpointId() {
      return endpointId;
    }

    /**
     * @return The value of the {@code macAddress} attribute
     */
    @JsonProperty("MacAddress")
    @Override
    public String macAddress() {
      return macAddress;
    }

    /**
     * @return The value of the {@code ipv4Address} attribute
     */
    @JsonProperty("IPv4Address")
    @Override
    public String ipv4Address() {
      return ipv4Address;
    }

    /**
     * @return The value of the {@code ipv6Address} attribute
     */
    @JsonProperty("IPv6Address")
    @Override
    public String ipv6Address() {
      return ipv6Address;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Network.Container#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableNetwork.Container withName(@Nullable String value) {
      if (Objects.equals(this.name, value)) return this;
      return new ImmutableNetwork.Container(value, this.endpointId, this.macAddress, this.ipv4Address, this.ipv6Address);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Network.Container#endpointId() endpointId} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for endpointId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableNetwork.Container withEndpointId(String value) {
      String newValue = Objects.requireNonNull(value, "endpointId");
      if (this.endpointId.equals(newValue)) return this;
      return new ImmutableNetwork.Container(this.name, newValue, this.macAddress, this.ipv4Address, this.ipv6Address);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Network.Container#macAddress() macAddress} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for macAddress
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableNetwork.Container withMacAddress(String value) {
      String newValue = Objects.requireNonNull(value, "macAddress");
      if (this.macAddress.equals(newValue)) return this;
      return new ImmutableNetwork.Container(this.name, this.endpointId, newValue, this.ipv4Address, this.ipv6Address);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Network.Container#ipv4Address() ipv4Address} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for ipv4Address
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableNetwork.Container withIpv4Address(String value) {
      String newValue = Objects.requireNonNull(value, "ipv4Address");
      if (this.ipv4Address.equals(newValue)) return this;
      return new ImmutableNetwork.Container(this.name, this.endpointId, this.macAddress, newValue, this.ipv6Address);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Network.Container#ipv6Address() ipv6Address} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for ipv6Address
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableNetwork.Container withIpv6Address(String value) {
      String newValue = Objects.requireNonNull(value, "ipv6Address");
      if (this.ipv6Address.equals(newValue)) return this;
      return new ImmutableNetwork.Container(this.name, this.endpointId, this.macAddress, this.ipv4Address, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Container} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableNetwork.Container
          && equalTo(0, (ImmutableNetwork.Container) another);
    }

    private boolean equalTo(int synthetic, ImmutableNetwork.Container another) {
      return Objects.equals(name, another.name)
          && endpointId.equals(another.endpointId)
          && macAddress.equals(another.macAddress)
          && ipv4Address.equals(another.ipv4Address)
          && ipv6Address.equals(another.ipv6Address);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code endpointId}, {@code macAddress}, {@code ipv4Address}, {@code ipv6Address}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(name);
      h += (h << 5) + endpointId.hashCode();
      h += (h << 5) + macAddress.hashCode();
      h += (h << 5) + ipv4Address.hashCode();
      h += (h << 5) + ipv6Address.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Container} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Container{"
          + "name=" + name
          + ", endpointId=" + endpointId
          + ", macAddress=" + macAddress
          + ", ipv4Address=" + ipv4Address
          + ", ipv6Address=" + ipv6Address
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link Network.Container} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Container instance
     */
    public static ImmutableNetwork.Container copyOf(Network.Container instance) {
      if (instance instanceof ImmutableNetwork.Container) {
        return (ImmutableNetwork.Container) instance;
      }
      return ImmutableNetwork.Container.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableNetwork.Container Container}.
     * <pre>
     * ImmutableNetwork.Container.builder()
     *    .name(String | null) // nullable {@link Network.Container#name() name}
     *    .endpointId(String) // required {@link Network.Container#endpointId() endpointId}
     *    .macAddress(String) // required {@link Network.Container#macAddress() macAddress}
     *    .ipv4Address(String) // required {@link Network.Container#ipv4Address() ipv4Address}
     *    .ipv6Address(String) // required {@link Network.Container#ipv6Address() ipv6Address}
     *    .build();
     * </pre>
     * @return A new Container builder
     */
    public static ImmutableNetwork.Container.Builder builder() {
      return new ImmutableNetwork.Container.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableNetwork.Container Container}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    static final class Builder {
      private static final long INIT_BIT_ENDPOINT_ID = 0x1L;
      private static final long INIT_BIT_MAC_ADDRESS = 0x2L;
      private static final long INIT_BIT_IPV4_ADDRESS = 0x4L;
      private static final long INIT_BIT_IPV6_ADDRESS = 0x8L;
      private long initBits = 0xfL;

      private String name;
      private String endpointId;
      private String macAddress;
      private String ipv4Address;
      private String ipv6Address;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Container} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Network.Container instance) {
        Objects.requireNonNull(instance, "instance");
        @Nullable String nameValue = instance.name();
        if (nameValue != null) {
          name(nameValue);
        }
        endpointId(instance.endpointId());
        macAddress(instance.macAddress());
        ipv4Address(instance.ipv4Address());
        ipv6Address(instance.ipv6Address());
        return this;
      }

      /**
       * Initializes the value for the {@link Network.Container#name() name} attribute.
       * @param name The value for name (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Name")
      public final Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      /**
       * Initializes the value for the {@link Network.Container#endpointId() endpointId} attribute.
       * @param endpointId The value for endpointId 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("EndpointID")
      public final Builder endpointId(String endpointId) {
        this.endpointId = Objects.requireNonNull(endpointId, "endpointId");
        initBits &= ~INIT_BIT_ENDPOINT_ID;
        return this;
      }

      /**
       * Initializes the value for the {@link Network.Container#macAddress() macAddress} attribute.
       * @param macAddress The value for macAddress 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("MacAddress")
      public final Builder macAddress(String macAddress) {
        this.macAddress = Objects.requireNonNull(macAddress, "macAddress");
        initBits &= ~INIT_BIT_MAC_ADDRESS;
        return this;
      }

      /**
       * Initializes the value for the {@link Network.Container#ipv4Address() ipv4Address} attribute.
       * @param ipv4Address The value for ipv4Address 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("IPv4Address")
      public final Builder ipv4Address(String ipv4Address) {
        this.ipv4Address = Objects.requireNonNull(ipv4Address, "ipv4Address");
        initBits &= ~INIT_BIT_IPV4_ADDRESS;
        return this;
      }

      /**
       * Initializes the value for the {@link Network.Container#ipv6Address() ipv6Address} attribute.
       * @param ipv6Address The value for ipv6Address 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("IPv6Address")
      public final Builder ipv6Address(String ipv6Address) {
        this.ipv6Address = Objects.requireNonNull(ipv6Address, "ipv6Address");
        initBits &= ~INIT_BIT_IPV6_ADDRESS;
        return this;
      }

      /**
       * Builds a new {@link ImmutableNetwork.Container Container}.
       * @return An immutable instance of Container
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableNetwork.Container build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableNetwork.Container(name, endpointId, macAddress, ipv4Address, ipv6Address);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_ENDPOINT_ID) != 0) attributes.add("endpointId");
        if ((initBits & INIT_BIT_MAC_ADDRESS) != 0) attributes.add("macAddress");
        if ((initBits & INIT_BIT_IPV4_ADDRESS) != 0) attributes.add("ipv4Address");
        if ((initBits & INIT_BIT_IPV6_ADDRESS) != 0) attributes.add("ipv6Address");
        return "Cannot build Container, some of required attributes are not set " + attributes;
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
