package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link Network}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNetwork.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableNetwork implements Network {
  private final String id;
  private final Version version;
  private final Date createdAt;
  private final Date updatedAt;
  private final NetworkSpec spec;
  private final Driver driverState;
  private final IpamOptions ipamOptions;

  private ImmutableNetwork(
      String id,
      Version version,
      Date createdAt,
      Date updatedAt,
      NetworkSpec spec,
      Driver driverState,
      IpamOptions ipamOptions) {
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.spec = spec;
    this.driverState = driverState;
    this.ipamOptions = ipamOptions;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("Version")
  @Override
  public Version version() {
    return version;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @JsonProperty("CreatedAt")
  @Override
  public Date createdAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code updatedAt} attribute
   */
  @JsonProperty("UpdatedAt")
  @Override
  public Date updatedAt() {
    return updatedAt;
  }

  /**
   * @return The value of the {@code spec} attribute
   */
  @JsonProperty("Spec")
  @Override
  public NetworkSpec spec() {
    return spec;
  }

  /**
   * @return The value of the {@code driverState} attribute
   */
  @JsonProperty("DriverState")
  @Override
  public Driver driverState() {
    return driverState;
  }

  /**
   * @return The value of the {@code ipamOptions} attribute
   */
  @JsonProperty("IPAMOptions")
  @Override
  public IpamOptions ipamOptions() {
    return ipamOptions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableNetwork(
        newValue,
        this.version,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.driverState,
        this.ipamOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withVersion(Version value) {
    if (this.version == value) return this;
    Version newValue = Objects.requireNonNull(value, "version");
    return new ImmutableNetwork(
        this.id,
        newValue,
        this.createdAt,
        this.updatedAt,
        this.spec,
        this.driverState,
        this.ipamOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withCreatedAt(Date value) {
    if (this.createdAt == value) return this;
    Date newValue = Objects.requireNonNull(value, "createdAt");
    return new ImmutableNetwork(this.id, this.version, newValue, this.updatedAt, this.spec, this.driverState, this.ipamOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withUpdatedAt(Date value) {
    if (this.updatedAt == value) return this;
    Date newValue = Objects.requireNonNull(value, "updatedAt");
    return new ImmutableNetwork(this.id, this.version, this.createdAt, newValue, this.spec, this.driverState, this.ipamOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#spec() spec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for spec
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withSpec(NetworkSpec value) {
    if (this.spec == value) return this;
    NetworkSpec newValue = Objects.requireNonNull(value, "spec");
    return new ImmutableNetwork(
        this.id,
        this.version,
        this.createdAt,
        this.updatedAt,
        newValue,
        this.driverState,
        this.ipamOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#driverState() driverState} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for driverState
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withDriverState(Driver value) {
    if (this.driverState == value) return this;
    Driver newValue = Objects.requireNonNull(value, "driverState");
    return new ImmutableNetwork(this.id, this.version, this.createdAt, this.updatedAt, this.spec, newValue, this.ipamOptions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Network#ipamOptions() ipamOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipamOptions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNetwork withIpamOptions(IpamOptions value) {
    if (this.ipamOptions == value) return this;
    IpamOptions newValue = Objects.requireNonNull(value, "ipamOptions");
    return new ImmutableNetwork(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.driverState, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNetwork} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNetwork
        && equalTo(0, (ImmutableNetwork) another);
  }

  private boolean equalTo(int synthetic, ImmutableNetwork another) {
    return id.equals(another.id)
        && version.equals(another.version)
        && createdAt.equals(another.createdAt)
        && updatedAt.equals(another.updatedAt)
        && spec.equals(another.spec)
        && driverState.equals(another.driverState)
        && ipamOptions.equals(another.ipamOptions);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}, {@code createdAt}, {@code updatedAt}, {@code spec}, {@code driverState}, {@code ipamOptions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + updatedAt.hashCode();
    h += (h << 5) + spec.hashCode();
    h += (h << 5) + driverState.hashCode();
    h += (h << 5) + ipamOptions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Network} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Network{"
        + "id=" + id
        + ", version=" + version
        + ", createdAt=" + createdAt
        + ", updatedAt=" + updatedAt
        + ", spec=" + spec
        + ", driverState=" + driverState
        + ", ipamOptions=" + ipamOptions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Network} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Network instance
   */
  public static ImmutableNetwork copyOf(Network instance) {
    if (instance instanceof ImmutableNetwork) {
      return (ImmutableNetwork) instance;
    }
    return ImmutableNetwork.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNetwork ImmutableNetwork}.
   * <pre>
   * ImmutableNetwork.builder()
   *    .id(String) // required {@link Network#id() id}
   *    .version(org.mandas.docker.client.messages.swarm.Version) // required {@link Network#version() version}
   *    .createdAt(Date) // required {@link Network#createdAt() createdAt}
   *    .updatedAt(Date) // required {@link Network#updatedAt() updatedAt}
   *    .spec(org.mandas.docker.client.messages.swarm.NetworkSpec) // required {@link Network#spec() spec}
   *    .driverState(org.mandas.docker.client.messages.swarm.Driver) // required {@link Network#driverState() driverState}
   *    .ipamOptions(org.mandas.docker.client.messages.swarm.IpamOptions) // required {@link Network#ipamOptions() ipamOptions}
   *    .build();
   * </pre>
   * @return A new ImmutableNetwork builder
   */
  public static ImmutableNetwork.Builder builder() {
    return new ImmutableNetwork.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNetwork ImmutableNetwork}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VERSION = 0x2L;
    private static final long INIT_BIT_CREATED_AT = 0x4L;
    private static final long INIT_BIT_UPDATED_AT = 0x8L;
    private static final long INIT_BIT_SPEC = 0x10L;
    private static final long INIT_BIT_DRIVER_STATE = 0x20L;
    private static final long INIT_BIT_IPAM_OPTIONS = 0x40L;
    private long initBits = 0x7fL;

    private String id;
    private Version version;
    private Date createdAt;
    private Date updatedAt;
    private NetworkSpec spec;
    private Driver driverState;
    private IpamOptions ipamOptions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Network} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Network instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      version(instance.version());
      createdAt(instance.createdAt());
      updatedAt(instance.updatedAt());
      spec(instance.spec());
      driverState(instance.driverState());
      ipamOptions(instance.ipamOptions());
      return this;
    }

    /**
     * Initializes the value for the {@link Network#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Version")
    public final Builder version(Version version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CreatedAt")
    public final Builder createdAt(Date createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("UpdatedAt")
    public final Builder updatedAt(Date updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      initBits &= ~INIT_BIT_UPDATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#spec() spec} attribute.
     * @param spec The value for spec 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Spec")
    public final Builder spec(NetworkSpec spec) {
      this.spec = Objects.requireNonNull(spec, "spec");
      initBits &= ~INIT_BIT_SPEC;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#driverState() driverState} attribute.
     * @param driverState The value for driverState 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("DriverState")
    public final Builder driverState(Driver driverState) {
      this.driverState = Objects.requireNonNull(driverState, "driverState");
      initBits &= ~INIT_BIT_DRIVER_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link Network#ipamOptions() ipamOptions} attribute.
     * @param ipamOptions The value for ipamOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("IPAMOptions")
    public final Builder ipamOptions(IpamOptions ipamOptions) {
      this.ipamOptions = Objects.requireNonNull(ipamOptions, "ipamOptions");
      initBits &= ~INIT_BIT_IPAM_OPTIONS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNetwork ImmutableNetwork}.
     * @return An immutable instance of Network
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNetwork build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNetwork(id, version, createdAt, updatedAt, spec, driverState, ipamOptions);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_UPDATED_AT) != 0) attributes.add("updatedAt");
      if ((initBits & INIT_BIT_SPEC) != 0) attributes.add("spec");
      if ((initBits & INIT_BIT_DRIVER_STATE) != 0) attributes.add("driverState");
      if ((initBits & INIT_BIT_IPAM_OPTIONS) != 0) attributes.add("ipamOptions");
      return "Cannot build Network, some of required attributes are not set " + attributes;
    }
  }
}
