package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link SwarmSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSwarmSpec.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableSwarmSpec implements SwarmSpec {
  private final @Nullable String name;
  private final @Nullable Map<String, String> labels;
  private final @Nullable OrchestrationConfig orchestration;
  private final @Nullable RaftConfig raft;
  private final @Nullable DispatcherConfig dispatcher;
  private final @Nullable CaConfig caConfig;
  private final @Nullable EncryptionConfig encryptionConfig;
  private final @Nullable TaskDefaults taskDefaults;

  private ImmutableSwarmSpec(
      @Nullable String name,
      @Nullable Map<String, String> labels,
      @Nullable OrchestrationConfig orchestration,
      @Nullable RaftConfig raft,
      @Nullable DispatcherConfig dispatcher,
      @Nullable CaConfig caConfig,
      @Nullable EncryptionConfig encryptionConfig,
      @Nullable TaskDefaults taskDefaults) {
    this.name = name;
    this.labels = labels;
    this.orchestration = orchestration;
    this.raft = raft;
    this.dispatcher = dispatcher;
    this.caConfig = caConfig;
    this.encryptionConfig = encryptionConfig;
    this.taskDefaults = taskDefaults;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("Labels")
  @Override
  public @Nullable Map<String, String> labels() {
    return labels;
  }

  /**
   * @return The value of the {@code orchestration} attribute
   */
  @JsonProperty("Orchestration")
  @Override
  public @Nullable OrchestrationConfig orchestration() {
    return orchestration;
  }

  /**
   * @return The value of the {@code raft} attribute
   */
  @JsonProperty("Raft")
  @Override
  public @Nullable RaftConfig raft() {
    return raft;
  }

  /**
   * @return The value of the {@code dispatcher} attribute
   */
  @JsonProperty("Dispatcher")
  @Override
  public @Nullable DispatcherConfig dispatcher() {
    return dispatcher;
  }

  /**
   * @return The value of the {@code caConfig} attribute
   */
  @JsonProperty("CAConfig")
  @Override
  public @Nullable CaConfig caConfig() {
    return caConfig;
  }

  /**
   * @return The value of the {@code encryptionConfig} attribute
   */
  @JsonProperty("EncryptionConfig")
  @Override
  public @Nullable EncryptionConfig encryptionConfig() {
    return encryptionConfig;
  }

  /**
   * @return The value of the {@code taskDefaults} attribute
   */
  @JsonProperty("TaskDefaults")
  @Override
  public @Nullable TaskDefaults taskDefaults() {
    return taskDefaults;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmSpec withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableSwarmSpec(
        value,
        this.labels,
        this.orchestration,
        this.raft,
        this.dispatcher,
        this.caConfig,
        this.encryptionConfig,
        this.taskDefaults);
  }

  /**
   * Copy the current immutable object by replacing the {@link SwarmSpec#labels() labels} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the labels map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSwarmSpec withLabels(@Nullable Map<String, ? extends String> entries) {
    if (this.labels == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableSwarmSpec(
        this.name,
        newValue,
        this.orchestration,
        this.raft,
        this.dispatcher,
        this.caConfig,
        this.encryptionConfig,
        this.taskDefaults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmSpec#orchestration() orchestration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for orchestration (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmSpec withOrchestration(@Nullable OrchestrationConfig value) {
    if (this.orchestration == value) return this;
    return new ImmutableSwarmSpec(
        this.name,
        this.labels,
        value,
        this.raft,
        this.dispatcher,
        this.caConfig,
        this.encryptionConfig,
        this.taskDefaults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmSpec#raft() raft} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for raft (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmSpec withRaft(@Nullable RaftConfig value) {
    if (this.raft == value) return this;
    return new ImmutableSwarmSpec(
        this.name,
        this.labels,
        this.orchestration,
        value,
        this.dispatcher,
        this.caConfig,
        this.encryptionConfig,
        this.taskDefaults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmSpec#dispatcher() dispatcher} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dispatcher (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmSpec withDispatcher(@Nullable DispatcherConfig value) {
    if (this.dispatcher == value) return this;
    return new ImmutableSwarmSpec(
        this.name,
        this.labels,
        this.orchestration,
        this.raft,
        value,
        this.caConfig,
        this.encryptionConfig,
        this.taskDefaults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmSpec#caConfig() caConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caConfig (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmSpec withCaConfig(@Nullable CaConfig value) {
    if (this.caConfig == value) return this;
    return new ImmutableSwarmSpec(
        this.name,
        this.labels,
        this.orchestration,
        this.raft,
        this.dispatcher,
        value,
        this.encryptionConfig,
        this.taskDefaults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmSpec#encryptionConfig() encryptionConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for encryptionConfig (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmSpec withEncryptionConfig(@Nullable EncryptionConfig value) {
    if (this.encryptionConfig == value) return this;
    return new ImmutableSwarmSpec(
        this.name,
        this.labels,
        this.orchestration,
        this.raft,
        this.dispatcher,
        this.caConfig,
        value,
        this.taskDefaults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmSpec#taskDefaults() taskDefaults} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for taskDefaults (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmSpec withTaskDefaults(@Nullable TaskDefaults value) {
    if (this.taskDefaults == value) return this;
    return new ImmutableSwarmSpec(
        this.name,
        this.labels,
        this.orchestration,
        this.raft,
        this.dispatcher,
        this.caConfig,
        this.encryptionConfig,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSwarmSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSwarmSpec
        && equalTo(0, (ImmutableSwarmSpec) another);
  }

  private boolean equalTo(int synthetic, ImmutableSwarmSpec another) {
    return Objects.equals(name, another.name)
        && Objects.equals(labels, another.labels)
        && Objects.equals(orchestration, another.orchestration)
        && Objects.equals(raft, another.raft)
        && Objects.equals(dispatcher, another.dispatcher)
        && Objects.equals(caConfig, another.caConfig)
        && Objects.equals(encryptionConfig, another.encryptionConfig)
        && Objects.equals(taskDefaults, another.taskDefaults);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code labels}, {@code orchestration}, {@code raft}, {@code dispatcher}, {@code caConfig}, {@code encryptionConfig}, {@code taskDefaults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(orchestration);
    h += (h << 5) + Objects.hashCode(raft);
    h += (h << 5) + Objects.hashCode(dispatcher);
    h += (h << 5) + Objects.hashCode(caConfig);
    h += (h << 5) + Objects.hashCode(encryptionConfig);
    h += (h << 5) + Objects.hashCode(taskDefaults);
    return h;
  }

  /**
   * Prints the immutable value {@code SwarmSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SwarmSpec{"
        + "name=" + name
        + ", labels=" + labels
        + ", orchestration=" + orchestration
        + ", raft=" + raft
        + ", dispatcher=" + dispatcher
        + ", caConfig=" + caConfig
        + ", encryptionConfig=" + encryptionConfig
        + ", taskDefaults=" + taskDefaults
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SwarmSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SwarmSpec instance
   */
  public static ImmutableSwarmSpec copyOf(SwarmSpec instance) {
    if (instance instanceof ImmutableSwarmSpec) {
      return (ImmutableSwarmSpec) instance;
    }
    return ImmutableSwarmSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSwarmSpec ImmutableSwarmSpec}.
   * <pre>
   * ImmutableSwarmSpec.builder()
   *    .name(String | null) // nullable {@link SwarmSpec#name() name}
   *    .labels(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link SwarmSpec#labels() labels}
   *    .orchestration(org.mandas.docker.client.messages.swarm.OrchestrationConfig | null) // nullable {@link SwarmSpec#orchestration() orchestration}
   *    .raft(org.mandas.docker.client.messages.swarm.RaftConfig | null) // nullable {@link SwarmSpec#raft() raft}
   *    .dispatcher(org.mandas.docker.client.messages.swarm.DispatcherConfig | null) // nullable {@link SwarmSpec#dispatcher() dispatcher}
   *    .caConfig(org.mandas.docker.client.messages.swarm.CaConfig | null) // nullable {@link SwarmSpec#caConfig() caConfig}
   *    .encryptionConfig(org.mandas.docker.client.messages.swarm.EncryptionConfig | null) // nullable {@link SwarmSpec#encryptionConfig() encryptionConfig}
   *    .taskDefaults(org.mandas.docker.client.messages.swarm.TaskDefaults | null) // nullable {@link SwarmSpec#taskDefaults() taskDefaults}
   *    .build();
   * </pre>
   * @return A new ImmutableSwarmSpec builder
   */
  public static ImmutableSwarmSpec.Builder builder() {
    return new ImmutableSwarmSpec.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSwarmSpec ImmutableSwarmSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements SwarmSpec.Builder {
    private String name;
    private Map<String, String> labels = null;
    private OrchestrationConfig orchestration;
    private RaftConfig raft;
    private DispatcherConfig dispatcher;
    private CaConfig caConfig;
    private EncryptionConfig encryptionConfig;
    private TaskDefaults taskDefaults;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SwarmSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SwarmSpec instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable Map<String, String> labelsValue = instance.labels();
      if (labelsValue != null) {
        putAllLabels(labelsValue);
      }
      @Nullable OrchestrationConfig orchestrationValue = instance.orchestration();
      if (orchestrationValue != null) {
        orchestration(orchestrationValue);
      }
      @Nullable RaftConfig raftValue = instance.raft();
      if (raftValue != null) {
        raft(raftValue);
      }
      @Nullable DispatcherConfig dispatcherValue = instance.dispatcher();
      if (dispatcherValue != null) {
        dispatcher(dispatcherValue);
      }
      @Nullable CaConfig caConfigValue = instance.caConfig();
      if (caConfigValue != null) {
        caConfig(caConfigValue);
      }
      @Nullable EncryptionConfig encryptionConfigValue = instance.encryptionConfig();
      if (encryptionConfigValue != null) {
        encryptionConfig(encryptionConfigValue);
      }
      @Nullable TaskDefaults taskDefaultsValue = instance.taskDefaults();
      if (taskDefaultsValue != null) {
        taskDefaults(taskDefaultsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmSpec#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Put one entry to the {@link SwarmSpec#labels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(String key, String value) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      this.labels.put(
          Objects.requireNonNull(key, "labels key"),
          value == null ? Objects.requireNonNull(value, "labels value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link SwarmSpec#labels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.labels.put(
          Objects.requireNonNull(k, "labels key"),
          v == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SwarmSpec#labels() labels} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Labels")
    public final Builder labels(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.labels = null;
        return this;
      }
      this.labels = new LinkedHashMap<String, String>();
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SwarmSpec#labels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabels(Map<String, ? extends String> entries) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.labels.put(
            Objects.requireNonNull(k, "labels key"),
            v == null ? Objects.requireNonNull(v, "labels value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmSpec#orchestration() orchestration} attribute.
     * @param orchestration The value for orchestration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Orchestration")
    public final Builder orchestration(@Nullable OrchestrationConfig orchestration) {
      this.orchestration = orchestration;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmSpec#raft() raft} attribute.
     * @param raft The value for raft (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Raft")
    public final Builder raft(@Nullable RaftConfig raft) {
      this.raft = raft;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmSpec#dispatcher() dispatcher} attribute.
     * @param dispatcher The value for dispatcher (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Dispatcher")
    public final Builder dispatcher(@Nullable DispatcherConfig dispatcher) {
      this.dispatcher = dispatcher;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmSpec#caConfig() caConfig} attribute.
     * @param caConfig The value for caConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CAConfig")
    public final Builder caConfig(@Nullable CaConfig caConfig) {
      this.caConfig = caConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmSpec#encryptionConfig() encryptionConfig} attribute.
     * @param encryptionConfig The value for encryptionConfig (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("EncryptionConfig")
    public final Builder encryptionConfig(@Nullable EncryptionConfig encryptionConfig) {
      this.encryptionConfig = encryptionConfig;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmSpec#taskDefaults() taskDefaults} attribute.
     * @param taskDefaults The value for taskDefaults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("TaskDefaults")
    public final Builder taskDefaults(@Nullable TaskDefaults taskDefaults) {
      this.taskDefaults = taskDefaults;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSwarmSpec ImmutableSwarmSpec}.
     * @return An immutable instance of SwarmSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSwarmSpec build() {
      return new ImmutableSwarmSpec(
          name,
          labels == null ? null : createUnmodifiableMap(false, false, labels),
          orchestration,
          raft,
          dispatcher,
          caConfig,
          encryptionConfig,
          taskDefaults);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
