/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.mount.Driver;

final class ImmutableDriver
implements Driver {
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, String> options;

    private ImmutableDriver(@Nullable String name, @Nullable Map<String, String> options) {
        this.name = name;
        this.options = options;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Options")
    @Nullable
    public Map<String, String> options() {
        return this.options;
    }

    public final ImmutableDriver withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableDriver(value, this.options);
    }

    public final ImmutableDriver withOptions(@Nullable Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableDriver.createUnmodifiableMap(true, false, entries);
        return new ImmutableDriver(this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDriver && this.equalTo(0, (ImmutableDriver)another);
    }

    private boolean equalTo(int synthetic, ImmutableDriver another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.options, another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.options);
        return h;
    }

    public String toString() {
        return "Driver{name=" + this.name + ", options=" + this.options + "}";
    }

    public static ImmutableDriver copyOf(Driver instance) {
        if (instance instanceof ImmutableDriver) {
            return (ImmutableDriver)instance;
        }
        return ImmutableDriver.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements Driver.Builder {
        private String name;
        private Map<String, String> options = null;

        private Builder() {
        }

        public final Builder from(Driver instance) {
            Map<String, String> optionsValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((optionsValue = instance.options()) != null) {
                this.putAllOptions(optionsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder addOption(String key, String value) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            this.options.put(Objects.requireNonNull(key, "options key"), value == null ? Objects.requireNonNull(value, "options value for key: " + key) : value);
            return this;
        }

        public final Builder addOption(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.options.put(Objects.requireNonNull(k, "options key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
            return this;
        }

        @Override
        @JsonProperty(value="Options")
        public final Builder options(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.options = null;
                return this;
            }
            this.options = new LinkedHashMap<String, String>();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "options value for key: " + k) : v);
            }
            return this;
        }

        @Override
        public ImmutableDriver build() {
            return new ImmutableDriver(this.name, this.options == null ? null : ImmutableDriver.createUnmodifiableMap(false, false, this.options));
        }
    }
}

