/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ContainerSpec;
import org.mandas.docker.client.messages.swarm.Driver;
import org.mandas.docker.client.messages.swarm.NetworkAttachmentConfig;
import org.mandas.docker.client.messages.swarm.Placement;
import org.mandas.docker.client.messages.swarm.ResourceRequirements;
import org.mandas.docker.client.messages.swarm.RestartPolicy;
import org.mandas.docker.client.messages.swarm.TaskSpec;

final class ImmutableTaskSpec
implements TaskSpec {
    @Nullable
    private final ContainerSpec containerSpec;
    @Nullable
    private final ResourceRequirements resources;
    @Nullable
    private final RestartPolicy restartPolicy;
    @Nullable
    private final Placement placement;
    @Nullable
    private final List<NetworkAttachmentConfig> networks;
    @Nullable
    private final Driver logDriver;

    private ImmutableTaskSpec(@Nullable ContainerSpec containerSpec, @Nullable ResourceRequirements resources, @Nullable RestartPolicy restartPolicy, @Nullable Placement placement, @Nullable List<NetworkAttachmentConfig> networks, @Nullable Driver logDriver) {
        this.containerSpec = containerSpec;
        this.resources = resources;
        this.restartPolicy = restartPolicy;
        this.placement = placement;
        this.networks = networks;
        this.logDriver = logDriver;
    }

    @Override
    @JsonProperty(value="ContainerSpec")
    @Nullable
    public ContainerSpec containerSpec() {
        return this.containerSpec;
    }

    @Override
    @JsonProperty(value="Resources")
    @Nullable
    public ResourceRequirements resources() {
        return this.resources;
    }

    @Override
    @JsonProperty(value="RestartPolicy")
    @Nullable
    public RestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    @Override
    @JsonProperty(value="Placement")
    @Nullable
    public Placement placement() {
        return this.placement;
    }

    @Override
    @JsonProperty(value="Networks")
    @Nullable
    public List<NetworkAttachmentConfig> networks() {
        return this.networks;
    }

    @Override
    @JsonProperty(value="LogDriver")
    @Nullable
    public Driver logDriver() {
        return this.logDriver;
    }

    public final ImmutableTaskSpec withContainerSpec(@Nullable ContainerSpec value) {
        if (this.containerSpec == value) {
            return this;
        }
        return new ImmutableTaskSpec(value, this.resources, this.restartPolicy, this.placement, this.networks, this.logDriver);
    }

    public final ImmutableTaskSpec withResources(@Nullable ResourceRequirements value) {
        if (this.resources == value) {
            return this;
        }
        return new ImmutableTaskSpec(this.containerSpec, value, this.restartPolicy, this.placement, this.networks, this.logDriver);
    }

    public final ImmutableTaskSpec withRestartPolicy(@Nullable RestartPolicy value) {
        if (this.restartPolicy == value) {
            return this;
        }
        return new ImmutableTaskSpec(this.containerSpec, this.resources, value, this.placement, this.networks, this.logDriver);
    }

    public final ImmutableTaskSpec withPlacement(@Nullable Placement value) {
        if (this.placement == value) {
            return this;
        }
        return new ImmutableTaskSpec(this.containerSpec, this.resources, this.restartPolicy, value, this.networks, this.logDriver);
    }

    public final ImmutableTaskSpec withNetworks(NetworkAttachmentConfig ... elements) {
        if (elements == null) {
            return new ImmutableTaskSpec(this.containerSpec, this.resources, this.restartPolicy, this.placement, null, this.logDriver);
        }
        List<NetworkAttachmentConfig> newValue = Arrays.asList(elements) == null ? null : ImmutableTaskSpec.createUnmodifiableList(false, ImmutableTaskSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTaskSpec(this.containerSpec, this.resources, this.restartPolicy, this.placement, newValue, this.logDriver);
    }

    public final ImmutableTaskSpec withNetworks(@Nullable Iterable<? extends NetworkAttachmentConfig> elements) {
        if (this.networks == elements) {
            return this;
        }
        List<NetworkAttachmentConfig> newValue = elements == null ? null : ImmutableTaskSpec.createUnmodifiableList(false, ImmutableTaskSpec.createSafeList(elements, true, false));
        return new ImmutableTaskSpec(this.containerSpec, this.resources, this.restartPolicy, this.placement, newValue, this.logDriver);
    }

    public final ImmutableTaskSpec withLogDriver(@Nullable Driver value) {
        if (this.logDriver == value) {
            return this;
        }
        return new ImmutableTaskSpec(this.containerSpec, this.resources, this.restartPolicy, this.placement, this.networks, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskSpec && this.equalTo(0, (ImmutableTaskSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableTaskSpec another) {
        return Objects.equals(this.containerSpec, another.containerSpec) && Objects.equals(this.resources, another.resources) && Objects.equals(this.restartPolicy, another.restartPolicy) && Objects.equals(this.placement, another.placement) && Objects.equals(this.networks, another.networks) && Objects.equals(this.logDriver, another.logDriver);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.containerSpec);
        h += (h << 5) + Objects.hashCode(this.resources);
        h += (h << 5) + Objects.hashCode(this.restartPolicy);
        h += (h << 5) + Objects.hashCode(this.placement);
        h += (h << 5) + Objects.hashCode(this.networks);
        h += (h << 5) + Objects.hashCode(this.logDriver);
        return h;
    }

    public String toString() {
        return "TaskSpec{containerSpec=" + this.containerSpec + ", resources=" + this.resources + ", restartPolicy=" + this.restartPolicy + ", placement=" + this.placement + ", networks=" + this.networks + ", logDriver=" + this.logDriver + "}";
    }

    public static ImmutableTaskSpec copyOf(TaskSpec instance) {
        if (instance instanceof ImmutableTaskSpec) {
            return (ImmutableTaskSpec)instance;
        }
        return ImmutableTaskSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements TaskSpec.Builder {
        private ContainerSpec containerSpec;
        private ResourceRequirements resources;
        private RestartPolicy restartPolicy;
        private Placement placement;
        private List<NetworkAttachmentConfig> networks = null;
        private Driver logDriver;

        private Builder() {
        }

        public final Builder from(TaskSpec instance) {
            Driver logDriverValue;
            List<NetworkAttachmentConfig> networksValue;
            Placement placementValue;
            RestartPolicy restartPolicyValue;
            ResourceRequirements resourcesValue;
            Objects.requireNonNull(instance, "instance");
            ContainerSpec containerSpecValue = instance.containerSpec();
            if (containerSpecValue != null) {
                this.containerSpec(containerSpecValue);
            }
            if ((resourcesValue = instance.resources()) != null) {
                this.resources(resourcesValue);
            }
            if ((restartPolicyValue = instance.restartPolicy()) != null) {
                this.restartPolicy(restartPolicyValue);
            }
            if ((placementValue = instance.placement()) != null) {
                this.placement(placementValue);
            }
            if ((networksValue = instance.networks()) != null) {
                this.addAllNetworks(networksValue);
            }
            if ((logDriverValue = instance.logDriver()) != null) {
                this.logDriver(logDriverValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="ContainerSpec")
        public final Builder containerSpec(@Nullable ContainerSpec containerSpec) {
            this.containerSpec = containerSpec;
            return this;
        }

        @Override
        @JsonProperty(value="Resources")
        public final Builder resources(@Nullable ResourceRequirements resources) {
            this.resources = resources;
            return this;
        }

        @Override
        @JsonProperty(value="RestartPolicy")
        public final Builder restartPolicy(@Nullable RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        @Override
        @JsonProperty(value="Placement")
        public final Builder placement(@Nullable Placement placement) {
            this.placement = placement;
            return this;
        }

        public final Builder network(NetworkAttachmentConfig element) {
            if (this.networks == null) {
                this.networks = new ArrayList<NetworkAttachmentConfig>();
            }
            this.networks.add(Objects.requireNonNull(element, "networks element"));
            return this;
        }

        @Override
        public final Builder networks(NetworkAttachmentConfig ... elements) {
            if (this.networks == null) {
                this.networks = new ArrayList<NetworkAttachmentConfig>();
            }
            for (NetworkAttachmentConfig element : elements) {
                this.networks.add(Objects.requireNonNull(element, "networks element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Networks")
        public final Builder networks(@Nullable Iterable<? extends NetworkAttachmentConfig> elements) {
            if (elements == null) {
                this.networks = null;
                return this;
            }
            this.networks = new ArrayList<NetworkAttachmentConfig>();
            return this.addAllNetworks(elements);
        }

        public final Builder addAllNetworks(Iterable<? extends NetworkAttachmentConfig> elements) {
            Objects.requireNonNull(elements, "networks element");
            if (this.networks == null) {
                this.networks = new ArrayList<NetworkAttachmentConfig>();
            }
            for (NetworkAttachmentConfig networkAttachmentConfig : elements) {
                this.networks.add(Objects.requireNonNull(networkAttachmentConfig, "networks element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="LogDriver")
        public final Builder logDriver(@Nullable Driver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        @Override
        public ImmutableTaskSpec build() {
            return new ImmutableTaskSpec(this.containerSpec, this.resources, this.restartPolicy, this.placement, this.networks == null ? null : ImmutableTaskSpec.createUnmodifiableList(true, this.networks), this.logDriver);
        }
    }
}

