/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.Bind;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.HTreeMap;
import org.mapdb.Pump;
import org.mapdb.Queues;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.SerializerPojo;
import org.mapdb.Store;
import org.mapdb.StoreHeap;
import org.mapdb.TxEngine;

public class DB
implements Closeable {
    protected static final Logger LOG = Logger.getLogger(DB.class.getName());
    public static final String METRICS_DATA_WRITE = "data.write";
    public static final String METRICS_RECORD_WRITE = "record.write";
    public static final String METRICS_DATA_READ = "data.read";
    public static final String METRICS_RECORD_READ = "record.read";
    public static final String METRICS_CACHE_HIT = "cache.hit";
    public static final String METRICS_CACHE_MISS = "cache.miss";
    protected final boolean strictDBGet;
    protected final boolean deleteFilesAfterClose;
    protected Engine engine;
    protected Map<String, WeakReference<?>> namesInstanciated = new HashMap();
    protected Map<IdentityWrapper, String> namesLookup = new ConcurrentHashMap<IdentityWrapper, String>();
    protected SortedMap<String, Object> catalog;
    protected ScheduledExecutorService executor = null;
    protected SerializerPojo serializerPojo;
    protected ScheduledExecutorService metricsExecutor;
    protected ScheduledExecutorService storeExecutor;
    protected ScheduledExecutorService cacheExecutor;
    protected final Set<String> unknownClasses = new ConcurrentSkipListSet<String>();
    protected final ReadWriteLock consistencyLock;

    public DB(Engine engine) {
        this(engine, false, false, null, false, null, 0L, null, null, null);
    }

    public DB(final Engine engine, boolean strictDBGet, boolean deleteFilesAfterClose, ScheduledExecutorService executor, boolean lockDisable, ScheduledExecutorService metricsExecutor, long metricsLogInterval, ScheduledExecutorService storeExecutor, ScheduledExecutorService cacheExecutor, Fun.Function1<Class, String> classLoader) {
        this.engine = engine;
        this.strictDBGet = strictDBGet;
        this.deleteFilesAfterClose = deleteFilesAfterClose;
        this.executor = executor;
        this.consistencyLock = lockDisable ? new Store.ReadWriteSingleLock(Store.NOLOCK) : new ReentrantReadWriteLock();
        this.metricsExecutor = metricsExecutor == null ? executor : metricsExecutor;
        this.storeExecutor = storeExecutor;
        this.cacheExecutor = cacheExecutor;
        this.serializerPojo = new SerializerPojo(new Fun.Function1<String, Object>(){

            @Override
            public String run(Object o) {
                if (o == DB.this) {
                    return "$$DB_OBJECT_Q!#!@#!#@9009a09sd";
                }
                return DB.this.getNameForObject(o);
            }
        }, new Fun.Function1<Object, String>(){

            @Override
            public Object run(String name) {
                Object ret = DB.this.get(name);
                if (ret == null && "$$DB_OBJECT_Q!#!@#!#@9009a09sd".equals(name)) {
                    return DB.this;
                }
                return ret;
            }
        }, new Fun.Function1Int<SerializerPojo.ClassInfo>(){

            @Override
            public SerializerPojo.ClassInfo run(int index) {
                long[] classInfoRecids = DB.this.engine.get(2L, Serializer.RECID_ARRAY);
                if (classInfoRecids == null || index < 0 || index >= classInfoRecids.length) {
                    return null;
                }
                return DB.this.getEngine().get(classInfoRecids[index], DB.this.serializerPojo.classInfoSerializer);
            }
        }, new Fun.Function0<SerializerPojo.ClassInfo[]>(){

            @Override
            public SerializerPojo.ClassInfo[] run() {
                long[] classInfoRecids = engine.get(2L, Serializer.RECID_ARRAY);
                SerializerPojo.ClassInfo[] ret = new SerializerPojo.ClassInfo[classInfoRecids == null ? 0 : classInfoRecids.length];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = engine.get(classInfoRecids[i], DB.this.serializerPojo.classInfoSerializer);
                }
                return ret;
            }
        }, new Fun.Function1<Void, String>(){

            @Override
            public Void run(String className) {
                DB.this.unknownClasses.add(className);
                return null;
            }
        }, classLoader, engine);
        this.reinit();
        if (metricsExecutor != null && metricsLogInterval != 0L) {
            metricsExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DB.this.metricsLog();
                }
            }, metricsLogInterval, metricsLogInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void metricsLog() {
        Map<String, Long> metrics = this.metricsGet();
        String s = metrics.toString();
        LOG.info("Metrics: " + s);
    }

    public Map<String, Long> metricsGet() {
        TreeMap<String, Long> ret = new TreeMap<String, Long>();
        Store s = Store.forEngine(this.engine);
        s.metricsCollect(ret);
        return Collections.unmodifiableMap(ret);
    }

    protected void reinit() {
        this.catalog = BTreeMap.preinitCatalog(this);
    }

    public <A> A catGet(String name, A init) {
        Object ret = this.catalog.get(name);
        return (A)(ret != null ? ret : init);
    }

    public <A> A catGet(String name) {
        return (A)this.catalog.get(name);
    }

    public <A> A catPut(String name, A value) {
        this.catalog.put(name, value);
        return value;
    }

    public <A> A catPut(String name, A value, A retValueIfNull) {
        if (value == null) {
            return retValueIfNull;
        }
        this.catalog.put(name, value);
        return value;
    }

    public String getNameForObject(Object obj) {
        return this.namesLookup.get(new IdentityWrapper(obj));
    }

    public synchronized <K, V> HTreeMap<K, V> getHashMap(String name) {
        return this.hashMap(name);
    }

    public synchronized <K, V> HTreeMap<K, V> hashMap(String name) {
        return this.hashMap(name, null, null, null);
    }

    public synchronized <K, V> HTreeMap<K, V> getHashMap(String name, Fun.Function1<V, K> valueCreator) {
        return this.hashMap(name, null, null, valueCreator);
    }

    public synchronized <K, V> HTreeMap<K, V> hashMap(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.hashMap(name, keySerializer, valueSerializer, null);
    }

    public synchronized <K, V> HTreeMap<K, V> hashMap(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer, Fun.Function1<V, K> valueCreator) {
        this.checkNotClosed();
        HTreeMap<K, V> ret = (HTreeMap<K, V>)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).hashMap("a");
                return (HTreeMap)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).hashMap("a"));
            }
            HTreeMapMaker m = this.hashMapCreate(name);
            if (valueCreator != null) {
                m = m.valueCreator(valueCreator);
            }
            if (keySerializer != null) {
                m = m.keySerializer(keySerializer);
            }
            if (valueSerializer != null) {
                m = m.valueSerializer(valueSerializer);
            }
            return m.make();
        }
        this.checkType(type, "HashMap");
        Serializer<K> keySer2 = this.checkPlaceholder(name + ".keySerializer", keySerializer);
        Serializer<V> valSer2 = this.checkPlaceholder(name + ".valueSerializer", valueSerializer);
        ret = new HTreeMap<K, V>(HTreeMap.fillEngineArray(this.engine), false, (long[])this.catGet(name + ".counterRecids"), (Integer)this.catGet(name + ".hashSalt"), (long[])this.catGet(name + ".segmentRecids"), keySer2, valSer2, this.catGet(name + ".expireTimeStart", 0L), this.catGet(name + ".expire", 0L), this.catGet(name + ".expireAccess", 0L), this.catGet(name + ".expireMaxSize", 0L), this.catGet(name + ".expireStoreSize", 0L), this.catGet(name + ".expireTick", 0L), this.catGet(name + ".expireHeads", null), this.catGet(name + ".expireTails", null), valueCreator, this.executor, 1000L, false, this.consistencyLock.readLock());
        this.namedPut(name, ret);
        return ret;
    }

    protected <K> K checkPlaceholder(String nameCatParam, K fromConstructor) {
        Object fromCatalog = this.catGet(nameCatParam);
        if (fromConstructor != null) {
            if (fromCatalog != Fun.PLACEHOLDER && fromCatalog != fromConstructor && !((SerializerBase)this.getDefaultSerializer()).equalsBinary(fromCatalog, fromConstructor)) {
                LOG.warning(nameCatParam + " is defined in Name Catalog, but other serializer was passed as constructor argument. Using one from constructor argument");
            }
            fromCatalog = fromConstructor;
        }
        if (fromCatalog == Fun.PLACEHOLDER || fromCatalog == null) {
            throw new DBException.UnknownSerializer(nameCatParam + " is not defined in Name Catalog nor constructor argument");
        }
        return (K)fromCatalog;
    }

    public <V> V namedPut(String name, Object ret) {
        this.namesInstanciated.put(name, new WeakReference<Object>(ret));
        this.namesLookup.put(new IdentityWrapper(ret), name);
        return (V)ret;
    }

    public HTreeMapMaker createHashMap(String name) {
        return this.hashMapCreate(name);
    }

    public HTreeMapMaker hashMapCreate(String name) {
        return new HTreeMapMaker(this, name, HTreeMap.fillEngineArray(this.engine));
    }

    protected synchronized <K, V> HTreeMap<K, V> hashMapCreate(HTreeMapMaker m) {
        String name = m.name;
        this.checkNameNotExists(name);
        long expireTimeStart = 0L;
        long expire = 0L;
        long expireAccess = 0L;
        long expireMaxSize = 0L;
        long expireStoreSize = 0L;
        long expireTick = 0L;
        long[] expireHeads = null;
        long[] expireTails = null;
        if (m.ondisk != null) {
            if (m.valueCreator != null) {
                throw new IllegalArgumentException("ValueCreator can not be used together with ExpireOverflow.");
            }
            final Bind.MapWithModificationListener ondisk = m.ondisk;
            m.valueCreator = new Fun.Function1<Object, Object>(){

                @Override
                public Object run(Object key) {
                    return ondisk.get(key);
                }
            };
        }
        if (m.expire != 0L || m.expireAccess != 0L || m.expireMaxSize != 0L || m.expireStoreSize != 0L) {
            expireTimeStart = this.catPut(name + ".expireTimeStart", System.currentTimeMillis());
            expire = this.catPut(name + ".expire", m.expire);
            expireAccess = this.catPut(name + ".expireAccess", m.expireAccess);
            expireMaxSize = this.catPut(name + ".expireMaxSize", m.expireMaxSize);
            expireStoreSize = this.catPut(name + ".expireStoreSize", m.expireStoreSize);
            expireTick = this.catPut(name + ".expireTick", m.expireTick);
            expireHeads = new long[16];
            expireTails = new long[16];
            for (int i = 0; i < 16; ++i) {
                expireHeads[i] = m.engines[i].put(0L, Serializer.LONG);
                expireTails[i] = m.engines[i].put(0L, Serializer.LONG);
            }
            this.catPut(name + ".expireHeads", expireHeads);
            this.catPut(name + ".expireTails", expireTails);
        }
        long[] counterRecids = null;
        if (m.counter) {
            counterRecids = new long[16];
            for (int i = 0; i < 16; ++i) {
                counterRecids[i] = m.engines[i].put(0L, Serializer.LONG);
            }
        }
        if (m.keySerializer == null) {
            m.keySerializer = this.getDefaultSerializer();
        }
        this.catPut(name + ".keySerializer", this.serializableOrPlaceHolder(m.keySerializer));
        if (m.valueSerializer == null) {
            m.valueSerializer = this.getDefaultSerializer();
        }
        this.catPut(name + ".valueSerializer", this.serializableOrPlaceHolder(m.valueSerializer));
        HTreeMap ret = new HTreeMap(m.engines, m.closeEngine, counterRecids == null ? null : this.catPut(name + ".counterRecids", counterRecids), this.catPut(name + ".hashSalt", new SecureRandom().nextInt()), this.catPut(name + ".segmentRecids", HTreeMap.preallocateSegments(m.engines)), m.keySerializer, m.valueSerializer, expireTimeStart, expire, expireAccess, expireMaxSize, expireStoreSize, expireTick, expireHeads, expireTails, m.valueCreator, m.executor, m.executorPeriod, m.executor != this.executor, this.consistencyLock.readLock());
        this.catalog.put(name + ".type", "HashMap");
        this.namedPut(name, ret);
        if (m.pumpSource != null) {
            Pump.fillHTreeMap(ret, m.pumpSource, m.pumpKeyExtractor, m.pumpValueExtractor, m.pumpPresortBatchSize, m.pumpIgnoreDuplicates, this.getDefaultSerializer(), m.executor);
        }
        if (m.ondisk != null) {
            Bind.mapPutAfterDelete(ret, m.ondisk, m.ondiskOverwrite);
        }
        return ret;
    }

    protected Object serializableOrPlaceHolder(Object o) {
        SerializerBase b = (SerializerBase)this.getDefaultSerializer();
        if (o == null || b.isSerializable(o)) {
            try {
                DataIO.DataOutputByteArray out = new DataIO.DataOutputByteArray();
                b.serialize((DataOutput)out, o);
                return o;
            }
            catch (Exception e) {
                return Fun.PLACEHOLDER;
            }
        }
        return Fun.PLACEHOLDER;
    }

    public synchronized <K> Set<K> getHashSet(String name) {
        return this.hashSet(name);
    }

    public synchronized <K> Set<K> hashSet(String name) {
        return this.hashSet(name, null);
    }

    public synchronized <K> Set<K> hashSet(String name, Serializer<K> serializer) {
        this.checkNotClosed();
        Set<K> ret = (Set<K>)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).hashSet("a");
                return (Set)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).hashSet("a"));
            }
            HTreeSetMaker m = this.hashSetCreate(name);
            if (serializer != null) {
                m = m.serializer(serializer);
            }
            return m.makeOrGet();
        }
        this.checkType(type, "HashSet");
        Serializer<K> keySer2 = this.checkPlaceholder(name + ".serializer", serializer);
        ret = new HTreeMap(HTreeMap.fillEngineArray(this.engine), false, (long[])this.catGet(name + ".counterRecids"), (Integer)this.catGet(name + ".hashSalt"), (long[])this.catGet(name + ".segmentRecids"), keySer2, null, this.catGet(name + ".expireTimeStart", 0L), this.catGet(name + ".expire", 0L), this.catGet(name + ".expireAccess", 0L), this.catGet(name + ".expireMaxSize", 0L), this.catGet(name + ".expireStoreSize", 0L), this.catGet(name + ".expireTick", 0L), this.catGet(name + ".expireHeads", null), this.catGet(name + ".expireTails", null), null, this.executor, 1000L, false, this.consistencyLock.readLock()).keySet();
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized HTreeSetMaker createHashSet(String name) {
        return this.hashSetCreate(name);
    }

    public synchronized HTreeSetMaker hashSetCreate(String name) {
        return new HTreeSetMaker(name);
    }

    protected synchronized <K> Set<K> hashSetCreate(HTreeSetMaker m) {
        String name = m.name;
        this.checkNameNotExists(name);
        long expireTimeStart = 0L;
        long expire = 0L;
        long expireAccess = 0L;
        long expireMaxSize = 0L;
        long expireStoreSize = 0L;
        long expireTick = 0L;
        long[] expireHeads = null;
        long[] expireTails = null;
        if (m.expire != 0L || m.expireAccess != 0L || m.expireMaxSize != 0L) {
            expireTimeStart = this.catPut(name + ".expireTimeStart", System.currentTimeMillis());
            expire = this.catPut(name + ".expire", m.expire);
            expireAccess = this.catPut(name + ".expireAccess", m.expireAccess);
            expireMaxSize = this.catPut(name + ".expireMaxSize", m.expireMaxSize);
            expireStoreSize = this.catPut(name + ".expireStoreSize", m.expireStoreSize);
            expireTick = this.catPut(name + ".expireTick", m.expireTick);
            expireHeads = new long[16];
            expireTails = new long[16];
            for (int i = 0; i < 16; ++i) {
                expireHeads[i] = this.engine.put(0L, Serializer.LONG);
                expireTails[i] = this.engine.put(0L, Serializer.LONG);
            }
            this.catPut(name + ".expireHeads", expireHeads);
            this.catPut(name + ".expireTails", expireTails);
        }
        Engine[] engines = HTreeMap.fillEngineArray(this.engine);
        long[] counterRecids = null;
        if (m.counter) {
            counterRecids = new long[16];
            for (int i = 0; i < 16; ++i) {
                counterRecids[i] = engines[i].put(0L, Serializer.LONG);
            }
        }
        if (m.serializer == null) {
            m.serializer = this.getDefaultSerializer();
        }
        this.catPut(name + ".serializer", this.serializableOrPlaceHolder(m.serializer));
        HTreeMap ret = new HTreeMap(engines, m.closeEngine, counterRecids == null ? null : this.catPut(name + ".counterRecids", counterRecids), this.catPut(name + ".hashSalt", new SecureRandom().nextInt()), this.catPut(name + ".segmentRecids", HTreeMap.preallocateSegments(engines)), m.serializer, null, expireTimeStart, expire, expireAccess, expireMaxSize, expireStoreSize, expireTick, expireHeads, expireTails, null, m.executor, m.executorPeriod, m.executor != this.executor, this.consistencyLock.readLock());
        Set<?> ret2 = ret.keySet();
        this.catalog.put(name + ".type", "HashSet");
        this.namedPut(name, ret2);
        if (m.pumpSource != null) {
            Pump.fillHTreeMap(ret, m.pumpSource, Fun.extractNoTransform(), null, m.pumpPresortBatchSize, m.pumpIgnoreDuplicates, this.getDefaultSerializer(), m.executor);
        }
        return ret2;
    }

    public synchronized <K, V> BTreeMap<K, V> getTreeMap(String name) {
        return this.treeMap(name);
    }

    public synchronized <K, V> BTreeMap<K, V> treeMap(String name) {
        return this.treeMap(name, (BTreeKeySerializer)null, null);
    }

    public synchronized <K, V> BTreeMap<K, V> treeMap(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        if (keySerializer == null) {
            keySerializer = this.getDefaultSerializer();
        }
        return this.treeMap(name, keySerializer.getBTreeKeySerializer(null), valueSerializer);
    }

    public synchronized <K, V> BTreeMap<K, V> treeMap(String name, BTreeKeySerializer keySerializer, Serializer<V> valueSerializer) {
        this.checkNotClosed();
        BTreeMap ret = (BTreeMap)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).treeMap("a");
                return (BTreeMap)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).treeMap("a"));
            }
            BTreeMapMaker m = this.treeMapCreate(name);
            if (keySerializer != null) {
                m = m.keySerializer(keySerializer);
            }
            if (valueSerializer != null) {
                m = m.valueSerializer(valueSerializer);
            }
            return m.make();
        }
        this.checkType(type, "TreeMap");
        BTreeKeySerializer keySer2 = this.checkPlaceholder(name + ".keySerializer", keySerializer);
        Serializer<V> valSer2 = this.checkPlaceholder(name + ".valueSerializer", valueSerializer);
        ret = new BTreeMap(this.engine, false, (Long)this.catGet(name + ".rootRecidRef"), this.catGet(name + ".maxNodeSize", 32), this.catGet(name + ".valuesOutsideNodes", false), this.catGet(name + ".counterRecids", 0L), keySer2, valSer2, this.catGet(name + ".numberOfNodeMetas", 0));
        this.namedPut(name, ret);
        return ret;
    }

    public BTreeMapMaker createTreeMap(String name) {
        return this.treeMapCreate(name);
    }

    public BTreeMapMaker treeMapCreate(String name) {
        return new BTreeMapMaker(name, this);
    }

    protected synchronized <K, V> BTreeMap<K, V> treeMapCreate(BTreeMapMaker m) {
        String name = m.name;
        this.checkNameNotExists(name);
        BTreeKeySerializer<?, ?> keySerializer = this.fillNulls(m.getKeySerializer());
        this.catPut(name + ".keySerializer", this.serializableOrPlaceHolder(keySerializer));
        if (m.valueSerializer == null) {
            m.valueSerializer = this.getDefaultSerializer();
        }
        this.catPut(name + ".valueSerializer", this.serializableOrPlaceHolder(m.valueSerializer));
        if (m.pumpPresortBatchSize != -1 && m.pumpSource != null) {
            final Comparator<?> comp = keySerializer.comparator();
            final Fun.Function1 extr = m.pumpKeyExtractor;
            Comparator presortComp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return -comp.compare(extr.run(o1), extr.run(o2));
                }
            };
            m.pumpSource = Pump.sort(m.pumpSource, m.pumpIgnoreDuplicates, m.pumpPresortBatchSize, presortComp, this.getDefaultSerializer(), m.executor);
        }
        long counterRecid = !m.counter ? 0L : this.engine.put(0L, Serializer.LONG);
        long rootRecidRef = m.pumpSource == null || !m.pumpSource.hasNext() ? BTreeMap.createRootRef(this.engine, keySerializer, m.valueSerializer, m.valuesOutsideNodes, 0) : Pump.buildTreeMap(m.pumpSource, this.engine, m.pumpKeyExtractor, m.pumpValueExtractor, m.pumpIgnoreDuplicates, m.nodeSize, m.valuesOutsideNodes, counterRecid, keySerializer, m.valueSerializer, m.executor);
        BTreeMap ret = new BTreeMap(this.engine, m.closeEngine, this.catPut(name + ".rootRecidRef", rootRecidRef), this.catPut(name + ".maxNodeSize", m.nodeSize), this.catPut(name + ".valuesOutsideNodes", m.valuesOutsideNodes), this.catPut(name + ".counterRecids", counterRecid), keySerializer, m.valueSerializer, this.catPut(m.name + ".numberOfNodeMetas", 0));
        this.catalog.put(name + ".type", "TreeMap");
        this.namedPut(name, ret);
        return ret;
    }

    protected BTreeKeySerializer<?, ?> fillNulls(BTreeKeySerializer<?, ?> keySerializer) {
        if (keySerializer == null) {
            return new BTreeKeySerializer.BasicKeySerializer(this.getDefaultSerializer(), Fun.COMPARATOR);
        }
        if (keySerializer instanceof BTreeKeySerializer.ArrayKeySerializer) {
            BTreeKeySerializer.ArrayKeySerializer k = (BTreeKeySerializer.ArrayKeySerializer)keySerializer;
            Serializer[] serializers = new Serializer[k.tsize];
            Comparator[] comparators = new Comparator[k.tsize];
            for (int i = 0; i < k.tsize; ++i) {
                serializers[i] = k.serializers[i] != null && k.serializers[i] != Serializer.BASIC ? k.serializers[i] : this.getDefaultSerializer();
                comparators[i] = k.comparators[i] != null ? k.comparators[i] : Fun.COMPARATOR;
            }
            return new BTreeKeySerializer.ArrayKeySerializer(comparators, serializers);
        }
        return keySerializer;
    }

    public SortedMap<String, Object> getCatalog() {
        return this.catalog;
    }

    public synchronized <K> NavigableSet<K> getTreeSet(String name) {
        return this.treeSet(name);
    }

    public synchronized <K> NavigableSet<K> treeSet(String name) {
        return this.treeSet(name, (BTreeKeySerializer)null);
    }

    public synchronized <K> NavigableSet<K> treeSet(String name, Serializer serializer) {
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        return this.treeSet(name, serializer.getBTreeKeySerializer(null));
    }

    public synchronized <K> NavigableSet<K> treeSet(String name, BTreeKeySerializer serializer) {
        this.checkNotClosed();
        Set ret = (NavigableSet)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).treeSet("a");
                return (NavigableSet)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).treeSet("a"));
            }
            BTreeSetMaker m = this.treeSetCreate(name);
            if (serializer != null) {
                m = m.serializer(serializer);
            }
            return m.make();
        }
        this.checkType(type, "TreeSet");
        BTreeKeySerializer keySer2 = this.checkPlaceholder(name + ".serializer", serializer);
        ret = new BTreeMap(this.engine, false, (Long)this.catGet(name + ".rootRecidRef"), this.catGet(name + ".maxNodeSize", 32), false, this.catGet(name + ".counterRecids", 0L), keySer2, null, this.catGet(name + ".numberOfNodeMetas", 0)).keySet();
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized BTreeSetMaker createTreeSet(String name) {
        return this.treeSetCreate(name);
    }

    public synchronized BTreeSetMaker treeSetCreate(String name) {
        return new BTreeSetMaker(name);
    }

    public synchronized <K> NavigableSet<K> treeSetCreate(BTreeSetMaker m) {
        this.checkNameNotExists(m.name);
        BTreeKeySerializer<?, ?> serializer = this.fillNulls(m.getSerializer());
        this.catPut(m.name + ".serializer", this.serializableOrPlaceHolder(serializer));
        if (m.pumpPresortBatchSize != -1) {
            m.pumpSource = Pump.sort(m.pumpSource, m.pumpIgnoreDuplicates, m.pumpPresortBatchSize, Collections.reverseOrder(serializer.comparator()), this.getDefaultSerializer(), m.executor);
        }
        long counterRecid = !m.counter ? 0L : this.engine.put(0L, Serializer.LONG);
        long rootRecidRef = m.pumpSource == null || !m.pumpSource.hasNext() ? BTreeMap.createRootRef(this.engine, serializer, null, false, 0) : Pump.buildTreeMap(m.pumpSource, this.engine, Fun.extractNoTransform(), null, m.pumpIgnoreDuplicates, m.nodeSize, false, counterRecid, serializer, null, m.executor);
        Set ret = new BTreeMap(this.engine, m.standalone, this.catPut(m.name + ".rootRecidRef", rootRecidRef), this.catPut(m.name + ".maxNodeSize", m.nodeSize), false, this.catPut(m.name + ".counterRecids", counterRecid), serializer, null, this.catPut(m.name + ".numberOfNodeMetas", 0)).keySet();
        this.catalog.put(m.name + ".type", "TreeSet");
        this.namedPut(m.name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> getQueue(String name) {
        this.checkNotClosed();
        Queues.Queue ret = (Queues.Queue)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).getQueue("a");
                return (BlockingQueue)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).getQueue("a"));
            }
            return this.createQueue(name, null, true);
        }
        this.checkType(type, "Queue");
        ret = new Queues.Queue(this.engine, this.catGet(name + ".serializer", this.getDefaultSerializer()), (Long)this.catGet(name + ".headRecid"), (Long)this.catGet(name + ".tailRecid"), (Boolean)this.catGet(name + ".useLocks"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> createQueue(String name, Serializer<E> serializer, boolean useLocks) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        long node = this.engine.put(null, new Queues.SimpleQueue.NodeSerializer(serializer));
        long headRecid = this.engine.put(node, Serializer.LONG);
        long tailRecid = this.engine.put(node, Serializer.LONG);
        Queues.Queue ret = new Queues.Queue(this.engine, this.catPut(name + ".serializer", serializer), this.catPut(name + ".headRecid", headRecid), this.catPut(name + ".tailRecid", tailRecid), this.catPut(name + ".useLocks", useLocks));
        this.catalog.put(name + ".type", "Queue");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> getStack(String name) {
        this.checkNotClosed();
        Queues.Stack ret = (Queues.Stack)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).getStack("a");
                return (BlockingQueue)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).getStack("a"));
            }
            return this.createStack(name, null, true);
        }
        this.checkType(type, "Stack");
        ret = new Queues.Stack(this.engine, this.catGet(name + ".serializer", this.getDefaultSerializer()), (Long)this.catGet(name + ".headRecid"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> createStack(String name, Serializer<E> serializer, boolean useLocks) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        long node = this.engine.put(null, new Queues.SimpleQueue.NodeSerializer(serializer));
        long headRecid = this.engine.put(node, Serializer.LONG);
        Queues.Stack ret = new Queues.Stack(this.engine, this.catPut(name + ".serializer", serializer), this.catPut(name + ".headRecid", headRecid));
        this.catalog.put(name + ".type", "Stack");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> getCircularQueue(String name) {
        this.checkNotClosed();
        Queues.CircularQueue ret = (Queues.CircularQueue)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).getCircularQueue("a");
                return (BlockingQueue)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).getCircularQueue("a"));
            }
            return this.createCircularQueue(name, null, 1024L);
        }
        this.checkType(type, "CircularQueue");
        ret = new Queues.CircularQueue(this.engine, this.catGet(name + ".serializer", this.getDefaultSerializer()), (Long)this.catGet(name + ".headRecid"), (Long)this.catGet(name + ".headInsertRecid"), (Long)this.catGet(name + ".size"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> createCircularQueue(String name, Serializer<E> serializer, long size) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        long prevRecid = 0L;
        long firstRecid = 0L;
        Queues.SimpleQueue.NodeSerializer nodeSer = new Queues.SimpleQueue.NodeSerializer(serializer);
        for (long i = 0L; i < size + 1L; ++i) {
            Queues.SimpleQueue.Node<Object> n = new Queues.SimpleQueue.Node<Object>(prevRecid, null);
            prevRecid = this.engine.put(n, nodeSer);
            if (firstRecid != 0L) continue;
            firstRecid = prevRecid;
        }
        this.engine.update(firstRecid, new Queues.SimpleQueue.Node<Object>(prevRecid, null), nodeSer);
        long headRecid = this.engine.put(prevRecid, Serializer.LONG);
        long headInsertRecid = this.engine.put(prevRecid, Serializer.LONG);
        Queues.CircularQueue ret = new Queues.CircularQueue(this.engine, this.catPut(name + ".serializer", serializer), this.catPut(name + ".headRecid", headRecid), this.catPut(name + ".headInsertRecid", headInsertRecid), this.catPut(name + ".size", size));
        this.catalog.put(name + ".type", "CircularQueue");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Long createAtomicLong(String name, long initValue) {
        return this.atomicLongCreate(name, initValue);
    }

    public synchronized Atomic.Long atomicLongCreate(String name, long initValue) {
        this.checkNameNotExists(name);
        long recid = this.engine.put(initValue, Serializer.LONG);
        Atomic.Long ret = new Atomic.Long(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicLong");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Long getAtomicLong(String name) {
        return this.atomicLong(name);
    }

    public synchronized Atomic.Long atomicLong(String name) {
        this.checkNotClosed();
        Atomic.Long ret = (Atomic.Long)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).atomicLong("a");
                return (Atomic.Long)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).atomicLong("a"));
            }
            return this.atomicLongCreate(name, 0L);
        }
        this.checkType(type, "AtomicLong");
        ret = new Atomic.Long(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Integer createAtomicInteger(String name, int initValue) {
        return this.atomicIntegerCreate(name, initValue);
    }

    public synchronized Atomic.Integer atomicIntegerCreate(String name, int initValue) {
        this.checkNameNotExists(name);
        long recid = this.engine.put(initValue, Serializer.INTEGER);
        Atomic.Integer ret = new Atomic.Integer(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicInteger");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Integer getAtomicInteger(String name) {
        return this.atomicInteger(name);
    }

    public synchronized Atomic.Integer atomicInteger(String name) {
        this.checkNotClosed();
        Atomic.Integer ret = (Atomic.Integer)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).atomicInteger("a");
                return (Atomic.Integer)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).atomicInteger("a"));
            }
            return this.atomicIntegerCreate(name, 0);
        }
        this.checkType(type, "AtomicInteger");
        ret = new Atomic.Integer(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Boolean createAtomicBoolean(String name, boolean initValue) {
        return this.atomicBooleanCreate(name, initValue);
    }

    public synchronized Atomic.Boolean atomicBooleanCreate(String name, boolean initValue) {
        this.checkNameNotExists(name);
        long recid = this.engine.put(initValue, Serializer.BOOLEAN);
        Atomic.Boolean ret = new Atomic.Boolean(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicBoolean");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Boolean getAtomicBoolean(String name) {
        return this.atomicBoolean(name);
    }

    public synchronized Atomic.Boolean atomicBoolean(String name) {
        this.checkNotClosed();
        Atomic.Boolean ret = (Atomic.Boolean)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).atomicBoolean("a");
                return (Atomic.Boolean)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).atomicBoolean("a"));
            }
            return this.atomicBooleanCreate(name, false);
        }
        this.checkType(type, "AtomicBoolean");
        ret = new Atomic.Boolean(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public void checkShouldCreate(String name) {
        if (this.strictDBGet) {
            throw new NoSuchElementException("No record with this name was found: " + name);
        }
    }

    public synchronized Atomic.String createAtomicString(String name, String initValue) {
        return this.atomicStringCreate(name, initValue);
    }

    public synchronized Atomic.String atomicStringCreate(String name, String initValue) {
        this.checkNameNotExists(name);
        if (initValue == null) {
            throw new IllegalArgumentException("initValue may not be null");
        }
        long recid = this.engine.put(initValue, Serializer.STRING_NOSIZE);
        Atomic.String ret = new Atomic.String(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicString");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.String getAtomicString(String name) {
        return this.atomicString(name);
    }

    public synchronized Atomic.String atomicString(String name) {
        this.checkNotClosed();
        Atomic.String ret = (Atomic.String)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).atomicString("a");
                return (Atomic.String)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).atomicString("a"));
            }
            return this.atomicStringCreate(name, "");
        }
        this.checkType(type, "AtomicString");
        ret = new Atomic.String(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> Atomic.Var<E> createAtomicVar(String name, E initValue, Serializer<E> serializer) {
        return this.atomicVarCreate(name, initValue, serializer);
    }

    public synchronized <E> Atomic.Var<E> atomicVarCreate(String name, E initValue, Serializer<E> serializer) {
        if (this.catGet(name + ".type") != null) {
            return this.atomicVar(name, serializer);
        }
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        this.catPut(name + ".serializer", this.serializableOrPlaceHolder(serializer));
        long recid = this.engine.put(initValue, serializer);
        Atomic.Var ret = new Atomic.Var(this.engine, this.catPut(name + ".recid", recid), serializer);
        this.catalog.put(name + ".type", "AtomicVar");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> Atomic.Var<E> getAtomicVar(String name) {
        return this.atomicVar(name);
    }

    public synchronized <E> Atomic.Var<E> atomicVar(String name) {
        return this.atomicVar(name, null);
    }

    public synchronized <E> Atomic.Var<E> atomicVar(String name, Serializer<E> serializer) {
        this.checkNotClosed();
        Atomic.Var ret = (Atomic.Var)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap(true, 1, 0, false);
                new DB(e).atomicVar("a");
                return (Atomic.Var)this.namedPut(name, new DB(new Engine.ReadOnlyWrapper(e)).atomicVar("a"));
            }
            return this.atomicVarCreate(name, null, this.getDefaultSerializer());
        }
        this.checkType(type, "AtomicVar");
        Serializer serializer2 = serializer == null ? this.catGet(name + ".serializer") : serializer;
        if (serializer2 == null) {
            serializer2 = this.getDefaultSerializer();
        }
        if (serializer2 == Fun.PLACEHOLDER) {
            throw new DBException.UnknownSerializer("Atomic.Var '" + name + "' has no serializer defined in Name Catalog nor constructor argument.");
        }
        ret = new Atomic.Var(this.engine, (Long)this.catGet(name + ".recid"), serializer2);
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> E get(String name) {
        String type = (String)this.catGet(name + ".type");
        if (type == null) {
            return null;
        }
        if ("HashMap".equals(type)) {
            return (E)this.hashMap(name);
        }
        if ("HashSet".equals(type)) {
            return (E)this.hashSet(name);
        }
        if ("TreeMap".equals(type)) {
            return (E)this.treeMap(name);
        }
        if ("TreeSet".equals(type)) {
            return (E)this.treeSet(name);
        }
        if ("AtomicBoolean".equals(type)) {
            return (E)this.atomicBoolean(name);
        }
        if ("AtomicInteger".equals(type)) {
            return (E)this.atomicInteger(name);
        }
        if ("AtomicLong".equals(type)) {
            return (E)this.atomicLong(name);
        }
        if ("AtomicString".equals(type)) {
            return (E)this.atomicString(name);
        }
        if ("AtomicVar".equals(type)) {
            return (E)this.atomicVar(name);
        }
        if ("Queue".equals(type)) {
            return (E)this.getQueue(name);
        }
        if ("Stack".equals(type)) {
            return (E)this.getStack(name);
        }
        if ("CircularQueue".equals(type)) {
            return (E)this.getCircularQueue(name);
        }
        throw new DBException.DataCorruption("Unknown type: " + name);
    }

    public synchronized boolean exists(String name) {
        return this.catGet(name + ".type") != null;
    }

    public synchronized void delete(String name) {
        AbstractMap m;
        Object r = this.get(name);
        if (r instanceof Atomic.Boolean) {
            this.engine.delete(((Atomic.Boolean)r).recid, Serializer.BOOLEAN);
        } else if (r instanceof Atomic.Integer) {
            this.engine.delete(((Atomic.Integer)r).recid, Serializer.INTEGER);
        } else if (r instanceof Atomic.Long) {
            this.engine.delete(((Atomic.Long)r).recid, Serializer.LONG);
        } else if (r instanceof Atomic.String) {
            this.engine.delete(((Atomic.String)r).recid, Serializer.STRING_NOSIZE);
        } else if (r instanceof Atomic.Var) {
            this.engine.delete(((Atomic.Var)r).recid, ((Atomic.Var)r).serializer);
        } else if (r instanceof Queue) {
            Queue q = (Queue)r;
            while (q.poll() != null) {
            }
        } else if (r instanceof HTreeMap || r instanceof HTreeMap.KeySet) {
            m = r instanceof HTreeMap ? (HTreeMap)r : ((HTreeMap.KeySet)r).parent();
            ((HTreeMap)m).clear();
            for (long segmentRecid : ((HTreeMap)m).segmentRecids) {
                this.engine.delete(segmentRecid, HTreeMap.DIR_SERIALIZER);
            }
        } else if (r instanceof BTreeMap || r instanceof BTreeMap.KeySet) {
            m = r instanceof BTreeMap ? (BTreeMap)r : (BTreeMap)((BTreeMap.KeySet)r).m;
            ((BTreeMap)m).clear();
            if (((BTreeMap)m).counter != null) {
                this.engine.delete(((BTreeMap)m).counter.recid, Serializer.LONG);
            }
        }
        for (String n : this.catalog.keySet()) {
            String suffix;
            if (!n.startsWith(name) || (suffix = n.substring(name.length())).charAt(0) != '.' || suffix.length() <= 1 || suffix.substring(1).contains(".")) continue;
            this.catalog.remove(n);
        }
        this.namesInstanciated.remove(name);
        this.namesLookup.remove(new IdentityWrapper(r));
    }

    public synchronized Map<String, Object> getAll() {
        TreeMap ret = new TreeMap();
        for (String name : this.catalog.keySet()) {
            if (!name.endsWith(".type")) continue;
            name = name.substring(0, name.length() - 5);
            ret.put(name, this.get(name));
        }
        return Collections.unmodifiableMap(ret);
    }

    public synchronized void rename(String oldName, String newName) {
        Object old2;
        String param;
        if (oldName.equals(newName)) {
            return;
        }
        SortedMap<String, Object> sub = this.catalog.tailMap(oldName);
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator i$ = sub.keySet().iterator();
        while (i$.hasNext() && (param = (String)i$.next()).startsWith(oldName)) {
            String suffix = param.substring(oldName.length());
            this.catalog.put(newName + suffix, this.catalog.get(param));
            toRemove.add(param);
        }
        if (toRemove.isEmpty()) {
            throw new NoSuchElementException("Could not rename, name does not exist: " + oldName);
        }
        WeakReference<?> old = this.namesInstanciated.remove(oldName);
        if (old != null && (old2 = old.get()) != null) {
            this.namesLookup.remove(new IdentityWrapper(old2));
            this.namedPut(newName, old2);
        }
        for (String param2 : toRemove) {
            this.catalog.remove(param2);
        }
    }

    public void checkNameNotExists(String name) {
        if (this.catalog.get(name + ".type") != null) {
            throw new IllegalArgumentException("Name already used: " + name);
        }
    }

    @Override
    public synchronized void close() {
        if (this.engine == null) {
            return;
        }
        this.consistencyLock.writeLock().lock();
        try {
            File f;
            if (this.metricsExecutor != null && this.metricsExecutor != this.executor && !this.metricsExecutor.isShutdown()) {
                this.metricsExecutor.shutdown();
                this.metricsExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                this.metricsExecutor = null;
            }
            if (this.cacheExecutor != null && this.cacheExecutor != this.executor && !this.cacheExecutor.isShutdown()) {
                this.cacheExecutor.shutdown();
                this.cacheExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                this.cacheExecutor = null;
            }
            if (this.storeExecutor != null && this.storeExecutor != this.executor && !this.storeExecutor.isShutdown()) {
                this.storeExecutor.shutdown();
                this.storeExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                this.storeExecutor = null;
            }
            if (this.executor != null && !this.executor.isTerminated()) {
                this.executor.shutdown();
                this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                this.executor = null;
            }
            for (WeakReference<?> r : this.namesInstanciated.values()) {
                Object rr = r.get();
                if (rr == null || !(rr instanceof Closeable)) continue;
                ((Closeable)rr).close();
            }
            String fileName = this.deleteFilesAfterClose ? Store.forEngine((Engine)this.engine).fileName : null;
            this.engine.close();
            this.engine = Engine.CLOSED_ENGINE;
            this.namesInstanciated = Collections.unmodifiableMap(new HashMap());
            this.namesLookup = Collections.unmodifiableMap(new HashMap());
            if (this.deleteFilesAfterClose && fileName != null && (f = new File(fileName)).exists() && !f.delete()) {
                // empty if block
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (InterruptedException e) {
            throw new DBException.Interrupted(e);
        }
        finally {
            this.consistencyLock.writeLock().unlock();
        }
    }

    public synchronized Object getFromWeakCollection(String name) {
        WeakReference<?> r = this.namesInstanciated.get(name);
        if (r == null) {
            return null;
        }
        Object o = r.get();
        if (o == null) {
            this.namesInstanciated.remove(name);
        }
        return o;
    }

    public void checkNotClosed() {
        if (this.engine == null) {
            throw new IllegalAccessError("DB was already closed");
        }
    }

    public synchronized boolean isClosed() {
        return this.engine == null || this.engine.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        this.checkNotClosed();
        this.consistencyLock.writeLock().lock();
        try {
            String[] toBeAdded;
            String[] stringArray = toBeAdded = this.unknownClasses.isEmpty() ? null : this.unknownClasses.toArray(new String[0]);
            if (toBeAdded != null) {
                long[] classInfoRecids;
                long[] classInfoRecidsOrig = classInfoRecids = this.engine.get(2L, Serializer.RECID_ARRAY);
                if (classInfoRecids == null) {
                    classInfoRecids = new long[]{};
                }
                int pos = classInfoRecids.length;
                classInfoRecids = Arrays.copyOf(classInfoRecids, classInfoRecids.length + toBeAdded.length);
                for (String className : toBeAdded) {
                    SerializerPojo.ClassInfo classInfo = this.serializerPojo.makeClassInfo(className);
                    classInfoRecids[pos++] = this.engine.put(classInfo, this.serializerPojo.classInfoSerializer);
                }
                if (!this.engine.compareAndSwap(2L, classInfoRecidsOrig, classInfoRecids, Serializer.RECID_ARRAY)) {
                    LOG.log(Level.WARNING, "Could not update class catalog with new classes, CAS failed");
                }
            }
            this.engine.commit();
            if (toBeAdded != null) {
                for (String className : toBeAdded) {
                    this.unknownClasses.remove(className);
                }
            }
        }
        finally {
            this.consistencyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() {
        this.checkNotClosed();
        this.consistencyLock.writeLock().lock();
        try {
            this.engine.rollback();
        }
        finally {
            this.consistencyLock.writeLock().unlock();
        }
    }

    public synchronized void compact() {
        this.engine.compact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DB snapshot() {
        this.consistencyLock.writeLock().lock();
        try {
            Engine snapshot = TxEngine.createSnapshotFor(this.engine);
            DB dB = new DB(snapshot);
            return dB;
        }
        finally {
            this.consistencyLock.writeLock().unlock();
        }
    }

    public Serializer getDefaultSerializer() {
        return this.serializerPojo;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void checkType(String type, String expected) {
        if (!expected.equals(type)) {
            throw new IllegalArgumentException("Wrong type: " + type);
        }
    }

    public ReadWriteLock consistencyLock() {
        return this.consistencyLock;
    }

    public class BTreeSetMaker {
        protected final String name;
        protected int nodeSize = 32;
        protected boolean counter = false;
        private BTreeKeySerializer _serializer;
        private Serializer _serializer2;
        private Comparator _comparator;
        protected Iterator<?> pumpSource;
        protected int pumpPresortBatchSize = -1;
        protected boolean pumpIgnoreDuplicates = false;
        protected boolean standalone = false;
        protected Executor executor;

        public BTreeSetMaker(String name) {
            this.executor = DB.this.executor;
            this.name = name;
        }

        public BTreeSetMaker nodeSize(int nodeSize) {
            this.nodeSize = nodeSize;
            return this;
        }

        public BTreeSetMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public BTreeSetMaker serializer(BTreeKeySerializer serializer) {
            this._serializer = serializer;
            return this;
        }

        public BTreeSetMaker serializer(Serializer serializer) {
            this._serializer2 = serializer;
            return this;
        }

        public BTreeSetMaker serializer(Serializer serializer, Comparator comparator) {
            this._serializer2 = serializer;
            this._comparator = comparator;
            return this;
        }

        public BTreeSetMaker comparator(Comparator<?> comparator) {
            this._comparator = comparator;
            return this;
        }

        protected BTreeKeySerializer getSerializer() {
            if (this._serializer == null) {
                if (this._serializer2 == null && this._comparator != null) {
                    this._serializer2 = DB.this.getDefaultSerializer();
                }
                if (this._serializer2 != null) {
                    this._serializer = this._serializer2.getBTreeKeySerializer(this._comparator);
                }
            }
            return this._serializer;
        }

        public BTreeSetMaker pumpSource(Iterator<?> source) {
            this.pumpSource = source;
            return this;
        }

        public BTreeSetMaker pumpSource(NavigableSet m) {
            this.pumpSource = m.descendingIterator();
            return this;
        }

        public <K> BTreeSetMaker pumpIgnoreDuplicates() {
            this.pumpIgnoreDuplicates = true;
            return this;
        }

        public BTreeSetMaker pumpPresort(int batchSize) {
            this.pumpPresortBatchSize = batchSize;
            return this;
        }

        protected BTreeSetMaker standalone() {
            this.standalone = true;
            return this;
        }

        public <K> NavigableSet<K> make() {
            return DB.this.treeSetCreate(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K> NavigableSet<K> makeOrGet() {
            DB dB = DB.this;
            synchronized (dB) {
                return DB.this.catGet(this.name + ".type") == null ? this.make() : DB.this.treeSet(this.name, this.getSerializer());
            }
        }

        public NavigableSet<String> makeStringSet() {
            this.serializer(BTreeKeySerializer.STRING);
            return this.make();
        }

        public NavigableSet<Long> makeLongSet() {
            this.serializer(BTreeKeySerializer.LONG);
            return this.make();
        }
    }

    public static class BTreeMapMaker {
        protected final String name;
        protected final DB db;
        protected int nodeSize = 32;
        protected boolean valuesOutsideNodes = false;
        protected boolean counter = false;
        private BTreeKeySerializer _keySerializer;
        private Serializer _keySerializer2;
        private Comparator _comparator;
        protected Serializer<?> valueSerializer;
        protected Iterator pumpSource;
        protected Fun.Function1 pumpKeyExtractor;
        protected Fun.Function1 pumpValueExtractor;
        protected int pumpPresortBatchSize = -1;
        protected boolean pumpIgnoreDuplicates = false;
        protected boolean closeEngine = false;
        protected Executor executor = null;

        public BTreeMapMaker(String name) {
            this(name, null);
        }

        protected BTreeMapMaker(String name, DB db) {
            this.name = name;
            this.db = db;
            this.executor = db == null ? null : db.executor;
        }

        public BTreeMapMaker nodeSize(int nodeSize) {
            if (nodeSize >= 8191) {
                throw new IllegalArgumentException("Too large max node size");
            }
            this.nodeSize = nodeSize;
            return this;
        }

        public BTreeMapMaker valuesOutsideNodesEnable() {
            this.valuesOutsideNodes = true;
            return this;
        }

        public BTreeMapMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public BTreeMapMaker keySerializer(BTreeKeySerializer<?, ?> keySerializer) {
            this._keySerializer = keySerializer;
            return this;
        }

        public BTreeMapMaker keySerializer(Serializer<?> serializer) {
            this._keySerializer2 = serializer;
            return this;
        }

        public BTreeMapMaker keySerializer(Serializer<?> serializer, Comparator<?> comparator) {
            this._keySerializer2 = serializer;
            this._comparator = comparator;
            return this;
        }

        public BTreeMapMaker keySerializerWrap(Serializer<?> serializer) {
            return this.keySerializer(serializer);
        }

        public BTreeMapMaker valueSerializer(Serializer<?> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public BTreeMapMaker comparator(Comparator<?> comparator) {
            this._comparator = comparator;
            return this;
        }

        public <K, V> BTreeMapMaker pumpSource(Iterator<K> keysSource, Fun.Function1<V, K> valueExtractor) {
            this.pumpSource = keysSource;
            this.pumpKeyExtractor = Fun.extractNoTransform();
            this.pumpValueExtractor = valueExtractor;
            return this;
        }

        public <K, V> BTreeMapMaker pumpSource(Iterator<Fun.Pair<K, V>> entriesSource) {
            this.pumpSource = entriesSource;
            this.pumpKeyExtractor = Fun.extractKey();
            this.pumpValueExtractor = Fun.extractValue();
            return this;
        }

        public BTreeMapMaker pumpSource(NavigableMap m) {
            this.pumpSource = m.descendingMap().entrySet().iterator();
            this.pumpKeyExtractor = Fun.extractMapEntryKey();
            this.pumpValueExtractor = Fun.extractMapEntryValue();
            return this;
        }

        public BTreeMapMaker pumpPresort(int batchSize) {
            this.pumpPresortBatchSize = batchSize;
            return this;
        }

        public <K> BTreeMapMaker pumpIgnoreDuplicates() {
            this.pumpIgnoreDuplicates = true;
            return this;
        }

        public <K, V> BTreeMap<K, V> make() {
            if (this.db == null) {
                throw new IllegalAccessError("This maker is not attached to any DB, it only hold configuration");
            }
            return this.db.treeMapCreate(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K, V> BTreeMap<K, V> makeOrGet() {
            if (this.db == null) {
                throw new IllegalAccessError("This maker is not attached to any DB, it only hold configuration");
            }
            DB dB = this.db;
            synchronized (dB) {
                return this.db.catGet(this.name + ".type") == null ? this.make() : this.db.treeMap(this.name, this.getKeySerializer(), this.valueSerializer);
            }
        }

        protected BTreeKeySerializer getKeySerializer() {
            if (this._keySerializer == null) {
                if (this._keySerializer2 == null && this._comparator != null) {
                    this._keySerializer2 = this.db.getDefaultSerializer();
                }
                if (this._keySerializer2 != null) {
                    this._keySerializer = this._keySerializer2.getBTreeKeySerializer(this._comparator);
                }
            }
            return this._keySerializer;
        }

        public <V> BTreeMap<String, V> makeStringMap() {
            this.keySerializer(Serializer.STRING);
            return this.make();
        }

        public <V> BTreeMap<Long, V> makeLongMap() {
            this.keySerializer(Serializer.LONG);
            return this.make();
        }

        protected BTreeMapMaker closeEngine() {
            this.closeEngine = true;
            return this;
        }
    }

    public class HTreeSetMaker {
        protected final String name;
        protected boolean counter = false;
        protected Serializer<?> serializer = null;
        protected long expireMaxSize = 0L;
        protected long expireStoreSize = 0L;
        protected long expire = 0L;
        protected long expireAccess = 0L;
        protected long expireTick = 1000L;
        protected Iterator pumpSource;
        protected int pumpPresortBatchSize = 10000000;
        protected boolean pumpIgnoreDuplicates = false;
        protected boolean closeEngine = false;
        protected ScheduledExecutorService executor;
        protected long executorPeriod;

        public HTreeSetMaker(String name) {
            this.executor = DB.this.executor;
            this.executorPeriod = 1000L;
            this.name = name;
        }

        public HTreeSetMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public HTreeSetMaker serializer(Serializer<?> serializer) {
            this.serializer = serializer;
            return this;
        }

        public HTreeSetMaker expireMaxSize(long maxSize) {
            this.expireMaxSize = maxSize;
            this.counter = true;
            return this;
        }

        public HTreeSetMaker expireStoreSize(double maxStoreSize) {
            this.expireStoreSize = (long)(maxStoreSize * 1024.0 * 1024.0 * 1024.0);
            return this;
        }

        public HTreeSetMaker expireAfterWrite(long interval, TimeUnit timeUnit) {
            this.expire = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeSetMaker expireAfterWrite(long interval) {
            this.expire = interval;
            return this;
        }

        public HTreeSetMaker expireAfterAccess(long interval, TimeUnit timeUnit) {
            this.expireAccess = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeSetMaker expireAfterAccess(long interval) {
            this.expireAccess = interval;
            return this;
        }

        public HTreeSetMaker expireTick(long expireTick) {
            this.expireTick = expireTick;
            return this;
        }

        public HTreeSetMaker pumpSource(Iterator<?> source) {
            this.pumpSource = source;
            return this;
        }

        public HTreeSetMaker pumpIgnoreDuplicates() {
            this.pumpIgnoreDuplicates = true;
            return this;
        }

        public HTreeSetMaker pumpPresort(int batchSize) {
            this.pumpPresortBatchSize = batchSize;
            return this;
        }

        public HTreeSetMaker executorEnable() {
            return this.executorEnable(Executors.newSingleThreadScheduledExecutor());
        }

        public HTreeSetMaker executorEnable(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public HTreeSetMaker executorPeriod(long period) {
            this.executorPeriod = period;
            return this;
        }

        protected HTreeSetMaker closeEngine() {
            this.closeEngine = true;
            return this;
        }

        public <K> Set<K> make() {
            if (this.expireMaxSize != 0L) {
                this.counter = true;
            }
            return DB.this.hashSetCreate(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K> Set<K> makeOrGet() {
            DB dB = DB.this;
            synchronized (dB) {
                return DB.this.catGet(this.name + ".type") == null ? this.make() : DB.this.hashSet(this.name, this.serializer);
            }
        }
    }

    public static class HTreeMapMaker {
        protected final DB db;
        protected final String name;
        protected final Engine[] engines;
        protected boolean counter = false;
        protected Serializer<?> keySerializer = null;
        protected Serializer<?> valueSerializer = null;
        protected long expireMaxSize = 0L;
        protected long expire = 0L;
        protected long expireAccess = 0L;
        protected long expireStoreSize;
        protected long expireTick = 1000L;
        protected Bind.MapWithModificationListener ondisk;
        protected boolean ondiskOverwrite;
        protected Fun.Function1<?, ?> valueCreator = null;
        protected Iterator pumpSource;
        protected Fun.Function1 pumpKeyExtractor;
        protected Fun.Function1 pumpValueExtractor;
        protected int pumpPresortBatchSize = 10000000;
        protected boolean pumpIgnoreDuplicates = false;
        protected boolean closeEngine = false;
        protected ScheduledExecutorService executor;
        protected long executorPeriod = 1000L;

        public HTreeMapMaker(DB db, String name, Engine[] engines) {
            this.db = db;
            this.name = name;
            this.engines = engines;
            this.executor = db.executor;
        }

        public HTreeMapMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public HTreeMapMaker keySerializer(Serializer<?> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public HTreeMapMaker valueSerializer(Serializer<?> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public HTreeMapMaker expireMaxSize(long maxSize) {
            this.expireMaxSize = maxSize;
            this.counter = true;
            return this;
        }

        public HTreeMapMaker expireTick(long expireTick) {
            this.expireTick = expireTick;
            return this;
        }

        public HTreeMapMaker expireAfterWrite(long interval, TimeUnit timeUnit) {
            this.expire = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeMapMaker expireAfterWrite(long interval) {
            this.expire = interval;
            return this;
        }

        public HTreeMapMaker expireAfterAccess(long interval, TimeUnit timeUnit) {
            this.expireAccess = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeMapMaker expireAfterAccess(long interval) {
            this.expireAccess = interval;
            return this;
        }

        public HTreeMapMaker expireStoreSize(double maxStoreSize) {
            this.expireStoreSize = (long)(maxStoreSize * 1024.0 * 1024.0 * 1024.0);
            return this;
        }

        public HTreeMapMaker expireOverflow(Bind.MapWithModificationListener ondisk, boolean overwrite) {
            this.ondisk = ondisk;
            this.ondiskOverwrite = overwrite;
            return this;
        }

        public HTreeMapMaker valueCreator(Fun.Function1<?, ?> valueCreator) {
            this.valueCreator = valueCreator;
            return this;
        }

        public <K, V> HTreeMapMaker pumpSource(Iterator<K> keysSource, Fun.Function1<V, K> valueExtractor) {
            this.pumpSource = keysSource;
            this.pumpKeyExtractor = Fun.extractNoTransform();
            this.pumpValueExtractor = valueExtractor;
            return this;
        }

        public <K, V> HTreeMapMaker pumpSource(Iterator<Fun.Pair<K, V>> entriesSource) {
            this.pumpSource = entriesSource;
            this.pumpKeyExtractor = Fun.extractKey();
            this.pumpValueExtractor = Fun.extractValue();
            return this;
        }

        public HTreeMapMaker pumpPresort(int batchSize) {
            this.pumpPresortBatchSize = batchSize;
            return this;
        }

        public HTreeMapMaker executorEnable() {
            return this.executorEnable(Executors.newSingleThreadScheduledExecutor());
        }

        public HTreeMapMaker executorEnable(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public HTreeMapMaker executorPeriod(long period) {
            this.executorPeriod = period;
            return this;
        }

        public <K> HTreeMapMaker pumpIgnoreDuplicates() {
            this.pumpIgnoreDuplicates = true;
            return this;
        }

        protected HTreeMapMaker closeEngine() {
            this.closeEngine = true;
            return this;
        }

        public <K, V> HTreeMap<K, V> make() {
            if (this.expireMaxSize != 0L) {
                this.counter = true;
            }
            return this.db.hashMapCreate(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K, V> HTreeMap<K, V> makeOrGet() {
            DB dB = this.db;
            synchronized (dB) {
                return this.db.catGet(this.name + ".type") == null ? this.make() : this.db.hashMap(this.name, this.keySerializer, this.valueSerializer, this.valueCreator);
            }
        }
    }

    protected static class IdentityWrapper {
        final Object o;

        public IdentityWrapper(Object o) {
            this.o = o;
        }

        public int hashCode() {
            return System.identityHashCode(this.o);
        }

        public boolean equals(Object v) {
            return ((IdentityWrapper)v).o == this.o;
        }
    }

    protected static interface Keys {
        public static final String type = ".type";
        public static final String keySerializer = ".keySerializer";
        public static final String valueSerializer = ".valueSerializer";
        public static final String serializer = ".serializer";
        public static final String counterRecids = ".counterRecids";
        public static final String hashSalt = ".hashSalt";
        public static final String segmentRecids = ".segmentRecids";
        public static final String expire = ".expire";
        public static final String expireMaxSize = ".expireMaxSize";
        public static final String expireAccess = ".expireAccess";
        public static final String expireStoreSize = ".expireStoreSize";
        public static final String expireHeads = ".expireHeads";
        public static final String expireTails = ".expireTails";
        public static final String expireTick = ".expireTick";
        public static final String expireTimeStart = ".expireTimeStart";
        public static final String rootRecidRef = ".rootRecidRef";
        public static final String maxNodeSize = ".maxNodeSize";
        public static final String valuesOutsideNodes = ".valuesOutsideNodes";
        public static final String numberOfNodeMetas = ".numberOfNodeMetas";
        public static final String headRecid = ".headRecid";
        public static final String tailRecid = ".tailRecid";
        public static final String useLocks = ".useLocks";
        public static final String size = ".size";
        public static final String recid = ".recid";
        public static final String headInsertRecid = ".headInsertRecid";
    }
}

