/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.DBException;
import org.mapdb.SerializerBase;

public final class DataIO {
    public static final long PACK_LONG_RESULT_MASK = 0xFFFFFFFFFFFFFFFL;
    static final long PRIME64_1 = -7046029288634856825L;
    static final long PRIME64_2 = -4417276706812531889L;
    static final long PRIME64_3 = 1609587929392839161L;
    static final long PRIME64_4 = -8796714831421723037L;
    static final long PRIME64_5 = 2870177450012600261L;

    private DataIO() {
    }

    public static int unpackInt(DataInput is) throws IOException {
        byte v;
        int ret = 0;
        do {
            v = is.readByte();
            ret = ret << 7 | v & 0x7F;
        } while (v < 0);
        return ret;
    }

    public static long unpackLong(DataInput in) throws IOException {
        byte v;
        long ret = 0L;
        do {
            v = in.readByte();
            ret = ret << 7 | (long)(v & 0x7F);
        } while (v < 0);
        return ret;
    }

    public static long unpackLong(InputStream in) throws IOException {
        int v;
        long ret = 0L;
        do {
            if ((v = in.read()) == -1) {
                throw new EOFException();
            }
            ret = ret << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) != 0);
        return ret;
    }

    public static void packLong(DataOutput out, long value) throws IOException {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.writeByte((byte)(value >>> shift & 0x7FL | 0x80L));
            shift -= 7;
        }
        out.writeByte((byte)(value & 0x7FL));
    }

    public static void packLong(OutputStream out, long value) throws IOException {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.write((int)(value >>> shift & 0x7FL | 0x80L));
            shift -= 7;
        }
        out.write((int)(value & 0x7FL));
    }

    public static int packLongSize(long value) {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        int ret = 1;
        while (shift != 0) {
            shift -= 7;
            ++ret;
        }
        return ret;
    }

    public static long unpackRecid(DataInput in) throws IOException {
        long val = DataIO.unpackLong(in);
        val = DataIO.parity3Get(val);
        return val >>> 3;
    }

    public static void packRecid(DataOutput out, long value) throws IOException {
        value = DataIO.parity3Set(value << 3);
        DataIO.packLong(out, value);
    }

    public static void packInt(DataOutput out, int value) throws IOException {
        int shift = value & 0xFFFFFF80;
        if (shift != 0) {
            shift = 31 - Integer.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                out.writeByte((byte)(value >>> shift & 0x7F | 0x80));
                shift -= 7;
            }
        }
        out.writeByte((byte)(value & 0x7F));
    }

    public static void packIntBigger(DataOutput out, int value) throws IOException {
        int shift = 31 - Integer.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            out.writeByte((byte)(value >>> shift & 0x7F | 0x80));
            shift -= 7;
        }
        out.writeByte((byte)(value & 0x7F));
    }

    public static int longHash(long h) {
        h *= -7046029254386353131L;
        h ^= h >> 32;
        return (int)(h ^ h >> 16);
    }

    public static int intHash(int h) {
        return (h *= -1640531527) ^ h >> 16;
    }

    public static int packLongBidi(byte[] b, int pos, long value) {
        int ret = 0;
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            b[pos + ret++] = (byte)(value >>> shift & 0x7FL);
            shift -= 7;
        }
        b[pos + ret++] = (byte)(value & 0x7FL | 0x80L);
        return ret;
    }

    public static long unpackLongBidi(byte[] b, int pos) {
        byte v;
        long ret = 0L;
        int pos2 = 0;
        do {
            v = b[pos + pos2++];
            ret = ret << 7 | (long)(v & 0x7F);
        } while (v >= 0);
        return (long)pos2 << 60 | ret;
    }

    public static long unpackLongBidiReverse(byte[] bb, int pos, int limit) {
        int pos2;
        for (pos2 = pos - 2; pos2 >= limit && (bb[pos2] & 0x80) == 0; --pos2) {
        }
        return DataIO.unpackLongBidi(bb, ++pos2);
    }

    public static long getLong(byte[] buf, int pos) {
        return (long)buf[pos++] << 56 | ((long)buf[pos++] & 0xFFL) << 48 | ((long)buf[pos++] & 0xFFL) << 40 | ((long)buf[pos++] & 0xFFL) << 32 | ((long)buf[pos++] & 0xFFL) << 24 | ((long)buf[pos++] & 0xFFL) << 16 | ((long)buf[pos++] & 0xFFL) << 8 | (long)buf[pos] & 0xFFL;
    }

    public static void putLong(byte[] buf, int pos, long v) {
        buf[pos++] = (byte)(0xFFL & v >> 56);
        buf[pos++] = (byte)(0xFFL & v >> 48);
        buf[pos++] = (byte)(0xFFL & v >> 40);
        buf[pos++] = (byte)(0xFFL & v >> 32);
        buf[pos++] = (byte)(0xFFL & v >> 24);
        buf[pos++] = (byte)(0xFFL & v >> 16);
        buf[pos++] = (byte)(0xFFL & v >> 8);
        buf[pos] = (byte)(0xFFL & v);
    }

    public static long getSixLong(byte[] buf, int pos) {
        return (long)(buf[pos++] & 0xFF) << 40 | (long)(buf[pos++] & 0xFF) << 32 | (long)(buf[pos++] & 0xFF) << 24 | (long)(buf[pos++] & 0xFF) << 16 | (long)(buf[pos++] & 0xFF) << 8 | (long)(buf[pos] & 0xFF);
    }

    public static void putSixLong(byte[] buf, int pos, long value) {
        buf[pos++] = (byte)(0xFFL & value >> 40);
        buf[pos++] = (byte)(0xFFL & value >> 32);
        buf[pos++] = (byte)(0xFFL & value >> 24);
        buf[pos++] = (byte)(0xFFL & value >> 16);
        buf[pos++] = (byte)(0xFFL & value >> 8);
        buf[pos] = (byte)(0xFFL & value);
    }

    public static long nextPowTwo(long a) {
        return 1L << 64 - Long.numberOfLeadingZeros(a - 1L);
    }

    public static int nextPowTwo(int a) {
        return 1 << 32 - Integer.numberOfLeadingZeros(a - 1);
    }

    public static void readFully(InputStream in, byte[] data) throws IOException {
        int c;
        int len = data.length;
        for (int read = 0; read < len; read += c) {
            c = in.read(data, read, len - read);
            if (c >= 0) continue;
            throw new EOFException();
        }
    }

    public static void skipFully(InputStream in, long length) throws IOException {
        while ((length -= in.skip(length)) > 0L) {
        }
    }

    public static long fillLowBits(int bitCount) {
        long ret = 0L;
        while (bitCount > 0) {
            ret = ret << 1 | 1L;
            --bitCount;
        }
        return ret;
    }

    public static long parity1Set(long i) {
        return i | (long)((Long.bitCount(i) + 1) % 2);
    }

    public static long parity1Get(long i) {
        if (Long.bitCount(i) % 2 != 1) {
            throw new DBException.PointerChecksumBroken();
        }
        return i & 0xFFFFFFFFFFFFFFFEL;
    }

    public static long parity3Set(long i) {
        return i | (long)((Long.bitCount(i) + 1) % 8);
    }

    public static long parity3Get(long i) {
        long ret = i & 0xFFFFFFFFFFFFFFF8L;
        if ((long)((Long.bitCount(ret) + 1) % 8) != (i & 7L)) {
            throw new DBException.PointerChecksumBroken();
        }
        return ret;
    }

    public static long parity4Set(long i) {
        return i | (long)((Long.bitCount(i) + 1) % 16);
    }

    public static long parity4Get(long i) {
        long ret = i & 0xFFFFFFFFFFFFFFF0L;
        if ((long)((Long.bitCount(ret) + 1) % 16) != (i & 0xFL)) {
            throw new DBException.PointerChecksumBroken();
        }
        return ret;
    }

    public static long parity16Set(long i) {
        return i | (long)DataIO.longHash(i) & 0xFFFFL;
    }

    public static long parity16Get(long i) {
        long ret = i & 0xFFFFFFFFFFFF0000L;
        if (((long)DataIO.longHash(ret) & 0xFFFFL) != (i & 0xFFFFL)) {
            throw new DBException.PointerChecksumBroken();
        }
        return ret;
    }

    public static String toHexa(byte[] bb) {
        char[] HEXA_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ret = new char[bb.length * 2];
        for (int i = 0; i < bb.length; ++i) {
            ret[i * 2] = HEXA_CHARS[(bb[i] & 0xF0) >> 4];
            ret[i * 2 + 1] = HEXA_CHARS[bb[i] & 0xF];
        }
        return new String(ret);
    }

    public static byte[] fromHexa(String s) {
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }

    public static long hash(byte[] buf, int off, int len, long seed) {
        long h64;
        if (len < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
        if (off < 0 || off > buf.length || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int end = off + len;
        if (len >= 32) {
            int limit = end - 32;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed + 0L;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += DataIO.readLongLE(buf, off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += DataIO.readLongLE(buf, off += 8) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += DataIO.readLongLE(buf, off += 8) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += DataIO.readLongLE(buf, off += 8) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((off += 8) <= limit);
            h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            h64 ^= (v1 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            h64 ^= (v2 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            h64 ^= (v3 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            h64 ^= (v4 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
        } else {
            h64 = seed + 2870177450012600261L;
        }
        h64 += (long)len;
        while (off <= end - 8) {
            long k1 = DataIO.readLongLE(buf, off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            h64 ^= (k1 *= -7046029288634856825L);
            h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 8;
        }
        if (off <= end - 4) {
            h64 ^= ((long)DataIO.readIntLE(buf, off) & 0xFFFFFFFFL) * -7046029288634856825L;
            h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 4;
        }
        while (off < end) {
            h64 ^= (long)(buf[off] & 0xFF) * 2870177450012600261L;
            h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
            ++off;
        }
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        h64 *= 1609587929392839161L;
        h64 ^= h64 >>> 32;
        return h64;
    }

    static long readLongLE(byte[] buf, int i) {
        return (long)buf[i] & 0xFFL | ((long)buf[i + 1] & 0xFFL) << 8 | ((long)buf[i + 2] & 0xFFL) << 16 | ((long)buf[i + 3] & 0xFFL) << 24 | ((long)buf[i + 4] & 0xFFL) << 32 | ((long)buf[i + 5] & 0xFFL) << 40 | ((long)buf[i + 6] & 0xFFL) << 48 | ((long)buf[i + 7] & 0xFFL) << 56;
    }

    static int readIntLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
    }

    public static long hash(char[] buf, int off, int len, long seed) {
        long h64;
        if (len < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
        if (off < 0 || off > buf.length || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int end = off + len;
        if (len >= 16) {
            int limit = end - 16;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed + 0L;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += DataIO.readLongLE(buf, off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += DataIO.readLongLE(buf, off += 4) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += DataIO.readLongLE(buf, off += 4) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += DataIO.readLongLE(buf, off += 4) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((off += 4) <= limit);
            h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            h64 ^= (v1 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            h64 ^= (v2 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            h64 ^= (v3 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            h64 ^= (v4 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
        } else {
            h64 = seed + 2870177450012600261L;
        }
        h64 += (long)len;
        while (off <= end - 4) {
            long k1 = DataIO.readLongLE(buf, off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            h64 ^= (k1 *= -7046029288634856825L);
            h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 4;
        }
        if (off <= end - 2) {
            h64 ^= ((long)DataIO.readIntLE(buf, off) & 0xFFFFFFFFL) * -7046029288634856825L;
            h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 2;
        }
        while (off < end) {
            h64 ^= (long)(DataIO.readCharLE(buf, off) & 0xFFFF) * 2870177450012600261L;
            h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
            ++off;
        }
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        h64 *= 1609587929392839161L;
        h64 ^= h64 >>> 32;
        return h64;
    }

    static long readLongLE(char[] buf, int i) {
        return (long)buf[i] & 0xFFFFL | ((long)buf[i + 1] & 0xFFFFL) << 16 | ((long)buf[i + 2] & 0xFFFFL) << 32 | ((long)buf[i + 3] & 0xFFFFL) << 48;
    }

    static int readIntLE(char[] buf, int i) {
        return buf[i] & 0xFFFF | (buf[i + 1] & 0xFFFF) << 16;
    }

    static int readCharLE(char[] buf, int i) {
        return buf[i];
    }

    public static final class HeartbeatFileLock {
        private static final Logger LOG = Logger.getLogger(HeartbeatFileLock.class.getName());
        private static final int SLEEP_GAP = 25;
        private static final int TIME_GRANULARITY = 2000;
        private WeakReference quitAfterGCed = null;
        private final long id = new SecureRandom().nextLong();
        private volatile File file;
        private volatile boolean locked;
        private final int sleep;
        private long lastWrite;
        private Thread watchdog;
        private final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HeartbeatFileLock.this.run();
            }
        };

        public HeartbeatFileLock(File file, int sleep) {
            this.file = file;
            this.sleep = sleep;
        }

        public void setQuitAfterGCed(Object object) {
            this.quitAfterGCed = object == null ? null : new WeakReference<Object>(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            LOG.fine("Lock Watchdog start");
            try {
                while (this.locked && this.file != null) {
                    block15: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("watchdog check");
                        }
                        WeakReference quitAfterGCed = this.quitAfterGCed;
                        if (quitAfterGCed == null || quitAfterGCed.get() != null) break block15;
                        return;
                    }
                    try {
                        if (!this.file.exists() || this.file.lastModified() != this.lastWrite) {
                            this.save();
                        }
                        Thread.sleep(this.sleep);
                    }
                    catch (OutOfMemoryError e) {
                    }
                    catch (InterruptedException e) {
                    }
                    catch (NullPointerException e) {
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "MapDB Lock Watchdog", e);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "MapDB Lock Watchdog failed", e);
            }
            finally {
                LOG.fine("Lock Watcher end");
            }
        }

        private void waitUntilOld() {
            for (int i = 0; i < 160; ++i) {
                long last = this.file.lastModified();
                long dist = System.currentTimeMillis() - last;
                if (dist < -2000L) {
                    HeartbeatFileLock.sleep(10 * this.sleep);
                    return;
                }
                if (dist > 2000L) {
                    return;
                }
                HeartbeatFileLock.sleep(25);
            }
            throw new DBException.FileLocked("Lock file recently modified");
        }

        public synchronized void lock() {
            if (this.locked) {
                throw new DBException.FileLocked("Already locked, cannot call lock() twice");
            }
            try {
                if (!this.file.createNewFile()) {
                    this.waitUntilOld();
                    this.save();
                    HeartbeatFileLock.sleep(10 * this.sleep);
                    if (this.load() != this.id) {
                        throw new DBException.FileLocked("Locked by another process");
                    }
                    this.delete();
                    if (!this.file.createNewFile()) {
                        throw new DBException.FileLocked("Another process was faster");
                    }
                }
                this.save();
                HeartbeatFileLock.sleep(25);
                if (this.load() != this.id) {
                    this.file = null;
                    throw new DBException.FileLocked("Concurrent update");
                }
                this.watchdog = new Thread(this.runnable, "MapDB File Lock Watchdog " + this.file.getAbsolutePath());
                this.watchdog.setDaemon(true);
                try {
                    this.watchdog.setPriority(9);
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "Could not set thread priority", e);
                }
                this.watchdog.start();
            }
            catch (IOException e) {
                throw new DBException.FileLocked("Could not lock file: " + this.file, e);
            }
            this.locked = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void unlock() {
            if (!this.locked) {
                return;
            }
            this.locked = false;
            try {
                if (this.watchdog != null) {
                    this.watchdog.interrupt();
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "unlock interrupt", e);
            }
            try {
                if (this.file != null && this.load() == this.id) {
                    this.delete();
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "unlock", e);
            }
            finally {
                this.file = null;
            }
            try {
                if (this.watchdog != null) {
                    this.watchdog.join();
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "unlock", e);
            }
            finally {
                this.watchdog = null;
            }
        }

        private void save() throws IOException {
            RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
            raf.seek(0L);
            raf.writeLong(this.id);
            raf.getFD().sync();
            raf.close();
            this.lastWrite = this.file.lastModified();
        }

        private long load() throws IOException {
            RandomAccessFile raf = new RandomAccessFile(this.file, "r");
            raf.seek(0L);
            long ret = raf.readLong();
            raf.close();
            return ret;
        }

        private static void sleep(int delay) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new DBException.Interrupted(e);
            }
        }

        protected void delete() {
            for (int i = 0; i < 16; ++i) {
                boolean ok = this.file.delete();
                if (ok || !this.file.exists()) {
                    return;
                }
                HeartbeatFileLock.wait(i);
            }
            throw new DBException.FileDeleteFailed(this.file);
        }

        private static void wait(int i) {
            if (i == 8) {
                System.gc();
            }
            try {
                long sleep = Math.min(256, i * i);
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public boolean isLocked() {
            return this.locked;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static final class DataOutputByteArray
    extends OutputStream
    implements DataOutput {
        public byte[] buf = new byte[128];
        public int pos = 0;
        public int sizeMask = -1 - (this.buf.length - 1);

        public byte[] copyBytes() {
            return Arrays.copyOf(this.buf, this.pos);
        }

        public void ensureAvail(int n) {
            if (((n += this.pos) & this.sizeMask) != 0) {
                this.grow(n);
            }
        }

        private void grow(int n) {
            int newSize = Math.max(DataIO.nextPowTwo(n), this.buf.length);
            this.sizeMask = -1 - (newSize - 1);
            this.buf = Arrays.copyOf(this.buf, newSize);
        }

        @Override
        public void write(int b) throws IOException {
            this.ensureAvail(1);
            this.buf[this.pos++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureAvail(len);
            System.arraycopy(b, off, this.buf, this.pos, len);
            this.pos += len;
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.ensureAvail(1);
            this.buf[this.pos++] = (byte)(v ? 1 : 0);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.ensureAvail(1);
            this.buf[this.pos++] = (byte)v;
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.ensureAvail(2);
            this.buf[this.pos++] = (byte)(0xFF & v >> 8);
            this.buf[this.pos++] = (byte)(0xFF & v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.ensureAvail(2);
            this.buf[this.pos++] = (byte)(v >>> 8);
            this.buf[this.pos++] = (byte)v;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.ensureAvail(4);
            this.buf[this.pos++] = (byte)(0xFF & v >> 24);
            this.buf[this.pos++] = (byte)(0xFF & v >> 16);
            this.buf[this.pos++] = (byte)(0xFF & v >> 8);
            this.buf[this.pos++] = (byte)(0xFF & v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.ensureAvail(8);
            this.buf[this.pos++] = (byte)(0xFFL & v >> 56);
            this.buf[this.pos++] = (byte)(0xFFL & v >> 48);
            this.buf[this.pos++] = (byte)(0xFFL & v >> 40);
            this.buf[this.pos++] = (byte)(0xFFL & v >> 32);
            this.buf[this.pos++] = (byte)(0xFFL & v >> 24);
            this.buf[this.pos++] = (byte)(0xFFL & v >> 16);
            this.buf[this.pos++] = (byte)(0xFFL & v >> 8);
            this.buf[this.pos++] = (byte)(0xFFL & v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.writeInt(Float.floatToIntBits(v));
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.writeLong(Double.doubleToLongBits(v));
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.writeUTF(s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.writeUTF(s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            int len = s.length();
            this.packInt(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                this.packInt(c);
            }
        }

        public void packInt(int value) throws IOException {
            this.ensureAvail(5);
            int shift = value & 0xFFFFFF80;
            if (shift != 0) {
                shift = 31 - Integer.numberOfLeadingZeros(value);
                shift -= shift % 7;
                while (shift != 0) {
                    this.buf[this.pos++] = (byte)(value >>> shift & 0x7F | 0x80);
                    shift -= 7;
                }
            }
            this.buf[this.pos++] = (byte)(value & 0x7F);
        }

        public void packIntBigger(int value) throws IOException {
            this.ensureAvail(5);
            int shift = 31 - Integer.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                this.buf[this.pos++] = (byte)(value >>> shift & 0x7F | 0x80);
                shift -= 7;
            }
            this.buf[this.pos++] = (byte)(value & 0x7F);
        }

        public void packLong(long value) {
            this.ensureAvail(10);
            int shift = 63 - Long.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                this.buf[this.pos++] = (byte)(value >>> shift & 0x7FL | 0x80L);
                shift -= 7;
            }
            this.buf[this.pos++] = (byte)(value & 0x7FL);
        }
    }

    public static final class DataInputByteBuffer
    implements DataInput,
    DataInputInternal {
        public final ByteBuffer buf;
        public int pos;

        public DataInputByteBuffer(ByteBuffer buf, int pos) {
            this.buf = buf;
            this.pos = pos;
        }

        public DataInputByteBuffer(byte[] b) {
            this(ByteBuffer.wrap(b), 0);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            ByteBuffer clone = this.buf.duplicate();
            clone.position(this.pos);
            this.pos += len;
            clone.get(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.pos += n;
            return n;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.buf.get(this.pos++) == 1;
        }

        @Override
        public byte readByte() throws IOException {
            return this.buf.get(this.pos++);
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.buf.get(this.pos++) & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            short ret = this.buf.getShort(this.pos);
            this.pos += 2;
            return ret;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.readChar();
        }

        @Override
        public char readChar() throws IOException {
            return (char)((this.buf.get(this.pos++) & 0xFF) << 8 | this.buf.get(this.pos++) & 0xFF);
        }

        @Override
        public int readInt() throws IOException {
            int ret = this.buf.getInt(this.pos);
            this.pos += 4;
            return ret;
        }

        @Override
        public long readLong() throws IOException {
            long ret = this.buf.getLong(this.pos);
            this.pos += 8;
            return ret;
        }

        @Override
        public float readFloat() throws IOException {
            float ret = this.buf.getFloat(this.pos);
            this.pos += 4;
            return ret;
        }

        @Override
        public double readDouble() throws IOException {
            double ret = this.buf.getDouble(this.pos);
            this.pos += 8;
            return ret;
        }

        @Override
        public String readLine() throws IOException {
            return this.readUTF();
        }

        @Override
        public String readUTF() throws IOException {
            int size = this.unpackInt();
            return SerializerBase.deserializeString(this, size);
        }

        @Override
        public int getPos() {
            return this.pos;
        }

        @Override
        public void setPos(int pos) {
            this.pos = pos;
        }

        @Override
        public byte[] internalByteArray() {
            return null;
        }

        @Override
        public ByteBuffer internalByteBuffer() {
            return this.buf;
        }

        @Override
        public void close() {
        }

        @Override
        public long unpackLong() throws IOException {
            byte v;
            long ret = 0L;
            do {
                v = this.buf.get(this.pos++);
                ret = ret << 7 | (long)(v & 0x7F);
            } while (v < 0);
            return ret;
        }

        @Override
        public int unpackInt() throws IOException {
            byte v;
            int ret = 0;
            do {
                v = this.buf.get(this.pos++);
                ret = ret << 7 | v & 0x7F;
            } while (v < 0);
            return ret;
        }

        @Override
        public long[] unpackLongArrayDeltaCompression(int size) throws IOException {
            long[] ret = new long[size];
            int pos2 = this.pos;
            ByteBuffer buf2 = this.buf;
            long prev = 0L;
            for (int i = 0; i < size; ++i) {
                byte v;
                long r = 0L;
                do {
                    v = buf2.get(pos2++);
                    r = r << 7 | (long)(v & 0x7F);
                } while (v < 0);
                ret[i] = prev += r;
            }
            this.pos = pos2;
            return ret;
        }

        @Override
        public void unpackLongArray(long[] array, int start, int end) {
            int pos2 = this.pos;
            ByteBuffer buf2 = this.buf;
            while (start < end) {
                byte v;
                long ret = 0L;
                do {
                    v = buf2.get(pos2++);
                    ret = ret << 7 | (long)(v & 0x7F);
                } while (v < 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }

        @Override
        public void unpackIntArray(int[] array, int start, int end) {
            int pos2 = this.pos;
            ByteBuffer buf2 = this.buf;
            while (start < end) {
                byte v;
                int ret = 0;
                do {
                    v = buf2.get(pos2++);
                    ret = ret << 7 | v & 0x7F;
                } while (v < 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }
    }

    public static final class DataInputToStream
    extends InputStream {
        protected final DataInput in;

        public DataInputToStream(DataInput in) {
            this.in = in;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.in.readFully(b, off, len);
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            n = Math.min(n, Integer.MAX_VALUE);
            return this.in.skipBytes((int)n);
        }

        @Override
        public void close() throws IOException {
            if (this.in instanceof Closeable) {
                ((Closeable)((Object)this.in)).close();
            }
        }

        @Override
        public int read() throws IOException {
            return this.in.readUnsignedByte();
        }
    }

    public static final class DataInputByteArray
    implements DataInput,
    DataInputInternal {
        protected final byte[] buf;
        protected int pos;

        public DataInputByteArray(byte[] b) {
            this(b, 0);
        }

        public DataInputByteArray(byte[] bb, int pos) {
            this.buf = bb;
            this.pos = pos;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.pos += n;
            return n;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.buf[this.pos++] == 1;
        }

        @Override
        public byte readByte() throws IOException {
            return this.buf[this.pos++];
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.buf[this.pos++] & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            return (short)(this.buf[this.pos++] << 8 | this.buf[this.pos++] & 0xFF);
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.readChar();
        }

        @Override
        public char readChar() throws IOException {
            return (char)((this.buf[this.pos++] & 0xFF) << 8 | this.buf[this.pos++] & 0xFF);
        }

        @Override
        public int readInt() throws IOException {
            int p = this.pos;
            byte[] b = this.buf;
            int ret = b[p++] << 24 | (b[p++] & 0xFF) << 16 | (b[p++] & 0xFF) << 8 | b[p++] & 0xFF;
            this.pos = p;
            return ret;
        }

        @Override
        public long readLong() throws IOException {
            int p = this.pos;
            byte[] b = this.buf;
            long ret = (long)b[p++] << 56 | ((long)b[p++] & 0xFFL) << 48 | ((long)b[p++] & 0xFFL) << 40 | ((long)b[p++] & 0xFFL) << 32 | ((long)b[p++] & 0xFFL) << 24 | ((long)b[p++] & 0xFFL) << 16 | ((long)b[p++] & 0xFFL) << 8 | (long)b[p++] & 0xFFL;
            this.pos = p;
            return ret;
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public String readLine() throws IOException {
            return this.readUTF();
        }

        @Override
        public String readUTF() throws IOException {
            int len = this.unpackInt();
            char[] b = new char[len];
            for (int i = 0; i < len; ++i) {
                b[i] = (char)this.unpackInt();
            }
            return new String(b);
        }

        @Override
        public int getPos() {
            return this.pos;
        }

        @Override
        public void setPos(int pos) {
            this.pos = pos;
        }

        @Override
        public byte[] internalByteArray() {
            return this.buf;
        }

        @Override
        public ByteBuffer internalByteBuffer() {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public long unpackLong() throws IOException {
            byte v;
            byte[] b = this.buf;
            int p = this.pos;
            long ret = 0L;
            do {
                v = b[p++];
                ret = ret << 7 | (long)(v & 0x7F);
            } while (v < 0);
            this.pos = p;
            return ret;
        }

        @Override
        public int unpackInt() throws IOException {
            byte v;
            byte[] b = this.buf;
            int p = this.pos;
            int ret = 0;
            do {
                v = b[p++];
                ret = ret << 7 | v & 0x7F;
            } while (v < 0);
            this.pos = p;
            return ret;
        }

        @Override
        public long[] unpackLongArrayDeltaCompression(int size) throws IOException {
            long[] ret = new long[size];
            int pos2 = this.pos;
            byte[] buf2 = this.buf;
            long prev = 0L;
            for (int i = 0; i < size; ++i) {
                byte v;
                long r = 0L;
                do {
                    v = buf2[pos2++];
                    r = r << 7 | (long)(v & 0x7F);
                } while (v < 0);
                ret[i] = prev += r;
            }
            this.pos = pos2;
            return ret;
        }

        @Override
        public void unpackLongArray(long[] array, int start, int end) {
            int pos2 = this.pos;
            byte[] buf2 = this.buf;
            while (start < end) {
                byte v;
                long ret = 0L;
                do {
                    v = buf2[pos2++];
                    ret = ret << 7 | (long)(v & 0x7F);
                } while (v < 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }

        @Override
        public void unpackIntArray(int[] array, int start, int end) {
            int pos2 = this.pos;
            byte[] buf2 = this.buf;
            while (start < end) {
                byte v;
                int ret = 0;
                do {
                    v = buf2[pos2++];
                    ret = ret << 7 | v & 0x7F;
                } while (v < 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }
    }

    public static interface DataInputInternal
    extends DataInput,
    Closeable {
        public int getPos();

        public void setPos(int var1);

        public byte[] internalByteArray();

        public ByteBuffer internalByteBuffer();

        @Override
        public void close();

        public long unpackLong() throws IOException;

        public int unpackInt() throws IOException;

        public long[] unpackLongArrayDeltaCompression(int var1) throws IOException;

        public void unpackLongArray(long[] var1, int var2, int var3);

        public void unpackIntArray(int[] var1, int var2, int var3);
    }
}

