/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.Store;

public class StoreHeap
extends Store {
    protected final Store.LongObjectMap[] data = new Store.LongObjectMap[this.lockScale];
    protected final Store.LongObjectMap[] rollback;
    protected static final Object TOMBSTONE = new Object();
    protected static final Object NULL = new Object();
    protected long[] freeRecid;
    protected int freeRecidTail;
    protected long maxRecid = 8L;
    protected final Lock newRecidLock;
    protected List<Snapshot> snapshots;

    public StoreHeap(boolean txDisabled, int lockScale, int lockingStrategy, boolean snapshotEnable) {
        super(null, null, null, lockScale, 0, false, false, null, false, snapshotEnable, false, null);
        int i;
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = new Store.LongObjectMap();
        }
        if (txDisabled) {
            this.rollback = null;
        } else {
            this.rollback = new Store.LongObjectMap[this.lockScale];
            for (i = 0; i < this.rollback.length; ++i) {
                this.rollback[i] = new Store.LongObjectMap();
            }
        }
        this.newRecidLock = lockingStrategy == 2 ? NOLOCK : new ReentrantLock(false);
        this.freeRecid = new long[16];
        this.freeRecidTail = 0;
        this.snapshots = snapshotEnable ? new CopyOnWriteArrayList() : null;
        for (long recid = 1L; recid <= 7L; ++recid) {
            this.data[this.lockPos(recid)].put(recid, NULL);
        }
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        int pos = this.lockPos(recid);
        Object ret = this.data[pos].get(recid);
        if (ret == null) {
            throw new DBException.EngineGetVoid();
        }
        if (ret == TOMBSTONE || ret == NULL) {
            ret = null;
        }
        return (A)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        Object val2 = value == null ? NULL : value;
        int pos = this.lockPos(recid);
        Store.LongObjectMap data2 = this.data[pos];
        Lock lock = this.locks[pos].writeLock();
        lock.lock();
        try {
            Object old = data2.put(recid, val2);
            this.updateOld(pos, recid, old);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void update2(long recid, DataIO.DataOutputByteArray out) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected <A> void delete2(long recid, Serializer<A> serializer) {
        int pos = this.lockPos(recid);
        Object old = this.data[pos].put(recid, TOMBSTONE);
        this.updateOld(pos, recid, old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        int pos = this.lockPos(recid);
        Lock lock = this.locks[pos].writeLock();
        lock.lock();
        try {
            A oldVal = this.get2(recid, serializer);
            if (oldVal == expectedOldValue || oldVal != null && serializer.equals(oldVal, expectedOldValue)) {
                Object newValue2 = newValue == null ? NULL : newValue;
                Object old = this.data[pos].put(recid, newValue2);
                this.updateOld(pos, recid, old);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected void updateOld(int pos, long recid, Object old) {
        Store.LongObjectMap rol;
        if (this.rollback != null && (rol = this.rollback[pos]).get(recid) == null) {
            rol.put(recid, old);
        }
        if (this.snapshots != null) {
            for (Snapshot snap : this.snapshots) {
                snap.oldData[pos].putIfAbsent(recid, old);
            }
        }
    }

    @Override
    public long getCurrSize() {
        return -1L;
    }

    @Override
    public long getFreeSize() {
        return -1L;
    }

    @Override
    public boolean fileLoad() {
        return false;
    }

    @Override
    public void backup(OutputStream out, boolean incremental) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void backupRestore(InputStream[] in) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        long recid = this.allocateRecid();
        int lockPos = this.lockPos(recid);
        Lock lock = this.locks[lockPos].writeLock();
        lock.lock();
        try {
            Store.LongObjectMap rol;
            this.data[lockPos].put(recid, NULL);
            if (this.rollback != null && (rol = this.rollback[lockPos]).get(recid) == null) {
                rol.put(recid, TOMBSTONE);
            }
        }
        finally {
            lock.unlock();
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long allocateRecid() {
        long recid;
        this.newRecidLock.lock();
        try {
            if (this.freeRecidTail > 0) {
                --this.freeRecidTail;
                recid = this.freeRecid[this.freeRecidTail];
                this.freeRecid[this.freeRecidTail] = 0L;
            } else {
                recid = this.maxRecid++;
            }
        }
        finally {
            this.newRecidLock.unlock();
        }
        return recid;
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        long recid = this.allocateRecid();
        this.update(recid, value, serializer);
        return recid;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        if (this.rollback != null) {
            this.commitLock.lock();
            try {
                for (int i = 0; i < this.data.length; ++i) {
                    Lock lock = this.locks[i].writeLock();
                    lock.lock();
                    try {
                        this.rollback[i].clear();
                        continue;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            finally {
                this.commitLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        if (this.rollback == null) {
            throw new UnsupportedOperationException();
        }
        this.commitLock.lock();
        try {
            for (int i = 0; i < this.data.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
                try {
                    Store.LongObjectMap r = this.rollback[i];
                    Store.LongObjectMap d = this.data[i];
                    long[] rs = r.set;
                    Object[] rv = r.values;
                    for (int j = 0; j < rs.length; ++j) {
                        long recid = rs[j];
                        if (recid == 0L) continue;
                        Object val = rv[j];
                        if (val == TOMBSTONE) {
                            d.remove(recid);
                            continue;
                        }
                        d.put(recid, val);
                    }
                    r.clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    @Override
    public boolean canRollback() {
        return this.rollback != null;
    }

    @Override
    public Engine snapshot() throws UnsupportedOperationException {
        if (this.snapshots == null) {
            throw new UnsupportedOperationException();
        }
        return new Snapshot(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        this.commitLock.lock();
        try {
            this.newRecidLock.lock();
            try {
                for (int i = 0; i < this.locks.length; ++i) {
                    this.locks[i].writeLock().lock();
                    try {
                        Store.LongObjectMap m = this.data[i];
                        for (int j = 0; j < m.set.length; ++j) {
                            long recid = m.set[j];
                            if (recid == 0L || m.values[j] != TOMBSTONE) continue;
                            m.remove(m.set[j]);
                            if (this.freeRecid.length == this.freeRecidTail) {
                                this.freeRecid = Arrays.copyOf(this.freeRecid, this.freeRecid.length * 2);
                            }
                            this.freeRecid[this.freeRecidTail++] = recid;
                        }
                        continue;
                    }
                    finally {
                        this.locks[i].writeLock().unlock();
                    }
                }
            }
            finally {
                this.newRecidLock.unlock();
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    public static class Snapshot
    extends Engine.ReadOnly {
        protected StoreHeap engine;
        protected Store.LongObjectMap[] oldData;

        public Snapshot(StoreHeap engine) {
            this.engine = engine;
            this.oldData = new Store.LongObjectMap[engine.lockScale];
            for (int i = 0; i < this.oldData.length; ++i) {
                this.oldData[i] = new Store.LongObjectMap();
            }
            engine.snapshots.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            StoreHeap engine = this.engine;
            int pos = engine.lockPos(recid);
            Lock lock = engine.locks[pos].readLock();
            lock.lock();
            try {
                Object ret = this.oldData[pos].get(recid);
                if (ret == null) {
                    ret = engine.get(recid, serializer);
                }
                if (ret == TOMBSTONE) {
                    A a = null;
                    return a;
                }
                Object object = ret;
                return (A)object;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void close() {
            this.engine.snapshots.remove(this);
            this.engine = null;
            this.oldData = null;
        }

        @Override
        public boolean isClosed() {
            return this.engine != null;
        }

        @Override
        public boolean canRollback() {
            return false;
        }

        @Override
        public boolean canSnapshot() {
            return true;
        }

        @Override
        public Engine snapshot() throws UnsupportedOperationException {
            return this;
        }

        @Override
        public Engine getWrappedEngine() {
            return this.engine;
        }

        @Override
        public void clearCache() {
        }
    }
}

