/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreDirect;
import org.mapdb.StoreWAL;
import org.mapdb.Volume;

public class StoreCached
extends StoreDirect {
    protected static final byte[] LONG_STACK_PAGE_TOMBSTONE = new byte[0];
    protected final Store.LongObjectMap<byte[]> uncommittedStackPages = new Store.LongObjectMap();
    protected final Store.LongObjectObjectMap[] writeCache;
    protected static final Object TOMBSTONE2 = new Object(){

        public String toString() {
            return StoreCached.class.getName() + ".TOMBSTONE2";
        }
    };
    protected final int writeQueueSize;
    protected final int writeQueueSizePerSegment;
    protected final boolean flushInThread;

    public StoreCached(String fileName, Volume.VolumeFactory volumeFactory, Store.Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat, ScheduledExecutorService executor, long startSize, long sizeIncrement, boolean recidReuseDisable, long executorScheduledRate, int writeQueueSize) {
        super(fileName, volumeFactory, cache, lockScale, lockingStrategy, checksum, compress, password, readonly, snapshotEnable, fileLockDisable, fileLockHeartbeat, executor, startSize, sizeIncrement, recidReuseDisable);
        int i;
        this.writeQueueSize = writeQueueSize;
        this.writeQueueSizePerSegment = writeQueueSize / lockScale;
        this.writeCache = new Store.LongObjectObjectMap[this.lockScale];
        for (i = 0; i < this.writeCache.length; ++i) {
            this.writeCache[i] = new Store.LongObjectObjectMap();
        }
        boolean bl = this.flushInThread = this.executor == null && writeQueueSize != 0 && !(this instanceof StoreWAL);
        if (this.executor != null && !(this instanceof StoreWAL)) {
            for (i = 0; i < this.lockScale; ++i) {
                final int seg = i;
                final Lock lock = this.locks[i].writeLock();
                this.executor.scheduleAtFixedRate(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        lock.lock();
                        try {
                            if (StoreCached.this.writeCache[seg].size > StoreCached.this.writeQueueSizePerSegment) {
                                StoreCached.this.flushWriteCacheSegment(seg);
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }, (long)((double)executorScheduledRate * Math.random()), executorScheduledRate, TimeUnit.MILLISECONDS);
            }
        }
    }

    public StoreCached(String fileName) {
        this(fileName, fileName == null ? CC.DEFAULT_MEMORY_VOLUME_FACTORY : CC.DEFAULT_FILE_VOLUME_FACTORY, null, 16, 0, false, false, null, false, false, false, null, null, 0L, 0L, false, 0L, 0);
    }

    @Override
    protected void initHeadVol() {
        if (this.headVol != null && !this.headVol.isClosed()) {
            this.headVol.close();
        }
        this.headVol = new Volume.SingleByteArrayVol(32856);
        this.vol.transferInto(0L, this.headVol, 0L, 32856L);
    }

    @Override
    protected void longStackPut(long masterLinkOffset, long value, boolean recursive) {
        long masterLinkVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset));
        long pageOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        if (masterLinkVal == 0L) {
            this.longStackNewPage(masterLinkOffset, 0L, value, recursive);
            return;
        }
        long currSize = masterLinkVal >>> 48;
        byte[] page = this.loadLongStackPage(pageOffset, true);
        long prevLinkVal = DataIO.parity4Get(DataIO.getLong(page, 0));
        long pageSize = prevLinkVal >>> 48;
        if (currSize + 8L >= pageSize) {
            Arrays.fill(page, (int)currSize, (int)pageSize, (byte)0);
            this.longStackNewPage(masterLinkOffset, pageOffset, value, recursive);
            return;
        }
        currSize += (long)DataIO.packLongBidi(page, (int)currSize, this.longParitySet(value));
        this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | pageOffset));
    }

    @Override
    protected long longStackTake(long masterLinkOffset, boolean recursive) {
        long masterLinkVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            return 0L;
        }
        long currSize = masterLinkVal >>> 48;
        long pageOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        byte[] page = this.loadLongStackPage(pageOffset, true);
        long ret = DataIO.unpackLongBidiReverse(page, (int)currSize, 8);
        long oldCurrSize = currSize;
        Arrays.fill(page, (int)(currSize -= ret >>> 60), (int)oldCurrSize, (byte)0);
        ret = this.longParityGet(ret & 0xFFFFFFFFFFFFFFFL);
        if (currSize > 8L) {
            this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | pageOffset));
            return ret;
        }
        long prevPageOffset = DataIO.parity4Get(DataIO.getLong(page, 0));
        int currPageSize = (int)(prevPageOffset >>> 48);
        if ((prevPageOffset &= 0xFFFFFFFFFFF0L) != 0L) {
            byte[] page2 = this.loadLongStackPage(prevPageOffset, true);
            currSize = DataIO.parity4Get(DataIO.getLong(page2, 0)) >>> 48;
            while (page2[(int)(currSize - 1L)] == 0) {
                --currSize;
            }
        } else {
            currSize = 0L;
        }
        this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | prevPageOffset));
        this.uncommittedStackPages.put(pageOffset, LONG_STACK_PAGE_TOMBSTONE);
        this.freeDataPut(-1, pageOffset, currPageSize);
        return ret;
    }

    protected byte[] loadLongStackPage(long pageOffset, boolean willBeModified) {
        byte[] page = this.uncommittedStackPages.get(pageOffset);
        if (page == null) {
            int pageSize = (int)(DataIO.parity4Get(this.vol.getLong(pageOffset)) >>> 48);
            page = new byte[pageSize];
            this.vol.getData(pageOffset, page, 0, pageSize);
            if (willBeModified) {
                this.uncommittedStackPages.put(pageOffset, page);
            }
        }
        return page;
    }

    @Override
    protected long longStackCount(long masterLinkOffset) {
        long nextLinkVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset));
        long ret = 0L;
        while (true) {
            int currSize = (int)(nextLinkVal >>> 48);
            long pageOffset = nextLinkVal & 0xFFFFFFFFFFF0L;
            if (pageOffset == 0L) break;
            byte[] page = this.loadLongStackPage(pageOffset, false);
            while ((page[currSize - 1] & 0xFF) == 0) {
                --currSize;
            }
            while (currSize > 8) {
                long read = DataIO.unpackLongBidiReverse(page, currSize, 8);
                currSize = (int)((long)currSize - (read >>> 60));
                ++ret;
            }
            nextLinkVal = DataIO.parity4Get(DataIO.getLong(page, 0));
        }
        return ret;
    }

    @Override
    protected void longStackNewPage(long masterLinkOffset, long prevPageOffset, long value, boolean recursive) {
        long newPageSize = 160L;
        if (!recursive) {
            for (long size = 256L; size >= 32L; size -= 16L) {
                long indexVal;
                long masterLinkOffset2 = this.longStackMasterLinkOffset(size);
                if (masterLinkOffset == masterLinkOffset2 || (indexVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset2))) == 0L) continue;
                newPageSize = size;
                break;
            }
            if (this.longStackMasterLinkOffset(newPageSize) == masterLinkOffset) {
                newPageSize += 16L;
            }
        }
        long newPageOffset = this.freeDataTakeSingle((int)newPageSize, true);
        byte[] page = new byte[(int)newPageSize];
        this.uncommittedStackPages.put(newPageOffset, page);
        DataIO.putLong(page, 0, DataIO.parity4Set(newPageSize << 48 | prevPageOffset));
        long currSize = 8 + DataIO.packLongBidi(page, 8, this.longParitySet(value));
        this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | newPageOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush() {
        if (this.isReadOnly()) {
            return;
        }
        this.flushWriteCache();
        this.structuralLock.lock();
        try {
            long[] set = this.uncommittedStackPages.set;
            for (int i = 0; i < set.length; ++i) {
                byte[] val;
                long offset = set[i];
                if (offset == 0L || (val = (byte[])this.uncommittedStackPages.values[i]) == LONG_STACK_PAGE_TOMBSTONE) continue;
                this.vol.putData(offset, val, 0, val.length);
            }
            this.uncommittedStackPages.clear();
            this.headVol.putInt(4L, this.headChecksum(this.headVol));
            byte[] buf = new byte[32856];
            this.headVol.getData(0L, buf, 0, buf.length);
            this.vol.putData(0L, buf, 0, buf.length);
        }
        finally {
            this.structuralLock.unlock();
        }
        this.vol.sync();
    }

    protected void assertLongStackPage(long offset, byte[] val) {
        if (val.length > 65535) {
            throw new DBException.DataCorruption("wrong length");
        }
    }

    protected void assertNoOverlaps(Store.LongObjectMap<byte[]> pages) {
        long[] sorted = new long[pages.size];
        int c = 0;
        for (long key : pages.set) {
            if (key == 0L) continue;
            sorted[c++] = key;
        }
        Arrays.sort(sorted);
        for (int i = 0; i < sorted.length - 1; ++i) {
            long offsetNext;
            long offset = sorted[i];
            long pageSize = pages.get(offset).length;
            if (offset + pageSize > (offsetNext = sorted[i + 1])) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushWriteCache() {
        for (int i = 0; i < this.locks.length; ++i) {
            Lock lock = this.locks[i].writeLock();
            lock.lock();
            try {
                this.flushWriteCacheSegment(i);
                continue;
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected void flushWriteCacheSegment(int segment) {
        Store.LongObjectObjectMap writeCache1 = this.writeCache[segment];
        long[] set = writeCache1.set;
        Object[] values = writeCache1.values;
        for (int i = 0; i < set.length; ++i) {
            long recid = set[i];
            if (recid == 0L) continue;
            Object value = values[i * 2];
            if (value == TOMBSTONE2) {
                super.delete2(recid, Serializer.ILLEGAL_ACCESS);
                continue;
            }
            Serializer s = (Serializer)values[i * 2 + 1];
            DataIO.DataOutputByteArray buf = this.serialize(value, s);
            super.update2(recid, buf);
            this.recycledDataOut.lazySet(buf);
        }
        writeCache1.clear();
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        Store.LongObjectObjectMap m = this.writeCache[this.lockPos(recid)];
        Object cached = m.get1(recid);
        if (cached != null) {
            if (cached == TOMBSTONE2) {
                return null;
            }
            return (A)cached;
        }
        return super.get2(recid, serializer);
    }

    @Override
    protected <A> void delete2(long recid, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        int lockPos = this.lockPos(recid);
        Store.LongObjectObjectMap map = this.writeCache[lockPos];
        map.put(recid, TOMBSTONE2, null);
        if (this.flushInThread && map.size > this.writeQueueSize) {
            this.flushWriteCacheSegment(lockPos);
        }
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        long recid = this.preallocate();
        this.update(recid, value, serializer);
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        int lockPos = this.lockPos(recid);
        Store.Cache cache = this.caches == null ? null : this.caches[lockPos];
        Lock lock = this.locks[lockPos].writeLock();
        lock.lock();
        try {
            if (cache != null) {
                cache.put(recid, value);
            }
            Store.LongObjectObjectMap map = this.writeCache[lockPos];
            map.put(recid, value, serializer);
            if (this.flushInThread && map.size > this.writeQueueSizePerSegment) {
                this.flushWriteCacheSegment(lockPos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        int lockPos = this.lockPos(recid);
        Lock lock = this.locks[lockPos].writeLock();
        Store.Cache cache = this.caches == null ? null : this.caches[lockPos];
        Store.LongObjectObjectMap map = this.writeCache[lockPos];
        lock.lock();
        try {
            Object oldVal;
            Object object = oldVal = cache == null ? null : cache.get(recid);
            if (oldVal == null) {
                oldVal = this.get2(recid, serializer);
            } else if (oldVal == Store.Cache.NULL) {
                oldVal = null;
            }
            if (oldVal == expectedOldValue || oldVal != null && serializer.equals(oldVal, expectedOldValue)) {
                if (cache != null) {
                    cache.put(recid, newValue);
                }
                map.put(recid, newValue, serializer);
                if (this.flushInThread && map.size > this.writeQueueSizePerSegment) {
                    this.flushWriteCacheSegment(lockPos);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    void assertZeroes(long startOffset, long endOffset) {
        startOffset = Math.min(startOffset, this.vol.length());
        endOffset = Math.min(endOffset, this.vol.length());
        super.assertZeroes(startOffset, endOffset);
    }
}

