/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.Rectangle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.mapeditor.core.LayerData;
import org.mapeditor.core.Map;
import org.mapeditor.core.Properties;

@XmlAccessorType(value=XmlAccessType.NONE)
public class MapLayer
extends LayerData
implements Cloneable {
    public static final int MIRROR_HORIZONTAL = 1;
    public static final int MIRROR_VERTICAL = 2;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    protected Map map;

    public MapLayer() {
        this.setMap(null);
    }

    public MapLayer(int w, int h) {
        this(new Rectangle(0, 0, w, h));
    }

    public MapLayer(Rectangle r) {
        this();
        this.setBounds(r);
    }

    MapLayer(Map map) {
        this();
        this.setMap(map);
    }

    public MapLayer(Map map, int w, int h) {
        this(w, h);
        this.setMap(map);
    }

    public void translate(int x, int y) {
        MapLayer mapLayer = this;
        mapLayer.x = mapLayer.x + x;
        mapLayer = this;
        mapLayer.y = mapLayer.y + y;
    }

    protected void setBounds(Rectangle bounds) {
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
    }

    public final void setMap(Map map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    public void setOffset(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x == null ? 0 : this.x, this.y == null ? 0 : this.y, this.width, this.height);
    }

    public void getBounds(Rectangle rect) {
        rect.x = this.x;
        rect.y = this.y;
        rect.width = this.width;
        rect.height = this.height;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return super.getProperties();
    }

    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    public Object clone() throws CloneNotSupportedException {
        MapLayer clone = (MapLayer)super.clone();
        clone.setBounds(new Rectangle(this.getBounds()));
        clone.properties = this.properties.clone();
        return clone;
    }

    public void resize(int width, int height, int dx, int dy) {
    }
}

